/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddClusterViewListenerCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MembersView;
import com.hazelcast.internal.cluster.impl.MembershipManager;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.scheduler.CoalescingDelayedTrigger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import java.nio.channels.CancelledKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ClusterViewListenerService {
    private static final int PUSH_PERIOD_IN_SECONDS = 30;
    private static final long PARTITION_UPDATE_DELAY_MS = 100L;
    private static final long PARTITION_UPDATE_MAX_DELAY_MS = 500L;
    private final Map<ClientEndpoint, Long> clusterListeningEndpoints = new ConcurrentHashMap<ClientEndpoint, Long>();
    private final NodeEngine nodeEngine;
    private final boolean advancedNetworkConfigEnabled;
    private final AtomicBoolean pushScheduled = new AtomicBoolean();
    private final CoalescingDelayedTrigger delayedPartitionUpdateTrigger;
    private final AtomicInteger partitionTableVersion = new AtomicInteger();
    private final AtomicLong latestPartitionStamp = new AtomicLong();

    ClusterViewListenerService(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.advancedNetworkConfigEnabled = nodeEngine.getConfig().getAdvancedNetworkConfig().isEnabled();
        this.delayedPartitionUpdateTrigger = new CoalescingDelayedTrigger(nodeEngine.getExecutionService(), 100L, 500L, this::pushPartitionTableView);
    }

    private void schedulePeriodicPush() {
        ExecutionService executor = this.nodeEngine.getExecutionService();
        executor.scheduleWithRepetition(this::pushView, 30L, 30L, TimeUnit.SECONDS);
    }

    private void pushView() {
        this.pushPartitionTableView();
        this.sendToListeningEndpoints(this.getMemberListViewMessage());
    }

    private void pushPartitionTableView() {
        ClientMessage partitionViewMessage = this.getPartitionViewMessageOrNull();
        if (partitionViewMessage != null) {
            this.sendToListeningEndpoints(partitionViewMessage);
        }
    }

    public void onPartitionStateChange() {
        this.delayedPartitionUpdateTrigger.executeWithDelay();
    }

    public void onMemberListChange() {
        this.sendToListeningEndpoints(this.getMemberListViewMessage());
    }

    private void sendToListeningEndpoints(ClientMessage clientMessage) {
        for (Map.Entry<ClientEndpoint, Long> entry : this.clusterListeningEndpoints.entrySet()) {
            Long correlationId = entry.getValue();
            ClientMessage message = clientMessage.copyWithNewCorrelationId(correlationId);
            ClientEndpoint clientEndpoint = entry.getKey();
            ServerConnection connection = clientEndpoint.getConnection();
            this.write(message, connection);
        }
    }

    private void write(ClientMessage message, Connection connection) {
        try {
            connection.write(message);
        }
        catch (CancelledKeyException ignored) {
            EmptyStatement.ignore(ignored);
        }
    }

    public void registerListener(ClientEndpoint clientEndpoint, long correlationId) {
        if (this.pushScheduled.compareAndSet(false, true)) {
            this.schedulePeriodicPush();
        }
        this.clusterListeningEndpoints.put(clientEndpoint, correlationId);
        ClientMessage memberListViewMessage = this.getMemberListViewMessage();
        memberListViewMessage.setCorrelationId(correlationId);
        this.write(memberListViewMessage, clientEndpoint.getConnection());
        ClientMessage partitionViewMessage = this.getPartitionViewMessageOrNull();
        if (partitionViewMessage != null) {
            partitionViewMessage.setCorrelationId(correlationId);
            this.write(partitionViewMessage, clientEndpoint.getConnection());
        }
    }

    private ClientMessage getPartitionViewMessageOrNull() {
        long latestStamp;
        InternalPartitionService partitionService = (InternalPartitionService)this.nodeEngine.getPartitionService();
        PartitionTableView partitionTableView = partitionService.createPartitionTableView();
        Map<UUID, List<Integer>> partitions = this.getPartitions(partitionTableView);
        if (partitions.size() == 0) {
            return null;
        }
        long currentStamp = partitionTableView.stamp();
        if (currentStamp != (latestStamp = this.latestPartitionStamp.get()) && this.latestPartitionStamp.compareAndSet(latestStamp, currentStamp)) {
            this.partitionTableVersion.incrementAndGet();
        }
        int version = this.partitionTableVersion.get();
        return ClientAddClusterViewListenerCodec.encodePartitionsViewEvent(version, partitions.entrySet());
    }

    private ClientMessage getMemberListViewMessage() {
        MembershipManager membershipManager = ((ClusterServiceImpl)this.nodeEngine.getClusterService()).getMembershipManager();
        MembersView membersView = membershipManager.getMembersView();
        int version = membersView.getVersion();
        List<MemberInfo> members = membersView.getMembers();
        ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>();
        for (MemberInfo member : members) {
            memberInfos.add(new MemberInfo(this.clientAddressOf(member.getAddress()), member.getUuid(), member.getAttributes(), member.isLiteMember(), member.getVersion(), member.getAddressMap()));
        }
        return ClientAddClusterViewListenerCodec.encodeMembersViewEvent(version, memberInfos);
    }

    public void deregisterListener(ClientEndpoint clientEndpoint) {
        this.clusterListeningEndpoints.remove(clientEndpoint);
    }

    private Address clientAddressOf(Address memberAddress) {
        if (!this.advancedNetworkConfigEnabled) {
            return memberAddress;
        }
        MemberImpl member = this.nodeEngine.getClusterService().getMember(memberAddress);
        if (member != null) {
            return member.getAddressMap().get(EndpointQualifier.CLIENT);
        }
        return null;
    }

    public Map<UUID, List<Integer>> getPartitions(PartitionTableView partitionTableView) {
        HashMap<UUID, List<Integer>> partitionsMap = new HashMap<UUID, List<Integer>>();
        int partitionCount = partitionTableView.length();
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            PartitionReplica owner = partitionTableView.getReplica(partitionId, 0);
            if (owner == null || owner.uuid() == null) {
                partitionsMap.clear();
                return partitionsMap;
            }
            partitionsMap.computeIfAbsent(owner.uuid(), k -> new LinkedList()).add(partitionId);
        }
        return partitionsMap;
    }

    public Map<ClientEndpoint, Long> getClusterListeningEndpoints() {
        return this.clusterListeningEndpoints;
    }
}

