/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.RequiredOption;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.datasource.AbstractDataSourceConfigSwitcher;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;

public abstract class BaseJdbcDataSourceConfigSwitcher
extends AbstractDataSourceConfigSwitcher {
    private static final String TABLE_KEY = "table";
    private static final String DATABASE_KEY = "database";
    private static final String QUERY_KEY = "query";
    private static final String GENERATE_SINK_SQL = "generate_sink_sql";
    private static final String URL_KEY = "url";
    private static final String CATALOG = "catalog";
    private static final String FACTORY = "factory";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String BASE_URL = "base-url";
    private static final String CATALOG_SCHEMA = "schema";
    private static final Option<String> DATABASE_SCHEMA = Options.key((String)"database_schema").stringType().noDefaultValue().withDescription("the default database used during automated table creation.");

    @Override
    public FormStructure filterOptionRule(String connectorName, OptionRule dataSourceOptionRule, OptionRule virtualTableOptionRule, BusinessMode businessMode, PluginType pluginType, OptionRule connectorOptionRule, List<RequiredOption> addRequiredOptions, List<Option<?>> addOptionalOptions, List<String> excludedKeys) {
        HashMap<PluginType, List<String>> filterFieldMap = new HashMap<PluginType, List<String>>();
        filterFieldMap.put(PluginType.SINK, Arrays.asList(QUERY_KEY, TABLE_KEY, DATABASE_KEY, GENERATE_SINK_SQL));
        filterFieldMap.put(PluginType.SOURCE, Collections.singletonList(QUERY_KEY));
        if (this.isSupportDefaultSchema() && businessMode.equals((Object)BusinessMode.DATA_REPLICA) && pluginType.equals((Object)PluginType.SINK)) {
            addOptionalOptions.add(DATABASE_SCHEMA);
        }
        return super.filterOptionRule(connectorName, dataSourceOptionRule, virtualTableOptionRule, businessMode, pluginType, connectorOptionRule, addRequiredOptions, addOptionalOptions, (List)filterFieldMap.get(pluginType));
    }

    @Override
    public Config mergeDatasourceConfig(Config dataSourceInstanceConfig, VirtualTableDetailRes virtualTableDetail, DataSourceOption dataSourceOption, SelectTableFields selectTableFields, BusinessMode businessMode, PluginType pluginType, Config connectorConfig) {
        String databaseName;
        if (dataSourceOption.getDatabases().size() == 1) {
            databaseName = dataSourceOption.getDatabases().get(0);
            String url = dataSourceInstanceConfig.getString(URL_KEY);
            String newUrl = this.replaceDatabaseNameInUrl(url, databaseName);
            dataSourceInstanceConfig = dataSourceInstanceConfig.withValue(URL_KEY, ConfigValueFactory.fromAnyRef((Object)newUrl));
        }
        if (pluginType.equals((Object)PluginType.SINK)) {
            connectorConfig = connectorConfig.withValue(GENERATE_SINK_SQL, ConfigValueFactory.fromAnyRef((Object)true));
        }
        if (businessMode.equals((Object)BusinessMode.DATA_INTEGRATION)) {
            databaseName = dataSourceOption.getDatabases().get(0);
            String tableName = dataSourceOption.getTables().get(0);
            if (pluginType.equals((Object)PluginType.SOURCE)) {
                List<String> tableFields = selectTableFields.getTableFields();
                String sql = this.tableFieldsToSql(tableFields, databaseName, tableName);
                connectorConfig = connectorConfig.withValue(QUERY_KEY, ConfigValueFactory.fromAnyRef((Object)sql));
            } else if (pluginType.equals((Object)PluginType.SINK)) {
                connectorConfig = connectorConfig.withValue(DATABASE_KEY, ConfigValueFactory.fromAnyRef((Object)databaseName));
                connectorConfig = connectorConfig.withValue(TABLE_KEY, ConfigValueFactory.fromAnyRef((Object)tableName));
            } else {
                throw new UnsupportedOperationException("Unsupported plugin type: " + pluginType);
            }
            return super.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
        }
        if (businessMode.equals((Object)BusinessMode.DATA_REPLICA)) {
            databaseName = dataSourceOption.getDatabases().get(0);
            if (pluginType.equals((Object)PluginType.SINK)) {
                if (this.getCatalogName().isPresent()) {
                    Config config = ConfigFactory.empty();
                    config = config.withValue(FACTORY, ConfigValueFactory.fromAnyRef((Object)this.getCatalogName().get()));
                    config = config.withValue(USERNAME, ConfigValueFactory.fromAnyRef((Object)dataSourceInstanceConfig.getString("user")));
                    config = config.withValue(PASSWORD, ConfigValueFactory.fromAnyRef((Object)dataSourceInstanceConfig.getString(PASSWORD)));
                    config = config.withValue(BASE_URL, ConfigValueFactory.fromAnyRef((Object)dataSourceInstanceConfig.getString(URL_KEY)));
                    if (this.isSupportDefaultSchema() && connectorConfig.hasPath(DATABASE_SCHEMA.key())) {
                        config = config.withValue(CATALOG_SCHEMA, ConfigValueFactory.fromAnyRef((Object)connectorConfig.getString(DATABASE_SCHEMA.key())));
                    }
                    connectorConfig = connectorConfig.withValue(CATALOG, (ConfigValue)config.root());
                }
                connectorConfig = connectorConfig.withValue(DATABASE_KEY, ConfigValueFactory.fromAnyRef((Object)databaseName));
                return super.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
            }
            throw new UnsupportedOperationException("JDBC DATA_REPLICA Unsupported plugin type: " + pluginType);
        }
        throw new UnsupportedOperationException("Unsupported businessMode : " + (Object)((Object)businessMode));
    }

    protected String generateSql(List<String> tableFields, String database, String schema, String table) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (int i = 0; i < tableFields.size(); ++i) {
            sb.append(this.quoteIdentifier(tableFields.get(i)));
            if (i >= tableFields.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(" FROM ").append(this.quoteIdentifier(database));
        if (schema != null && !schema.isEmpty()) {
            sb.append(".").append(this.quoteIdentifier(schema));
        }
        sb.append(".").append(this.quoteIdentifier(table));
        return sb.toString();
    }

    protected boolean isSupportDefaultSchema() {
        return false;
    }

    protected Optional<String> getCatalogName() {
        return Optional.empty();
    }

    protected String tableFieldsToSql(List<String> tableFields, String database, String table) {
        return this.generateSql(tableFields, database, null, table);
    }

    protected String quoteIdentifier(String identifier) {
        return "`" + identifier + "`";
    }

    protected String replaceDatabaseNameInUrl(String url, String databaseName) {
        return url;
    }
}

