/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.factory;

import java.util.ServiceLoader;

public class Mappers {
    private static final String IMPLEMENTATION_SUFFIX = "Impl";

    private Mappers() {
    }

    public static <T> T getMapper(Class<T> clazz) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = Mappers.class.getClassLoader();
            }
            try {
                Object mapper = classLoader.loadClass(clazz.getName() + IMPLEMENTATION_SUFFIX).newInstance();
                return (T)mapper;
            }
            catch (ClassNotFoundException e) {
                ServiceLoader<T> loader = ServiceLoader.load(clazz, classLoader);
                if (loader != null) {
                    for (T mapper : loader) {
                        if (mapper == null) continue;
                        return mapper;
                    }
                }
                throw new ClassNotFoundException("Cannot find implementation for " + clazz.getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

