/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.app.domain.request.user.AddUserReq;
import org.apache.seatunnel.app.domain.request.user.UpdateUserReq;
import org.apache.seatunnel.app.domain.request.user.UserListReq;
import org.apache.seatunnel.app.domain.request.user.UserLoginReq;
import org.apache.seatunnel.app.domain.response.PageInfo;
import org.apache.seatunnel.app.domain.response.user.AddUserRes;
import org.apache.seatunnel.app.domain.response.user.UserSimpleInfoRes;
import org.apache.seatunnel.app.service.IUserService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/seatunnel/api/v1/user"})
@RestController
public class UserController {
    @Resource
    private IUserService iUserService;

    @PostMapping
    @ApiOperation(value="add user", httpMethod="POST")
    public Result<AddUserRes> add(@RequestBody @NotNull AddUserReq addReq) {
        return Result.success(this.iUserService.add(addReq));
    }

    @PutMapping(value={"/{userId}"})
    @ApiOperation(value="update user", httpMethod="PUT")
    public Result<Void> update(@ApiParam(value="user id", required=true) @PathVariable(value="userId") Integer userId, @RequestBody @NotNull UpdateUserReq updateReq) {
        updateReq.setUserId(userId);
        this.iUserService.update(updateReq);
        return Result.success();
    }

    @DeleteMapping(value={"/{userId}"})
    @ApiOperation(value="delete user", httpMethod="DELETE")
    public Result<Void> delete(@ApiParam(value="user id", required=true) @PathVariable(value="userId") Integer userId) {
        this.iUserService.delete(userId);
        return Result.success();
    }

    @GetMapping
    @ApiOperation(value="user list", httpMethod="GET")
    public Result<PageInfo<UserSimpleInfoRes>> list(@ApiParam(value="user name") @RequestParam(required=false) String name, @ApiParam(value="page num", required=true) @RequestParam Integer pageNo, @ApiParam(value="page size", required=true) @RequestParam Integer pageSize) {
        UserListReq req = new UserListReq();
        req.setName(name);
        req.setPageNo(pageNo);
        req.setPageSize(pageSize);
        return Result.success(this.iUserService.list(req));
    }

    @PatchMapping(value={"/{userId}/enable"})
    @ApiOperation(value="enable a user", httpMethod="PATCH")
    public Result<Void> enable(@ApiParam(value="user id", required=true) @PathVariable(value="userId") Integer userId) {
        this.iUserService.enable(userId);
        return Result.success();
    }

    @PutMapping(value={"/{userId}/disable"})
    @ApiOperation(value="disable a user", httpMethod="PUT")
    public Result<Void> disable(@ApiParam(value="user id", required=true) @PathVariable(value="userId") Integer userId) {
        this.iUserService.disable(userId);
        return Result.success();
    }

    @PostMapping(value={"/login"})
    public Result<UserSimpleInfoRes> login(@RequestBody UserLoginReq req) {
        return Result.success(this.iUserService.login(req));
    }

    @PatchMapping(value={"/logout"})
    public Result<Void> logout() {
        return Result.success();
    }
}

