/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.telemetry.metrics.exports;

import com.hazelcast.instance.impl.Node;
import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.engine.server.telemetry.metrics.AbstractCollector;
import org.apache.seatunnel.engine.server.telemetry.metrics.entity.ThreadPoolStatus;

public class JobThreadPoolStatusExports
extends AbstractCollector {
    private static String HELP = "The %s of seatunnel coordinator job's executor cached thread pool";

    public JobThreadPoolStatusExports(Node node) {
        super(node);
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        ThreadPoolStatus threadPoolStatusMetrics = this.getServer().getThreadPoolStatusMetrics();
        List<String> labelNames = this.clusterLabelNames(ADDRESS, "type");
        GaugeMetricFamily activeCount = new GaugeMetricFamily("job_thread_pool_activeCount", String.format(HELP, "activeCount"), labelNames);
        activeCount.addMetric(this.labelValues(this.localAddress(), "activeCount"), threadPoolStatusMetrics.getActiveCount());
        mfs.add(activeCount);
        CounterMetricFamily completedTask = new CounterMetricFamily("job_thread_pool_completedTask", String.format(HELP, "completedTask"), labelNames);
        completedTask.addMetric(this.labelValues(this.localAddress(), "completedTask"), threadPoolStatusMetrics.getCompletedTaskCount());
        mfs.add(completedTask);
        GaugeMetricFamily corePoolSize = new GaugeMetricFamily("job_thread_pool_corePoolSize", String.format(HELP, "corePoolSize"), labelNames);
        corePoolSize.addMetric(this.labelValues(this.localAddress(), "corePoolSize"), threadPoolStatusMetrics.getCorePoolSize());
        mfs.add(corePoolSize);
        GaugeMetricFamily maximumPoolSize = new GaugeMetricFamily("job_thread_pool_maximumPoolSize", String.format(HELP, "maximumPoolSize"), labelNames);
        maximumPoolSize.addMetric(this.labelValues(this.localAddress(), "maximumPoolSize"), threadPoolStatusMetrics.getMaximumPoolSize());
        mfs.add(maximumPoolSize);
        GaugeMetricFamily poolSize = new GaugeMetricFamily("job_thread_pool_poolSize", String.format(HELP, "poolSize"), labelNames);
        poolSize.addMetric(this.labelValues(this.localAddress(), "poolSize"), threadPoolStatusMetrics.getPoolSize());
        mfs.add(poolSize);
        CounterMetricFamily taskCount = new CounterMetricFamily("job_thread_pool_task", String.format(HELP, "taskCount"), labelNames);
        taskCount.addMetric(this.labelValues(this.localAddress(), "taskCount"), threadPoolStatusMetrics.getTaskCount());
        mfs.add(taskCount);
        GaugeMetricFamily queueTaskCount = new GaugeMetricFamily("job_thread_pool_queueTaskCount", String.format(HELP, "queueTaskCount"), labelNames);
        queueTaskCount.addMetric(this.labelValues(this.localAddress(), "queueTaskCount"), threadPoolStatusMetrics.getQueueTaskCount());
        mfs.add(queueTaskCount);
        CounterMetricFamily rejectedTaskCount = new CounterMetricFamily("job_thread_pool_rejection", String.format(HELP, "rejectionCount"), labelNames);
        rejectedTaskCount.addMetric(this.labelValues(this.localAddress(), "rejectionCount"), threadPoolStatusMetrics.getRejectionCount());
        mfs.add(rejectedTaskCount);
        return mfs;
    }
}

