/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.telemetry.metrics.exports;

import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.impl.Node;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.seatunnel.engine.server.telemetry.metrics.AbstractCollector;

public class ClusterMetricExports
extends AbstractCollector {
    public ClusterMetricExports(Node node) {
        super(node);
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.clusterInfo(mfs);
        this.clusterTime(mfs);
        this.nodeCount(mfs);
        return mfs;
    }

    private void clusterTime(List<Collector.MetricFamilySamples> mfs) {
        GaugeMetricFamily metricFamily = new GaugeMetricFamily("cluster_time", "Cluster start time", this.clusterLabelNames("hazelcastVersion"));
        List<String> labelValues = this.labelValues(this.getClusterService().getClusterVersion().toString());
        metricFamily.addMetric(labelValues, this.getClusterService().getClusterTime());
        mfs.add(metricFamily);
    }

    private void clusterInfo(List<Collector.MetricFamilySamples> mfs) {
        GaugeMetricFamily metricFamily = new GaugeMetricFamily("cluster_info", "Cluster info", this.clusterLabelNames("hazelcastVersion", "master"));
        List<String> labelValues = null;
        try {
            labelValues = this.labelValues(this.getClusterService().getClusterVersion().toString(), this.masterAddress());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        metricFamily.addMetric(labelValues, 1.0);
        mfs.add(metricFamily);
    }

    private void nodeCount(List<Collector.MetricFamilySamples> mfs) {
        Collection<MemberImpl> memberImpls = this.getClusterService().getMemberImpls();
        GaugeMetricFamily metricFamily = new GaugeMetricFamily("node_count", "Cluster node total count ", this.clusterLabelNames(new String[0]));
        List<String> labelValues = this.labelValues(new String[0]);
        metricFamily.addMetric(labelValues, memberImpls.size());
        mfs.add(metricFamily);
    }
}

