/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.parse;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.core.starter.execution.PluginUtil;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.core.parse.ConnectorInstanceLoader;
import org.apache.seatunnel.engine.core.parse.MultipleTableJobConfigParser;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import scala.Serializable;
import scala.Tuple2;

public class JobConfigParser {
    private static final ILogger LOGGER = Logger.getLogger(JobConfigParser.class);
    private IdGenerator idGenerator;
    private boolean isStartWithSavePoint;
    private MultipleTableJobConfigParser multipleTableJobConfigParser;
    private List<URL> commonPluginJars;

    public JobConfigParser(@NonNull IdGenerator idGenerator, @NonNull List<URL> commonPluginJars, MultipleTableJobConfigParser multipleTableJobConfigParser, boolean isStartWithSavePoint) {
        if (idGenerator == null) {
            throw new NullPointerException("idGenerator is marked non-null but is null");
        }
        if (commonPluginJars == null) {
            throw new NullPointerException("commonPluginJars is marked non-null but is null");
        }
        this.idGenerator = idGenerator;
        this.commonPluginJars = commonPluginJars;
        this.multipleTableJobConfigParser = multipleTableJobConfigParser;
        this.isStartWithSavePoint = isStartWithSavePoint;
    }

    public Tuple2<CatalogTable, Action> parseSource(Config config, JobConfig jobConfig, String tableId, int parallelism) {
        ImmutablePair<SeaTunnelSource, Set<URL>> tuple = ConnectorInstanceLoader.loadSourceInstance(config, jobConfig.getJobContext(), this.commonPluginJars);
        SeaTunnelSource source = tuple.getLeft();
        source.prepare(config);
        source.setJobContext(jobConfig.getJobContext());
        PluginUtil.ensureJobModeMatch(jobConfig.getJobContext(), source);
        String actionName = JobConfigParser.createSourceActionName(0, config.getString("plugin_name"));
        SourceAction action = new SourceAction(this.idGenerator.getNextId(), actionName, tuple.getLeft(), tuple.getRight(), new HashSet<ConnectorJarIdentifier>());
        action.setParallelism(parallelism);
        SeaTunnelRowType producedType = (SeaTunnelRowType)tuple.getLeft().getProducedType();
        CatalogTable catalogTable = CatalogTableUtil.getCatalogTable(tableId, producedType);
        return new Tuple2<CatalogTable, Action>(catalogTable, action);
    }

    public List<SinkAction<?, ?, ?, ?>> parseSinks(int configIndex, List<List<Tuple2<CatalogTable, Action>>> inputVertices, Config sinkConfig, JobConfig jobConfig) {
        ArrayList sinkActions = new ArrayList();
        int spareParallelism = inputVertices.get(0).get(0)._2().getParallelism();
        if (inputVertices.size() > 1) {
            Set inputActions = inputVertices.stream().flatMap(Collection::stream).map(Tuple2::_2).collect(Collectors.toCollection(LinkedHashSet::new));
            MultipleTableJobConfigParser.checkProducedTypeEquals(inputActions);
            SinkAction<?, ?, ?, ?> sinkAction = this.parseSink(configIndex, sinkConfig, jobConfig, spareParallelism, inputVertices.get(0).get(0)._1().getTableSchema().toPhysicalRowDataType(), inputActions);
            sinkActions.add(sinkAction);
        } else {
            for (Tuple2<CatalogTable, Action> tableTuple : inputVertices.get(0)) {
                CatalogTable catalogTable = tableTuple._1();
                Action inputAction = tableTuple._2();
                int parallelism = inputAction.getParallelism();
                SinkAction<?, ?, ?, ?> sinkAction = this.parseSink(configIndex, sinkConfig, jobConfig, parallelism, catalogTable.getTableSchema().toPhysicalRowDataType(), Collections.singleton(inputAction));
                sinkActions.add(sinkAction);
            }
        }
        return sinkActions;
    }

    private SinkAction<?, ?, ?, ?> parseSink(int configIndex, Config config, JobConfig jobConfig, int parallelism, SeaTunnelRowType rowType, Set<Action> inputActions) {
        ImmutablePair<SeaTunnelSink<SeaTunnelRow, Serializable, Serializable, Serializable>, Set<URL>> tuple = ConnectorInstanceLoader.loadSinkInstance(config, jobConfig.getJobContext(), this.commonPluginJars);
        SeaTunnelSink<SeaTunnelRow, Serializable, Serializable, Serializable> sink = tuple.getLeft();
        sink.prepare(config);
        sink.setJobContext(jobConfig.getJobContext());
        sink.setTypeInfo(rowType);
        if (!this.isStartWithSavePoint) {
            this.multipleTableJobConfigParser.handleSaveMode(sink);
        }
        String actionName = JobConfigParser.createSinkActionName(configIndex, tuple.getLeft().getPluginName());
        SinkAction<SeaTunnelRow, Serializable, Serializable, Serializable> action = new SinkAction<SeaTunnelRow, Serializable, Serializable, Serializable>(this.idGenerator.getNextId(), actionName, new ArrayList<Action>(inputActions), sink, tuple.getRight(), new HashSet<ConnectorJarIdentifier>());
        action.setParallelism(parallelism);
        return action;
    }

    static String createSourceActionName(int configIndex, String pluginName) {
        return String.format("Source[%s]-%s", configIndex, pluginName);
    }

    static String createSinkActionName(int configIndex, String pluginName) {
        return String.format("Sink[%s]-%s", configIndex, pluginName);
    }

    static String createSinkActionName(int configIndex, String pluginName, String table) {
        return String.format("Sink[%s]-%s-%s", configIndex, pluginName, table);
    }

    static String createTransformActionName(int configIndex, String pluginName) {
        return String.format("Transform[%s]-%s", configIndex, pluginName);
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public boolean isStartWithSavePoint() {
        return this.isStartWithSavePoint;
    }

    public MultipleTableJobConfigParser getMultipleTableJobConfigParser() {
        return this.multipleTableJobConfigParser;
    }

    public List<URL> getCommonPluginJars() {
        return this.commonPluginJars;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void setStartWithSavePoint(boolean isStartWithSavePoint) {
        this.isStartWithSavePoint = isStartWithSavePoint;
    }

    public void setMultipleTableJobConfigParser(MultipleTableJobConfigParser multipleTableJobConfigParser) {
        this.multipleTableJobConfigParser = multipleTableJobConfigParser;
    }

    public void setCommonPluginJars(List<URL> commonPluginJars) {
        this.commonPluginJars = commonPluginJars;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobConfigParser)) {
            return false;
        }
        JobConfigParser other = (JobConfigParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStartWithSavePoint() != other.isStartWithSavePoint()) {
            return false;
        }
        IdGenerator this$idGenerator = this.getIdGenerator();
        IdGenerator other$idGenerator = other.getIdGenerator();
        if (this$idGenerator == null ? other$idGenerator != null : !this$idGenerator.equals(other$idGenerator)) {
            return false;
        }
        MultipleTableJobConfigParser this$multipleTableJobConfigParser = this.getMultipleTableJobConfigParser();
        MultipleTableJobConfigParser other$multipleTableJobConfigParser = other.getMultipleTableJobConfigParser();
        if (this$multipleTableJobConfigParser == null ? other$multipleTableJobConfigParser != null : !this$multipleTableJobConfigParser.equals(other$multipleTableJobConfigParser)) {
            return false;
        }
        List<URL> this$commonPluginJars = this.getCommonPluginJars();
        List<URL> other$commonPluginJars = other.getCommonPluginJars();
        return !(this$commonPluginJars == null ? other$commonPluginJars != null : !((Object)this$commonPluginJars).equals(other$commonPluginJars));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobConfigParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStartWithSavePoint() ? 79 : 97);
        IdGenerator $idGenerator = this.getIdGenerator();
        result = result * 59 + ($idGenerator == null ? 43 : $idGenerator.hashCode());
        MultipleTableJobConfigParser $multipleTableJobConfigParser = this.getMultipleTableJobConfigParser();
        result = result * 59 + ($multipleTableJobConfigParser == null ? 43 : $multipleTableJobConfigParser.hashCode());
        List<URL> $commonPluginJars = this.getCommonPluginJars();
        result = result * 59 + ($commonPluginJars == null ? 43 : ((Object)$commonPluginJars).hashCode());
        return result;
    }

    public String toString() {
        return "JobConfigParser(idGenerator=" + this.getIdGenerator() + ", isStartWithSavePoint=" + this.isStartWithSavePoint() + ", multipleTableJobConfigParser=" + this.getMultipleTableJobConfigParser() + ", commonPluginJars=" + this.getCommonPluginJars() + ")";
    }
}

