/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.string;

import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.UniExpression;
import com.hazelcast.sql.impl.expression.string.StringFunctionUtils;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;

public class LowerFunction
extends UniExpression<String>
implements IdentifiedDataSerializable {
    public LowerFunction() {
    }

    private LowerFunction(Expression<?> operand) {
        super(operand);
    }

    public static LowerFunction create(Expression<?> operand) {
        return new LowerFunction(operand);
    }

    @Override
    public String eval(Row row, ExpressionEvalContext context) {
        String value = StringFunctionUtils.asVarchar(this.operand, row, context);
        return StringFunctionUtils.lower(value);
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.VARCHAR;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 42;
    }
}

