/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.dynamiccompile;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableTransform;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableTransformFactory;
import org.apache.seatunnel.api.table.factory.TableTransformFactoryContext;
import org.apache.seatunnel.transform.dynamiccompile.DynamicCompileTransform;
import org.apache.seatunnel.transform.dynamiccompile.DynamicCompileTransformConfig;

@AutoService(value={Factory.class})
public class DynamicCompileTransformFactory
implements TableTransformFactory {
    public String factoryIdentifier() {
        return "DynamicCompile";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{DynamicCompileTransformConfig.COMPILE_LANGUAGE, DynamicCompileTransformConfig.SOURCE_CODE}).build();
    }

    public TableTransform createTransform(TableTransformFactoryContext context) {
        CatalogTable catalogTable = (CatalogTable)context.getCatalogTables().get(0);
        return () -> new DynamicCompileTransform(context.getOptions(), catalogTable);
    }
}

