/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.source;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.common.schema.SeaTunnelSchema;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.exception.FakeConnectorException;

public class FakeDataGenerator {
    public static final String SCHEMA = "schema";
    private final SeaTunnelSchema schema;
    private final FakeConfig fakeConfig;

    public FakeDataGenerator(SeaTunnelSchema schema, FakeConfig fakeConfig) {
        this.schema = schema;
        this.fakeConfig = fakeConfig;
    }

    private SeaTunnelRow randomRow() {
        SeaTunnelRowType seaTunnelRowType = this.schema.getSeaTunnelRowType();
        String[] fieldNames = seaTunnelRowType.getFieldNames();
        SeaTunnelDataType[] fieldTypes = seaTunnelRowType.getFieldTypes();
        ArrayList<Object> randomRow = new ArrayList<Object>(fieldNames.length);
        for (SeaTunnelDataType fieldType : fieldTypes) {
            randomRow.add(this.randomColumnValue(fieldType));
        }
        return new SeaTunnelRow(randomRow.toArray());
    }

    public List<SeaTunnelRow> generateFakedRows(int rowNum) {
        ArrayList<SeaTunnelRow> seaTunnelRows = new ArrayList<SeaTunnelRow>();
        for (int i = 0; i < rowNum; ++i) {
            seaTunnelRows.add(this.randomRow());
        }
        return seaTunnelRows;
    }

    private Object randomColumnValue(SeaTunnelDataType<?> fieldType) {
        switch (fieldType.getSqlType()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)fieldType;
                BasicType elementType = arrayType.getElementType();
                int length = this.fakeConfig.getArraySize();
                Object array = Array.newInstance(elementType.getTypeClass(), length);
                for (int i = 0; i < length; ++i) {
                    Object value = this.randomColumnValue((SeaTunnelDataType<?>)elementType);
                    Array.set(array, i, value);
                }
                return array;
            }
            case MAP: {
                MapType mapType = (MapType)fieldType;
                SeaTunnelDataType keyType = mapType.getKeyType();
                SeaTunnelDataType valueType = mapType.getValueType();
                HashMap<Object, Object> objectMap = new HashMap<Object, Object>();
                int mapSize = this.fakeConfig.getMapSize();
                for (int i = 0; i < mapSize; ++i) {
                    Object key = this.randomColumnValue(keyType);
                    Object value = this.randomColumnValue(valueType);
                    objectMap.put(key, value);
                }
                return objectMap;
            }
            case STRING: {
                return RandomStringUtils.randomAlphabetic((int)this.fakeConfig.getStringLength());
            }
            case BOOLEAN: {
                return RandomUtils.nextInt((int)0, (int)2) == 1;
            }
            case TINYINT: {
                return (byte)RandomUtils.nextInt((int)0, (int)255);
            }
            case SMALLINT: {
                return (short)RandomUtils.nextInt((int)127, (int)Short.MAX_VALUE);
            }
            case INT: {
                return RandomUtils.nextInt((int)Short.MAX_VALUE, (int)Integer.MAX_VALUE);
            }
            case BIGINT: {
                return RandomUtils.nextLong((long)Integer.MAX_VALUE, (long)Long.MAX_VALUE);
            }
            case FLOAT: {
                return Float.valueOf(RandomUtils.nextFloat((float)Float.MIN_VALUE, (float)Float.MAX_VALUE));
            }
            case DOUBLE: {
                return RandomUtils.nextDouble((double)3.4028234663852886E38, (double)Double.MAX_VALUE);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)fieldType;
                return new BigDecimal(RandomStringUtils.randomNumeric((int)(decimalType.getPrecision() - decimalType.getScale())) + "." + RandomStringUtils.randomNumeric((int)decimalType.getScale()));
            }
            case NULL: {
                return null;
            }
            case BYTES: {
                return RandomStringUtils.randomAlphabetic((int)this.fakeConfig.getBytesLength()).getBytes();
            }
            case DATE: {
                return this.randomLocalDateTime().toLocalDate();
            }
            case TIME: {
                return this.randomLocalDateTime().toLocalTime();
            }
            case TIMESTAMP: {
                return this.randomLocalDateTime();
            }
            case ROW: {
                SeaTunnelDataType[] fieldTypes = ((SeaTunnelRowType)fieldType).getFieldTypes();
                Object[] objects = new Object[fieldTypes.length];
                for (int i = 0; i < fieldTypes.length; ++i) {
                    Object object;
                    objects[i] = object = this.randomColumnValue(fieldTypes[i]);
                }
                return new SeaTunnelRow(objects);
            }
        }
        throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "SeaTunnel Fake source connector not support this data type");
    }

    private LocalDateTime randomLocalDateTime() {
        return LocalDateTime.of(LocalDateTime.now().getYear(), RandomUtils.nextInt((int)1, (int)12), RandomUtils.nextInt((int)1, (int)28), RandomUtils.nextInt((int)0, (int)24), RandomUtils.nextInt((int)0, (int)59));
    }
}

