/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.common.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.connectors.seatunnel.common.schema.Schema;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigRenderOptions;

public class SeaTunnelSchema
implements Serializable {
    public static final Option<Schema> SCHEMA = Options.key((String)"schema").objectType(Schema.class).noDefaultValue().withDescription("SeaTunnel Schema");
    private static final String FIELD_KEY = "fields";
    private static final String SIMPLE_SCHEMA_FILED = "content";
    private final SeaTunnelRowType seaTunnelRowType;

    private SeaTunnelSchema(SeaTunnelRowType seaTunnelRowType) {
        this.seaTunnelRowType = seaTunnelRowType;
    }

    private static String[] parseMapGeneric(String type) {
        int index;
        int end;
        int start = type.indexOf("<");
        String genericType = type.substring(start + 1, end = type.lastIndexOf(">")).replace(" ", "");
        if (genericType.startsWith(SqlType.DECIMAL.name())) {
            index = genericType.indexOf(",");
            index = genericType.indexOf(",", index + 1);
        } else {
            index = genericType.indexOf(",");
        }
        String keyGenericType = genericType.substring(0, index);
        String valueGenericType = genericType.substring(index + 1);
        return new String[]{keyGenericType, valueGenericType};
    }

    private static String parseArrayGeneric(String type) {
        int start = type.indexOf("<");
        int end = type.lastIndexOf(">");
        return type.substring(start + 1, end).replace(" ", "");
    }

    private static int[] parseDecimalPS(String type) {
        int end;
        int start = type.indexOf("(");
        String decimalInfo = type.substring(start + 1, end = type.lastIndexOf(")")).replace(" ", "");
        String[] split = decimalInfo.split(",");
        if (split.length < 2) {
            throw new RuntimeException("Decimal type should assign precision and scale information");
        }
        int precision = Integer.parseInt(split[0]);
        int scale = Integer.parseInt(split[1]);
        return new int[]{precision, scale};
    }

    private static SeaTunnelDataType<?> parseTypeByString(String type) {
        SqlType sqlType;
        int precision = 0;
        int scale = 0;
        String genericType = "";
        String keyGenericType = "";
        String valueGenericType = "";
        String originContent = type = type.toUpperCase();
        if (type.contains("{") || type.contains("}")) {
            type = SqlType.ROW.name();
        }
        if (type.contains("<") || type.contains(">")) {
            if (type.startsWith(SqlType.MAP.name())) {
                String[] genericTypes = SeaTunnelSchema.parseMapGeneric(type);
                keyGenericType = genericTypes[0];
                valueGenericType = genericTypes[1];
                type = SqlType.MAP.name();
            } else if (type.startsWith(SqlType.ARRAY.name())) {
                genericType = SeaTunnelSchema.parseArrayGeneric(type);
                type = SqlType.ARRAY.name();
            }
        }
        if (type.contains("(")) {
            int[] results = SeaTunnelSchema.parseDecimalPS(type);
            precision = results[0];
            scale = results[1];
            type = SqlType.DECIMAL.name();
        }
        try {
            sqlType = SqlType.valueOf((String)type);
        }
        catch (IllegalArgumentException e) {
            String errorMsg = String.format("Field type not support [%s], currently only support [array, map, string, boolean, tinyint, smallint, int, bigint, float, double, decimal, null, bytes, date, time, timestamp]", type.toUpperCase());
            throw new RuntimeException(errorMsg);
        }
        switch (sqlType) {
            case ARRAY: {
                SeaTunnelDataType<?> dataType = SeaTunnelSchema.parseTypeByString(genericType);
                switch (dataType.getSqlType()) {
                    case STRING: {
                        return ArrayType.STRING_ARRAY_TYPE;
                    }
                    case BOOLEAN: {
                        return ArrayType.BOOLEAN_ARRAY_TYPE;
                    }
                    case TINYINT: {
                        return ArrayType.BYTE_ARRAY_TYPE;
                    }
                    case SMALLINT: {
                        return ArrayType.SHORT_ARRAY_TYPE;
                    }
                    case INT: {
                        return ArrayType.INT_ARRAY_TYPE;
                    }
                    case BIGINT: {
                        return ArrayType.LONG_ARRAY_TYPE;
                    }
                    case FLOAT: {
                        return ArrayType.FLOAT_ARRAY_TYPE;
                    }
                    case DOUBLE: {
                        return ArrayType.DOUBLE_ARRAY_TYPE;
                    }
                }
                String errorMsg = String.format("Array type not support this genericType [%s]", genericType);
                throw new UnsupportedOperationException(errorMsg);
            }
            case MAP: {
                return new MapType(SeaTunnelSchema.parseTypeByString(keyGenericType), SeaTunnelSchema.parseTypeByString(valueGenericType));
            }
            case STRING: {
                return BasicType.STRING_TYPE;
            }
            case BOOLEAN: {
                return BasicType.BOOLEAN_TYPE;
            }
            case TINYINT: {
                return BasicType.BYTE_TYPE;
            }
            case BYTES: {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case SMALLINT: {
                return BasicType.SHORT_TYPE;
            }
            case INT: {
                return BasicType.INT_TYPE;
            }
            case BIGINT: {
                return BasicType.LONG_TYPE;
            }
            case FLOAT: {
                return BasicType.FLOAT_TYPE;
            }
            case DOUBLE: {
                return BasicType.DOUBLE_TYPE;
            }
            case DECIMAL: {
                return new DecimalType(precision, scale);
            }
            case NULL: {
                return BasicType.VOID_TYPE;
            }
            case DATE: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case TIME: {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case TIMESTAMP: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
        }
        return SeaTunnelSchema.mapToSeaTunnelRowType(SeaTunnelSchema.convertJsonToMap(originContent));
    }

    private static Map<String, String> convertConfigToMap(Config config) {
        ConfigRenderOptions options = ConfigRenderOptions.concise();
        String schema = config.root().render(options);
        return SeaTunnelSchema.convertJsonToMap(schema);
    }

    private static Map<String, String> convertJsonToMap(String json) {
        ObjectNode jsonNodes = JsonUtils.parseObject((String)json);
        LinkedHashMap<String, String> fieldsMap = new LinkedHashMap<String, String>();
        jsonNodes.fields().forEachRemaining(field -> {
            String key = (String)field.getKey();
            JsonNode value = (JsonNode)field.getValue();
            if (value.getNodeType() == JsonNodeType.OBJECT) {
                fieldsMap.put(key, value.toString());
            } else {
                fieldsMap.put(key, value.textValue());
            }
        });
        return fieldsMap;
    }

    private static SeaTunnelRowType mapToSeaTunnelRowType(Map<String, String> fieldsMap) {
        int fieldsNum = fieldsMap.size();
        int i = 0;
        String[] fieldsName = new String[fieldsNum];
        SeaTunnelDataType[] seaTunnelDataTypes = new SeaTunnelDataType[fieldsNum];
        for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            SeaTunnelDataType<?> dataType = SeaTunnelSchema.parseTypeByString(value);
            fieldsName[i] = key;
            seaTunnelDataTypes[i] = dataType;
            ++i;
        }
        return new SeaTunnelRowType(fieldsName, seaTunnelDataTypes);
    }

    public static SeaTunnelSchema buildWithConfig(Config schemaConfig) {
        CheckResult checkResult = CheckConfigUtil.checkAllExists((Config)schemaConfig, (String[])new String[]{FIELD_KEY});
        if (!checkResult.isSuccess()) {
            String errorMsg = String.format("Schema config need option [%s], please correct your config first", FIELD_KEY);
            throw new RuntimeException(errorMsg);
        }
        Config fields = schemaConfig.getConfig(FIELD_KEY);
        Map<String, String> fieldsMap = SeaTunnelSchema.convertConfigToMap(fields);
        return new SeaTunnelSchema(SeaTunnelSchema.mapToSeaTunnelRowType(fieldsMap));
    }

    public static SeaTunnelRowType buildSimpleTextSchema() {
        return new SeaTunnelRowType(new String[]{SIMPLE_SCHEMA_FILED}, new SeaTunnelDataType[]{BasicType.STRING_TYPE});
    }

    public SeaTunnelRowType getSeaTunnelRowType() {
        return this.seaTunnelRowType;
    }
}

