/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.spark.common.source.micro;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.Handover;
import org.apache.seatunnel.translation.source.BaseSourceFunction;
import org.apache.seatunnel.translation.source.CoordinatedSource;
import org.apache.seatunnel.translation.spark.common.InternalRowCollector;
import org.apache.seatunnel.translation.spark.common.ReaderState;
import org.apache.seatunnel.translation.spark.common.source.micro.ParallelMicroBatchPartitionReader;

public class CoordinatedMicroBatchPartitionReader
extends ParallelMicroBatchPartitionReader {
    protected final Map<Integer, InternalRowCollector> collectorMap;

    public CoordinatedMicroBatchPartitionReader(SeaTunnelSource<SeaTunnelRow, ?, ?> source, Integer parallelism, Integer subtaskId, Integer checkpointId, Integer checkpointInterval, String checkpointPath, String hdfsRoot, String hdfsUser) {
        super(source, parallelism, subtaskId, checkpointId, checkpointInterval, checkpointPath, hdfsRoot, hdfsUser);
        this.collectorMap = new HashMap<Integer, InternalRowCollector>(parallelism);
        for (int i = 0; i < parallelism; ++i) {
            this.collectorMap.put(i, new InternalRowCollector(this.handover, new Object(), source.getProducedType()));
        }
    }

    @Override
    public void virtualCheckpoint() {
        try {
            int checkpointRetries = Math.max(1, CHECKPOINT_RETRIES);
            do {
                --checkpointRetries;
                long collectedReader = this.collectorMap.values().stream().mapToLong(e -> e.collectTotalCount() > 0L ? 1L : 0L).sum();
                if (collectedReader == 0L) {
                    Thread.sleep(CHECKPOINT_SLEEP_INTERVAL.intValue());
                }
                if ((collectedReader = this.collectorMap.values().stream().mapToLong(e -> e.collectTotalCount() > 0L ? 1L : 0L).sum()) == 0L && checkpointRetries != 0) continue;
                checkpointRetries = 0;
                this.internalCheckpoint(this.collectorMap.values().iterator(), 0);
            } while (checkpointRetries > 0);
        }
        catch (Exception e2) {
            throw new RuntimeException("An error occurred in virtual checkpoint execution.", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalCheckpoint(Iterator<InternalRowCollector> iterator2, int loop2) throws Exception {
        if (!iterator2.hasNext()) {
            return;
        }
        Object object = iterator2.next().getCheckpointLock();
        synchronized (object) {
            this.internalCheckpoint(iterator2, ++loop2);
            if (loop2 != this.parallelism) {
                return;
            }
            while (!this.handover.isEmpty()) {
                Thread.sleep(CHECKPOINT_SLEEP_INTERVAL.intValue());
            }
            Handover handover = this.handover;
            synchronized (handover) {
                int currentCheckpoint = this.checkpointId;
                ReaderState readerState = this.snapshotState();
                this.saveState(readerState, currentCheckpoint);
                this.internalSource.notifyCheckpointComplete(currentCheckpoint);
                this.running = false;
            }
        }
    }

    @Override
    protected String getEnumeratorThreadName() {
        return "coordinated-split-enumerator-executor";
    }

    @Override
    protected BaseSourceFunction<SeaTunnelRow> createInternalSource() {
        return new InternalCoordinatedSource(this.source, null, this.parallelism);
    }

    public class InternalCoordinatedSource<SplitT extends SourceSplit, StateT extends Serializable>
    extends CoordinatedSource<SeaTunnelRow, SplitT, StateT> {
        public InternalCoordinatedSource(SeaTunnelSource<SeaTunnelRow, SplitT, StateT> source, Map<Integer, List<byte[]>> restoredState, int parallelism) {
            super(source, restoredState, parallelism);
        }

        @Override
        public void run(Collector<SeaTunnelRow> collector) throws Exception {
            this.readerMap.entrySet().parallelStream().forEach(entry -> {
                AtomicBoolean flag = (AtomicBoolean)this.readerRunningMap.get(entry.getKey());
                SourceReader reader = (SourceReader)entry.getValue();
                Collector rowCollector = CoordinatedMicroBatchPartitionReader.this.collectorMap.get(entry.getKey());
                this.executorService.execute(() -> {
                    while (flag.get()) {
                        try {
                            reader.pollNext(rowCollector);
                            Thread.sleep(5L);
                        }
                        catch (Exception e) {
                            this.running = false;
                            flag.set(false);
                            throw new RuntimeException(e);
                        }
                    }
                });
            });
            this.splitEnumerator.run();
            while (this.running) {
                Thread.sleep(5L);
            }
        }

        @Override
        protected void handleNoMoreElement(int subtaskId) {
            super.handleNoMoreElement(subtaskId);
            if (!this.running) {
                CoordinatedMicroBatchPartitionReader.this.running = false;
            }
        }
    }
}

