/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.spark.common;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.Handover;
import org.apache.seatunnel.translation.spark.common.serialization.InternalRowConverter;
import org.apache.spark.sql.catalyst.InternalRow;

public class InternalRowCollector
implements Collector<SeaTunnelRow> {
    private final Handover<InternalRow> handover;
    private final Object checkpointLock;
    private final InternalRowConverter rowSerialization;
    private final AtomicLong collectTotalCount;

    public InternalRowCollector(Handover<InternalRow> handover, Object checkpointLock, SeaTunnelDataType<?> dataType) {
        this.handover = handover;
        this.checkpointLock = checkpointLock;
        this.rowSerialization = new InternalRowConverter(dataType);
        this.collectTotalCount = new AtomicLong(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collect(SeaTunnelRow record) {
        try {
            Object object = this.checkpointLock;
            synchronized (object) {
                this.handover.produce(this.rowSerialization.convert(record));
            }
            this.collectTotalCount.incrementAndGet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long collectTotalCount() {
        return this.collectTotalCount.get();
    }

    @Override
    public Object getCheckpointLock() {
        return this.checkpointLock;
    }
}

