/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.common;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.transform.common.AbstractSeaTunnelTransform;
import org.apache.seatunnel.transform.common.SeaTunnelRowAccessor;
import org.apache.seatunnel.transform.common.SeaTunnelRowContainerGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingleFieldOutputTransform
extends AbstractSeaTunnelTransform {
    private static final Logger log = LoggerFactory.getLogger(SingleFieldOutputTransform.class);
    private static final String[] TYPE_ARRAY_STRING = new String[0];
    private static final SeaTunnelDataType[] TYPE_ARRAY_SEATUNNEL_DATA_TYPE = new SeaTunnelDataType[0];
    private int fieldIndex;
    private SeaTunnelRowContainerGenerator rowContainerGenerator;

    @Override
    protected SeaTunnelRowType transformRowType(SeaTunnelRowType inputRowType) {
        this.setInputRowType(inputRowType);
        String outputFieldName = this.getOutputFieldName();
        SeaTunnelDataType outputFieldDataType = this.getOutputFieldDataType();
        LinkedList<String> fieldNames = new LinkedList<String>(Arrays.asList(inputRowType.getFieldNames()));
        LinkedList<SeaTunnelDataType> fieldDataTypes = new LinkedList<SeaTunnelDataType>(Arrays.asList(inputRowType.getFieldTypes()));
        int index = fieldNames.indexOf(outputFieldName);
        if (index != -1) {
            if (!outputFieldDataType.equals(fieldDataTypes.get(index))) {
                fieldDataTypes.set(index, outputFieldDataType);
            }
            this.fieldIndex = index;
            this.rowContainerGenerator = SeaTunnelRowContainerGenerator.REUSE_ROW;
        } else {
            fieldNames.addLast(outputFieldName);
            fieldDataTypes.addLast(outputFieldDataType);
            final int inputFieldLength = inputRowType.getTotalFields();
            final int outputFieldLength = fieldNames.size();
            this.fieldIndex = fieldNames.indexOf(outputFieldName);
            this.rowContainerGenerator = new SeaTunnelRowContainerGenerator(){

                @Override
                public SeaTunnelRow apply(SeaTunnelRow inputRow) {
                    Object[] outputFieldValues = new Object[outputFieldLength];
                    System.arraycopy(inputRow.getFields(), 0, outputFieldValues, 0, inputFieldLength);
                    SeaTunnelRow outputRow = new SeaTunnelRow(outputFieldValues);
                    outputRow.setTableId(inputRow.getTableId());
                    outputRow.setRowKind(inputRow.getRowKind());
                    return outputRow;
                }
            };
        }
        SeaTunnelRowType outputRowType = new SeaTunnelRowType(fieldNames.toArray(TYPE_ARRAY_STRING), fieldDataTypes.toArray(TYPE_ARRAY_SEATUNNEL_DATA_TYPE));
        log.info("Changed input row type: {} to output row type: {}", (Object)inputRowType, (Object)outputRowType);
        return outputRowType;
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        Object fieldValue = this.getOutputFieldValue(new SeaTunnelRowAccessor(inputRow));
        SeaTunnelRow outputRow = (SeaTunnelRow)this.rowContainerGenerator.apply(inputRow);
        outputRow.setField(this.fieldIndex, fieldValue);
        return outputRow;
    }

    protected abstract void setInputRowType(SeaTunnelRowType var1);

    protected abstract String getOutputFieldName();

    protected abstract SeaTunnelDataType getOutputFieldDataType();

    protected abstract Object getOutputFieldValue(SeaTunnelRowAccessor var1);
}

