/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.metrics;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.metrics.MetricConsumer;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.internal.util.MapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.seatunnel.api.common.metrics.JobMetrics;
import org.apache.seatunnel.api.common.metrics.Measurement;
import org.apache.seatunnel.api.common.metrics.RawJobMetrics;

public final class JobMetricsUtil {
    private JobMetricsUtil() {
    }

    public static String getTaskGroupLocationFromMetricsDescriptor(MetricDescriptor descriptor) {
        for (int i = 0; i < descriptor.tagCount(); ++i) {
            if (!"taskGroupLocation".equals(descriptor.tag(i))) continue;
            return descriptor.tagValue(i);
        }
        return null;
    }

    public static UnaryOperator<MetricDescriptor> addMemberPrefixFn(Member member) {
        String uuid = member.getUuid().toString();
        String addr = member.getAddress().toString();
        return d -> d.copy().withTag("member", uuid).withTag("address", addr);
    }

    public static JobMetrics toJobMetrics(List<RawJobMetrics> rawJobMetrics) {
        JobMetricsConsumer consumer = null;
        for (RawJobMetrics metrics : rawJobMetrics) {
            if (metrics.getBlob() == null) continue;
            if (consumer == null) {
                consumer = new JobMetricsConsumer();
            }
            consumer.timestamp = metrics.getTimestamp();
            MetricsCompressor.extractMetrics(metrics.getBlob(), consumer);
        }
        return consumer == null ? JobMetrics.empty() : JobMetrics.of(consumer.metrics);
    }

    private static class JobMetricsConsumer
    implements MetricConsumer {
        final Map<String, List<Measurement>> metrics = new HashMap<String, List<Measurement>>();
        long timestamp;

        private JobMetricsConsumer() {
        }

        @Override
        public void consumeLong(MetricDescriptor descriptor, long value) {
            this.metrics.computeIfAbsent(descriptor.metric(), k -> new ArrayList()).add(this.measurement(descriptor, value));
        }

        @Override
        public void consumeDouble(MetricDescriptor descriptor, double value) {
            this.metrics.computeIfAbsent(descriptor.metric(), k -> new ArrayList()).add(this.measurement(descriptor, value));
        }

        private Measurement measurement(MetricDescriptor descriptor, Object value) {
            Map<String, String> tags = MapUtil.createHashMap(descriptor.tagCount());
            for (int i = 0; i < descriptor.tagCount(); ++i) {
                tags.put(descriptor.tag(i), descriptor.tagValue(i));
            }
            if (descriptor.discriminator() != null || descriptor.discriminatorValue() != null) {
                tags.put(descriptor.discriminator(), descriptor.discriminatorValue());
            }
            return Measurement.of(descriptor.metric(), value, this.timestamp, tags);
        }
    }
}

