/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client.job;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import lombok.NonNull;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.client.SeaTunnelHazelcastClient;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.Job;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelCancelJobCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelGetJobStatusCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelSubmitJobCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelWaitForJobCompleteCodec;

public class ClientJobProxy
implements Job {
    private static final ILogger LOGGER = Logger.getLogger(ClientJobProxy.class);
    private final SeaTunnelHazelcastClient seaTunnelHazelcastClient;
    private final JobImmutableInformation jobImmutableInformation;

    public ClientJobProxy(@NonNull SeaTunnelHazelcastClient seaTunnelHazelcastClient, @NonNull JobImmutableInformation jobImmutableInformation) {
        if (seaTunnelHazelcastClient == null) {
            throw new NullPointerException("seaTunnelHazelcastClient is marked @NonNull but is null");
        }
        if (jobImmutableInformation == null) {
            throw new NullPointerException("jobImmutableInformation is marked @NonNull but is null");
        }
        this.seaTunnelHazelcastClient = seaTunnelHazelcastClient;
        this.jobImmutableInformation = jobImmutableInformation;
        this.submitJob();
    }

    @Override
    public long getJobId() {
        return this.jobImmutableInformation.getJobId();
    }

    private void submitJob() {
        LOGGER.info(String.format("start submit job, job id: %s, with plugin jar %s", this.jobImmutableInformation.getJobId(), this.jobImmutableInformation.getPluginJarsUrls()));
        ClientMessage request = SeaTunnelSubmitJobCodec.encodeRequest(this.jobImmutableInformation.getJobId(), this.seaTunnelHazelcastClient.getSerializationService().toData(this.jobImmutableInformation));
        PassiveCompletableFuture<Void> submitJobFuture = this.seaTunnelHazelcastClient.requestOnMasterAndGetCompletableFuture(request);
        submitJobFuture.join();
    }

    @Override
    public JobStatus waitForJobComplete() {
        JobStatus jobStatus;
        try {
            jobStatus = RetryUtils.retryWithException(() -> {
                PassiveCompletableFuture<JobStatus> jobFuture = this.doWaitForJobComplete();
                return (JobStatus)((Object)((Object)jobFuture.get()));
            }, new RetryUtils.RetryMaterial(10, true, exception -> exception instanceof RuntimeException, 2000L));
        }
        catch (Exception e) {
            LOGGER.info(String.format("Job %s (%s) end with unknown state, and throw Exception: %s", this.jobImmutableInformation.getJobId(), this.jobImmutableInformation.getJobConfig().getName(), ExceptionUtils.getMessage(e)));
            throw new RuntimeException(e);
        }
        LOGGER.info(String.format("Job %s (%s) end with state %s", new Object[]{this.jobImmutableInformation.getJobConfig().getName(), this.jobImmutableInformation.getJobId(), jobStatus}));
        return jobStatus;
    }

    @Override
    public PassiveCompletableFuture<JobStatus> doWaitForJobComplete() {
        return this.seaTunnelHazelcastClient.requestOnMasterAndGetCompletableFuture(SeaTunnelWaitForJobCompleteCodec.encodeRequest(this.jobImmutableInformation.getJobId()), response -> JobStatus.values()[SeaTunnelWaitForJobCompleteCodec.decodeResponse(response)]);
    }

    @Override
    public void cancelJob() {
        PassiveCompletableFuture<Void> cancelFuture = this.seaTunnelHazelcastClient.requestOnMasterAndGetCompletableFuture(SeaTunnelCancelJobCodec.encodeRequest(this.jobImmutableInformation.getJobId()));
        cancelFuture.join();
    }

    @Override
    public JobStatus getJobStatus() {
        int jobStatusOrdinal = (Integer)this.seaTunnelHazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelGetJobStatusCodec.encodeRequest(this.jobImmutableInformation.getJobId()), SeaTunnelGetJobStatusCodec::decodeResponse);
        return JobStatus.values()[jobStatusOrdinal];
    }
}

