/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class OptimizeCalls
implements CompilerPass {
    private final List<CallGraphCompilerPass> passes = new ArrayList<CallGraphCompilerPass>();
    private final AbstractCompiler compiler;

    OptimizeCalls(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    OptimizeCalls addPass(CallGraphCompilerPass pass) {
        this.passes.add(pass);
        return this;
    }

    @Override
    public void process(Node externs, Node root) {
        if (!this.passes.isEmpty()) {
            ReferenceMap refMap = OptimizeCalls.buildPropAndGlobalNameReferenceMap(this.compiler, externs, root);
            for (CallGraphCompilerPass pass : this.passes) {
                pass.process(externs, root, refMap);
            }
        }
    }

    private static Set<String> safeSet(@Nullable Set<String> set) {
        return set != null ? ImmutableSet.copyOf(set) : ImmutableSet.of();
    }

    static ReferenceMap buildPropAndGlobalNameReferenceMap(AbstractCompiler compiler, Node externs, Node root) {
        ReferenceMap references = new ReferenceMap();
        NodeTraversal.traverseRoots(compiler, new ReferenceMapBuildingCallback(compiler, references), externs, root);
        return references;
    }

    static boolean mayBeOptimizableName(AbstractCompiler compiler, String name) {
        if (compiler.getCodingConvention().isExported(name)) {
            return false;
        }
        return !name.equals("JSCompiler_renameProperty") && !name.equals("JSCompiler_ObjectPropertyString") && !name.equals("inherits") && !name.equals("$jscomp$inherits") && !name.equals("goog$inherits");
    }

    static boolean isAllowedReference(Node n) {
        Node parent = n.getParent();
        switch (parent.getToken()) {
            case FOR_IN: 
            case FOR_OF: {
                return parent.getSecondChild() == n;
            }
            case INSTANCEOF: 
            case TYPEOF: 
            case IN: {
                return true;
            }
            case GETELEM: 
            case GETPROP: {
                Node grandparent = parent.getParent();
                return n != parent.getFirstChild() || grandparent == null || !grandparent.isCall();
            }
        }
        return NodeUtil.isNameDeclaration(parent) && !n.hasChildren();
    }

    static class ReferenceMapBuildingCallback
    implements NodeTraversal.ScopedCallback {
        AbstractCompiler compiler;
        final Set<String> externProps;
        final ReferenceMap references;
        private Scope globalScope;

        public ReferenceMapBuildingCallback(AbstractCompiler compiler, ReferenceMap references) {
            this.compiler = compiler;
            this.externProps = OptimizeCalls.safeSet(compiler.getExternProperties());
            this.references = references;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node unused) {
            switch (n.getToken()) {
                case NAME: {
                    this.maybeAddNameReference(n);
                    break;
                }
                case COMPUTED_PROP: {
                    break;
                }
                case GETELEM: {
                    break;
                }
                case GETPROP: {
                    this.maybeAddPropReference(n.getLastChild().getString(), n);
                    break;
                }
                case STRING_KEY: 
                case GETTER_DEF: 
                case SETTER_DEF: 
                case MEMBER_FUNCTION_DEF: {
                    if (n.isQuotedString()) break;
                    this.maybeAddPropReference(n.getString(), n);
                    break;
                }
            }
        }

        private void maybeAddNameReference(Node n) {
            String name = n.getString();
            if (this.isGlobalNonExternNameReference(name)) {
                this.references.addNameReference(name, n);
            }
        }

        private void maybeAddPropReference(String name, Node n) {
            if (!this.externProps.contains(name)) {
                this.references.addPropReference(name, n);
            }
        }

        private boolean isGlobalNonExternNameReference(String name) {
            Var v = (Var)this.globalScope.getSlot(name);
            return v != null && !v.isExtern();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isScript() || !t.getInput().isExtern();
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                this.globalScope = t.getScope();
                this.references.globalScope = this.globalScope;
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }
    }

    static class ReferenceMap {
        private Scope globalScope;
        private final LinkedHashMap<String, ArrayList<Node>> names = new LinkedHashMap();
        private final LinkedHashMap<String, ArrayList<Node>> props = new LinkedHashMap();

        ReferenceMap() {
        }

        private void addReference(LinkedHashMap<String, ArrayList<Node>> data, String name, Node n) {
            ArrayList<Node> refs = data.get(name);
            if (refs == null) {
                refs = new ArrayList();
                data.put(name, refs);
            }
            refs.add(n);
        }

        void addNameReference(String name, Node n) {
            this.addReference(this.names, name, n);
        }

        void addPropReference(String name, Node n) {
            this.addReference(this.props, name, n);
        }

        Scope getGlobalScope() {
            return this.globalScope;
        }

        Iterable<Map.Entry<String, ArrayList<Node>>> getNameReferences() {
            return this.names.entrySet();
        }

        Iterable<Map.Entry<String, ArrayList<Node>>> getPropReferences() {
            return this.props.entrySet();
        }

        static ImmutableListMultimap<Node, Node> getFunctionNodes(List<Node> definitionSites) {
            ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
            for (Node def : definitionSites) {
                result.putAll((Object)def, ReferenceMap.definitionFunctionNodesFor(def));
            }
            return result.build();
        }

        private static List<Node> definitionFunctionNodesFor(Node definitionSite) {
            if (definitionSite.isGetterDef() || definitionSite.isSetterDef()) {
                return ImmutableList.of();
            }
            Node parent = definitionSite.getParent();
            if (parent == null) {
                return ImmutableList.of();
            }
            ArrayList<Node> fns = new ArrayList<Node>();
            switch (parent.getToken()) {
                case FUNCTION: {
                    fns.add(parent);
                    break;
                }
                case CLASS_MEMBERS: {
                    Preconditions.checkArgument(definitionSite.isMemberFunctionDef());
                    fns.add(definitionSite.getLastChild());
                    break;
                }
                case OBJECTLIT: {
                    Preconditions.checkArgument(definitionSite.isStringKey());
                    ReferenceMap.addValueFunctionNodes(fns, definitionSite.getLastChild());
                    break;
                }
                case ASSIGN: {
                    Node target = parent.getFirstChild();
                    Node value = parent.getLastChild();
                    if (definitionSite != target) break;
                    ReferenceMap.addValueFunctionNodes(fns, value);
                    break;
                }
                case CONST: 
                case LET: 
                case VAR: {
                    if (!definitionSite.isName() || !definitionSite.hasChildren()) break;
                    ReferenceMap.addValueFunctionNodes(fns, definitionSite.getFirstChild());
                    break;
                }
            }
            return fns;
        }

        private static void addValueFunctionNodes(ArrayList<Node> fns, Node n) {
            switch (n.getToken()) {
                case FUNCTION: {
                    fns.add(n);
                    break;
                }
                case HOOK: {
                    ReferenceMap.addValueFunctionNodes(fns, n.getSecondChild());
                    ReferenceMap.addValueFunctionNodes(fns, n.getLastChild());
                    break;
                }
                case OR: 
                case AND: {
                    ReferenceMap.addValueFunctionNodes(fns, n.getFirstChild());
                    ReferenceMap.addValueFunctionNodes(fns, n.getLastChild());
                    break;
                }
                case CAST: 
                case COMMA: {
                    ReferenceMap.addValueFunctionNodes(fns, n.getLastChild());
                    break;
                }
            }
        }

        static boolean isCallOrNewTarget(Node n) {
            return ReferenceMap.isCallTarget(n) || ReferenceMap.isNewTarget(n);
        }

        static boolean isCallTarget(Node n) {
            Node parent = n.getParent();
            return parent.getFirstChild() == n && parent.isCall() || parent.isGetProp() && parent.getParent().isCall() && parent.getLastChild().getString().equals("call");
        }

        static boolean isNewTarget(Node n) {
            Node parent = n.getParent();
            return parent.isNew() && parent.getFirstChild() == n;
        }

        static Node getCallOrNewNodeForTarget(Node n) {
            Node maybeCall = n.getParent();
            Preconditions.checkState(n.isFirstChildOf(maybeCall), "%s\n\n%s", (Object)maybeCall, (Object)n);
            if (NodeUtil.isCallOrNew(maybeCall)) {
                return maybeCall;
            }
            Node child = maybeCall;
            maybeCall = child.getParent();
            Preconditions.checkState(child.isGetProp(), child);
            Preconditions.checkState(maybeCall.isCall(), maybeCall);
            Preconditions.checkState(child.isFirstChildOf(maybeCall), "%s\n\n%s", (Object)maybeCall, (Object)child);
            return maybeCall;
        }

        static Node getFirstArgumentForCallOrNewOrDotCall(Node n) {
            return ReferenceMap.getArgumentForCallOrNewOrDotCall(n, 0);
        }

        static Node getArgumentForCallOrNewOrDotCall(Node n, int index) {
            int adjustedIndex = index;
            Node parent = n.getParent();
            if (!parent.isCall() && !parent.isNew() && NodeUtil.isFunctionObjectCall(parent = parent.getParent())) {
                ++adjustedIndex;
            }
            return NodeUtil.getArgumentForCallOrNew(parent, adjustedIndex);
        }

        static boolean isSimpleAssignmentTarget(Node n) {
            Node parent = n.getParent();
            return parent.isAssign() && n == parent.getFirstChild();
        }
    }

    static interface CallGraphCompilerPass {
        public void process(Node var1, Node var2, ReferenceMap var3);
    }
}

