/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoTraceRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.FunctionCallID, (node, tokenQuery, problems) -> this.checkFunctionCallNode((IFunctionCallNode)node, tokenQuery, problems));
        return result;
    }

    private void checkFunctionCallNode(IFunctionCallNode functionCallNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (!"trace".equals(functionCallNode.getFunctionName())) {
            return;
        }
        IASNode parentNode = functionCallNode.getParent();
        if (parentNode instanceof IMemberAccessExpressionNode) {
            return;
        }
        problems.add(new NoTraceLinterProblem(functionCallNode));
    }

    public static class NoTraceLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Must not call trace() function";

        public NoTraceLinterProblem(IFunctionCallNode node) {
            super((ISourceLocation)node);
        }
    }
}

