/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.ActionDecoder;
import flash.swf.DebugDecoder;
import flash.swf.Dictionary;
import flash.swf.Header;
import flash.swf.SwfDecoder;
import flash.swf.SwfFormatException;
import flash.swf.Tag;
import flash.swf.TagHandler;
import flash.swf.TagValues;
import flash.swf.debug.DebugTable;
import flash.swf.tags.CSMTextSettings;
import flash.swf.tags.DebugID;
import flash.swf.tags.DefineBinaryData;
import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineBitsJPEG3;
import flash.swf.tags.DefineBitsLossless;
import flash.swf.tags.DefineButton;
import flash.swf.tags.DefineButtonCxform;
import flash.swf.tags.DefineButtonSound;
import flash.swf.tags.DefineEditText;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineFont1;
import flash.swf.tags.DefineFont2;
import flash.swf.tags.DefineFont3;
import flash.swf.tags.DefineFont4;
import flash.swf.tags.DefineFontAlignZones;
import flash.swf.tags.DefineFontInfo;
import flash.swf.tags.DefineFontName;
import flash.swf.tags.DefineMorphShape;
import flash.swf.tags.DefineScalingGrid;
import flash.swf.tags.DefineSceneAndFrameLabelData;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineSound;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DefineText;
import flash.swf.tags.DefineVideoStream;
import flash.swf.tags.DoABC;
import flash.swf.tags.DoAction;
import flash.swf.tags.DoInitAction;
import flash.swf.tags.EnableDebugger;
import flash.swf.tags.EnableTelemetry;
import flash.swf.tags.ExportAssets;
import flash.swf.tags.FileAttributes;
import flash.swf.tags.FrameLabel;
import flash.swf.tags.GenericTag;
import flash.swf.tags.ImportAssets;
import flash.swf.tags.Metadata;
import flash.swf.tags.PlaceObject;
import flash.swf.tags.ProductInfo;
import flash.swf.tags.RemoveObject;
import flash.swf.tags.ScriptLimits;
import flash.swf.tags.SetBackgroundColor;
import flash.swf.tags.SetTabIndex;
import flash.swf.tags.ShowFrame;
import flash.swf.tags.SoundStreamHead;
import flash.swf.tags.StartSound;
import flash.swf.tags.SymbolClass;
import flash.swf.tags.VideoFrame;
import flash.swf.tags.ZoneRecord;
import flash.swf.types.BevelFilter;
import flash.swf.types.BlurFilter;
import flash.swf.types.ButtonCondAction;
import flash.swf.types.ButtonRecord;
import flash.swf.types.CXForm;
import flash.swf.types.CXFormWithAlpha;
import flash.swf.types.ColorMatrixFilter;
import flash.swf.types.ConvolutionFilter;
import flash.swf.types.CurvedEdgeRecord;
import flash.swf.types.DropShadowFilter;
import flash.swf.types.FillStyle;
import flash.swf.types.Filter;
import flash.swf.types.FlashUUID;
import flash.swf.types.FocalGradient;
import flash.swf.types.GlowFilter;
import flash.swf.types.GlyphEntry;
import flash.swf.types.GradRecord;
import flash.swf.types.Gradient;
import flash.swf.types.GradientBevelFilter;
import flash.swf.types.GradientGlowFilter;
import flash.swf.types.ImportRecord;
import flash.swf.types.KerningRecord;
import flash.swf.types.LineStyle;
import flash.swf.types.Matrix;
import flash.swf.types.MorphFillStyle;
import flash.swf.types.MorphGradRecord;
import flash.swf.types.MorphLineStyle;
import flash.swf.types.Rect;
import flash.swf.types.Shape;
import flash.swf.types.ShapeRecord;
import flash.swf.types.ShapeWithStyle;
import flash.swf.types.SoundInfo;
import flash.swf.types.StraightEdgeRecord;
import flash.swf.types.StyleChangeRecord;
import flash.swf.types.TextRecord;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.InflaterInputStream;

public final class TagDecoder
implements TagValues {
    private Header header;
    private InputStream swfIn;
    private InputStream swdIn;
    private URL swfUrl;
    private DebugTable swd;
    private SwfDecoder r;
    private GenericTag jpegTables;
    private TagHandler handler;
    private boolean keepOffsets;
    private Dictionary dict = new Dictionary();

    public TagDecoder(InputStream swfIn) {
        this.swfIn = swfIn;
        this.swdIn = null;
    }

    public TagDecoder(InputStream swfIn, InputStream swdIn) {
        this.swfIn = swfIn;
        this.swdIn = swdIn;
    }

    public TagDecoder(InputStream in, URL swfUrl) {
        this.swfIn = in;
        this.swfUrl = swfUrl;
    }

    public void setKeepOffsets(boolean b) {
        this.keepOffsets = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(TagHandler handler) throws IOException {
        this.handler = handler;
        try {
            try {
                handler.setDecoderDictionary(this.dict);
                this.header = this.decodeHeader();
                handler.header(this.header);
                this.decodeTags(handler);
                handler.finish();
                if (this.swfIn == null) return;
            }
            catch (FatalParseException fatalParseException) {
                if (this.swfIn == null) return;
                this.swfIn.close();
                return;
            }
            catch (Throwable throwable) {
                if (this.swfIn == null) throw throwable;
                this.swfIn.close();
                throw throwable;
            }
            this.swfIn.close();
            return;
        }
        finally {
            if (this.swdIn != null) {
                this.swdIn.close();
            }
        }
    }

    public int getSwfVersion() {
        return this.header.version;
    }

    private void decodeTags(TagHandler handler) throws IOException {
        int type;
        do {
            int currentOffset = this.r.getOffset();
            int h = this.r.readUI16();
            type = h >> 6;
            int length = h & 0x3F;
            if (length == 63 && (length = this.r.readSI32()) < 0) {
                handler.error("negative tag length: " + length + " at offset " + currentOffset);
                break;
            }
            int o = this.r.getOffset();
            int eat = 0;
            if (type == 0) continue;
            Tag t = this.decodeTag(type, length);
            if (this.r.getOffset() - o != length) {
                handler.error("offset mismatch after " + Tag.names[t.code] + ": read " + (this.r.getOffset() - o) + ", expected " + length);
                if (this.r.getOffset() - o < length) {
                    eat = length - (this.r.getOffset() - o);
                }
            }
            handler.setOffsetAndSize(currentOffset, this.r.getOffset() - currentOffset);
            handler.any(t);
            t.visit(handler);
            if (eat <= 0) continue;
            this.r.read(new byte[eat]);
        } while (type != 0);
    }

    private Tag decodeTag(int type, int length) throws IOException {
        Tag t;
        int pos = this.r.getOffset();
        switch (type) {
            case 41: {
                t = this.decodeSerialNumber();
                break;
            }
            case 1: {
                t = new ShowFrame();
                break;
            }
            case 77: {
                t = this.decodeMetadata();
                break;
            }
            case 2: 
            case 22: 
            case 32: 
            case 83: {
                t = this.decodeDefineShape(type);
                break;
            }
            case 4: {
                t = this.decodePlaceObject(length);
                break;
            }
            case 5: 
            case 28: {
                t = this.decodeRemoveObject(type);
                break;
            }
            case 87: {
                t = this.decodeDefineBinaryData(length);
                break;
            }
            case 6: {
                t = this.decodeDefineBits(length);
                break;
            }
            case 7: {
                t = this.decodeDefineButton(length);
                break;
            }
            case 8: {
                this.jpegTables = this.decodeJPEGTables(length);
                t = this.jpegTables;
                break;
            }
            case 9: {
                t = this.decodeSetBackgroundColor();
                break;
            }
            case 10: {
                t = this.decodeDefineFont();
                break;
            }
            case 11: 
            case 33: {
                t = this.decodeDefineText(type);
                break;
            }
            case 12: {
                t = this.decodeDoAction(length);
                break;
            }
            case 13: 
            case 62: {
                t = this.decodeDefineFontInfo(type, length);
                break;
            }
            case 14: {
                t = this.decodeDefineSound(length);
                break;
            }
            case 15: {
                t = this.decodeStartSound();
                break;
            }
            case 17: {
                t = this.decodeDefineButtonSound();
                break;
            }
            case 18: 
            case 45: {
                t = this.decodeSoundStreamHead(type);
                break;
            }
            case 19: {
                t = this.decodeSoundStreamBlock(length);
                break;
            }
            case 20: {
                t = this.decodeDefineBitsLossless(length);
                break;
            }
            case 21: {
                t = this.decodeDefineJPEG2(length);
                break;
            }
            case 23: {
                t = this.decodeDefineButtonCxform();
                break;
            }
            case 24: {
                t = this.decodeProtect(length);
                break;
            }
            case 26: {
                t = this.decodePlaceObject23(26, length);
                break;
            }
            case 70: {
                t = this.decodePlaceObject23(70, length);
                break;
            }
            case 34: {
                t = this.decodeDefineButton2(length);
                break;
            }
            case 35: {
                t = this.decodeDefineJPEG3(length);
                break;
            }
            case 36: {
                t = this.decodeDefineBitsLossless2(length);
                break;
            }
            case 37: {
                t = this.decodeDefineEditText();
                break;
            }
            case 39: {
                t = this.decodeDefineSprite(pos + length);
                break;
            }
            case 78: {
                t = this.decodeDefineScalingGrid();
                break;
            }
            case 43: {
                t = this.decodeFrameLabel(length);
                break;
            }
            case 46: {
                t = this.decodeDefineMorphShape();
                break;
            }
            case 84: {
                t = this.decodeDefineMorphShape2();
                break;
            }
            case 48: {
                t = this.decodeDefineFont2();
                break;
            }
            case 75: {
                t = this.decodeDefineFont3();
                break;
            }
            case 91: {
                t = this.decodeDefineFont4(length);
                break;
            }
            case 56: {
                t = this.decodeExportAssets();
                break;
            }
            case 57: 
            case 71: {
                t = this.decodeImportAssets(type);
                break;
            }
            case 58: 
            case 64: {
                t = this.decodeEnableDebugger(type);
                break;
            }
            case 59: {
                t = this.decodeDoInitAction(length);
                break;
            }
            case 60: {
                t = this.decodeDefineVideoStream();
                break;
            }
            case 61: {
                t = this.decodeVideoFrame(length);
                break;
            }
            case 63: {
                t = this.decodeDebugID(type, length);
                break;
            }
            case 65: {
                t = this.decodeScriptLimits();
                break;
            }
            case 66: {
                t = this.decodeSetTabIndex();
                break;
            }
            case 72: 
            case 82: {
                t = this.decodeDoABC(type, length);
                break;
            }
            case 76: {
                t = this.decodeSymbolClass();
                break;
            }
            case 69: {
                t = this.decodeFileAttributes();
                break;
            }
            case 93: {
                t = this.decodeEnableTelemetry();
                break;
            }
            case 73: {
                t = this.decodeDefineFontAlignZones();
                break;
            }
            case 74: {
                t = this.decodeCSMTextSettings();
                break;
            }
            case 86: {
                t = this.decodeDefineSceneAndFrameData(length);
                break;
            }
            case 88: {
                t = this.decodeDefineFontName();
                break;
            }
            default: {
                t = this.decodeUnknown(length, type);
            }
        }
        int consumed = this.r.getOffset() - pos;
        if (consumed != length && type == 18 && consumed != length + 2) {
            throw new SwfFormatException(TagValues.names[type] + " at pos " + pos + ": " + consumed + " bytes were read. " + length + " byte were required.");
        }
        return t;
    }

    private Tag decodeDefineSceneAndFrameData(int length) throws IOException {
        DefineSceneAndFrameLabelData t = new DefineSceneAndFrameLabelData();
        t.data = new byte[length];
        this.r.readFully(t.data);
        return t;
    }

    private Tag decodeDoABC(int type, int length) throws IOException {
        DoABC t;
        if (type == 82) {
            int pos = this.r.getOffset();
            int skip = this.r.readSI32();
            String name = this.r.readString();
            t = new DoABC(name, skip);
            length -= this.r.getOffset() - pos;
        } else {
            t = new DoABC();
        }
        t.abc = new byte[length];
        this.r.readFully(t.abc);
        return t;
    }

    private Tag decodeSymbolClass() throws IOException {
        SymbolClass t = new SymbolClass();
        int count = this.r.readUI16();
        t.class2tag = new HashMap<String, Tag>(count);
        for (int i = 0; i < count; ++i) {
            int idref = this.r.readUI16();
            String name = this.r.readString();
            if (idref == 0) {
                t.topLevelClass = name;
                continue;
            }
            DefineTag ref = this.dict.getTag(idref);
            t.class2tag.put(name, ref);
            if (ref.name != null) {
                if (ref.name.equals(name)) continue;
                this.handler.error("SymbolClass: symbol " + idref + " already exported as " + ref.name);
                continue;
            }
            DefineTag other = this.dict.getTag(name);
            if (other != null) {
                int id = this.dict.getId(other);
                this.handler.error("Symbol " + name + " already refers to ID " + id);
            }
            ref.name = name;
            this.dict.addName(ref, name);
        }
        return t;
    }

    private Tag decodeSetTabIndex() throws IOException {
        int depth = this.r.readUI16();
        int index = this.r.readUI16();
        return new SetTabIndex(depth, index);
    }

    private Tag decodeUnknown(int length, int code) throws IOException {
        GenericTag t = new GenericTag(code);
        t.data = new byte[length];
        this.r.readFully(t.data);
        return t;
    }

    private ScriptLimits decodeScriptLimits() throws IOException {
        ScriptLimits scriptLimits = new ScriptLimits(this.r.readUI16(), this.r.readUI16());
        return scriptLimits;
    }

    private Tag decodeDebugID(int type, int length) throws IOException {
        DebugID t = new DebugID(type);
        t.uuid = this.decodeFlashUUID(length);
        if (this.swdIn != null) {
            InputStream in = this.swdIn;
            DebugTable swd = new DebugTable();
            new DebugDecoder(in).readSwd(swd);
            if (!t.uuid.equals(swd.uuid)) {
                this.handler.error("SWD uuid " + swd.uuid + " doesn't match " + t.uuid);
            } else if (swd.version != this.getSwfVersion()) {
                this.handler.error("SWD version number " + swd.version + " doesn't match SWF version number " + this.getSwfVersion());
            } else {
                this.swd = swd;
            }
        } else if (this.swfUrl != null) {
            Object path = this.swfUrl.toString();
            int q = ((String)path).indexOf("?");
            String query = null;
            if (q != -1) {
                query = ((String)path).substring(q);
                path = ((String)path).substring(0, q);
            }
            path = ((String)path).endsWith(".swf") ? ((String)path).substring(0, ((String)path).length() - 4) + ".swd" : (String)path + ".swd";
            if (query != null) {
                path = (String)path + query;
            }
            URL swdUrl = new URL((String)path);
            try {
                InputStream in = swdUrl.openStream();
                DebugTable swd = new DebugTable();
                new DebugDecoder(in).readSwd(swd);
                if (!t.uuid.equals(swd.uuid)) {
                    this.handler.error("SWD uuid " + swd.uuid + " doesn't match " + t.uuid);
                } else if (swd.version != this.getSwfVersion()) {
                    this.handler.error("SWD version number " + swd.version + " doesn't match SWF version number " + this.getSwfVersion());
                } else {
                    this.swd = swd;
                }
            }
            catch (FileNotFoundException ex) {
                this.handler.error("SWD not found at url " + swdUrl);
            }
        }
        return t;
    }

    private FlashUUID decodeFlashUUID(int length) throws IOException {
        byte[] uuid = new byte[length];
        this.r.readFully(uuid);
        return new FlashUUID(uuid);
    }

    private Tag decodeVideoFrame(int length) throws IOException {
        VideoFrame t = new VideoFrame();
        int pos = this.r.getOffset();
        int idref = this.r.readUI16();
        t.stream = (DefineVideoStream)this.dict.getTag(idref);
        t.frameNum = this.r.readUI16();
        t.videoData = new byte[length -= this.r.getOffset() - pos];
        this.r.readFully(t.videoData);
        return t;
    }

    private Tag decodeDefineVideoStream() throws IOException {
        DefineVideoStream t = new DefineVideoStream();
        int id = this.r.readUI16();
        t.numFrames = this.r.readUI16();
        t.width = this.r.readUI16();
        t.height = this.r.readUI16();
        this.r.syncBits();
        this.r.readUBits(4);
        t.deblocking = this.r.readUBits(3);
        t.smoothing = this.r.readBit();
        t.codecID = this.r.readUI8();
        this.dict.add(id, t);
        return t;
    }

    private Tag decodeDoInitAction(int length) throws IOException {
        DoInitAction t = new DoInitAction();
        int idref = this.r.readUI16();
        try {
            t.sprite = (DefineSprite)this.dict.getTag(idref);
            if (t.sprite.initAction != null) {
                this.handler.error("Sprite " + idref + " initaction redefined");
            } else {
                t.sprite.initAction = t;
            }
        }
        catch (IllegalArgumentException e) {
            this.handler.error(e.getMessage());
        }
        ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
        actionDecoder.setKeepOffsets(this.keepOffsets);
        t.actionList = actionDecoder.decode(length - 2);
        return t;
    }

    private Tag decodeEnableDebugger(int code) throws IOException {
        EnableDebugger t = new EnableDebugger(code);
        if (code == 64) {
            if (this.getSwfVersion() < 6) {
                this.handler.error("EnableDebugger2 not valid before SWF 6");
            }
            t.reserved = this.r.readUI16();
        }
        t.password = this.r.readString();
        return t;
    }

    private Tag decodeImportAssets(int code) throws IOException {
        ImportAssets t = new ImportAssets(code);
        t.url = this.r.readString();
        if (code == 71) {
            boolean bl = t.downloadNow = this.r.readUI8() == 1;
            if (this.r.readUI8() == 1) {
                t.SHA1 = new byte[20];
                this.r.readFully(t.SHA1);
            }
        }
        int count = this.r.readUI16();
        t.importRecords = new ArrayList<ImportRecord>();
        for (int i = 0; i < count; ++i) {
            ImportRecord ir = new ImportRecord();
            int id = this.r.readUI16();
            ir.name = this.r.readString();
            t.importRecords.add(ir);
            this.dict.add(id, ir);
            this.dict.addName(ir, ir.name);
        }
        return t;
    }

    private Tag decodeExportAssets() throws IOException {
        ExportAssets t = new ExportAssets();
        int count = this.r.readUI16();
        t.exports = new ArrayList<Tag>(count);
        for (int i = 0; i < count; ++i) {
            int idref = this.r.readUI16();
            String name = this.r.readString();
            DefineTag ref = this.dict.getTag(idref);
            t.exports.add(ref);
            if (ref.name != null) {
                if (!ref.name.equals(name)) {
                    this.handler.error("ExportAsset: symbol " + idref + " already exported as " + ref.name);
                    continue;
                }
                this.handler.error("redundant export of " + ref.name);
                continue;
            }
            DefineTag other = this.dict.getTag(name);
            if (other != null) {
                int id = this.dict.getId(other);
                this.handler.error("Symbol " + name + " already refers to ID " + id);
            }
            ref.name = name;
            this.dict.addName(ref, name);
        }
        return t;
    }

    private Tag decodeDefineFont2() throws IOException {
        DefineFont2 t = new DefineFont2();
        return this.decodeDefineFont2And3(t);
    }

    private Tag decodeDefineFont3() throws IOException {
        DefineFont3 t = new DefineFont3();
        return this.decodeDefineFont2And3(t);
    }

    private Tag decodeDefineFont2And3(DefineFont2 t) throws IOException {
        int i;
        int id = this.r.readUI16();
        this.r.syncBits();
        t.hasLayout = this.r.readBit();
        t.shiftJIS = this.r.readBit();
        t.smallText = this.r.readBit();
        t.ansi = this.r.readBit();
        t.wideOffsets = this.r.readBit();
        t.wideCodes = this.r.readBit();
        t.italic = this.r.readBit();
        t.bold = this.r.readBit();
        t.langCode = this.r.readUI8();
        t.fontName = this.r.readLengthString();
        int numGlyphs = this.r.readUI16();
        long[] offsets = new long[numGlyphs];
        for (int i2 = 0; i2 < numGlyphs; ++i2) {
            offsets[i2] = t.wideOffsets ? this.r.readUI32() : (long)this.r.readUI16();
        }
        long codeTableOffset = 0L;
        if (numGlyphs > 0) {
            codeTableOffset = t.wideOffsets ? this.r.readUI32() : (long)this.r.readUI16();
        }
        t.glyphShapeTable = new Shape[numGlyphs];
        for (i = 0; i < numGlyphs; ++i) {
            int glyphLength = i < numGlyphs - 1 ? (int)(offsets[i + 1] - offsets[i]) : (int)(codeTableOffset - offsets[i]);
            t.glyphShapeTable[i] = this.decodeGlyph(32, glyphLength);
        }
        t.codeTable = new char[numGlyphs];
        if (t.wideCodes) {
            for (i = 0; i < numGlyphs; ++i) {
                t.codeTable[i] = (char)this.r.readUI16();
            }
        } else {
            for (i = 0; i < numGlyphs; ++i) {
                t.codeTable[i] = (char)this.r.readUI8();
            }
        }
        if (t.hasLayout) {
            t.ascent = this.r.readSI16();
            t.descent = this.r.readSI16();
            t.leading = this.r.readSI16();
            t.advanceTable = new short[numGlyphs];
            for (i = 0; i < numGlyphs; ++i) {
                t.advanceTable[i] = (short)this.r.readSI16();
            }
            t.boundsTable = new Rect[numGlyphs];
            for (i = 0; i < numGlyphs; ++i) {
                t.boundsTable[i] = this.decodeRect();
            }
            t.kerningCount = this.r.readUI16();
            t.kerningTable = new KerningRecord[t.kerningCount];
            for (i = 0; i < t.kerningCount; ++i) {
                t.kerningTable[i] = this.decodeKerningRecord(t.wideCodes);
            }
        }
        this.dict.add(id, t);
        this.dict.addFontFace(t);
        return t;
    }

    private Tag decodeDefineFont4(int length) throws IOException {
        DefineFont4 t = new DefineFont4();
        int pos = this.r.getOffset();
        int id = this.r.readUI16();
        this.r.syncBits();
        this.r.readUBits(5);
        t.hasFontData = this.r.readBit();
        t.italic = this.r.readBit();
        t.bold = this.r.readBit();
        t.fontName = this.r.readString();
        if (t.hasFontData) {
            t.data = new byte[length -= this.r.getOffset() - pos];
            this.r.readFully(t.data);
        }
        this.dict.add(id, t);
        this.dict.addFontFace(t);
        return t;
    }

    private KerningRecord decodeKerningRecord(boolean wideCodes) throws IOException {
        KerningRecord kr = new KerningRecord();
        kr.code1 = wideCodes ? this.r.readUI16() : this.r.readUI8();
        kr.code2 = wideCodes ? this.r.readUI16() : this.r.readUI8();
        kr.adjustment = this.r.readUI16();
        return kr;
    }

    private Tag decodeDefineMorphShape() throws IOException {
        return this.decodeDefineMorphShape(46);
    }

    private Tag decodeDefineMorphShape2() throws IOException {
        return this.decodeDefineMorphShape(84);
    }

    private Tag decodeDefineMorphShape(int code) throws IOException {
        DefineMorphShape t = new DefineMorphShape(code);
        int id = this.r.readUI16();
        t.startBounds = this.decodeRect();
        t.endBounds = this.decodeRect();
        if (code == 84) {
            t.startEdgeBounds = this.decodeRect();
            t.endEdgeBounds = this.decodeRect();
            this.r.readUBits(6);
            t.usesNonScalingStrokes = this.r.readBit();
            t.usesScalingStrokes = this.r.readBit();
        }
        int offset = (int)this.r.readUI32();
        t.fillStyles = this.decodeMorphFillstyles(code);
        t.lineStyles = this.decodeMorphLinestyles(code);
        t.startEdges = this.decodeShape(32);
        if (offset != 0) {
            t.endEdges = this.decodeShape(32);
        }
        this.dict.add(id, t);
        return t;
    }

    private MorphLineStyle[] decodeMorphLinestyles(int code) throws IOException {
        int count = this.r.readUI8();
        if (count == 255) {
            count = this.r.readUI16();
        }
        MorphLineStyle[] styles = new MorphLineStyle[count];
        for (int i = 0; i < count; ++i) {
            MorphLineStyle s = new MorphLineStyle();
            s.startWidth = this.r.readUI16();
            s.endWidth = this.r.readUI16();
            if (code == 84) {
                s.startCapsStyle = this.r.readUBits(2);
                s.jointStyle = this.r.readUBits(2);
                s.hasFill = this.r.readBit();
                s.noHScale = this.r.readBit();
                s.noVScale = this.r.readBit();
                s.pixelHinting = this.r.readBit();
                this.r.readUBits(5);
                s.noClose = this.r.readBit();
                s.endCapsStyle = this.r.readUBits(2);
                if (s.jointStyle == 2) {
                    s.miterLimit = this.r.readUI16();
                }
            }
            if (!s.hasFill) {
                s.startColor = this.decodeRGBA(this.r);
                s.endColor = this.decodeRGBA(this.r);
            }
            if (s.hasFill) {
                s.fillType = this.decodeMorphFillStyle(code);
            }
            styles[i] = s;
        }
        return styles;
    }

    private MorphFillStyle[] decodeMorphFillstyles(int shape) throws IOException {
        int count = this.r.readUI8();
        if (count == 255) {
            count = this.r.readUI16();
        }
        MorphFillStyle[] styles = new MorphFillStyle[count];
        for (int i = 0; i < count; ++i) {
            styles[i] = this.decodeMorphFillStyle(shape);
        }
        return styles;
    }

    private MorphFillStyle decodeMorphFillStyle(int shape) throws IOException {
        MorphFillStyle s = new MorphFillStyle();
        s.type = this.r.readUI8();
        switch (s.type) {
            case 0: {
                s.startColor = this.decodeRGBA(this.r);
                s.endColor = this.decodeRGBA(this.r);
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                s.startGradientMatrix = this.decodeMatrix();
                s.endGradientMatrix = this.decodeMatrix();
                s.gradRecords = this.decodeMorphGradient();
                if (s.type != 19 || shape != 84) break;
                s.ratio1 = this.r.readSI16();
                s.ratio2 = this.r.readSI16();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                int idref = this.r.readUI16();
                try {
                    s.bitmap = this.dict.getTag(idref);
                }
                catch (IllegalArgumentException ex) {
                    this.handler.error(ex.getMessage());
                    s.bitmap = null;
                }
                s.startBitmapMatrix = this.decodeMatrix();
                s.endBitmapMatrix = this.decodeMatrix();
                break;
            }
            default: {
                throw new SwfFormatException("unrecognized fill style type: " + s.type);
            }
        }
        return s;
    }

    private MorphGradRecord[] decodeMorphGradient() throws IOException {
        int num = this.r.readUI8();
        MorphGradRecord[] gradRecords = new MorphGradRecord[num];
        for (int i = 0; i < num; ++i) {
            MorphGradRecord g = new MorphGradRecord();
            g.startRatio = this.r.readUI8();
            g.startColor = this.decodeRGBA(this.r);
            g.endRatio = this.r.readUI8();
            g.endColor = this.decodeRGBA(this.r);
            gradRecords[i] = g;
        }
        return gradRecords;
    }

    private Tag decodeFrameLabel(int length) throws IOException {
        FrameLabel t = new FrameLabel();
        int pos = this.r.getOffset();
        t.label = this.r.readString();
        if (this.getSwfVersion() >= 6 && length - this.r.getOffset() + pos == 1) {
            int anchor = this.r.readUI8();
            if (anchor != 0 && anchor != 1) {
                this.handler.error("illegal anchor value: " + anchor + ".  Must be 0 or 1");
            }
            t.anchor = anchor != 0;
        }
        return t;
    }

    private Tag decodeDefineEditText() throws IOException {
        DefineEditText t = new DefineEditText();
        int id = this.r.readUI16();
        t.bounds = this.decodeRect();
        this.r.syncBits();
        t.hasText = this.r.readBit();
        t.wordWrap = this.r.readBit();
        t.multiline = this.r.readBit();
        t.password = this.r.readBit();
        t.readOnly = this.r.readBit();
        t.hasTextColor = this.r.readBit();
        t.hasMaxLength = this.r.readBit();
        t.hasFont = this.r.readBit();
        t.hasFontClass = this.r.readBit();
        t.autoSize = this.r.readBit();
        t.hasLayout = this.r.readBit();
        t.noSelect = this.r.readBit();
        t.border = this.r.readBit();
        t.wasStatic = this.r.readBit();
        t.html = this.r.readBit();
        t.useOutlines = this.r.readBit();
        if (t.hasFont) {
            int idref = this.r.readUI16();
            t.font = (DefineFont)this.dict.getTag(idref);
            t.height = this.r.readUI16();
        }
        if (t.hasFontClass) {
            t.fontClass = this.r.readString();
            t.height = this.r.readUI16();
        }
        if (t.hasTextColor) {
            t.color = this.decodeRGBA(this.r);
        }
        if (t.hasMaxLength) {
            t.maxLength = this.r.readUI16();
        }
        if (t.hasLayout) {
            t.align = this.r.readUI8();
            t.leftMargin = this.r.readUI16();
            t.rightMargin = this.r.readUI16();
            t.ident = this.r.readUI16();
            t.leading = this.r.readSI16();
        }
        t.varName = this.r.readString();
        if (t.hasText) {
            t.initialText = this.r.readString();
        }
        this.dict.add(id, t);
        return t;
    }

    private Tag decodeDefineScalingGrid() throws IOException {
        DefineScalingGrid t = new DefineScalingGrid();
        int idref = this.r.readUI16();
        try {
            t.scalingTarget = this.dict.getTag(idref);
            if (t.scalingTarget instanceof DefineSprite) {
                DefineSprite targetSprite = (DefineSprite)t.scalingTarget;
                if (targetSprite.scalingGrid != null) {
                    this.handler.error("Sprite " + idref + " scaling grid redefined");
                }
                targetSprite.scalingGrid = t;
            } else if (t.scalingTarget instanceof DefineButton) {
                DefineButton targetButton = (DefineButton)t.scalingTarget;
                if (targetButton.scalingGrid != null) {
                    this.handler.error("Button " + idref + " scaling grid redefined");
                }
                targetButton.scalingGrid = t;
            }
        }
        catch (Exception e) {
            return null;
        }
        t.rect = this.decodeRect();
        return t;
    }

    private Tag decodeDefineBitsLossless2(int length) throws IOException {
        DefineBitsLossless t = new DefineBitsLossless(36);
        SwfDecoder r1 = this.r;
        int pos = r1.getOffset();
        int id = r1.readUI16();
        t.format = r1.readUI8();
        t.width = r1.readUI16();
        t.height = r1.readUI16();
        switch (t.format) {
            case 3: {
                int colorTableSize = r1.readUI8() + 1;
                byte[] data = new byte[length -= r1.getOffset() - pos];
                r1.readFully(data);
                r1 = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(data)), this.getSwfVersion());
                this.decodeAlphaColorMapData(r1, t, colorTableSize);
                break;
            }
            case 4: 
            case 5: {
                byte[] data = new byte[length -= r1.getOffset() - pos];
                r1.readFully(data);
                r1 = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(data)), this.getSwfVersion());
                t.data = new byte[t.width * t.height * 4];
                r1.readFully(t.data);
                break;
            }
            default: {
                throw new SwfFormatException("Illegal bitmap format " + t.format);
            }
        }
        this.dict.add(id, t);
        return t;
    }

    private void decodeAlphaColorMapData(SwfDecoder r1, DefineBitsLossless tag, int tableSize) throws IOException {
        int b;
        int i;
        int width = tag.width;
        int height = tag.height;
        tag.colorData = new int[tableSize];
        for (int i2 = 0; i2 < tableSize; ++i2) {
            tag.colorData[i2] = this.decodeRGBA(r1);
        }
        if (width % 4 != 0) {
            width = (width / 4 + 1) * 4;
        }
        int data_size = width * height;
        tag.data = new byte[data_size];
        for (i = 0; i < data_size && (b = r1.readUI8()) != -1; ++i) {
            tag.data[i] = (byte)b;
        }
        int extra = 0;
        while (r1.readUI8() != -1) {
            ++extra;
        }
        if (extra > 0) {
            throw new SwfFormatException(extra + " bytes of bitmap data (" + width + "x" + height + ") not read!");
        }
        if (i != data_size) {
            throw new SwfFormatException("(" + width + "x" + height + ") data buffer " + (data_size - i) + " bytes too big...");
        }
    }

    private Tag decodeDefineJPEG3(int length) throws IOException {
        int alpha;
        DefineBitsJPEG3 t = new DefineBitsJPEG3();
        int pos = this.r.getOffset();
        int id = this.r.readUI16();
        t.alphaDataOffset = this.r.readUI32();
        t.data = new byte[(int)t.alphaDataOffset];
        this.r.readFully(t.data);
        byte[] temp = new byte[length -= this.r.getOffset() - pos];
        this.r.readFully(temp);
        SwfDecoder r1 = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(temp)), this.getSwfVersion());
        int i = 0;
        byte[] alphaData = new byte[length];
        while ((alpha = r1.readUI8()) != -1) {
            if (i == alphaData.length) {
                byte[] b = new byte[i + length];
                System.arraycopy(alphaData, 0, b, 0, alphaData.length);
                alphaData = b;
            }
            alphaData[i] = (byte)alpha;
            ++i;
        }
        t.alphaData = new byte[i];
        System.arraycopy(alphaData, 0, t.alphaData, 0, i);
        this.dict.add(id, t);
        r1.close();
        return t;
    }

    private Tag decodeDefineButton2(int length) throws IOException {
        ButtonRecord record;
        int endpos = this.r.getOffset() + length;
        DefineButton t = new DefineButton(34);
        int id = this.r.readUI16();
        this.r.syncBits();
        this.r.readUBits(7);
        t.trackAsMenu = this.r.readBit();
        int actionOffset = this.r.readUI16();
        ArrayList<Object> list = new ArrayList<Object>(5);
        while ((record = this.decodeButtonRecord(t.code)) != null) {
            list.add(record);
        }
        t.buttonRecords = new ButtonRecord[list.size()];
        list.toArray(t.buttonRecords);
        list.clear();
        if (actionOffset > 0) {
            list = new ArrayList();
            int pos = this.r.getOffset();
            while ((actionOffset = this.r.readUI16()) > 0) {
                list.add(this.decodeButtonCondAction(actionOffset - 2));
                if (this.r.getOffset() != pos + actionOffset) {
                    throw new SwfFormatException("incorrect offset read in ButtonCondAction. read " + actionOffset);
                }
                pos = this.r.getOffset();
            }
            list.add(this.decodeButtonCondAction(endpos - this.r.getOffset()));
            t.condActions = new ButtonCondAction[list.size()];
            list.toArray(t.condActions);
        } else {
            t.condActions = new ButtonCondAction[0];
        }
        while (this.r.getOffset() < endpos) {
            int b = this.r.readUI8();
            if (b == 0) continue;
            throw new SwfFormatException("nonzero data past end of DefineButton2");
        }
        this.dict.add(id, t);
        return t;
    }

    private ButtonCondAction decodeButtonCondAction(int length) throws IOException {
        ButtonCondAction a = new ButtonCondAction();
        this.r.syncBits();
        a.keyPress = this.r.readUBits(7);
        a.overDownToIdle = this.r.readBit();
        a.idleToOverDown = this.r.readBit();
        a.outDownToIdle = this.r.readBit();
        a.outDownToOverDown = this.r.readBit();
        a.overDownToOutDown = this.r.readBit();
        a.overDownToOverUp = this.r.readBit();
        a.overUpToOverDown = this.r.readBit();
        a.overUpToIdle = this.r.readBit();
        a.idleToOverUp = this.r.readBit();
        ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
        actionDecoder.setKeepOffsets(this.keepOffsets);
        a.actionList = actionDecoder.decode(length - 2);
        return a;
    }

    private Tag decodePlaceObject23(int type, int length) throws IOException {
        PlaceObject t = new PlaceObject(type);
        int pos = this.r.getOffset();
        t.flags = this.r.readUI8();
        if (type == 70) {
            t.flags2 = this.r.readUI8();
        }
        t.depth = this.r.readUI16();
        if (t.hasClassName()) {
            t.className = this.r.readString();
        }
        if (t.hasCharID()) {
            int idref = this.r.readUI16();
            t.setRef(this.dict.getTag(idref));
        }
        if (t.hasMatrix()) {
            t.matrix = this.decodeMatrix();
        }
        if (t.hasCxform()) {
            t.setCxform(this.decodeCxforma());
        }
        if (t.hasRatio()) {
            t.ratio = this.r.readUI16();
        }
        if (t.hasName()) {
            t.name = this.r.readString();
        }
        if (t.hasClipDepth()) {
            t.clipDepth = this.r.readUI16();
        }
        if (type == 70) {
            if (t.hasFilterList()) {
                t.filters = this.decodeFilterList();
            }
            if (t.hasBlendMode()) {
                t.blendMode = this.r.readUI8();
            }
        }
        if (t.hasClipAction()) {
            ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
            actionDecoder.setKeepOffsets(this.keepOffsets);
            t.clipActions = actionDecoder.decodeClipActions(length - (this.r.getOffset() - pos));
        }
        return t;
    }

    private List<Filter> decodeFilterList() throws IOException {
        LinkedList<Filter> filters = new LinkedList<Filter>();
        int count = this.r.readUI8();
        block10: for (int i = 0; i < count; ++i) {
            int filterID = this.r.readUI8();
            switch (filterID) {
                case 0: {
                    filters.add(this.decodeDropShadowFilter());
                    continue block10;
                }
                case 1: {
                    filters.add(this.decodeBlurFilter());
                    continue block10;
                }
                case 2: {
                    filters.add(this.decodeGlowFilter());
                    continue block10;
                }
                case 3: {
                    filters.add(this.decodeBevelFilter());
                    continue block10;
                }
                case 4: {
                    filters.add(this.decodeGradientGlowFilter());
                    continue block10;
                }
                case 5: {
                    filters.add(this.decodeConvolutionFilter());
                    continue block10;
                }
                case 6: {
                    filters.add(this.decodeColorMatrixFilter());
                    continue block10;
                }
                case 7: {
                    filters.add(this.decodeGradientBevelFilter());
                }
            }
        }
        return filters;
    }

    private DropShadowFilter decodeDropShadowFilter() throws IOException {
        DropShadowFilter f = new DropShadowFilter();
        f.color = this.decodeRGBA(this.r);
        f.blurX = this.r.readSI32();
        f.blurY = this.r.readSI32();
        f.angle = this.r.readSI32();
        f.distance = this.r.readSI32();
        f.strength = this.r.readUI16();
        f.flags = this.r.readUI8();
        return f;
    }

    private BlurFilter decodeBlurFilter() throws IOException {
        BlurFilter f = new BlurFilter();
        f.blurX = this.r.readSI32();
        f.blurY = this.r.readSI32();
        f.passes = this.r.readUI8();
        return f;
    }

    private GlowFilter decodeGlowFilter() throws IOException {
        GlowFilter f = new GlowFilter();
        f.color = this.decodeRGBA(this.r);
        f.blurX = this.r.readSI32();
        f.blurY = this.r.readSI32();
        f.strength = this.r.readUI16();
        f.flags = this.r.readUI8();
        return f;
    }

    private BevelFilter decodeBevelFilter() throws IOException {
        BevelFilter f = new BevelFilter();
        f.highlightColor = this.decodeRGBA(this.r);
        f.shadowColor = this.decodeRGBA(this.r);
        f.blurX = this.r.readSI32();
        f.blurY = this.r.readSI32();
        f.angle = this.r.readSI32();
        f.distance = this.r.readSI32();
        f.strength = this.r.readUI16();
        f.flags = this.r.readUI8();
        return f;
    }

    private GradientGlowFilter decodeGradientGlowFilter() throws IOException {
        int i;
        GradientGlowFilter f = new GradientGlowFilter();
        f.numcolors = this.r.readUI8();
        f.gradientColors = new int[f.numcolors];
        for (i = 0; i < f.numcolors; ++i) {
            f.gradientColors[i] = this.decodeRGBA(this.r);
        }
        f.gradientRatio = new int[f.numcolors];
        for (i = 0; i < f.numcolors; ++i) {
            f.gradientRatio[i] = this.r.readUI8();
        }
        f.blurX = this.r.readSI32();
        f.blurY = this.r.readSI32();
        f.angle = this.r.readSI32();
        f.distance = this.r.readSI32();
        f.strength = this.r.readUI16();
        f.flags = this.r.readUI8();
        return f;
    }

    private ConvolutionFilter decodeConvolutionFilter() throws IOException {
        ConvolutionFilter f = new ConvolutionFilter();
        f.matrixX = this.r.readUI8();
        f.matrixY = this.r.readUI8();
        f.divisor = this.r.readFloat();
        f.bias = this.r.readFloat();
        f.matrix = new float[f.matrixX * f.matrixY];
        for (int i = 0; i < f.matrixX * f.matrixY; ++i) {
            f.matrix[i] = this.r.readFloat();
        }
        f.color = this.decodeRGBA(this.r);
        f.flags = this.r.readUI8();
        return f;
    }

    private ColorMatrixFilter decodeColorMatrixFilter() throws IOException {
        ColorMatrixFilter f = new ColorMatrixFilter();
        for (int i = 0; i < 20; ++i) {
            f.values[i] = this.r.readFloat();
        }
        return f;
    }

    private GradientBevelFilter decodeGradientBevelFilter() throws IOException {
        int i;
        GradientBevelFilter f = new GradientBevelFilter();
        f.numcolors = this.r.readUI8();
        f.gradientColors = new int[f.numcolors];
        for (i = 0; i < f.numcolors; ++i) {
            f.gradientColors[i] = this.decodeRGBA(this.r);
        }
        f.gradientRatio = new int[f.numcolors];
        for (i = 0; i < f.numcolors; ++i) {
            f.gradientRatio[i] = this.r.readUI8();
        }
        f.blurX = this.r.readSI32();
        f.blurY = this.r.readSI32();
        f.angle = this.r.readSI32();
        f.distance = this.r.readSI32();
        f.strength = this.r.readUI16();
        f.flags = this.r.readUI8();
        return f;
    }

    private Tag decodePlaceObject(int length) throws IOException {
        PlaceObject t = new PlaceObject(4);
        int pos = this.r.getOffset();
        int idref = this.r.readUI16();
        t.depth = this.r.readUI16();
        t.setMatrix(this.decodeMatrix());
        if (length - this.r.getOffset() + pos != 0) {
            t.setCxform(this.decodeCxform());
        }
        t.setRef(this.dict.getTag(idref));
        return t;
    }

    private CXFormWithAlpha decodeCxforma() throws IOException {
        CXFormWithAlpha c = new CXFormWithAlpha();
        this.r.syncBits();
        c.hasAdd = this.r.readBit();
        c.hasMult = this.r.readBit();
        int nbits = this.r.readUBits(4);
        if (c.hasMult) {
            c.redMultTerm = this.r.readSBits(nbits);
            c.greenMultTerm = this.r.readSBits(nbits);
            c.blueMultTerm = this.r.readSBits(nbits);
            c.alphaMultTerm = this.r.readSBits(nbits);
        }
        if (c.hasAdd) {
            c.redAddTerm = this.r.readSBits(nbits);
            c.greenAddTerm = this.r.readSBits(nbits);
            c.blueAddTerm = this.r.readSBits(nbits);
            c.alphaAddTerm = this.r.readSBits(nbits);
        }
        return c;
    }

    private Tag decodeProtect(int length) throws IOException {
        GenericTag t = new GenericTag(24);
        t.data = new byte[length];
        this.r.readFully(t.data);
        return t;
    }

    private Tag decodeDefineButtonCxform() throws IOException {
        DefineButtonCxform t = new DefineButtonCxform();
        int idref = this.r.readUI16();
        t.button = (DefineButton)this.dict.getTag(idref);
        if (t.button.cxform != null) {
            this.handler.error("button " + this.dict.getId(t.button) + " cxform redefined");
        }
        t.button.cxform = t;
        t.colorTransform = this.decodeCxform();
        return t;
    }

    private Tag decodeDefineJPEG2(int length) throws IOException {
        DefineBits t = new DefineBits(21);
        int pos = this.r.getOffset();
        int id = this.r.readUI16();
        t.data = new byte[length -= this.r.getOffset() - pos];
        this.r.readFully(t.data);
        this.dict.add(id, t);
        return t;
    }

    private Tag decodeDefineBitsLossless(int length) throws IOException {
        DefineBitsLossless t = new DefineBitsLossless(20);
        SwfDecoder r1 = this.r;
        int pos = r1.getOffset();
        int id = r1.readUI16();
        t.format = r1.readUI8();
        t.width = r1.readUI16();
        t.height = r1.readUI16();
        switch (t.format) {
            case 3: {
                int tableSize = r1.readUI8() + 1;
                byte[] data = new byte[length -= r1.getOffset() - pos];
                r1.readFully(data);
                r1 = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(data)), this.getSwfVersion());
                this.decodeColorMapData(r1, t, tableSize);
                break;
            }
            case 4: 
            case 5: {
                byte[] data = new byte[length -= r1.getOffset() - pos];
                r1.readFully(data);
                r1 = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(data)), this.getSwfVersion());
                t.data = new byte[t.width * t.height * 4];
                r1.readFully(t.data);
                break;
            }
            default: {
                throw new SwfFormatException("Illegal bitmap format " + t.format);
            }
        }
        this.dict.add(id, t);
        return t;
    }

    private void decodeColorMapData(SwfDecoder r1, DefineBitsLossless tag, int tableSize) throws IOException {
        tag.colorData = new int[tableSize];
        for (int i = 0; i < tableSize; ++i) {
            tag.colorData[i] = this.decodeRGB(r1);
        }
        int width = tag.width;
        int height = tag.height;
        if (width % 4 != 0) {
            width = (width / 4 + 1) * 4;
        }
        tag.data = new byte[width * height];
        r1.readFully(tag.data);
    }

    private Tag decodeSoundStreamBlock(int length) throws IOException {
        GenericTag t = new GenericTag(19);
        t.data = new byte[length];
        this.r.readFully(t.data);
        return t;
    }

    private Tag decodeSoundStreamHead(int code) throws IOException {
        SoundStreamHead t = new SoundStreamHead(code);
        this.r.syncBits();
        this.r.readUBits(4);
        t.playbackRate = this.r.readUBits(2);
        t.playbackSize = this.r.readUBits(1);
        t.playbackType = this.r.readUBits(1);
        t.compression = this.r.readUBits(4);
        t.streamRate = this.r.readUBits(2);
        t.streamSize = this.r.readUBits(1);
        t.streamType = this.r.readUBits(1);
        t.streamSampleCount = this.r.readUI16();
        if (t.compression == 2) {
            t.latencySeek = this.r.readSI16();
        }
        return t;
    }

    private Tag decodeDefineButtonSound() throws IOException {
        DefineButtonSound t = new DefineButtonSound();
        int idref = this.r.readUI16();
        t.button = (DefineButton)this.dict.getTag(idref);
        if (t.button.sounds != null) {
            this.handler.error("button " + idref + " sound redefined");
        }
        t.button.sounds = t;
        idref = this.r.readUI16();
        if (idref != 0) {
            t.sound0 = this.dict.getTag(idref);
            t.info0 = this.decodeSoundInfo();
        }
        if ((idref = this.r.readUI16()) != 0) {
            t.sound1 = this.dict.getTag(idref);
            t.info1 = this.decodeSoundInfo();
        }
        if ((idref = this.r.readUI16()) != 0) {
            t.sound2 = this.dict.getTag(idref);
            t.info2 = this.decodeSoundInfo();
        }
        if ((idref = this.r.readUI16()) != 0) {
            t.sound3 = this.dict.getTag(idref);
            t.info3 = this.decodeSoundInfo();
        }
        return t;
    }

    private Tag decodeStartSound() throws IOException {
        StartSound t = new StartSound();
        int idref = this.r.readUI16();
        t.sound = (DefineSound)this.dict.getTag(idref);
        t.soundInfo = this.decodeSoundInfo();
        return t;
    }

    private SoundInfo decodeSoundInfo() throws IOException {
        SoundInfo i = new SoundInfo();
        this.r.syncBits();
        this.r.readUBits(2);
        i.syncStop = this.r.readBit();
        i.syncNoMultiple = this.r.readBit();
        boolean hasEnvelope = this.r.readBit();
        boolean hasLoops = this.r.readBit();
        boolean hasOutPoint = this.r.readBit();
        boolean hasInPoint = this.r.readBit();
        if (hasInPoint) {
            i.inPoint = this.r.readUI32();
        }
        if (hasOutPoint) {
            i.outPoint = this.r.readUI32();
        }
        if (hasLoops) {
            i.loopCount = this.r.readUI16();
        }
        if (hasEnvelope) {
            int points = this.r.readUI8();
            i.records = new long[points];
            for (int k = 0; k < points; ++k) {
                i.records[k] = this.r.read64();
            }
        }
        return i;
    }

    private Tag decodeDefineSound(int length) throws IOException {
        DefineSound t = new DefineSound();
        int pos = this.r.getOffset();
        int id = this.r.readUI16();
        this.r.syncBits();
        t.format = this.r.readUBits(4);
        t.rate = this.r.readUBits(2);
        t.size = this.r.readUBits(1);
        t.type = this.r.readUBits(1);
        t.sampleCount = this.r.readUI32();
        t.data = new byte[length -= this.r.getOffset() - pos];
        this.r.readFully(t.data);
        this.dict.add(id, t);
        return t;
    }

    private Tag decodeDefineFontInfo(int code, int length) throws IOException {
        DefineFontInfo t = new DefineFontInfo(code);
        int pos = this.r.getOffset();
        int idref = this.r.readUI16();
        t.font = (DefineFont1)this.dict.getTag(idref);
        if (t.font.fontInfo != null) {
            this.handler.error("font " + idref + " info redefined");
        }
        t.font.fontInfo = t;
        t.name = this.r.readLengthString();
        this.r.syncBits();
        this.r.readUBits(3);
        t.shiftJIS = this.r.readBit();
        t.ansi = this.r.readBit();
        t.italic = this.r.readBit();
        t.bold = this.r.readBit();
        t.wideCodes = this.r.readBit();
        if (code == 62) {
            if (!t.wideCodes) {
                this.handler.error("widecodes must be true in DefineFontInfo2");
            }
            if (this.getSwfVersion() < 6) {
                this.handler.error("DefineFont2 not valid before SWF6");
            }
            t.langCode = this.r.readUI8();
        }
        length -= this.r.getOffset() - pos;
        if (t.wideCodes) {
            t.codeTable = new char[length /= 2];
            for (int i = 0; i < length; ++i) {
                t.codeTable[i] = (char)this.r.readUI16();
            }
        } else {
            t.codeTable = new char[length];
            for (int i = 0; i < length; ++i) {
                t.codeTable[i] = (char)this.r.readUI8();
            }
        }
        return t;
    }

    private Tag decodeDoAction(int length) throws IOException {
        DoAction t = new DoAction();
        ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
        actionDecoder.setKeepOffsets(this.keepOffsets);
        t.actionList = actionDecoder.decode(length);
        return t;
    }

    private Tag decodeDefineText(int type) throws IOException {
        int code;
        DefineText t = new DefineText(type);
        int id = this.r.readUI16();
        t.bounds = this.decodeRect();
        t.matrix = this.decodeMatrix();
        int glyphBits = this.r.readUI8();
        int advanceBits = this.r.readUI8();
        ArrayList<TextRecord> list = new ArrayList<TextRecord>(2);
        while ((code = this.r.readUI8()) != 0) {
            list.add(this.decodeTextRecord(type, code, glyphBits, advanceBits));
        }
        t.records = list;
        this.dict.add(id, t);
        return t;
    }

    private GlyphEntry[] decodeGlyphEntries(int glyphBits, int advanceBits, int count) throws IOException {
        GlyphEntry[] e = new GlyphEntry[count];
        this.r.syncBits();
        for (int i = 0; i < count; ++i) {
            GlyphEntry ge = new GlyphEntry();
            ge.setIndex(this.r.readUBits(glyphBits));
            ge.advance = this.r.readSBits(advanceBits);
            e[i] = ge;
        }
        return e;
    }

    private TextRecord decodeTextRecord(int defineText, int flags, int glyphBits, int advanceBits) throws IOException {
        TextRecord t = new TextRecord();
        t.flags = flags;
        if (t.hasFont()) {
            int idref = this.r.readUI16();
            t.font = (DefineFont)this.dict.getTag(idref);
        }
        if (t.hasColor()) {
            switch (defineText) {
                case 11: {
                    t.color = this.decodeRGB(this.r);
                    break;
                }
                case 33: {
                    t.color = this.decodeRGBA(this.r);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (t.hasX()) {
            t.xOffset = this.r.readSI16();
        }
        if (t.hasY()) {
            t.yOffset = this.r.readSI16();
        }
        if (t.hasHeight()) {
            t.height = this.r.readUI16();
        }
        int count = this.r.readUI8();
        t.entries = this.decodeGlyphEntries(glyphBits, advanceBits, count);
        return t;
    }

    private Tag decodeDefineFont() throws IOException {
        int i;
        DefineFont1 t = new DefineFont1();
        int id = this.r.readUI16();
        int offset = this.r.readUI16();
        int numGlyphs = offset / 2;
        t.glyphShapeTable = new Shape[numGlyphs];
        for (i = 1; i < numGlyphs; ++i) {
            this.r.readUI16();
        }
        for (i = 0; i < numGlyphs; ++i) {
            t.glyphShapeTable[i] = this.decodeShape(32);
        }
        this.dict.add(id, t);
        this.dict.addFontFace(t);
        return t;
    }

    private Tag decodeSetBackgroundColor() throws IOException {
        SetBackgroundColor t = new SetBackgroundColor(this.decodeRGB(this.r));
        return t;
    }

    private GenericTag decodeJPEGTables(int length) throws IOException {
        GenericTag t = new GenericTag(8);
        t.data = new byte[length];
        this.r.readFully(t.data);
        return t;
    }

    private Tag decodeDefineButton(int length) throws IOException {
        ButtonRecord record;
        int startPos = this.r.getOffset();
        DefineButton t = new DefineButton(7);
        int id = this.r.readUI16();
        ArrayList<ButtonRecord> list = new ArrayList<ButtonRecord>();
        do {
            if ((record = this.decodeButtonRecord(t.code)) == null) continue;
            list.add(record);
        } while (record != null);
        t.buttonRecords = new ButtonRecord[list.size()];
        list.toArray(t.buttonRecords);
        int consumed = this.r.getOffset() - startPos;
        t.condActions = new ButtonCondAction[1];
        t.condActions[0].overDownToOverUp = true;
        ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
        actionDecoder.setKeepOffsets(this.keepOffsets);
        t.condActions[0].actionList = actionDecoder.decode(length - consumed);
        t.trackAsMenu = false;
        this.dict.add(id, t);
        return t;
    }

    private ButtonRecord decodeButtonRecord(int type) throws IOException {
        int reserved;
        boolean hasFilterList = false;
        boolean hasBlendMode = false;
        ButtonRecord b = new ButtonRecord();
        this.r.syncBits();
        if (type == 34) {
            reserved = this.r.readUBits(2);
            hasBlendMode = this.r.readBit();
            hasFilterList = this.r.readBit();
        } else {
            reserved = this.r.readUBits(4);
        }
        b.hitTest = this.r.readBit();
        b.down = this.r.readBit();
        b.over = this.r.readBit();
        b.up = this.r.readBit();
        if (!(reserved != 0 || b.hitTest || b.down || b.over || b.up)) {
            return null;
        }
        int idref = this.r.readUI16();
        b.characterRef = this.dict.getTag(idref);
        b.placeDepth = this.r.readUI16();
        b.placeMatrix = this.decodeMatrix();
        if (type == 34) {
            b.colorTransform = this.decodeCxforma();
            if (hasFilterList) {
                b.filters = this.decodeFilterList();
            }
            if (hasBlendMode) {
                b.blendMode = this.r.readUI8();
            }
        }
        return b;
    }

    private Tag decodeDefineBinaryData(int length) throws IOException {
        DefineBinaryData t = new DefineBinaryData();
        int pos = this.r.getOffset();
        int id = this.r.readUI16();
        t.reserved = this.r.readSI32();
        t.data = new byte[length -= this.r.getOffset() - pos];
        this.r.readFully(t.data);
        this.dict.add(id, t);
        return t;
    }

    private Tag decodeDefineBits(int length) throws IOException {
        DefineBits t = new DefineBits(6);
        int pos = this.r.getOffset();
        int id = this.r.readUI16();
        t.data = new byte[length -= this.r.getOffset() - pos];
        this.r.readFully(t.data);
        t.jpegTables = this.jpegTables;
        this.dict.add(id, t);
        return t;
    }

    private Tag decodeRemoveObject(int code) throws IOException {
        RemoveObject t = new RemoveObject(code);
        if (code == 5) {
            int idref = this.r.readUI16();
            t.ref = this.dict.getTag(idref);
        }
        t.depth = this.r.readUI16();
        return t;
    }

    private CXForm decodeCxform() throws IOException {
        CXForm c = new CXForm();
        this.r.syncBits();
        c.hasAdd = this.r.readBit();
        c.hasMult = this.r.readBit();
        int nbits = this.r.readUBits(4);
        if (c.hasMult) {
            c.redMultTerm = this.r.readSBits(nbits);
            c.greenMultTerm = this.r.readSBits(nbits);
            c.blueMultTerm = this.r.readSBits(nbits);
        }
        if (c.hasAdd) {
            c.redAddTerm = this.r.readSBits(nbits);
            c.greenAddTerm = this.r.readSBits(nbits);
            c.blueAddTerm = this.r.readSBits(nbits);
        }
        return c;
    }

    private Tag decodeMetadata() throws IOException {
        Metadata t = new Metadata();
        t.xml = this.r.readString();
        return t;
    }

    private Tag decodeDefineShape(int shape) throws IOException {
        DefineShape t = new DefineShape(shape);
        int id = this.r.readUI16();
        t.bounds = this.decodeRect();
        if (shape == 83) {
            t.edgeBounds = this.decodeRect();
            this.r.readUBits(5);
            t.usesFillWindingRule = this.r.readBit();
            t.usesNonScalingStrokes = this.r.readBit();
            t.usesScalingStrokes = this.r.readBit();
        }
        t.shapeWithStyle = this.decodeShapeWithStyle(shape);
        this.dict.add(id, t);
        return t;
    }

    private ShapeWithStyle decodeShapeWithStyle(int shape) throws IOException {
        ShapeWithStyle sw = new ShapeWithStyle();
        this.r.syncBits();
        sw.fillstyles = this.decodeFillstyles(shape);
        sw.linestyles = this.decodeLinestyles(shape);
        Shape s = this.decodeShape(shape);
        sw.shapeRecords = s.shapeRecords;
        return sw;
    }

    private ArrayList<LineStyle> decodeLinestyles(int shape) throws IOException {
        ArrayList<LineStyle> a = new ArrayList<LineStyle>();
        int count = this.r.readUI8();
        if (count == 255) {
            count = this.r.readUI16();
        }
        for (int i = 0; i < count; ++i) {
            a.add(this.decodeLineStyle(shape));
        }
        return a;
    }

    private LineStyle decodeLineStyle(int shape) throws IOException {
        LineStyle s = new LineStyle();
        s.width = this.r.readUI16();
        if (shape == 83) {
            s.flags = this.r.readUI16();
            if (s.hasMiterJoint()) {
                s.miterLimit = this.r.readUI16();
            }
        }
        if (shape == 83 && s.hasFillStyle()) {
            s.fillStyle = this.decodeFillStyle(shape);
        } else {
            s.color = shape == 32 || shape == 83 ? this.decodeRGBA(this.r) : this.decodeRGB(this.r);
        }
        return s;
    }

    private ArrayList<FillStyle> decodeFillstyles(int shape) throws IOException {
        ArrayList<FillStyle> a = new ArrayList<FillStyle>();
        int count = this.r.readUI8();
        if (count == 255) {
            count = this.r.readUI16();
        }
        for (int i = 0; i < count; ++i) {
            a.add(this.decodeFillStyle(shape));
        }
        return a;
    }

    private FillStyle decodeFillStyle(int shape) throws IOException {
        FillStyle s = new FillStyle();
        s.type = this.r.readUI8();
        switch (s.type) {
            case 0: {
                if (shape == 32 || shape == 83) {
                    s.color = this.decodeRGBA(this.r);
                    break;
                }
                if (shape == 22 || shape == 2) {
                    s.color = this.decodeRGB(this.r);
                    break;
                }
                throw new SwfFormatException("bad shape code");
            }
            case 16: 
            case 18: 
            case 19: {
                s.matrix = this.decodeMatrix();
                s.gradient = this.decodeGradient(shape, s.type);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                int idref = this.r.readUI16();
                try {
                    s.bitmap = this.dict.getTag(idref);
                }
                catch (IllegalArgumentException e) {
                    s.bitmap = null;
                    this.handler.error(e.getMessage());
                }
                s.matrix = this.decodeMatrix();
                break;
            }
            default: {
                throw new SwfFormatException("unrecognized fill style type: " + s.type);
            }
        }
        return s;
    }

    private Gradient decodeGradient(int shape, int filltype) throws IOException {
        Gradient gradient = filltype == 19 ? new FocalGradient() : new Gradient();
        this.r.syncBits();
        gradient.spreadMode = this.r.readUBits(2);
        gradient.interpolationMode = this.r.readUBits(2);
        int count = this.r.readUBits(4);
        gradient.records = new GradRecord[count];
        for (int i = 0; i < count; ++i) {
            gradient.records[i] = this.decodeGradRecord(shape);
        }
        if (filltype == 19) {
            gradient.focalPoint = this.r.readFixed8();
        }
        return gradient;
    }

    private GradRecord decodeGradRecord(int shape) throws IOException {
        GradRecord g = new GradRecord();
        g.ratio = this.r.readUI8();
        switch (shape) {
            case 2: 
            case 22: {
                g.color = this.decodeRGB(this.r);
                break;
            }
            case 32: 
            case 83: {
                g.color = this.decodeRGBA(this.r);
            }
        }
        return g;
    }

    private Matrix decodeMatrix() throws IOException {
        Matrix m = new Matrix();
        this.r.syncBits();
        m.hasScale = this.r.readBit();
        if (m.hasScale) {
            int nScaleBits = this.r.readUBits(5);
            m.scaleX = this.r.readSBits(nScaleBits);
            m.scaleY = this.r.readSBits(nScaleBits);
        }
        m.hasRotate = this.r.readBit();
        if (m.hasRotate) {
            int nRotateBits = this.r.readUBits(5);
            m.rotateSkew0 = this.r.readSBits(nRotateBits);
            m.rotateSkew1 = this.r.readSBits(nRotateBits);
        }
        int nTranslateBits = this.r.readUBits(5);
        m.translateX = this.r.readSBits(nTranslateBits);
        m.translateY = this.r.readSBits(nTranslateBits);
        return m;
    }

    private int decodeRGBA(SwfDecoder r) throws IOException {
        int color = r.readUI8() << 16;
        color |= r.readUI8() << 8;
        color |= r.readUI8();
        return color |= r.readUI8() << 24;
    }

    private int decodeRGB(SwfDecoder r) throws IOException {
        int color = r.readUI8() << 16;
        color |= r.readUI8() << 8;
        return color |= r.readUI8();
    }

    private Shape decodeGlyph(int shape, int count) throws IOException {
        Shape s1 = new Shape();
        this.r.syncBits();
        if (count > 0) {
            int[] numFillBits = new int[]{this.r.readUBits(4)};
            int[] numLineBits = new int[]{this.r.readUBits(4)};
            if (count > 1) {
                s1.shapeRecords = this.decodeShapeRecords(shape, numFillBits, numLineBits);
            }
        }
        return s1;
    }

    private Shape decodeShape(int shape) throws IOException {
        Shape s1 = new Shape();
        this.r.syncBits();
        int[] numFillBits = new int[]{this.r.readUBits(4)};
        int[] numLineBits = new int[]{this.r.readUBits(4)};
        s1.shapeRecords = this.decodeShapeRecords(shape, numFillBits, numLineBits);
        return s1;
    }

    private List<ShapeRecord> decodeShapeRecords(int shape, int[] numFillBits, int[] numLineBits) throws IOException {
        ArrayList<ShapeRecord> list = new ArrayList<ShapeRecord>();
        boolean endShapeRecord = false;
        do {
            if (this.r.readBit()) {
                if (this.r.readBit()) {
                    list.add(this.decodeStraightEdgeRecord());
                    continue;
                }
                list.add(this.decodeCurvedEdgeRecord());
                continue;
            }
            boolean stateNewStyles = this.r.readBit();
            boolean stateLineStyle = this.r.readBit();
            boolean stateFillStyle1 = this.r.readBit();
            boolean stateFillStyle0 = this.r.readBit();
            boolean stateMoveTo = this.r.readBit();
            if (stateNewStyles || stateLineStyle || stateFillStyle1 || stateFillStyle0 || stateMoveTo) {
                StyleChangeRecord s = this.decodeStyleChangeRecord(stateNewStyles, stateLineStyle, stateFillStyle1, stateFillStyle0, stateMoveTo, shape, numFillBits, numLineBits);
                list.add(s);
                continue;
            }
            endShapeRecord = true;
        } while (!endShapeRecord);
        return list;
    }

    private CurvedEdgeRecord decodeCurvedEdgeRecord() throws IOException {
        CurvedEdgeRecord s = new CurvedEdgeRecord();
        int nbits = 2 + this.r.readUBits(4);
        s.controlDeltaX = this.r.readSBits(nbits);
        s.controlDeltaY = this.r.readSBits(nbits);
        s.anchorDeltaX = this.r.readSBits(nbits);
        s.anchorDeltaY = this.r.readSBits(nbits);
        return s;
    }

    private StraightEdgeRecord decodeStraightEdgeRecord() throws IOException {
        int nbits = 2 + this.r.readUBits(4);
        if (this.r.readBit()) {
            int dx = this.r.readSBits(nbits);
            int dy = this.r.readSBits(nbits);
            return new StraightEdgeRecord(dx, dy);
        }
        if (this.r.readBit()) {
            int dy = this.r.readSBits(nbits);
            return new StraightEdgeRecord(0, dy);
        }
        int dx = this.r.readSBits(nbits);
        return new StraightEdgeRecord(dx, 0);
    }

    private StyleChangeRecord decodeStyleChangeRecord(boolean stateNewStyles, boolean stateLineStyle, boolean stateFillStyle1, boolean stateFillStyle0, boolean stateMoveTo, int shape, int[] numFillBits, int[] numLineBits) throws IOException {
        StyleChangeRecord s = new StyleChangeRecord();
        s.stateNewStyles = stateNewStyles;
        s.stateLineStyle = stateLineStyle;
        s.stateFillStyle1 = stateFillStyle1;
        s.stateFillStyle0 = stateFillStyle0;
        s.stateMoveTo = stateMoveTo;
        if (s.stateMoveTo) {
            int moveBits = this.r.readUBits(5);
            s.moveDeltaX = this.r.readSBits(moveBits);
            s.moveDeltaY = this.r.readSBits(moveBits);
        }
        if (s.stateFillStyle0) {
            s.fillstyle0 = this.r.readUBits(numFillBits[0]);
        }
        if (s.stateFillStyle1) {
            s.fillstyle1 = this.r.readUBits(numFillBits[0]);
        }
        if (s.stateLineStyle) {
            s.linestyle = this.r.readUBits(numLineBits[0]);
        }
        if (s.stateNewStyles) {
            s.fillstyles = this.decodeFillstyles(shape);
            s.linestyles = this.decodeLinestyles(shape);
            this.r.syncBits();
            numFillBits[0] = this.r.readUBits(4);
            numLineBits[0] = this.r.readUBits(4);
        }
        return s;
    }

    private Tag decodeDefineSprite(int endpos) throws IOException {
        DefineSprite t = new DefineSprite();
        t.header = this.header;
        int id = this.r.readUI16();
        t.framecount = this.r.readUI16();
        this.decodeTags(t.tagList);
        while (this.r.getOffset() < endpos) {
            int b = this.r.readUI8();
            if (b == 0) continue;
            throw new SwfFormatException("nonzero data past end of sprite");
        }
        this.dict.add(id, t);
        return t;
    }

    public Tag decodeSerialNumber() throws IOException {
        int product = this.r.readSI32();
        int edition = this.r.readSI32();
        byte[] version = new byte[2];
        this.r.read(version);
        byte majorVersion = version[0];
        byte minorVersion = version[1];
        long build = this.r.read64();
        long compileDate = this.r.read64();
        return new ProductInfo(product, edition, majorVersion, minorVersion, build, compileDate);
    }

    public Header decodeHeader() throws IOException, FatalParseException {
        Header header = new Header();
        byte[] sig = new byte[8];
        new DataInputStream(this.swfIn).readFully(sig);
        header.version = sig[3];
        header.length = sig[4] & 0xFF | (sig[5] & 0xFF) << 8 | (sig[6] & 0xFF) << 16 | sig[7] << 24;
        if (sig[0] == 67 && sig[1] == 87 && sig[2] == 83) {
            header.compressed = true;
            this.r = new SwfDecoder(new InflaterInputStream(this.swfIn), header.version, 8);
        } else if (sig[0] == 70 || sig[1] == 87 || sig[2] == 83) {
            this.r = new SwfDecoder(this.swfIn, header.version, 8);
        } else {
            this.handler.error("Invalid signature found.  Not a SWF file");
            throw new FatalParseException();
        }
        header.size = this.decodeRect();
        header.rate = this.r.readUI8() << 8 | this.r.readUI8();
        header.framecount = this.r.readUI16();
        return header;
    }

    public Tag decodeFileAttributes() throws IOException {
        FileAttributes tag = new FileAttributes();
        this.r.syncBits();
        this.r.readUBits(1);
        tag.useDirectBlit = this.r.readBit();
        tag.useGPU = this.r.readBit();
        tag.hasMetadata = this.r.readBit();
        tag.actionScript3 = this.r.readBit();
        tag.suppressCrossDomainCaching = this.r.readBit();
        tag.swfRelativeUrls = this.r.readBit();
        tag.useNetwork = this.r.readBit();
        this.r.readUBits(24);
        return tag;
    }

    public Tag decodeEnableTelemetry() throws IOException {
        EnableTelemetry tag = new EnableTelemetry();
        this.r.syncBits();
        this.r.readUBits(16);
        tag.enabled = true;
        return tag;
    }

    public Tag decodeDefineFontAlignZones() throws IOException {
        DefineFontAlignZones zones = new DefineFontAlignZones();
        int fontID = this.r.readUI16();
        zones.font = (DefineFont3)this.dict.getTag(fontID);
        zones.font.zones = zones;
        zones.csmTableHint = this.r.readUBits(2);
        this.r.readUBits(6);
        zones.zoneTable = new ZoneRecord[zones.font.glyphShapeTable.length];
        for (int i = 0; i < zones.font.glyphShapeTable.length; ++i) {
            ZoneRecord record;
            zones.zoneTable[i] = record = new ZoneRecord();
            record.numZoneData = this.r.readUI8();
            record.zoneData = new long[record.numZoneData];
            for (int j = 0; j < record.numZoneData; ++j) {
                record.zoneData[j] = this.r.readUI32();
            }
            record.zoneMask = this.r.readUI8();
        }
        return zones;
    }

    public Tag decodeCSMTextSettings() throws IOException {
        CSMTextSettings tag = new CSMTextSettings();
        int textID = this.r.readUI16();
        if (textID != 0) {
            tag.textReference = this.dict.getTag(textID);
            if (tag.textReference instanceof DefineText) {
                ((DefineText)tag.textReference).csmTextSettings = tag;
            } else if (tag.textReference instanceof DefineEditText) {
                ((DefineEditText)tag.textReference).csmTextSettings = tag;
            } else {
                this.handler.error("CSMTextSettings' textID must reference a valid DefineText or DefineEditText.  References " + tag.textReference);
            }
        }
        tag.styleFlagsUseSaffron = this.r.readUBits(2);
        tag.gridFitType = this.r.readUBits(3);
        this.r.readUBits(3);
        tag.thickness = this.r.readUBits(32);
        tag.sharpness = this.r.readUBits(32);
        this.r.readUBits(8);
        return tag;
    }

    public Tag decodeDefineFontName() throws IOException {
        DefineFontName tag = new DefineFontName();
        int fontID = this.r.readUI16();
        tag.font = (DefineFont)this.dict.getTag(fontID);
        tag.font.license = tag;
        tag.fontName = this.r.readString();
        tag.copyright = this.r.readString();
        return tag;
    }

    private Rect decodeRect() throws IOException {
        this.r.syncBits();
        Rect rect = new Rect();
        int nBits = this.r.readUBits(5);
        rect.xMin = this.r.readSBits(nBits);
        rect.xMax = this.r.readSBits(nBits);
        rect.yMin = this.r.readSBits(nBits);
        rect.yMax = this.r.readSBits(nBits);
        return rect;
    }

    public static class FatalParseException
    extends Exception {
        private static final long serialVersionUID = 5819679367367802771L;
    }
}

