/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css.codegen;

import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Stack;
import java.util.Vector;
import org.apache.royale.compiler.css.ICSSNode;
import org.apache.royale.compiler.internal.css.CSSModelTreeType;
import org.apache.royale.compiler.internal.css.codegen.CSSReducer;
import org.apache.royale.compiler.internal.css.codegen.Pair;

public class CSSEmitter {
    Stack __reducedValues = new Stack();
    private final CSSReducer reducer;
    public static final int __selectorGroup_NT = 1;
    public static final int __propertyList_NT = 2;
    public static final int __document_NT = 3;
    public static final int __ruleList_NT = 4;
    public static final int __fontFace_NT = 5;
    public static final int __rule_NT = 6;
    public static final int __mediaQueryCondition_NT = 7;
    public static final int __namespaceDefinition_NT = 8;
    public static final int __namespaceList_NT = 9;
    public static final int __property_NT = 10;
    public static final int __selector_NT = 11;
    public static final int __fontFaceList_NT = 12;
    public static final int __mediaQuery_NT = 13;
    public static final int nStates = 13;
    private static final JBurgSubgoal[][] ___subgoals_by_rule = new JBurgSubgoal[][]{null, {new JBurgSubgoal(9, false, 0, 0), new JBurgSubgoal(12, false, 0, 1), new JBurgSubgoal(4, false, 0, 2)}, null, {new JBurgSubgoal(5, true, 0, new int[0])}, {new JBurgSubgoal(7, true, 0, new int[0])}, null, null, {new JBurgSubgoal(8, true, 0, new int[0])}, null, {new JBurgSubgoal(10, true, 0, new int[0])}, {new JBurgSubgoal(1, false, 0, 0), new JBurgSubgoal(13, false, 0, 1), new JBurgSubgoal(2, false, 0, 2)}, {new JBurgSubgoal(6, true, 0, new int[0])}, null, {new JBurgSubgoal(11, true, 0, new int[0])}};
    private JBurgAnnotation __problemTree;
    static final String[] stateName = new String[]{"", "selectorGroup", "propertyList", "document", "ruleList", "fontFace", "rule", "mediaQueryCondition", "namespaceDefinition", "namespaceList", "property", "selector", "fontFaceList", "mediaQuery"};
    final JBurgAnnotation errorAnnotation = new ErrorAnnotation();

    public CSSEmitter(CSSReducer reducer) {
        this.reducer = reducer;
    }

    public JBurgAnnotation label(ICSSNode to_be_labelled) {
        JBurgAnnotation result = null;
        result = this.getJBurgAnnotation(to_be_labelled);
        int arity = to_be_labelled.getArity();
        for (int i = 0; arity > i; ++i) {
            result.addChild(this.label(to_be_labelled.getNthChild(i)));
        }
        return result;
    }

    private Pair.PairOfInstructionLists action_1(ICSSNode __p) throws Exception {
        Pair.PairOfInstructionLists ruleList = (Pair.PairOfInstructionLists)this.__reducedValues.pop();
        Pair.PairOfInstructionLists fontFaceList = (Pair.PairOfInstructionLists)this.__reducedValues.pop();
        Pair.PairOfInstructionLists namespaceList = (Pair.PairOfInstructionLists)this.__reducedValues.pop();
        return this.reducer.reduceDocument(__p, namespaceList, ruleList);
    }

    private Pair.PairOfInstructionLists action_2(ICSSNode __p) throws Exception {
        return this.reducer.reduceFontFace(__p);
    }

    private Pair.PairOfInstructionLists action_3(ICSSNode __p) throws Exception {
        Vector fontFaces = (Vector)this.__reducedValues.pop();
        return this.reducer.reduceFontFaceList(__p, fontFaces);
    }

    private Pair.PairOfInstructionLists action_4(ICSSNode __p) throws Exception {
        Vector conditions = (Vector)this.__reducedValues.pop();
        return this.reducer.reduceMediaQuery(__p, conditions);
    }

    private Pair.PairOfInstructionLists action_5(ICSSNode __p) throws Exception {
        return this.reducer.reduceMediaQueryCondition(__p);
    }

    private Pair.PairOfInstructionLists action_6(ICSSNode __p) throws Exception {
        return this.reducer.reduceNamespaceDefinition(__p);
    }

    private Pair.PairOfInstructionLists action_7(ICSSNode __p) throws Exception {
        Vector namespaces = (Vector)this.__reducedValues.pop();
        return this.reducer.reduceNamespaceList(__p, namespaces);
    }

    private Pair.PairOfInstructionLists action_8(ICSSNode __p) throws Exception {
        return this.reducer.reduceProperty(__p);
    }

    private Pair.PairOfInstructionLists action_9(ICSSNode __p) throws Exception {
        Vector properties = (Vector)this.__reducedValues.pop();
        return this.reducer.reducePropertyList(__p, properties);
    }

    private Pair.InstructionListAndClosure action_10(ICSSNode __p) throws Exception {
        Pair.PairOfInstructionLists propertyList = (Pair.PairOfInstructionLists)this.__reducedValues.pop();
        Pair.PairOfInstructionLists mediaQuery = (Pair.PairOfInstructionLists)this.__reducedValues.pop();
        Pair.InstructionListAndClosure selectorGroup = (Pair.InstructionListAndClosure)this.__reducedValues.pop();
        return this.reducer.reduceRule(__p, selectorGroup, propertyList);
    }

    private Pair.PairOfInstructionLists action_11(ICSSNode __p) throws Exception {
        Vector rules = (Vector)this.__reducedValues.pop();
        return this.reducer.reduceRuleList(__p, rules);
    }

    private Pair.InstructionListAndString action_12(ICSSNode __p) throws Exception {
        return this.reducer.reduceSelector(__p);
    }

    private Pair.InstructionListAndClosure action_13(ICSSNode __p) throws Exception {
        Vector selectors = (Vector)this.__reducedValues.pop();
        return this.reducer.reduceSelectorGroup(__p, selectors);
    }

    private void dispatchAction(JBurgAnnotation ___node, int iRule) throws Exception {
        ICSSNode __p = ___node.getNode();
        switch (iRule) {
            case 1: {
                this.__reducedValues.push(this.action_1(__p));
                break;
            }
            case 2: {
                this.__reducedValues.push(this.action_2(__p));
                break;
            }
            case 3: {
                this.__reducedValues.push(this.action_3(__p));
                break;
            }
            case 4: {
                this.__reducedValues.push(this.action_4(__p));
                break;
            }
            case 5: {
                this.__reducedValues.push(this.action_5(__p));
                break;
            }
            case 6: {
                this.__reducedValues.push(this.action_6(__p));
                break;
            }
            case 7: {
                this.__reducedValues.push(this.action_7(__p));
                break;
            }
            case 8: {
                this.__reducedValues.push(this.action_8(__p));
                break;
            }
            case 9: {
                this.__reducedValues.push(this.action_9(__p));
                break;
            }
            case 10: {
                this.__reducedValues.push(this.action_10(__p));
                break;
            }
            case 11: {
                this.__reducedValues.push(this.action_11(__p));
                break;
            }
            case 12: {
                this.__reducedValues.push(this.action_12(__p));
                break;
            }
            case 13: {
                this.__reducedValues.push(this.action_13(__p));
                break;
            }
            default: {
                throw new IllegalStateException("Unmatched reduce action " + iRule);
            }
        }
    }

    public JBurgAnnotation getJBurgAnnotation(ICSSNode node) {
        switch (node.getOperator()) {
            case DOCUMENT: {
                if (node.getArity() != 3) break;
                return new JBurgAnnotation_DOCUMENT_3(node);
            }
            case FONT_FACE: {
                if (node.getArity() != 0) break;
                return new JBurgAnnotation_FONT_FACE_0(node);
            }
            case FONT_FACE_LIST: {
                if (node.getArity() < 0) break;
                return new JBurgAnnotation_FONT_FACE_LIST_0_n(node);
            }
            case MEDIA_QUERY: {
                if (node.getArity() < 0) break;
                return new JBurgAnnotation_MEDIA_QUERY_0_n(node);
            }
            case MEDIA_QUERY_CONDITION: {
                if (node.getArity() != 0) break;
                return new JBurgAnnotation_MEDIA_QUERY_CONDITION_0(node);
            }
            case NAMESPACE_DEFINITION: {
                if (node.getArity() != 0) break;
                return new JBurgAnnotation_NAMESPACE_DEFINITION_0(node);
            }
            case NAMESPACE_LIST: {
                if (node.getArity() < 0) break;
                return new JBurgAnnotation_NAMESPACE_LIST_0_n(node);
            }
            case PROPERTY: {
                if (node.getArity() != 0) break;
                return new JBurgAnnotation_PROPERTY_0(node);
            }
            case PROPERTY_LIST: {
                if (node.getArity() < 0) break;
                return new JBurgAnnotation_PROPERTY_LIST_0_n(node);
            }
            case RULE: {
                if (node.getArity() != 3) break;
                return new JBurgAnnotation_RULE_3(node);
            }
            case RULE_LIST: {
                if (node.getArity() < 0) break;
                return new JBurgAnnotation_RULE_LIST_0_n(node);
            }
            case SELECTOR: {
                if (node.getArity() != 0) break;
                return new JBurgAnnotation_SELECTOR_0(node);
            }
            case SELECTOR_GROUP: {
                if (node.getArity() < 0) break;
                return new JBurgAnnotation_SELECTOR_GROUP_0_n(node);
            }
        }
        return new JBurgAnnotationGeneral(node, 14);
    }

    public void reduce(JBurgAnnotation p, int goalState) throws Exception {
        this.reduceAntecedent(p, goalState);
        p.release();
    }

    public void reduceAntecedent(JBurgAnnotation p, int goalState) throws Exception {
        int iRule = -1;
        if (goalState > 0) {
            iRule = p.getRule(goalState);
        } else {
            int minCost = Integer.MAX_VALUE;
            for (int i = 0; i <= 13; ++i) {
                if (minCost <= p.getCost(i)) continue;
                iRule = p.getRule(i);
                minCost = p.getCost(i);
                goalState = i;
            }
        }
        if (iRule <= 0) {
            throw new IllegalStateException("Unable to find a rule to process \"" + p.toString() + "\", operator=" + String.valueOf((Object)p.getOperator()) + ", goal=" + String.valueOf(goalState));
        }
        this.reduceSubgoals(p, iRule);
        this.dispatchAction(p, iRule);
    }

    private void reduceSubgoals(JBurgAnnotation p, int rule_num) throws Exception {
        if (___subgoals_by_rule[rule_num] != null) {
            for (JBurgSubgoal sg : ___subgoals_by_rule[rule_num]) {
                if (!sg.isNary()) {
                    this.reduce(sg.getNode(p), sg.getGoalState());
                    continue;
                }
                JBurgAnnotation sub_parent = sg.getNode(p);
                Vector variadic_result = new Vector(sub_parent.getArity() - sg.startIndex);
                for (int j = sg.startIndex; j < sub_parent.getArity(); ++j) {
                    this.reduce(sub_parent.getNthChild(j), sg.getGoalState());
                    variadic_result.add(this.__reducedValues.pop());
                }
                this.__reducedValues.push(variadic_result);
            }
        }
    }

    private int getNaryCost(JBurgAnnotation node, int goalState, int start_index) {
        int accumCost = 0;
        for (int i = start_index; i < node.getArity() && accumCost != Integer.MAX_VALUE; ++i) {
            int subCost = node.getNthChild(i).getCost(goalState);
            if (subCost != Integer.MAX_VALUE) {
                accumCost += subCost;
                continue;
            }
            accumCost = Integer.MAX_VALUE;
        }
        return accumCost;
    }

    public void burm(ICSSNode root) throws Exception {
        this.burm(root, 0);
    }

    public void burm(ICSSNode root, int goal_state) throws Exception {
        JBurgAnnotation annotatedTree = this.label(root);
        try {
            this.reduce(annotatedTree, goal_state);
        }
        catch (Exception cant_reduce) {
            this.__problemTree = annotatedTree;
            throw cant_reduce;
        }
    }

    public void dump(PrintWriter debug_output) {
        if (null == this.__problemTree) {
            debug_output.println("<bailed reason=\"no problem tree\"/>");
            return;
        }
        debug_output.println("<jburg><label>");
        this.describeNode(this.__problemTree, debug_output);
        debug_output.println("</label></jburg>");
    }

    void describeNode(JBurgAnnotation node, PrintWriter debugOutput) {
        int i;
        String self_description;
        if (node == null) {
            return;
        }
        try {
            self_description = URLEncoder.encode(node.getNode().toString(), "UTF-8");
        }
        catch (Exception cant_encode) {
            self_description = node.getNode().toString();
        }
        debugOutput.print("<node operator=\"" + node.getNode().getOperator() + "\" selfDescription=\"" + self_description + "\">");
        for (i = 0; i <= 13; ++i) {
            if (node.getRule(i) == 0) continue;
            debugOutput.print("<goal");
            debugOutput.print(" name=\"" + stateName[i] + "\"");
            debugOutput.print(" rule=\"" + node.getRule(i) + "\"");
            debugOutput.print(" cost=\"" + node.getCost(i) + "\"");
            debugOutput.println("/>");
        }
        for (i = 0; i < node.getArity(); ++i) {
            this.describeNode(node.getNthChild(i), debugOutput);
        }
        debugOutput.println("</node>");
    }

    public Object getResult() {
        return this.__reducedValues.pop();
    }

    public int normalizeCost(long c) {
        return c < Integer.MAX_VALUE ? (int)c : Integer.MAX_VALUE;
    }

    class ErrorAnnotation
    extends JBurgSpecializedAnnotation {
        ErrorAnnotation() {
            super(null);
        }

        @Override
        public int getRule(int state) {
            return -1;
        }

        @Override
        public int getCost(int state) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int getArity() {
            return 0;
        }
    }

    abstract class JBurgAnnotation {
        ICSSNode m_node;

        JBurgAnnotation(ICSSNode newNode) {
            this.m_node = newNode;
        }

        public CSSModelTreeType getOperator() {
            return this.m_node.getOperator();
        }

        public ICSSNode getNode() {
            return this.m_node;
        }

        public abstract JBurgAnnotation getNthChild(int var1);

        public abstract int getArity();

        public abstract void addChild(JBurgAnnotation var1);

        public abstract void release();

        public String toString() {
            return this.m_node.toString();
        }

        public abstract int getCost(int var1);

        public abstract void reset(int var1, int var2, int var3);

        public abstract int getRule(int var1);

        public abstract void recordAntecedent(int var1, int var2);
    }

    class JBurgAnnotation_DOCUMENT_3
    extends JBurgSpecializedAnnotation {
        private JBurgAnnotation subtree0;
        private JBurgAnnotation subtree1;
        private JBurgAnnotation subtree2;
        private int cachedCostFor_document;

        JBurgAnnotation_DOCUMENT_3(ICSSNode node) {
            super(node);
            this.cachedCostFor_document = -1;
        }

        @Override
        public int getCost(int goalState) {
            switch (goalState) {
                case 3: {
                    if (this.cachedCostFor_document == -1) {
                        this.cachedCostFor_document = this.getCostForRule0(goalState);
                    }
                    return this.cachedCostFor_document;
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRule(int goalState) {
            switch (goalState) {
                case 3: {
                    int rule = -1;
                    int bestCost = Integer.MAX_VALUE;
                    int currentCost = this.getCostForRule0(goalState);
                    if (bestCost > currentCost) {
                        rule = 1;
                    }
                    return rule;
                }
            }
            return -1;
        }

        @Override
        public int getArity() {
            return 3;
        }

        @Override
        public JBurgAnnotation getNthChild(int index) {
            switch (index) {
                case 0: {
                    return this.subtree0;
                }
                case 1: {
                    return this.subtree1;
                }
                case 2: {
                    return this.subtree2;
                }
            }
            throw new IllegalStateException("Invalid index " + index);
        }

        @Override
        public void addChild(JBurgAnnotation child) {
            if (this.subtree0 == null) {
                this.subtree0 = child;
            } else if (this.subtree1 == null) {
                this.subtree1 = child;
            } else if (this.subtree2 == null) {
                this.subtree2 = child;
            } else {
                throw new IllegalStateException("too many children");
            }
        }

        private int getCostForRule0(int goalState) {
            return CSSEmitter.this.normalizeCost(1L + ((long)this.getNthChild(2).getCost(4) + (long)this.getNthChild(1).getCost(12) + (long)this.getNthChild(0).getCost(9)));
        }
    }

    class JBurgAnnotation_FONT_FACE_0
    extends JBurgSpecializedAnnotation {
        JBurgAnnotation_FONT_FACE_0(ICSSNode node) {
            super(node);
        }

        @Override
        public int getCost(int goalState) {
            switch (goalState) {
                case 5: {
                    return 1;
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRule(int goalState) {
            switch (goalState) {
                case 5: {
                    return 2;
                }
            }
            return -1;
        }

        @Override
        public int getArity() {
            return 0;
        }
    }

    class JBurgAnnotation_FONT_FACE_LIST_0_n
    extends JBurgSpecializedAnnotation {
        private Vector<JBurgAnnotation> narySubtrees;

        JBurgAnnotation_FONT_FACE_LIST_0_n(ICSSNode node) {
            super(node);
            this.narySubtrees = new Vector();
        }

        @Override
        public int getCost(int goalState) {
            switch (goalState) {
                case 12: {
                    return CSSEmitter.this.normalizeCost(1L + (long)CSSEmitter.this.getNaryCost(this, 5, 0));
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRule(int goalState) {
            switch (goalState) {
                case 12: {
                    int rule = -1;
                    int bestCost = Integer.MAX_VALUE;
                    int currentCost = CSSEmitter.this.normalizeCost(1L + (long)CSSEmitter.this.getNaryCost(this, 5, 0));
                    if (bestCost > currentCost) {
                        rule = 3;
                    }
                    return rule;
                }
            }
            return -1;
        }

        @Override
        public int getArity() {
            return this.narySubtrees.size();
        }

        @Override
        public JBurgAnnotation getNthChild(int index) {
            switch (index) {
                default: 
            }
            return this.narySubtrees.get(index);
        }

        @Override
        public void addChild(JBurgAnnotation child) {
            this.narySubtrees.add(child);
        }
    }

    class JBurgAnnotation_MEDIA_QUERY_0_n
    extends JBurgSpecializedAnnotation {
        private Vector<JBurgAnnotation> narySubtrees;

        JBurgAnnotation_MEDIA_QUERY_0_n(ICSSNode node) {
            super(node);
            this.narySubtrees = new Vector();
        }

        @Override
        public int getCost(int goalState) {
            switch (goalState) {
                case 13: {
                    return CSSEmitter.this.normalizeCost(1L + (long)CSSEmitter.this.getNaryCost(this, 7, 0));
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRule(int goalState) {
            switch (goalState) {
                case 13: {
                    int rule = -1;
                    int bestCost = Integer.MAX_VALUE;
                    int currentCost = CSSEmitter.this.normalizeCost(1L + (long)CSSEmitter.this.getNaryCost(this, 7, 0));
                    if (bestCost > currentCost) {
                        rule = 4;
                    }
                    return rule;
                }
            }
            return -1;
        }

        @Override
        public int getArity() {
            return this.narySubtrees.size();
        }

        @Override
        public JBurgAnnotation getNthChild(int index) {
            switch (index) {
                default: 
            }
            return this.narySubtrees.get(index);
        }

        @Override
        public void addChild(JBurgAnnotation child) {
            this.narySubtrees.add(child);
        }
    }

    class JBurgAnnotation_MEDIA_QUERY_CONDITION_0
    extends JBurgSpecializedAnnotation {
        JBurgAnnotation_MEDIA_QUERY_CONDITION_0(ICSSNode node) {
            super(node);
        }

        @Override
        public int getCost(int goalState) {
            switch (goalState) {
                case 7: {
                    return 1;
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRule(int goalState) {
            switch (goalState) {
                case 7: {
                    return 5;
                }
            }
            return -1;
        }

        @Override
        public int getArity() {
            return 0;
        }
    }

    class JBurgAnnotation_NAMESPACE_DEFINITION_0
    extends JBurgSpecializedAnnotation {
        JBurgAnnotation_NAMESPACE_DEFINITION_0(ICSSNode node) {
            super(node);
        }

        @Override
        public int getCost(int goalState) {
            switch (goalState) {
                case 8: {
                    return 1;
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRule(int goalState) {
            switch (goalState) {
                case 8: {
                    return 6;
                }
            }
            return -1;
        }

        @Override
        public int getArity() {
            return 0;
        }
    }

    class JBurgAnnotation_NAMESPACE_LIST_0_n
    extends JBurgSpecializedAnnotation {
        private Vector<JBurgAnnotation> narySubtrees;

        JBurgAnnotation_NAMESPACE_LIST_0_n(ICSSNode node) {
            super(node);
            this.narySubtrees = new Vector();
        }

        @Override
        public int getCost(int goalState) {
            switch (goalState) {
                case 9: {
                    return CSSEmitter.this.normalizeCost(1L + (long)CSSEmitter.this.getNaryCost(this, 8, 0));
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRule(int goalState) {
            switch (goalState) {
                case 9: {
                    int rule = -1;
                    int bestCost = Integer.MAX_VALUE;
                    int currentCost = CSSEmitter.this.normalizeCost(1L + (long)CSSEmitter.this.getNaryCost(this, 8, 0));
                    if (bestCost > currentCost) {
                        rule = 7;
                    }
                    return rule;
                }
            }
            return -1;
        }

        @Override
        public int getArity() {
            return this.narySubtrees.size();
        }

        @Override
        public JBurgAnnotation getNthChild(int index) {
            switch (index) {
                default: 
            }
            return this.narySubtrees.get(index);
        }

        @Override
        public void addChild(JBurgAnnotation child) {
            this.narySubtrees.add(child);
        }
    }

    class JBurgAnnotation_PROPERTY_0
    extends JBurgSpecializedAnnotation {
        JBurgAnnotation_PROPERTY_0(ICSSNode node) {
            super(node);
        }

        @Override
        public int getCost(int goalState) {
            switch (goalState) {
                case 10: {
                    return 1;
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRule(int goalState) {
            switch (goalState) {
                case 10: {
                    return 8;
                }
            }
            return -1;
        }

        @Override
        public int getArity() {
            return 0;
        }
    }

    class JBurgAnnotation_PROPERTY_LIST_0_n
    extends JBurgSpecializedAnnotation {
        private Vector<JBurgAnnotation> narySubtrees;

        JBurgAnnotation_PROPERTY_LIST_0_n(ICSSNode node) {
            super(node);
            this.narySubtrees = new Vector();
        }

        @Override
        public int getCost(int goalState) {
            switch (goalState) {
                case 2: {
                    return CSSEmitter.this.normalizeCost(1L + (long)CSSEmitter.this.getNaryCost(this, 10, 0));
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRule(int goalState) {
            switch (goalState) {
                case 2: {
                    int rule = -1;
                    int bestCost = Integer.MAX_VALUE;
                    int currentCost = CSSEmitter.this.normalizeCost(1L + (long)CSSEmitter.this.getNaryCost(this, 10, 0));
                    if (bestCost > currentCost) {
                        rule = 9;
                    }
                    return rule;
                }
            }
            return -1;
        }

        @Override
        public int getArity() {
            return this.narySubtrees.size();
        }

        @Override
        public JBurgAnnotation getNthChild(int index) {
            switch (index) {
                default: 
            }
            return this.narySubtrees.get(index);
        }

        @Override
        public void addChild(JBurgAnnotation child) {
            this.narySubtrees.add(child);
        }
    }

    class JBurgAnnotation_RULE_3
    extends JBurgSpecializedAnnotation {
        private JBurgAnnotation subtree0;
        private JBurgAnnotation subtree1;
        private JBurgAnnotation subtree2;
        private int cachedCostFor_rule;

        JBurgAnnotation_RULE_3(ICSSNode node) {
            super(node);
            this.cachedCostFor_rule = -1;
        }

        @Override
        public int getCost(int goalState) {
            switch (goalState) {
                case 6: {
                    if (this.cachedCostFor_rule == -1) {
                        this.cachedCostFor_rule = this.getCostForRule1(goalState);
                    }
                    return this.cachedCostFor_rule;
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRule(int goalState) {
            switch (goalState) {
                case 6: {
                    int rule = -1;
                    int bestCost = Integer.MAX_VALUE;
                    int currentCost = this.getCostForRule1(goalState);
                    if (bestCost > currentCost) {
                        rule = 10;
                    }
                    return rule;
                }
            }
            return -1;
        }

        @Override
        public int getArity() {
            return 3;
        }

        @Override
        public JBurgAnnotation getNthChild(int index) {
            switch (index) {
                case 0: {
                    return this.subtree0;
                }
                case 1: {
                    return this.subtree1;
                }
                case 2: {
                    return this.subtree2;
                }
            }
            throw new IllegalStateException("Invalid index " + index);
        }

        @Override
        public void addChild(JBurgAnnotation child) {
            if (this.subtree0 == null) {
                this.subtree0 = child;
            } else if (this.subtree1 == null) {
                this.subtree1 = child;
            } else if (this.subtree2 == null) {
                this.subtree2 = child;
            } else {
                throw new IllegalStateException("too many children");
            }
        }

        private int getCostForRule1(int goalState) {
            return CSSEmitter.this.normalizeCost(1L + ((long)this.getNthChild(2).getCost(2) + (long)this.getNthChild(1).getCost(13) + (long)this.getNthChild(0).getCost(1)));
        }
    }

    class JBurgAnnotation_RULE_LIST_0_n
    extends JBurgSpecializedAnnotation {
        private Vector<JBurgAnnotation> narySubtrees;

        JBurgAnnotation_RULE_LIST_0_n(ICSSNode node) {
            super(node);
            this.narySubtrees = new Vector();
        }

        @Override
        public int getCost(int goalState) {
            switch (goalState) {
                case 4: {
                    return CSSEmitter.this.normalizeCost(1L + (long)CSSEmitter.this.getNaryCost(this, 6, 0));
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRule(int goalState) {
            switch (goalState) {
                case 4: {
                    int rule = -1;
                    int bestCost = Integer.MAX_VALUE;
                    int currentCost = CSSEmitter.this.normalizeCost(1L + (long)CSSEmitter.this.getNaryCost(this, 6, 0));
                    if (bestCost > currentCost) {
                        rule = 11;
                    }
                    return rule;
                }
            }
            return -1;
        }

        @Override
        public int getArity() {
            return this.narySubtrees.size();
        }

        @Override
        public JBurgAnnotation getNthChild(int index) {
            switch (index) {
                default: 
            }
            return this.narySubtrees.get(index);
        }

        @Override
        public void addChild(JBurgAnnotation child) {
            this.narySubtrees.add(child);
        }
    }

    class JBurgAnnotation_SELECTOR_0
    extends JBurgSpecializedAnnotation {
        JBurgAnnotation_SELECTOR_0(ICSSNode node) {
            super(node);
        }

        @Override
        public int getCost(int goalState) {
            switch (goalState) {
                case 11: {
                    return 1;
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRule(int goalState) {
            switch (goalState) {
                case 11: {
                    return 12;
                }
            }
            return -1;
        }

        @Override
        public int getArity() {
            return 0;
        }
    }

    class JBurgAnnotation_SELECTOR_GROUP_0_n
    extends JBurgSpecializedAnnotation {
        private Vector<JBurgAnnotation> narySubtrees;

        JBurgAnnotation_SELECTOR_GROUP_0_n(ICSSNode node) {
            super(node);
            this.narySubtrees = new Vector();
        }

        @Override
        public int getCost(int goalState) {
            switch (goalState) {
                case 1: {
                    return CSSEmitter.this.normalizeCost(1L + (long)CSSEmitter.this.getNaryCost(this, 11, 0));
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRule(int goalState) {
            switch (goalState) {
                case 1: {
                    int rule = -1;
                    int bestCost = Integer.MAX_VALUE;
                    int currentCost = CSSEmitter.this.normalizeCost(1L + (long)CSSEmitter.this.getNaryCost(this, 11, 0));
                    if (bestCost > currentCost) {
                        rule = 13;
                    }
                    return rule;
                }
            }
            return -1;
        }

        @Override
        public int getArity() {
            return this.narySubtrees.size();
        }

        @Override
        public JBurgAnnotation getNthChild(int index) {
            switch (index) {
                default: 
            }
            return this.narySubtrees.get(index);
        }

        @Override
        public void addChild(JBurgAnnotation child) {
            this.narySubtrees.add(child);
        }
    }

    class JBurgAnnotationGeneral
    extends JBurgAnnotation {
        private int[] cost;
        private int[] rule;
        private int[] antecedentState;
        private Vector<JBurgAnnotation> m_children;

        JBurgAnnotationGeneral(ICSSNode newNode, int nRules) {
            super(newNode);
            this.antecedentState = null;
            this.m_children = null;
            this.rule = new int[nRules];
            this.cost = new int[nRules];
            Arrays.fill(this.cost, Integer.MAX_VALUE);
        }

        @Override
        public CSSModelTreeType getOperator() {
            return this.m_node.getOperator();
        }

        @Override
        public ICSSNode getNode() {
            return this.m_node;
        }

        @Override
        public JBurgAnnotation getNthChild(int idx) {
            if (this.m_children != null && this.m_children.size() > idx) {
                return this.m_children.elementAt(idx);
            }
            throw new IllegalArgumentException(String.format("Index %d out of range opcode %s:", new Object[]{idx, this.getOperator()}));
        }

        @Override
        public int getArity() {
            return this.m_children != null ? this.m_children.size() : 0;
        }

        @Override
        public void addChild(JBurgAnnotation new_child) {
            if (this.m_children == null) {
                this.m_children = new Vector();
            }
            if (new_child != null) {
                this.m_children.add(new_child);
            }
        }

        @Override
        public void release() {
            this.m_children = null;
            this.cost = null;
            this.rule = null;
        }

        @Override
        public String toString() {
            return this.m_node.toString();
        }

        @Override
        public int getCost(int goalState) {
            return this.cost[goalState];
        }

        @Override
        public void reset(int goalState, int cost, int rule) {
            this.cost[goalState] = cost;
            this.rule[goalState] = rule;
            if (this.antecedentState != null) {
                this.antecedentState[goalState] = 0;
            }
        }

        @Override
        public int getRule(int goalState) {
            return this.rule[goalState];
        }

        @Override
        public void recordAntecedent(int iGoalState, int newAntecedentState) {
            int antecedentRule = this.rule[newAntecedentState];
            if (antecedentRule == 0) {
                throw new IllegalStateException("Attempting to record an unlabelled antecedent state.");
            }
            if (antecedentRule == 1) {
                if (this.antecedentState != null) {
                    this.antecedentState[iGoalState] = this.antecedentState[newAntecedentState];
                }
            } else {
                if (this.antecedentState == null) {
                    this.antecedentState = new int[this.rule.length];
                }
                this.antecedentState[iGoalState] = newAntecedentState;
            }
        }
    }

    static class JBurgSubgoal {
        private int goalState;
        private boolean isNary;
        private int startIndex;
        private int[] accessPath;

        public JBurgSubgoal(int goal_state, boolean is_nary, int start_index, int ... access_path) {
            this.goalState = goal_state;
            this.isNary = is_nary;
            this.startIndex = start_index;
            this.accessPath = access_path;
        }

        public int getGoalState() {
            return this.goalState;
        }

        public boolean isNary() {
            return this.isNary;
        }

        public JBurgAnnotation getNode(JBurgAnnotation root) {
            JBurgAnnotation result = root;
            for (int idx : this.accessPath) {
                result = result.getNthChild(idx);
            }
            return result;
        }
    }

    abstract class JBurgSpecializedAnnotation
    extends JBurgAnnotation {
        JBurgSpecializedAnnotation(ICSSNode node) {
            super(node);
        }

        @Override
        public JBurgAnnotation getNthChild(int idx) {
            throw new IllegalStateException(this.getClass().getName() + " has no children.");
        }

        @Override
        public void addChild(JBurgAnnotation new_child) {
            throw new IllegalStateException(this.getClass().getName() + " cannot have children.");
        }

        @Override
        public void reset(int goalState, int cost, int rule) {
            throw new IllegalStateException(this.getClass().getName() + " cannot be reset.");
        }

        @Override
        public void release() {
        }

        @Override
        public void recordAntecedent(int iGoalState, int newAntecedentState) {
            throw new IllegalStateException(this.getClass().getName() + " cannot record antecedents.");
        }
    }
}

