/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.royale.abc.semantics.InstanceInfo;
import org.apache.royale.abc.semantics.Name;

public abstract class ClassDependencySort {
    public static <T extends IInstanceInfoProvider> Collection<T> getSorted(Collection<T> classes) {
        boolean classProcessed;
        ArrayList sortedClasses = new ArrayList();
        ArrayList<DependencyTracker<IInstanceInfoProvider>> workingSet = new ArrayList<DependencyTracker<IInstanceInfoProvider>>();
        for (IInstanceInfoProvider raw_x : classes) {
            DependencyTracker<IInstanceInfoProvider> x = new DependencyTracker<IInstanceInfoProvider>(raw_x);
            for (DependencyTracker dependencyTracker : workingSet) {
                x.establishDependency(dependencyTracker);
            }
            workingSet.add(x);
        }
        do {
            classProcessed = false;
            Iterator it = workingSet.iterator();
            while (it.hasNext()) {
                DependencyTracker n = (DependencyTracker)it.next();
                if (!n.dependencies.isEmpty()) continue;
                classProcessed = true;
                sortedClasses.add(n.payload);
                for (DependencyTracker dependencyTracker : n.dependents) {
                    dependencyTracker.dependencies.remove(n);
                }
                it.remove();
            }
        } while (classProcessed);
        if (!workingSet.isEmpty()) {
            throw new IllegalStateException("cycle in class dependency graph");
        }
        return sortedClasses;
    }

    static class DependencyTracker<T extends IInstanceInfoProvider> {
        T payload;
        Set<DependencyTracker<T>> dependents = new HashSet<DependencyTracker<T>>();
        Set<DependencyTracker<T>> dependencies = new HashSet<DependencyTracker<T>>();

        DependencyTracker(T payload) {
            this.payload = payload;
        }

        void establishDependency(DependencyTracker<T> other) {
            InstanceInfo myInstance = this.payload.getInstanceInfo();
            InstanceInfo otherInstance = other.payload.getInstanceInfo();
            if (myInstance.superName != null && myInstance.superName.equals(otherInstance.name)) {
                this.makeDependentOf(other);
            } else if (otherInstance.superName != null && otherInstance.superName.equals(myInstance.name)) {
                other.makeDependentOf(this);
            }
            for (Name myInterface : myInstance.interfaceNames) {
                if (myInterface == null || !myInterface.equals(otherInstance.name)) continue;
                this.makeDependentOf(other);
            }
            for (Name otherInterface : otherInstance.interfaceNames) {
                if (!otherInterface.equals(myInstance.name)) continue;
                other.makeDependentOf(this);
            }
            if (this.dependencies.contains(other) && other.dependencies.contains(this)) {
                throw new IllegalStateException("simple cycle in dependency graph");
            }
        }

        void makeDependentOf(DependencyTracker<T> other) {
            assert (other != this);
            this.dependencies.add(other);
            other.dependents.add(this);
        }
    }

    public static interface IInstanceInfoProvider {
        public InstanceInfo getInstanceInfo();
    }
}

