/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.as;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.parsing.ITokenStreamFilter;
import org.apache.royale.compiler.internal.parsing.SourceFragmentsReader;
import org.apache.royale.compiler.internal.parsing.TokenBase;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.parsing.as.ASTokenTypes;
import org.apache.royale.compiler.internal.parsing.as.BaseRawASTokenizer;
import org.apache.royale.compiler.internal.parsing.as.IncludeHandler;
import org.apache.royale.compiler.internal.parsing.as.MetaDataPayloadToken;
import org.apache.royale.compiler.internal.parsing.as.RawASTokenizer;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.parsing.IASTokenizer;
import org.apache.royale.compiler.problems.CyclicalIncludesProblem;
import org.apache.royale.compiler.problems.ExpectXmlBeforeNamespaceProblem;
import org.apache.royale.compiler.problems.FileNotFoundProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem2;
import org.apache.royale.compiler.problems.UnexpectedTokenProblem;
import org.apache.royale.utils.ILengthAwareReader;
import org.apache.royale.utils.NonLockingStringReader;

public class StreamingASTokenizer
implements ASTokenTypes,
IASTokenizer,
Closeable {
    private static final String FOR_EACH = "for each";
    private static final String XML = "xml";
    private static final String DEFAULT_XML_NAMESPACE = "default xml namespace";
    private static final String ZERO = "0";
    private static final Map<String, Integer> keywordToTokenMap = new ImmutableMap.Builder().put((Object)"as", (Object)103).put((Object)"is", (Object)102).put((Object)"instanceof", (Object)101).put((Object)"in", (Object)59).put((Object)"delete", (Object)113).put((Object)"typeof", (Object)117).put((Object)"const", (Object)52).put((Object)"get", (Object)48).put((Object)"implements", (Object)44).put((Object)"import", (Object)25).put((Object)"use", (Object)26).put((Object)"extends", (Object)41).put((Object)"new", (Object)155).put((Object)"dynamic", (Object)30).put((Object)"final", (Object)29).put((Object)"native", (Object)33).put((Object)"override", (Object)31).put((Object)"static", (Object)32).put((Object)"virtual", (Object)34).put((Object)"abstract", (Object)35).put((Object)"set", (Object)49).put((Object)"catch", (Object)17).put((Object)"class", (Object)43).put((Object)"function", (Object)45).put((Object)"interface", (Object)40).put((Object)"package", (Object)39).put((Object)"var", (Object)51).put((Object)"false", (Object)122).put((Object)"null", (Object)120).put((Object)"true", (Object)121).put((Object)"public", (Object)7).put((Object)"private", (Object)7).put((Object)"protected", (Object)7).put((Object)"internal", (Object)7).put((Object)"include", (Object)13).put((Object)"do", (Object)60).put((Object)"while", (Object)61).put((Object)"break", (Object)63).put((Object)"continue", (Object)62).put((Object)"goto", (Object)14).put((Object)"for", (Object)58).put((Object)"for each", (Object)58).put((Object)"each", (Object)11).put((Object)"with", (Object)64).put((Object)"else", (Object)67).put((Object)"if", (Object)66).put((Object)"switch", (Object)68).put((Object)"case", (Object)69).put((Object)"default", (Object)70).put((Object)"try", (Object)65).put((Object)"finally", (Object)16).put((Object)"namespace", (Object)27).put((Object)"config", (Object)12).put((Object)"throw", (Object)57).put((Object)"super", (Object)71).put((Object)"this", (Object)123).put((Object)"void", (Object)116).put((Object)"return", (Object)56).build();
    private Reader reader;
    private RawASTokenizer tokenizer;
    private Exception lastException = null;
    private final List<ASToken> lookAheadBuffer;
    private int bufferSize = 0;
    private ASToken lastToken;
    private int offsetAdjustment;
    private int lineAdjustment = 0;
    private int columnAdjustment = 0;
    private IncludeHandler includeHandler;
    private StreamingASTokenizer forkIncludeTokenizer;
    private boolean hasEncounteredIncludeStatements = false;
    private TokenizerConfig config;
    private String sourcePath;
    private final List<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
    private Iterator<ASToken> ascIncludeImaginaryTokens;
    private final HashMap<String, String> stringPool;
    private static final Pattern UNICODE_PATTERN = Pattern.compile("\\\\u[a-fA-F0-9]{4}");
    private static final String UNICODE_LEADING_CHARS = "\\u";

    public StreamingASTokenizer(Reader reader) {
        this();
        this.setReader(reader);
    }

    public StreamingASTokenizer() {
        this.tokenizer = new RawASTokenizer();
        this.config = new TokenizerConfig();
        this.lookAheadBuffer = new ArrayList<ASToken>(5);
        this.includeHandler = IncludeHandler.creatDefaultIncludeHandler();
        this.stringPool = new HashMap();
        for (String keyword : keywordToTokenMap.keySet()) {
            this.stringPool.put(keyword, keyword);
        }
    }

    public static StreamingASTokenizer createForMXMLIndexing(String fileName) {
        StreamingASTokenizer result = new StreamingASTokenizer();
        result.setPath(fileName);
        result.includeHandler.enterFile(result.sourcePath);
        return result;
    }

    private static StreamingASTokenizer createForIncludeFile(StreamingASTokenizer currentTokenizer, IFileSpecification fileSpec, IncludeHandler includeHandler) throws FileNotFoundException {
        StreamingASTokenizer tokenizer = StreamingASTokenizer.create(fileSpec, includeHandler);
        return tokenizer;
    }

    protected static StreamingASTokenizer create(IFileSpecification fileSpec, IncludeHandler includeHandler) throws FileNotFoundException {
        assert (fileSpec != null) : "File specification can't be null.";
        assert (includeHandler != null) : "Include handler can't be null.";
        StreamingASTokenizer tokenizer = new StreamingASTokenizer();
        tokenizer.setReader(fileSpec.createReader());
        tokenizer.setPath(fileSpec.getPath());
        tokenizer.includeHandler = includeHandler;
        tokenizer.includeHandler.enterFile(tokenizer.sourcePath);
        return tokenizer;
    }

    protected static StreamingASTokenizer createForASParser(IFileSpecification fileSpec, IncludeHandler includeHandler, boolean followIncludes, List<String> includedFiles, boolean strictIdentifierNames) throws FileNotFoundException {
        StreamingASTokenizer tokenizer = StreamingASTokenizer.create(fileSpec, includeHandler);
        tokenizer.setFollowIncludes(followIncludes);
        tokenizer.setStrictIdentifierNames(strictIdentifierNames);
        ImmutableList.Builder imaginaryTokensBuilder = new ImmutableList.Builder();
        for (String filename : includedFiles) {
            imaginaryTokensBuilder.add((Object)new ASToken(13, 0, 0, 0, 0, "include"));
            imaginaryTokensBuilder.add((Object)new ASToken(18, 0, 0, 0, 0, '\"' + filename + '\"'));
        }
        tokenizer.ascIncludeImaginaryTokens = imaginaryTokensBuilder.build().iterator();
        return tokenizer;
    }

    protected static StreamingASTokenizer createForInlineScriptScopeBuilding(Reader reader, String path, IncludeHandler includeHandler, int offsetAdjustment, int lineAdjustment, int columnAdjustment) {
        assert (reader != null) : "Reader can't be null";
        assert (path != null) : "Path can't be null";
        assert (includeHandler != null) : "IncludeHandler can't be null";
        StreamingASTokenizer tokenizer = new StreamingASTokenizer();
        tokenizer.setReader(reader);
        tokenizer.setPath(path);
        tokenizer.includeHandler = includeHandler;
        tokenizer.setSourcePositionAdjustment(offsetAdjustment, lineAdjustment, columnAdjustment);
        return tokenizer;
    }

    protected static StreamingASTokenizer createForInlineExpressionParsing(Reader reader, String path) {
        assert (reader != null) : "Reader can't be null";
        assert (path != null) : "Path can't be null";
        StreamingASTokenizer tokenizer = new StreamingASTokenizer();
        tokenizer.setReader(reader);
        tokenizer.setPath(path);
        tokenizer.includeHandler.enterFile(path);
        tokenizer.lastToken = new ASToken(53, -1, -1, -1, -1, "=");
        return tokenizer;
    }

    public static StreamingASTokenizer createForRepairingASTokenizer(Reader reader, String path, IncludeHandler includeHandler) {
        assert (path != null || includeHandler == null) : "We need a source path to follow includes";
        StreamingASTokenizer tokenizer = new StreamingASTokenizer();
        tokenizer.setReader(reader);
        tokenizer.setPath(path);
        if (includeHandler != null) {
            tokenizer.includeHandler = includeHandler;
            includeHandler.enterFile(path);
        }
        return tokenizer;
    }

    public void setReader(Reader reader) {
        this.setReader(reader, 0, 0, 0);
    }

    public void setReader(Reader reader, int offset, int line, int column) {
        this.reader = reader;
        this.tokenizer = new RawASTokenizer();
        this.tokenizer.yyreset(reader);
        this.tokenizer.setCollectComments(this.config.collectComments);
        this.tokenizer.setSourcePath(this.sourcePath);
        this.setSourcePositionAdjustment(offset, line, column);
    }

    @Override
    public void setPath(String path) {
        assert (path != null) : "path of tokenizer shouldn't be null";
        this.sourcePath = path;
        this.tokenizer.setSourcePath(path);
    }

    public void setSourcePositionAdjustment(int offset, int line, int column) {
        this.offsetAdjustment = offset;
        this.lineAdjustment = line;
        this.columnAdjustment = column;
    }

    @Override
    public void setCollectComments(boolean collect) {
        this.config.collectComments = collect;
        if (this.tokenizer != null) {
            this.tokenizer.setCollectComments(collect);
        }
    }

    @Override
    public void setFollowIncludes(boolean followIncludes) {
        this.config.followIncludes = followIncludes;
    }

    public void setStrictIdentifierNames(boolean value) {
        this.config.strictIdentifierNames = value;
    }

    @Override
    public void close() throws IOException {
        if (this.tokenizer != null) {
            this.tokenizer.reset();
            this.tokenizer.yyclose();
        }
    }

    public void setIgnoreKeywords(boolean ignore) {
        this.config.ignoreKeywords = ignore;
    }

    public void setScanningFullContent(boolean full) {
        this.config.completeContent = full;
    }

    public void setIsMetadataAware(boolean aware) {
        this.config.findMetadata = aware;
    }

    public void setTokenFilter(ITokenStreamFilter filter) {
        this.config.filter = filter;
    }

    public void setIncludeHandler(IncludeHandler handler) {
        this.includeHandler = handler;
    }

    public boolean hasTokenizationProblems() {
        return this.tokenizer.hasProblems() || this.problems.size() > 0;
    }

    public boolean hasEncounteredIncludeStatements() {
        return this.hasEncounteredIncludeStatements;
    }

    public List<ICompilerProblem> getTokenizationProblems() {
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>(this.problems);
        problems.addAll(this.tokenizer.getProblems());
        return problems;
    }

    public ASToken[] getTokens(Reader reader, ITokenStreamFilter filter) {
        this.setReader(reader);
        List<ASToken> tokenList = this.initializeTokenList(reader);
        ASToken token = null;
        do {
            if ((token = this.next()) == null || !filter.accept(token)) continue;
            tokenList.add(token.clone());
        } while (token != null);
        return tokenList.toArray(new ASToken[0]);
    }

    public ASToken[] getTokens(Reader reader) {
        if (this.config.filter != null) {
            return this.getTokens(reader, this.config.filter);
        }
        this.setReader(reader);
        List<ASToken> tokenList = this.initializeTokenList(reader);
        ASToken token = null;
        do {
            if ((token = this.next()) == null) continue;
            tokenList.add(token.clone());
        } while (token != null);
        return tokenList.toArray(new ASToken[0]);
    }

    private List<ASToken> initializeTokenList(Reader reader) {
        int listSize = 8012;
        if (reader instanceof NonLockingStringReader) {
            listSize = 5;
            if (((NonLockingStringReader)reader).getLength() > 0L) {
                listSize = Math.max((int)((NonLockingStringReader)reader).getLength() / 5, 5);
            }
        } else if (reader instanceof ILengthAwareReader && ((ILengthAwareReader)((Object)reader)).getInputType() == ILengthAwareReader.InputType.FILE) {
            listSize = 9;
            if (((ILengthAwareReader)((Object)reader)).getLength() > 0L) {
                listSize = Math.max((int)((ILengthAwareReader)((Object)reader)).getLength() / 9, 9);
            }
        }
        ArrayList<ASToken> tokenList = new ArrayList<ASToken>(listSize);
        return tokenList;
    }

    @Override
    public IASToken[] getTokens(String range) {
        return this.getTokens(new NonLockingStringReader(range));
    }

    public final ASToken next(ITokenStreamFilter filter) {
        ASToken retVal = null;
        while ((retVal = this.next()) != null && !filter.accept(retVal)) {
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ASToken next() {
        block133: {
            ASToken retVal = null;
            boolean consumeSemi = false;
            try {
                if (this.forkIncludeTokenizer != null) {
                    retVal = this.forkIncludeTokenizer.next();
                    if (retVal == null) {
                        this.closeIncludeTokenizer();
                        consumeSemi = true;
                    } else {
                        ASToken aSToken = retVal;
                        return aSToken;
                    }
                }
                if (this.bufferSize > 0) {
                    retVal = this.lookAheadBuffer.remove(0);
                    --this.bufferSize;
                } else {
                    retVal = this.nextTokenFromReader();
                }
                if (retVal == null) {
                    ASToken aSToken = null;
                    return aSToken;
                }
                int tokenType = retVal.getType();
                switch (tokenType) {
                    case 11: {
                        this.treatKeywordAsIdentifier(retVal);
                        this.processUserDefinedNamespace(retVal, 0);
                        ASToken aSToken = retVal;
                        return aSToken;
                    }
                    case 13: {
                        Object filenameTokenText;
                        if (!this.config.strictIdentifierNames && this.lastToken != null) {
                            int lastTokenType = this.lastToken.getType();
                            switch (lastTokenType) {
                                case 36: 
                                case 45: 
                                case 48: 
                                case 49: 
                                case 51: {
                                    retVal.setType(15);
                                    ASToken aSToken = retVal;
                                    return aSToken;
                                }
                            }
                        }
                        if (!this.config.followIncludes) {
                            ASToken lastTokenType = retVal;
                            return lastTokenType;
                        }
                        ASToken token = this.LT(1);
                        if (token == null) {
                            ASToken aSToken = retVal;
                            return aSToken;
                        }
                        if (!StreamingASTokenizer.matches(token, 18)) {
                            this.treatKeywordAsIdentifier(retVal);
                            this.processUserDefinedNamespace(retVal, 0);
                        } else {
                            this.hasEncounteredIncludeStatements = true;
                            this.consume(1);
                            filenameTokenText = token.getText();
                            String includeString = ((String)filenameTokenText).substring(1, ((String)filenameTokenText).length() - 1);
                            if (this.sourcePath == null) {
                                throw new NullPointerException("Source file is needed for resolving included file path.");
                            }
                            IFileSpecification includedFileSpec = null;
                            includedFileSpec = this.includeHandler.getFileSpecificationForInclude(this.sourcePath, includeString);
                            if (includedFileSpec == null) {
                                FileNotFoundProblem problem = new FileNotFoundProblem(token, (String)filenameTokenText);
                                this.problems.add(problem);
                                ASToken aSToken = retVal = this.next();
                                return aSToken;
                            }
                            if (this.includeHandler.isCyclicInclude(includedFileSpec.getPath())) {
                                CyclicalIncludesProblem problem = new CyclicalIncludesProblem(token);
                                this.problems.add(problem);
                                ASToken aSToken = retVal = this.next();
                                return aSToken;
                            }
                            try {
                                this.forkIncludeTokenizer = StreamingASTokenizer.createForIncludeFile(this, includedFileSpec, this.includeHandler);
                                retVal = this.forkIncludeTokenizer.next();
                            }
                            catch (FileNotFoundException fnfe) {
                                this.includeHandler.handleFileNotFound(includedFileSpec);
                                FileNotFoundProblem problem = new FileNotFoundProblem(token, includedFileSpec.getPath());
                                this.problems.add(problem);
                                ASToken aSToken = retVal = this.next();
                                consumeSemi = false;
                                this.lastToken = retVal;
                                return aSToken;
                            }
                        }
                        if (retVal == null) {
                            this.closeIncludeTokenizer();
                            retVal = this.next();
                        }
                        filenameTokenText = retVal;
                        return filenameTokenText;
                    }
                    case 12: {
                        if (StreamingASTokenizer.matches(this.LT(1), 27)) {
                            retVal.setType(12);
                            ASToken token = retVal;
                            return token;
                        }
                        this.treatKeywordAsIdentifier(retVal);
                        this.processUserDefinedNamespace(retVal, 0);
                        ASToken token = retVal;
                        return token;
                    }
                    case 7: {
                        if (StreamingASTokenizer.matches(this.LT(1), 20)) {
                            retVal.setType(19);
                            ASToken token = retVal;
                            return token;
                        }
                        retVal.setType(21);
                        ASToken token = retVal;
                        return token;
                    }
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: {
                        ASToken nextToken = this.LT(1);
                        if (nextToken != null) {
                            switch (nextToken.getType()) {
                                case 7: 
                                case 19: 
                                case 21: 
                                case 27: 
                                case 29: 
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 40: 
                                case 43: 
                                case 45: 
                                case 51: 
                                case 52: {
                                    ASToken filenameTokenText = retVal;
                                    return filenameTokenText;
                                }
                                case 15: {
                                    if (!this.isUserDefinedNamespace(nextToken, 1)) break;
                                    ASToken filenameTokenText = retVal;
                                    return filenameTokenText;
                                }
                            }
                        }
                        this.treatKeywordAsIdentifier(retVal);
                        this.processUserDefinedNamespace(retVal, 0);
                        ASToken filenameTokenText = retVal;
                        return filenameTokenText;
                    }
                    case 107: 
                    case 108: {
                        ASToken nextToken;
                        if (!(this.lastToken != null && this.lastToken.canPreceedSignedOperator() || (nextToken = this.LT(1)) == null)) {
                            switch (nextToken.getType()) {
                                case 127: 
                                case 128: {
                                    retVal.setEnd(nextToken.getEnd());
                                    StringBuilder builder = new StringBuilder(retVal.getText());
                                    builder.append(nextToken.getText());
                                    retVal.setText(this.poolString(builder.toString()));
                                    this.consume(1);
                                    retVal.setType(nextToken.getType());
                                    break;
                                }
                            }
                        }
                        nextToken = retVal;
                        return nextToken;
                    }
                    case 58: {
                        ASToken token = this.LT(1);
                        if (StreamingASTokenizer.matches(token, 11)) {
                            retVal.setEnd(token.getEnd());
                            retVal.setText(FOR_EACH);
                            this.consume(1);
                            ASToken builder = retVal;
                            return builder;
                        }
                        if (!this.config.strictIdentifierNames && this.lastToken != null) {
                            int lastTokenType = this.lastToken.getType();
                            switch (lastTokenType) {
                                case 36: 
                                case 45: 
                                case 48: 
                                case 49: 
                                case 51: {
                                    retVal.setType(15);
                                }
                            }
                        }
                        ASToken lastTokenType = retVal;
                        return lastTokenType;
                    }
                    case 70: {
                        ASToken maybeNS = this.LT(2);
                        boolean foundTokenNamespace = maybeNS != null && maybeNS.getType() == 27;
                        ASToken maybeXML = this.LT(1);
                        if (foundTokenNamespace) {
                            boolean foundTokenXML;
                            boolean bl = foundTokenXML = maybeXML != null && maybeXML.getType() == 15 && XML.equals(maybeXML.getText());
                            if (!foundTokenXML) {
                                ExpectXmlBeforeNamespaceProblem problem = new ExpectXmlBeforeNamespaceProblem(maybeNS);
                                this.problems.add(problem);
                            }
                            retVal.setEnd(maybeNS.getEnd());
                            retVal.setText(DEFAULT_XML_NAMESPACE);
                            retVal.setType(54);
                            this.consume(2);
                        } else if (!this.config.strictIdentifierNames && maybeXML != null && maybeXML.getType() != 24) {
                            retVal.setType(15);
                        } else if (!this.config.strictIdentifierNames && this.lastToken != null) {
                            int lastTokenType = this.lastToken.getType();
                            switch (lastTokenType) {
                                case 36: 
                                case 45: 
                                case 48: 
                                case 49: 
                                case 51: {
                                    retVal.setType(15);
                                }
                            }
                        }
                        ASToken aSToken = retVal;
                        return aSToken;
                    }
                    case 116: {
                        ASToken closeParenT;
                        ASToken zeroT;
                        ASToken token = this.LT(1);
                        if (StreamingASTokenizer.matches(token, 127) && ZERO.equals(token.getText())) {
                            retVal.setType(125);
                            this.combineText(retVal, token);
                            this.consume(1);
                        } else if (StreamingASTokenizer.matches(token, 46) && StreamingASTokenizer.matches(zeroT = this.LT(2), 127) && ZERO.equals(zeroT.getText()) && StreamingASTokenizer.matches(closeParenT = this.LT(3), 47)) {
                            this.combineText(retVal, token);
                            this.combineText(retVal, zeroT);
                            this.combineText(retVal, closeParenT);
                            retVal.setType(125);
                            this.consume(3);
                        }
                        zeroT = retVal;
                        return zeroT;
                    }
                    case 15: {
                        this.processUserDefinedNamespace(retVal, 0);
                        ASToken token = retVal;
                        return token;
                    }
                    case 38: {
                        ASToken token = retVal = this.tryParseMetadata(retVal);
                        return token;
                    }
                    case 6: {
                        retVal.setType(111);
                        retVal.setEnd(retVal.getEnd() - 1);
                        retVal.setText("*");
                        ASToken nextToken = (ASToken)this.tokenizer.buildToken(53, retVal.getEnd() + 1, retVal.getEnd() + 2, retVal.getLine(), retVal.getColumn(), "=");
                        nextToken.setSourcePath(this.sourcePath);
                        this.addTokenToBuffer(nextToken);
                        ASToken zeroT = retVal;
                        return zeroT;
                    }
                    case 55: {
                        if (consumeSemi) {
                            ASToken nextToken = this.next();
                            return nextToken;
                        }
                        ASToken nextToken = retVal;
                        return nextToken;
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 27: 
                    case 28: 
                    case 36: 
                    case 42: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 53: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 114: 
                    case 115: 
                    case 118: 
                    case 119: 
                    case 125: 
                    case 126: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: {
                        ASToken nextToken = retVal;
                        return nextToken;
                    }
                    case 5: 
                    case 8: {
                        if (this.tokenizer.isCollectingComments()) {
                            ASToken nextToken = retVal;
                            return nextToken;
                        }
                        assert (false);
                        ASToken nextToken = null;
                        return nextToken;
                    }
                    case 59: 
                    case 101: 
                    case 102: 
                    case 103: {
                        if (!this.config.strictIdentifierNames) {
                            if (this.lastToken != null) {
                                int lastTokenType = this.lastToken.getType();
                                switch (lastTokenType) {
                                    case 22: 
                                    case 42: 
                                    case 55: {
                                        retVal.setType(15);
                                        ASToken zeroT = retVal;
                                        return zeroT;
                                    }
                                }
                            } else {
                                retVal.setType(15);
                                ASToken lastTokenType = retVal;
                                return lastTokenType;
                            }
                        }
                    }
                    case 113: {
                        ASToken nextToken;
                        if (!this.config.strictIdentifierNames && (nextToken = this.LT(1)) != null) {
                            int nextTokenType = nextToken.getType();
                            switch (nextTokenType) {
                                case 15: {
                                    ASToken aSToken = retVal;
                                    return aSToken;
                                }
                                case 42: 
                                case 55: {
                                    retVal.setType(15);
                                    ASToken aSToken = retVal;
                                    return aSToken;
                                }
                            }
                        }
                    }
                    case 16: 
                    case 17: 
                    case 25: 
                    case 26: 
                    case 39: 
                    case 40: 
                    case 43: 
                    case 51: 
                    case 52: 
                    case 56: 
                    case 57: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 71: 
                    case 117: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 155: {
                        if (!this.config.strictIdentifierNames && this.lastToken != null) {
                            int lastTokenType = this.lastToken.getType();
                            switch (lastTokenType) {
                                case 36: 
                                case 45: 
                                case 48: 
                                case 49: 
                                case 51: {
                                    retVal.setType(15);
                                }
                            }
                        }
                        ASToken lastTokenType = retVal;
                        return lastTokenType;
                    }
                }
                if (ASToken.isE4X(tokenType)) {
                    ASToken lastTokenType = retVal;
                    return lastTokenType;
                }
                if (retVal.isKeywordOrContextualReservedWord() || retVal.isLiteral()) {
                    ASToken lastTokenType = retVal;
                    return lastTokenType;
                }
                UnexpectedTokenProblem problem = new UnexpectedTokenProblem(retVal, IASToken.ASTokenKind.UNKNOWN);
                this.problems.add(problem);
            }
            catch (Exception e) {
                if (this.lastException != null) {
                    if (this.lastException.getClass().isInstance(e)) {
                        InternalCompilerProblem2 problem = new InternalCompilerProblem2(this.sourcePath, e, "StreamingASTokenizer");
                        this.problems.add(problem);
                        ASToken aSToken = null;
                        return aSToken;
                    }
                    break block133;
                }
                this.lastException = e;
                retVal = null;
                ASToken aSToken = this.next();
                return aSToken;
            }
            finally {
                consumeSemi = false;
                this.lastToken = retVal;
            }
        }
        return null;
    }

    private void treatKeywordAsIdentifier(ASToken token) {
        assert (token != null) : "token can't be null";
        assert (token.isKeywordOrContextualReservedWord()) : "only transfer reserved words";
        if (token.isKeyword()) {
            UnexpectedTokenProblem problem = new UnexpectedTokenProblem(token, IASToken.ASTokenKind.IDENTIFIER);
            this.problems.add(problem);
        }
        token.setType(15);
    }

    private ASToken tryParseMetadata(ASToken nextToken) throws Exception {
        boolean isNextMetadata;
        if (!this.config.findMetadata) {
            isNextMetadata = false;
        } else if (this.lastToken == null) {
            isNextMetadata = true;
        } else {
            block0 : switch (this.lastToken.getType()) {
                case 5: 
                case 8: 
                case 22: 
                case 28: 
                case 37: 
                case 55: {
                    isNextMetadata = true;
                    break;
                }
                case 15: 
                case 129: {
                    isNextMetadata = false;
                    break;
                }
                case 13: 
                case 23: 
                case 111: {
                    isNextMetadata = !this.lastToken.matchesLine(nextToken);
                    break;
                }
                default: {
                    if (this.config.completeContent) {
                        isNextMetadata = false;
                        break;
                    }
                    switch (this.lastToken.getType()) {
                        case 24: 
                        case 42: 
                        case 46: 
                        case 53: 
                        case 74: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 118: 
                        case 119: {
                            isNextMetadata = false;
                            break block0;
                        }
                    }
                    isNextMetadata = true;
                }
            }
        }
        ASToken result = isNextMetadata ? this.consumeMetadata(nextToken) : nextToken;
        return result;
    }

    private void closeIncludeTokenizer() {
        if (this.forkIncludeTokenizer == null) {
            return;
        }
        try {
            this.problems.addAll(this.forkIncludeTokenizer.problems);
            this.forkIncludeTokenizer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.includeHandler.leaveFile(this.forkIncludeTokenizer.getEndOffset());
        this.forkIncludeTokenizer = null;
    }

    private final ASToken consumeMetadata(ASToken startToken) throws Exception {
        ASToken next;
        ASToken originalToken = new ASToken(startToken);
        MetaDataPayloadToken payload = new MetaDataPayloadToken(originalToken);
        ArrayList<ASToken> safetyNet = new ArrayList<ASToken>(5);
        boolean isMetadata = true;
        do {
            this.tokenizer.setReuseLastToken();
            next = this.LT(1);
            if (next == null) break;
            safetyNet.add(new ASToken(next));
            payload.addToken(next);
            if (!next.canExistInMetadata()) {
                isMetadata = false;
                this.consume(1);
                break;
            }
            this.consume(1);
        } while (next.getType() != 129);
        if (!isMetadata) {
            this.lookAheadBuffer.addAll(safetyNet);
            this.bufferSize = this.lookAheadBuffer.size();
            return originalToken;
        }
        return payload;
    }

    private final void fill(int distance) throws Exception {
        for (int pos = 0; pos < distance; ++pos) {
            this.addTokenToBuffer(this.nextTokenFromReader());
        }
    }

    private final void addTokenToBuffer(ASToken nextToken) {
        ++this.bufferSize;
        this.lookAheadBuffer.add(nextToken);
        if (nextToken != null) {
            nextToken.lock();
        }
    }

    private final String poolString(String text) {
        String pooledString = this.stringPool.get(text);
        if (pooledString == null) {
            this.stringPool.put(text, text);
            pooledString = text;
        }
        return pooledString;
    }

    private final ASToken nextTokenFromReader() throws IOException {
        ASToken nextToken = this.ascIncludeImaginaryTokens != null && this.ascIncludeImaginaryTokens.hasNext() ? this.ascIncludeImaginaryTokens.next() : (this.tokenizer.hasBufferToken() ? this.tokenizer.getBufferToken() : this.tokenizer.nextToken());
        if (nextToken != null) {
            switch (nextToken.getType()) {
                case 127: {
                    nextToken.setText(this.poolString(nextToken.getText()));
                    break;
                }
                case 126: {
                    nextToken.setText(this.poolString(StreamingASTokenizer.convertUnicode(nextToken.getText()).replaceAll("\\\\u", "u")));
                    break;
                }
                case 15: {
                    Integer info;
                    String originalIdentifierName = nextToken.getText();
                    String normalizedIdentifierName = this.poolString(StreamingASTokenizer.convertUnicode(originalIdentifierName));
                    nextToken.setText(normalizedIdentifierName);
                    if (this.config.ignoreKeywords || !originalIdentifierName.equals(normalizedIdentifierName) || (info = keywordToTokenMap.get(nextToken.getText())) == null) break;
                    nextToken.setType(info);
                    break;
                }
            }
            nextToken.adjustLocation(this.offsetAdjustment, this.lineAdjustment, nextToken.getLine() == 0 ? this.columnAdjustment : 0);
            nextToken.storeLocalOffset();
            if (this.includeHandler != null) {
                nextToken.setSourcePath(this.includeHandler.getIncludeStackTop());
                this.includeHandler.onNextToken(nextToken);
            }
            if (nextToken.getSourcePath() == null) {
                nextToken.setSourcePath(this.sourcePath);
            }
            if (this.reader instanceof SourceFragmentsReader) {
                ((SourceFragmentsReader)this.reader).adjustLocation(nextToken);
            }
        }
        return nextToken;
    }

    private final void consume(int distance) {
        if (this.bufferSize >= distance) {
            while (distance > 0) {
                this.lookAheadBuffer.remove(this.bufferSize - 1);
                --this.bufferSize;
                --distance;
            }
        }
    }

    private final ASToken LT(int distance) throws Exception {
        if (this.bufferSize < distance) {
            this.fill(distance - this.bufferSize);
        }
        return this.lookAheadBuffer.get(distance - 1);
    }

    private static final boolean matches(ASToken token, int type) {
        return token != null && token.getType() == type;
    }

    public final int getEndOffset() {
        return this.tokenizer.getOffset() + this.offsetAdjustment;
    }

    private final boolean isUserDefinedNamespace(ASToken token, int lookaheadOffset) throws Exception {
        this.processUserDefinedNamespace(token, lookaheadOffset);
        return token.getType() == 21 || token.getType() == 19;
    }

    private final void processUserDefinedNamespace(ASToken token, int lookaheadOffset) throws Exception {
        token.lock();
        ASToken nextToken = this.LT(1 + lookaheadOffset);
        if (token.matchesLine(nextToken)) {
            if (nextToken.getType() == 15) {
                this.processUserDefinedNamespace(nextToken, 1 + lookaheadOffset);
            }
            switch (nextToken.getType()) {
                case 7: 
                case 21: 
                case 27: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 40: 
                case 43: 
                case 45: 
                case 51: 
                case 52: {
                    token.setType(21);
                    return;
                }
                case 20: {
                    token.setType(19);
                    return;
                }
            }
            if (nextToken.getType() == 36) {
                int nextValidPart = 15;
                ArrayList<ASToken> toTransform = new ArrayList<ASToken>(3);
                toTransform.add(token);
                toTransform.add(nextToken);
                int laDistance = lookaheadOffset + 1;
                while (token.matchesLine(nextToken = this.LT(++laDistance))) {
                    if (nextToken.getType() == nextValidPart) {
                        nextValidPart = nextToken.getType() == 15 ? 36 : 15;
                        toTransform.add(nextToken);
                        continue;
                    }
                    if (nextValidPart == 15 || !nextToken.canFollowUserNamespace()) break;
                    for (ASToken ttToken : toTransform) {
                        if (ttToken.getType() == 15) {
                            ttToken.setType(21);
                            continue;
                        }
                        ttToken.setType(36);
                    }
                }
            }
        }
    }

    private final void combineText(TokenBase target, TokenBase source) {
        StringBuilder text = new StringBuilder();
        text.append(target.getText());
        for (int i = 0; i < source.getStart() - target.getEnd(); ++i) {
            text.append(" ");
        }
        text.append(source.getText());
        target.setText(this.poolString(text.toString()));
        target.setEnd(target.getStart() + text.length());
    }

    static String convertUnicode(String text) {
        if (text.contains(UNICODE_LEADING_CHARS)) {
            StringBuilder result = new StringBuilder();
            Matcher matcher = UNICODE_PATTERN.matcher(text);
            int start = 0;
            while (matcher.find()) {
                result.append(text, start, matcher.start());
                result.append(Character.toChars(BaseRawASTokenizer.decodeEscapedUnicode(matcher.group())));
                start = matcher.end();
            }
            result.append(text, start, text.length());
            return result.toString();
        }
        return text;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    private static final class TokenizerConfig {
        public boolean ignoreKeywords = false;
        public boolean findMetadata = true;
        public boolean completeContent = true;
        public ITokenStreamFilter filter;
        public boolean collectComments = false;
        public boolean followIncludes = true;
        public boolean strictIdentifierNames = false;

        private TokenizerConfig() {
        }
    }
}

