/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.channel;

import com.alibaba.fastjson.JSON;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.mqtt.common.facade.WillMsgPersistManager;
import org.apache.rocketmq.mqtt.common.meta.IpUtil;
import org.apache.rocketmq.mqtt.common.model.MqttMessageUpContext;
import org.apache.rocketmq.mqtt.common.model.WillMessage;
import org.apache.rocketmq.mqtt.common.util.HostInfo;
import org.apache.rocketmq.mqtt.common.util.MessageUtil;
import org.apache.rocketmq.mqtt.cs.channel.ChannelCloseFrom;
import org.apache.rocketmq.mqtt.cs.channel.ChannelInfo;
import org.apache.rocketmq.mqtt.cs.channel.ChannelManager;
import org.apache.rocketmq.mqtt.cs.config.ConnectConf;
import org.apache.rocketmq.mqtt.cs.session.Session;
import org.apache.rocketmq.mqtt.cs.session.infly.MqttMsgId;
import org.apache.rocketmq.mqtt.cs.session.infly.RetryDriver;
import org.apache.rocketmq.mqtt.cs.session.loop.SessionLoop;
import org.apache.rocketmq.mqtt.ds.upstream.processor.PublishProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultChannelManager
implements ChannelManager {
    private static Logger logger = LoggerFactory.getLogger(DefaultChannelManager.class);
    private Map<String, Channel> channelMap = new ConcurrentHashMap<String, Channel>(1024);
    private HashedWheelTimer hashedWheelTimer;
    private static int minBlankChannelSeconds = 10;
    private ScheduledThreadPoolExecutor scheduler;
    @Resource
    private ConnectConf connectConf;
    @Resource
    private SessionLoop sessionLoop;
    @Resource
    private RetryDriver retryDriver;
    @Resource
    private MqttMsgId mqttMsgId;
    @Resource
    private WillMsgPersistManager willMsgPersistManager;
    @Resource
    private PublishProcessor publishProcessor;
    private ThreadPoolExecutor executor;

    @PostConstruct
    public void init() {
        this.sessionLoop.setChannelManager(this);
        this.hashedWheelTimer = new HashedWheelTimer(1L, TimeUnit.SECONDS);
        this.hashedWheelTimer.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (Channel channel : this.channelMap.values()) {
                this.closeConnect(channel, ChannelCloseFrom.SERVER, "ServerShutdown");
            }
        }));
        this.executor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(5000), (ThreadFactory)new ThreadFactoryImpl("DispatchWillToMQ_ "));
    }

    @Override
    public void addChannel(Channel channel) {
        if (this.channelMap.size() > this.connectConf.getMaxConn()) {
            this.closeConnect(channel, ChannelCloseFrom.SERVER, "overflow");
            logger.error("channel is too many {}", (Object)this.channelMap.size());
            return;
        }
        ChannelInfo.touch(channel);
        this.channelMap.put(ChannelInfo.getId(channel), channel);
        this.hashedWheelTimer.newTimeout(timeout -> this.doPing(timeout, channel), (long)minBlankChannelSeconds, TimeUnit.SECONDS);
    }

    private void doPing(Timeout timeout, Channel channel) {
        try {
            if (StringUtils.isBlank((CharSequence)ChannelInfo.getClientId(channel))) {
                this.closeConnect(channel, ChannelCloseFrom.SERVER, "No CONNECT");
                return;
            }
            long channelLifeCycle = ChannelInfo.getChannelLifeCycle(channel);
            if (System.currentTimeMillis() > channelLifeCycle) {
                this.closeConnect(channel, ChannelCloseFrom.SERVER, "Channel Auth Expire");
                return;
            }
            if (ChannelInfo.isExpired(channel)) {
                this.closeConnect(channel, ChannelCloseFrom.SERVER, "No Heart");
            } else {
                int keepAliveTimeSeconds = ChannelInfo.getKeepLive(channel);
                long lastTouchTime = ChannelInfo.getLastTouch(channel);
                long heartWindow = (long)Math.ceil((double)keepAliveTimeSeconds * 1.5 + 1.0) * 1000L;
                long delay = Math.min(heartWindow, heartWindow - (System.currentTimeMillis() - lastTouchTime));
                if (delay <= 0L) {
                    delay = heartWindow;
                }
                this.hashedWheelTimer.newTimeout(timeout.task(), delay, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            logger.error("Exception when doPing: ", (Throwable)e);
        }
    }

    @Override
    public void closeConnect(final Channel channel, ChannelCloseFrom from, String reason) {
        String clientId = ChannelInfo.getClientId(channel);
        String channelId = ChannelInfo.getId(channel);
        String ip = IpUtil.getLocalAddressCompatible();
        final String willKey = ip + 1 + clientId;
        CompletableFuture willMessageFuture = this.willMsgPersistManager.get(willKey);
        willMessageFuture.whenComplete((willMessageByte, throwable) -> {
            String content = new String((byte[])willMessageByte);
            if ("NOT_FOUND".equals(content)) {
                return;
            }
            if (!"disconnect".equals(reason)) {
                WillMessage willMessage = (WillMessage)JSON.parseObject((String)content, WillMessage.class);
                int mqttId = this.mqttMsgId.nextId(clientId);
                final MqttPublishMessage mqttMessage = MessageUtil.toMqttMessage((String)willMessage.getWillTopic(), (byte[])willMessage.getBody(), (int)willMessage.getQos(), (int)mqttId, (boolean)willMessage.isRetain());
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        CompletableFuture upstreamHookResult = DefaultChannelManager.this.publishProcessor.process(DefaultChannelManager.this.buildMqttMessageUpContext(channel), (MqttMessage)mqttMessage);
                        upstreamHookResult.whenComplete((hookResult, tb) -> {
                            try {
                                if (!hookResult.isSuccess()) {
                                    DefaultChannelManager.this.executor.submit(this);
                                } else {
                                    DefaultChannelManager.this.willMsgPersistManager.delete(willKey).whenComplete((resultDel, tbDel) -> {
                                        if (!resultDel.booleanValue() || tbDel != null) {
                                            logger.error("fail to delete will message key:{}", (Object)willKey);
                                            return;
                                        }
                                        logger.info("connection close and send will, delete will message key {} successfully", (Object)willKey);
                                    });
                                }
                            }
                            catch (Throwable t) {
                                logger.error("", t);
                            }
                        });
                    }
                };
                this.executor.submit(runnable);
            }
        });
        if (clientId == null) {
            this.channelMap.remove(channelId);
            this.sessionLoop.unloadSession(clientId, channelId);
        } else {
            Session session = this.sessionLoop.unloadSession(clientId, channelId);
            this.retryDriver.unloadSession(session);
            this.channelMap.remove(channelId);
            ChannelInfo.clear(channel);
        }
        if (channel.isActive()) {
            channel.close();
        }
        logger.info("Close Connect of channel {} from {} by reason of {}", new Object[]{channel, from, reason});
    }

    private MqttMessageUpContext buildMqttMessageUpContext(Channel channel) {
        MqttMessageUpContext context = new MqttMessageUpContext();
        context.setClientId(ChannelInfo.getClientId(channel));
        context.setChannelId(ChannelInfo.getId(channel));
        context.setNode(HostInfo.getInstall().getAddress());
        context.setNamespace(ChannelInfo.getNamespace(channel));
        return context;
    }

    @Override
    public void closeConnect(String channelId, String reason) {
        Channel channel = this.channelMap.get(channelId);
        if (channel == null) {
            return;
        }
        this.closeConnect(channel, ChannelCloseFrom.SERVER, reason);
    }

    @Override
    public Channel getChannelById(String channelId) {
        return this.channelMap.get(channelId);
    }

    @Override
    public int totalConn() {
        return this.channelMap.size();
    }
}

