/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.rhea.storage.KVIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;

public class MemoryKVIterator
implements KVIterator {
    private final ConcurrentNavigableMap<byte[], byte[]> db;
    private Map.Entry<byte[], byte[]> cursorEntry;

    public MemoryKVIterator(ConcurrentNavigableMap<byte[], byte[]> db) {
        this.db = db;
    }

    @Override
    public boolean isValid() {
        return this.cursorEntry != null;
    }

    @Override
    public void seekToFirst() {
        this.cursorEntry = this.db.firstEntry();
    }

    @Override
    public void seekToLast() {
        this.cursorEntry = this.db.lastEntry();
    }

    @Override
    public void seek(byte[] target) {
        this.cursorEntry = this.db.ceilingEntry(target);
    }

    @Override
    public void seekForPrev(byte[] target) {
        this.cursorEntry = this.db.lowerEntry(target);
    }

    @Override
    public void next() {
        this.cursorEntry = this.db.higherEntry(this.cursorEntry.getKey());
    }

    @Override
    public void prev() {
        this.cursorEntry = this.db.lowerEntry(this.cursorEntry.getKey());
    }

    @Override
    public byte[] key() {
        return this.cursorEntry.getKey();
    }

    @Override
    public byte[] value() {
        return this.cursorEntry.getValue();
    }

    @Override
    public void close() throws Exception {
    }
}

