/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.rhea.storage.Sequence;

public abstract class LongSequence {
    private final long base;
    private Sequence sequence;
    private long value;

    public LongSequence() {
        this(0L);
    }

    public LongSequence(long base) {
        this.base = base;
    }

    public synchronized long get() {
        return this.base + this.value;
    }

    public synchronized long next() {
        long val;
        if (this.sequence == null) {
            this.reset();
        }
        if ((val = this.value++) == this.sequence.getEndValue()) {
            this.reset();
            return this.base + this.value++;
        }
        return this.base + val;
    }

    private void reset() {
        this.sequence = this.getNextSequence();
        this.value = this.sequence.getStartValue();
    }

    public abstract Sequence getNextSequence();
}

