/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.options.configured;

import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.rhea.options.RegionEngineOptions;
import com.alipay.sofa.jraft.rhea.util.Configured;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.rhea.util.Maps;
import com.alipay.sofa.jraft.util.Requires;
import java.util.List;
import java.util.Map;

public final class MultiRegionEngineOptionsConfigured
implements Configured<List<RegionEngineOptions>> {
    private final Map<Long, RegionEngineOptions> optsTable;

    public static MultiRegionEngineOptionsConfigured newConfigured() {
        return new MultiRegionEngineOptionsConfigured(Maps.newHashMap());
    }

    public MultiRegionEngineOptionsConfigured withStartKey(Long regionId, String startKey) {
        this.getOrCreateOptsById(regionId).setStartKey(startKey);
        return this;
    }

    public MultiRegionEngineOptionsConfigured withStartKeyBytes(Long regionId, byte[] startKeyBytes) {
        this.getOrCreateOptsById(regionId).setStartKeyBytes(startKeyBytes);
        return this;
    }

    public MultiRegionEngineOptionsConfigured withEndKey(Long regionId, String endKey) {
        this.getOrCreateOptsById(regionId).setEndKey(endKey);
        return this;
    }

    public MultiRegionEngineOptionsConfigured withEndKeyBytes(Long regionId, byte[] endKeyBytes) {
        this.getOrCreateOptsById(regionId).setEndKeyBytes(endKeyBytes);
        return this;
    }

    public MultiRegionEngineOptionsConfigured withNodeOptions(Long regionId, NodeOptions nodeOptions) {
        this.getOrCreateOptsById(regionId).setNodeOptions(nodeOptions);
        return this;
    }

    public MultiRegionEngineOptionsConfigured withMetricsReportPeriod(Long regionId, long metricsReportPeriod) {
        this.getOrCreateOptsById(regionId).setMetricsReportPeriod(metricsReportPeriod);
        return this;
    }

    @Override
    public List<RegionEngineOptions> config() {
        return Lists.newArrayList(this.optsTable.values());
    }

    private RegionEngineOptions getOrCreateOptsById(Long regionId) {
        Requires.requireNonNull((Object)regionId, (String)"regionId");
        RegionEngineOptions opts = this.optsTable.get(regionId);
        if (opts != null) {
            return opts;
        }
        opts = new RegionEngineOptions();
        opts.setRegionId(regionId);
        this.optsTable.put(regionId, opts);
        return opts;
    }

    private MultiRegionEngineOptionsConfigured(Map<Long, RegionEngineOptions> optsTable) {
        this.optsTable = optsTable;
    }
}

