/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.rocketmq.eventbridge.adapter.persistence.apidestination.mybatis.dataobject;

import java.io.Serializable;
import java.util.Date;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@ToString
@Setter
@Getter
public class ApiDestinationDO implements Serializable {

    private String accountId;

    /**
     * This field was generated by MyBatis Generator. This field corresponds to the database column
     * event_api_destination.name
     *
     * @mbggenerated
     */
    private String name;

    /**
     * This field was generated by MyBatis Generator. This field corresponds to the database column
     * event_api_destination.protocol
     *
     * @mbggenerated
     */
    private String protocol;

    /**
     * This field was generated by MyBatis Generator. This field corresponds to the database column
     * event_api_destination.connection_name
     *
     * @mbggenerated
     */
    private String connectionName;

    /**
     * This field was generated by MyBatis Generator. This field corresponds to the database column
     * event_api_destination.invocation_rate_limit_per_second
     *
     * @mbggenerated
     */
    private Integer invocationRateLimitPerSecond;

    /**
     * This field was generated by MyBatis Generator. This field corresponds to the database column
     * event_api_destination.description
     *
     * @mbggenerated
     */
    private String description;

    /**
     * This field was generated by MyBatis Generator. This field corresponds to the database column
     * event_api_destination.gmt_create
     *
     * @mbggenerated
     */
    private Date gmtCreate;

    /**
     * This field was generated by MyBatis Generator. This field corresponds to the database column
     * event_api_destination.gmt_modify
     *
     * @mbggenerated
     */
    private Date gmtModify;

    /**
     * This field was generated by MyBatis Generator. This field corresponds to the database column
     * event_api_destination.api_params
     *
     * @mbggenerated
     */
    private String apiParams;

    /**
     * This field was generated by MyBatis Generator. This field corresponds to the database table
     * event_api_destination
     *
     * @mbggenerated
     */
    private static final long serialVersionUID = 1L;
}
