/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.transaction;

import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.utils.StartAndShutdown;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.service.transaction.EndTransactionRequestData;
import org.apache.rocketmq.proxy.service.transaction.TransactionData;
import org.apache.rocketmq.proxy.service.transaction.TransactionDataManager;
import org.apache.rocketmq.proxy.service.transaction.TransactionService;
import org.apache.rocketmq.remoting.protocol.header.EndTransactionRequestHeader;

public abstract class AbstractTransactionService
implements TransactionService,
StartAndShutdown {
    protected TransactionDataManager transactionDataManager = new TransactionDataManager();

    @Override
    public TransactionData addTransactionDataByBrokerAddr(ProxyContext ctx, String brokerAddr, String producerGroup, long tranStateTableOffset, long commitLogOffset, String transactionId, Message message) {
        return this.addTransactionDataByBrokerName(ctx, this.getBrokerNameByAddr(brokerAddr), producerGroup, tranStateTableOffset, commitLogOffset, transactionId, message);
    }

    @Override
    public TransactionData addTransactionDataByBrokerName(ProxyContext ctx, String brokerName, String producerGroup, long tranStateTableOffset, long commitLogOffset, String transactionId, Message message) {
        if (StringUtils.isBlank((CharSequence)brokerName)) {
            return null;
        }
        TransactionData transactionData = new TransactionData(brokerName, tranStateTableOffset, commitLogOffset, transactionId, System.currentTimeMillis(), ConfigurationManager.getProxyConfig().getTransactionDataExpireMillis());
        this.transactionDataManager.addTransactionData(producerGroup, transactionId, transactionData);
        return transactionData;
    }

    @Override
    public EndTransactionRequestData genEndTransactionRequestHeader(ProxyContext ctx, String producerGroup, Integer commitOrRollback, boolean fromTransactionCheck, String msgId, String transactionId) {
        TransactionData transactionData = this.transactionDataManager.pollNoExpireTransactionData(producerGroup, transactionId);
        if (transactionData == null) {
            return null;
        }
        EndTransactionRequestHeader header = new EndTransactionRequestHeader();
        header.setProducerGroup(producerGroup);
        header.setCommitOrRollback(commitOrRollback);
        header.setFromTransactionCheck(Boolean.valueOf(fromTransactionCheck));
        header.setMsgId(msgId);
        header.setTransactionId(transactionId);
        header.setTranStateTableOffset(Long.valueOf(transactionData.getTranStateTableOffset()));
        header.setCommitLogOffset(Long.valueOf(transactionData.getCommitLogOffset()));
        return new EndTransactionRequestData(transactionData.getBrokerName(), header);
    }

    @Override
    public void onSendCheckTransactionStateFailed(ProxyContext context, String producerGroup, TransactionData transactionData) {
        this.transactionDataManager.removeTransactionData(producerGroup, transactionData.getTransactionId(), transactionData);
    }

    protected abstract String getBrokerNameByAddr(String var1);

    public void shutdown() throws Exception {
        this.transactionDataManager.shutdown();
    }

    public void start() throws Exception {
        this.transactionDataManager.start();
    }
}

