/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RaftServerConfigKeys {
    public static final Logger LOG = LoggerFactory.getLogger(RaftServerConfigKeys.class);
    public static final String PREFIX = "raft.server";
    public static final String STORAGE_DIR_KEY = "raft.server.storage.dir";
    public static final List<File> STORAGE_DIR_DEFAULT = Collections.singletonList(new File("/tmp/raft-server/"));
    public static final String STORAGE_FREE_SPACE_MIN_KEY = "raft.server.storage.free-space.min";
    public static final SizeInBytes STORAGE_FREE_SPACE_MIN_DEFAULT = SizeInBytes.valueOf("0MB");
    public static final String REMOVED_GROUPS_DIR_KEY = "raft.server.removed.groups.dir";
    public static final File REMOVED_GROUPS_DIR_DEFAULT = new File("/tmp/raft-server/removed-groups/");
    public static final String SLEEP_DEVIATION_THRESHOLD_KEY = "raft.server.sleep.deviation.threshold";
    public static final TimeDuration SLEEP_DEVIATION_THRESHOLD_DEFAULT = TimeDuration.valueOf(300L, TimeUnit.MILLISECONDS);
    public static final String CLOSE_THRESHOLD_KEY = "raft.server.close.threshold";
    public static final TimeDuration CLOSE_THRESHOLD_DEFAULT = TimeDuration.valueOf(60L, TimeUnit.SECONDS);
    public static final String STAGING_CATCHUP_GAP_KEY = "raft.server.staging.catchup.gap";
    public static final int STAGING_CATCHUP_GAP_DEFAULT = 1000;

    public static Consumer<String> getDefaultLog() {
        return LOG::info;
    }

    public static List<File> storageDir(RaftProperties properties) {
        return ConfUtils.getFiles(properties::getFiles, STORAGE_DIR_KEY, STORAGE_DIR_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
    }

    public static void setStorageDir(RaftProperties properties, List<File> storageDir) {
        ConfUtils.setFiles(properties::setFiles, STORAGE_DIR_KEY, storageDir, new BiConsumer[0]);
    }

    public static SizeInBytes storageFreeSpaceMin(RaftProperties properties) {
        return ConfUtils.getSizeInBytes(properties::getSizeInBytes, STORAGE_FREE_SPACE_MIN_KEY, STORAGE_FREE_SPACE_MIN_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
    }

    public static void setStorageFreeSpaceMin(RaftProperties properties, SizeInBytes storageFreeSpaceMin) {
        ConfUtils.setSizeInBytes(properties::set, STORAGE_FREE_SPACE_MIN_KEY, storageFreeSpaceMin, new BiConsumer[0]);
    }

    public static File removedGroupsDir(RaftProperties properties) {
        return ConfUtils.getFile(properties::getFile, REMOVED_GROUPS_DIR_KEY, REMOVED_GROUPS_DIR_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
    }

    public static void setRemovedGroupsDir(RaftProperties properties, File removedGroupsStorageDir) {
        ConfUtils.setFile(properties::setFile, REMOVED_GROUPS_DIR_KEY, removedGroupsStorageDir, new BiConsumer[0]);
    }

    public static TimeDuration sleepDeviationThreshold(RaftProperties properties) {
        return ConfUtils.getTimeDuration(properties.getTimeDuration(SLEEP_DEVIATION_THRESHOLD_DEFAULT.getUnit()), SLEEP_DEVIATION_THRESHOLD_KEY, SLEEP_DEVIATION_THRESHOLD_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
    }

    public static void setSleepDeviationThreshold(RaftProperties properties, int thresholdMs) {
        ConfUtils.setInt(properties::setInt, SLEEP_DEVIATION_THRESHOLD_KEY, thresholdMs, new BiConsumer[0]);
    }

    public static TimeDuration closeThreshold(RaftProperties properties) {
        return ConfUtils.getTimeDuration(properties.getTimeDuration(CLOSE_THRESHOLD_DEFAULT.getUnit()), CLOSE_THRESHOLD_KEY, CLOSE_THRESHOLD_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
    }

    public static void setCloseThreshold(RaftProperties properties, int thresholdMs) {
        ConfUtils.setInt(properties::setInt, CLOSE_THRESHOLD_KEY, thresholdMs, new BiConsumer[0]);
    }

    public static int stagingCatchupGap(RaftProperties properties) {
        return ConfUtils.getInt(properties::getInt, STAGING_CATCHUP_GAP_KEY, 1000, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(0));
    }

    public static void setStagingCatchupGap(RaftProperties properties, int stagingCatchupGap) {
        ConfUtils.setInt(properties::setInt, STAGING_CATCHUP_GAP_KEY, stagingCatchupGap, new BiConsumer[0]);
    }

    public static void main(String[] args) {
        ConfUtils.printAll(RaftServerConfigKeys.class);
    }

    public static interface LeaderElection {
        public static final String PREFIX = "raft.server." + JavaUtils.getClassSimpleName(LeaderElection.class).toLowerCase();
        public static final String LEADER_STEP_DOWN_WAIT_TIME_KEY = PREFIX + ".leader.step-down.wait-time";
        public static final TimeDuration LEADER_STEP_DOWN_WAIT_TIME_DEFAULT = TimeDuration.valueOf(10L, TimeUnit.SECONDS);
        public static final String PRE_VOTE_KEY = PREFIX + ".pre-vote";
        public static final boolean PRE_VOTE_DEFAULT = true;
        public static final String MEMBER_MAJORITY_ADD_KEY = PREFIX + ".member.majority-add";
        public static final boolean MEMBER_MAJORITY_ADD_DEFAULT = false;

        public static TimeDuration leaderStepDownWaitTime(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(LEADER_STEP_DOWN_WAIT_TIME_DEFAULT.getUnit()), LEADER_STEP_DOWN_WAIT_TIME_KEY, LEADER_STEP_DOWN_WAIT_TIME_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setLeaderStepDownWaitTime(RaftProperties properties, TimeDuration leaderStepDownWaitTime) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, LEADER_STEP_DOWN_WAIT_TIME_KEY, leaderStepDownWaitTime, new BiConsumer[0]);
        }

        public static boolean preVote(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, PRE_VOTE_KEY, true, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setPreVote(RaftProperties properties, boolean enablePreVote) {
            ConfUtils.setBoolean(properties::setBoolean, PRE_VOTE_KEY, enablePreVote, new BiConsumer[0]);
        }

        public static boolean memberMajorityAdd(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, MEMBER_MAJORITY_ADD_KEY, false, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setMemberMajorityAdd(RaftProperties properties, boolean enableMemberMajorityAdd) {
            ConfUtils.setBoolean(properties::setBoolean, MEMBER_MAJORITY_ADD_KEY, enableMemberMajorityAdd, new BiConsumer[0]);
        }
    }

    public static interface Notification {
        public static final String PREFIX = "raft.server." + JavaUtils.getClassSimpleName(Notification.class).toLowerCase();
        public static final String NO_LEADER_TIMEOUT_KEY = PREFIX + ".no-leader.timeout";
        public static final TimeDuration NO_LEADER_TIMEOUT_DEFAULT = TimeDuration.valueOf(60L, TimeUnit.SECONDS);

        public static TimeDuration noLeaderTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(NO_LEADER_TIMEOUT_DEFAULT.getUnit()), NO_LEADER_TIMEOUT_KEY, NO_LEADER_TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setNoLeaderTimeout(RaftProperties properties, TimeDuration noLeaderTimeout) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, NO_LEADER_TIMEOUT_KEY, noLeaderTimeout, new BiConsumer[0]);
        }
    }

    public static interface RetryCache {
        public static final String PREFIX = "raft.server.retrycache";
        public static final String EXPIRY_TIME_KEY = "raft.server.retrycache.expirytime";
        public static final TimeDuration EXPIRY_TIME_DEFAULT = TimeDuration.valueOf(60L, TimeUnit.SECONDS);
        public static final String STATISTICS_EXPIRY_TIME_KEY = "raft.server.retrycache.statistics.expirytime";
        public static final TimeDuration STATISTICS_EXPIRY_TIME_DEFAULT = TimeDuration.valueOf(100L, TimeUnit.MILLISECONDS);

        public static TimeDuration expiryTime(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(EXPIRY_TIME_DEFAULT.getUnit()), EXPIRY_TIME_KEY, EXPIRY_TIME_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setExpiryTime(RaftProperties properties, TimeDuration expiryTime) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, EXPIRY_TIME_KEY, expiryTime, new BiConsumer[0]);
        }

        public static TimeDuration statisticsExpiryTime(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(STATISTICS_EXPIRY_TIME_DEFAULT.getUnit()), STATISTICS_EXPIRY_TIME_KEY, STATISTICS_EXPIRY_TIME_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setStatisticsExpiryTime(RaftProperties properties, TimeDuration expiryTime) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, STATISTICS_EXPIRY_TIME_KEY, expiryTime, new BiConsumer[0]);
        }
    }

    public static interface Rpc {
        public static final String PREFIX = "raft.server.rpc";
        public static final String TIMEOUT_MIN_KEY = "raft.server.rpc.timeout.min";
        public static final TimeDuration TIMEOUT_MIN_DEFAULT = TimeDuration.valueOf(150L, TimeUnit.MILLISECONDS);
        public static final String TIMEOUT_MAX_KEY = "raft.server.rpc.timeout.max";
        public static final TimeDuration TIMEOUT_MAX_DEFAULT = TimeDuration.valueOf(300L, TimeUnit.MILLISECONDS);
        public static final String FIRST_ELECTION_TIMEOUT_MIN_KEY = "raft.server.rpc.first-election.timeout.min";
        public static final TimeDuration FIRST_ELECTION_TIMEOUT_MIN_DEFAULT = null;
        public static final String FIRST_ELECTION_TIMEOUT_MAX_KEY = "raft.server.rpc.first-election.timeout.max";
        public static final TimeDuration FIRST_ELECTION_TIMEOUT_MAX_DEFAULT = null;
        public static final String REQUEST_TIMEOUT_KEY = "raft.server.rpc.request.timeout";
        public static final TimeDuration REQUEST_TIMEOUT_DEFAULT = TimeDuration.valueOf(3000L, TimeUnit.MILLISECONDS);
        public static final String SLEEP_TIME_KEY = "raft.server.rpc.sleep.time";
        public static final TimeDuration SLEEP_TIME_DEFAULT = TimeDuration.valueOf(25L, TimeUnit.MILLISECONDS);
        public static final String SLOWNESS_TIMEOUT_KEY = "raft.server.rpc.slowness.timeout";
        public static final TimeDuration SLOWNESS_TIMEOUT_DEFAULT = TimeDuration.valueOf(60L, TimeUnit.SECONDS);

        public static TimeDuration timeoutMin(RaftProperties properties, Consumer<String> logger) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(TIMEOUT_MIN_DEFAULT.getUnit()), TIMEOUT_MIN_KEY, TIMEOUT_MIN_DEFAULT, logger, new BiConsumer[0]);
        }

        public static TimeDuration timeoutMin(RaftProperties properties) {
            return Rpc.timeoutMin(properties, RaftServerConfigKeys.getDefaultLog());
        }

        public static void setTimeoutMin(RaftProperties properties, TimeDuration minDuration) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, TIMEOUT_MIN_KEY, minDuration, new BiConsumer[0]);
        }

        public static TimeDuration timeoutMax(RaftProperties properties, Consumer<String> logger) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(TIMEOUT_MAX_DEFAULT.getUnit()), TIMEOUT_MAX_KEY, TIMEOUT_MAX_DEFAULT, logger, new BiConsumer[0]);
        }

        public static TimeDuration timeoutMax(RaftProperties properties) {
            return Rpc.timeoutMax(properties, RaftServerConfigKeys.getDefaultLog());
        }

        public static void setTimeoutMax(RaftProperties properties, TimeDuration maxDuration) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, TIMEOUT_MAX_KEY, maxDuration, new BiConsumer[0]);
        }

        public static TimeDuration firstElectionTimeoutMin(RaftProperties properties) {
            TimeDuration fallbackFirstElectionTimeoutMin = Rpc.timeoutMin(properties, null);
            return ConfUtils.getTimeDuration(properties.getTimeDuration(fallbackFirstElectionTimeoutMin.getUnit()), FIRST_ELECTION_TIMEOUT_MIN_KEY, FIRST_ELECTION_TIMEOUT_MIN_DEFAULT, TIMEOUT_MIN_KEY, fallbackFirstElectionTimeoutMin, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setFirstElectionTimeoutMin(RaftProperties properties, TimeDuration firstMinDuration) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, FIRST_ELECTION_TIMEOUT_MIN_KEY, firstMinDuration, new BiConsumer[0]);
        }

        public static TimeDuration firstElectionTimeoutMax(RaftProperties properties) {
            TimeDuration fallbackFirstElectionTimeoutMax = Rpc.timeoutMax(properties, null);
            return ConfUtils.getTimeDuration(properties.getTimeDuration(fallbackFirstElectionTimeoutMax.getUnit()), FIRST_ELECTION_TIMEOUT_MAX_KEY, FIRST_ELECTION_TIMEOUT_MAX_DEFAULT, TIMEOUT_MAX_KEY, fallbackFirstElectionTimeoutMax, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setFirstElectionTimeoutMax(RaftProperties properties, TimeDuration firstMaxDuration) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, FIRST_ELECTION_TIMEOUT_MAX_KEY, firstMaxDuration, new BiConsumer[0]);
        }

        public static TimeDuration requestTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(REQUEST_TIMEOUT_DEFAULT.getUnit()), REQUEST_TIMEOUT_KEY, REQUEST_TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setRequestTimeout(RaftProperties properties, TimeDuration timeoutDuration) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, REQUEST_TIMEOUT_KEY, timeoutDuration, new BiConsumer[0]);
        }

        public static TimeDuration sleepTime(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(SLEEP_TIME_DEFAULT.getUnit()), SLEEP_TIME_KEY, SLEEP_TIME_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setSleepTime(RaftProperties properties, TimeDuration sleepTime) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, SLEEP_TIME_KEY, sleepTime, new BiConsumer[0]);
        }

        public static TimeDuration slownessTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(SLOWNESS_TIMEOUT_DEFAULT.getUnit()), SLOWNESS_TIMEOUT_KEY, SLOWNESS_TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setSlownessTimeout(RaftProperties properties, TimeDuration expiryTime) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, SLOWNESS_TIMEOUT_KEY, expiryTime, new BiConsumer[0]);
        }
    }

    public static interface DataStream {
        public static final String PREFIX = "raft.server.data-stream";
        public static final String ASYNC_REQUEST_THREAD_POOL_CACHED_KEY = "raft.server.data-stream.async.request.thread.pool.cached";
        public static final boolean ASYNC_REQUEST_THREAD_POOL_CACHED_DEFAULT = false;
        public static final String ASYNC_REQUEST_THREAD_POOL_SIZE_KEY = "raft.server.data-stream.async.request.thread.pool.size";
        public static final int ASYNC_REQUEST_THREAD_POOL_SIZE_DEFAULT = 32;
        public static final String ASYNC_WRITE_THREAD_POOL_SIZE_KEY = "raft.server.data-stream.async.write.thread.pool.size";
        public static final int ASYNC_WRITE_THREAD_POOL_SIZE_DEFAULT = 16;
        public static final String CLIENT_POOL_SIZE_KEY = "raft.server.data-stream.client.pool.size";
        public static final int CLIENT_POOL_SIZE_DEFAULT = 10;

        public static boolean asyncRequestThreadPoolCached(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, ASYNC_REQUEST_THREAD_POOL_CACHED_KEY, false, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setAsyncRequestThreadPoolCached(RaftProperties properties, boolean useCached) {
            ConfUtils.setBoolean(properties::setBoolean, ASYNC_REQUEST_THREAD_POOL_CACHED_KEY, useCached, new BiConsumer[0]);
        }

        public static int asyncRequestThreadPoolSize(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, ASYNC_REQUEST_THREAD_POOL_SIZE_KEY, 32, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(0), ConfUtils.requireMax(65536));
        }

        public static void setAsyncRequestThreadPoolSize(RaftProperties properties, int size) {
            ConfUtils.setInt(properties::setInt, ASYNC_REQUEST_THREAD_POOL_SIZE_KEY, size, new BiConsumer[0]);
        }

        public static int asyncWriteThreadPoolSize(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, ASYNC_WRITE_THREAD_POOL_SIZE_KEY, 16, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(0), ConfUtils.requireMax(65536));
        }

        public static void setAsyncWriteThreadPoolSize(RaftProperties properties, int size) {
            ConfUtils.setInt(properties::setInt, ASYNC_WRITE_THREAD_POOL_SIZE_KEY, size, new BiConsumer[0]);
        }

        public static int clientPoolSize(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, CLIENT_POOL_SIZE_KEY, 10, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(0), ConfUtils.requireMax(65536));
        }

        public static void setClientPoolSize(RaftProperties properties, int num) {
            ConfUtils.setInt(properties::setInt, CLIENT_POOL_SIZE_KEY, num, new BiConsumer[0]);
        }
    }

    public static interface Snapshot {
        public static final String PREFIX = "raft.server.snapshot";
        public static final String AUTO_TRIGGER_ENABLED_KEY = "raft.server.snapshot.auto.trigger.enabled";
        public static final boolean AUTO_TRIGGER_ENABLED_DEFAULT = false;
        public static final String TRIGGER_WHEN_STOP_ENABLED_KEY = "raft.server.snapshot.trigger-when-stop.enabled";
        public static final boolean TRIGGER_WHEN_STOP_ENABLED_DEFAULT = true;
        public static final String CREATION_GAP_KEY = "raft.server.snapshot.creation.gap";
        public static final long CREATION_GAP_DEFAULT = 1024L;
        public static final String AUTO_TRIGGER_THRESHOLD_KEY = "raft.server.snapshot.auto.trigger.threshold";
        public static final long AUTO_TRIGGER_THRESHOLD_DEFAULT = 400000L;
        public static final String RETENTION_FILE_NUM_KEY = "raft.server.snapshot.retention.file.num";
        public static final int RETENTION_FILE_NUM_DEFAULT = -1;

        public static boolean autoTriggerEnabled(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, AUTO_TRIGGER_ENABLED_KEY, false, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setAutoTriggerEnabled(RaftProperties properties, boolean autoTriggerEnabled) {
            ConfUtils.setBoolean(properties::setBoolean, AUTO_TRIGGER_ENABLED_KEY, autoTriggerEnabled, new BiConsumer[0]);
        }

        public static boolean triggerWhenStopEnabled(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, TRIGGER_WHEN_STOP_ENABLED_KEY, true, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setTriggerWhenStopEnabled(RaftProperties properties, boolean triggerWhenStopEnabled) {
            ConfUtils.setBoolean(properties::setBoolean, TRIGGER_WHEN_STOP_ENABLED_KEY, triggerWhenStopEnabled, new BiConsumer[0]);
        }

        public static long creationGap(RaftProperties properties) {
            return ConfUtils.getLong(properties::getLong, CREATION_GAP_KEY, 1024L, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(1L));
        }

        public static void setCreationGap(RaftProperties properties, long creationGap) {
            ConfUtils.setLong(properties::setLong, CREATION_GAP_KEY, creationGap, new BiConsumer[0]);
        }

        public static long autoTriggerThreshold(RaftProperties properties) {
            return ConfUtils.getLong(properties::getLong, AUTO_TRIGGER_THRESHOLD_KEY, 400000L, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(0L));
        }

        public static void setAutoTriggerThreshold(RaftProperties properties, long autoTriggerThreshold) {
            ConfUtils.setLong(properties::setLong, AUTO_TRIGGER_THRESHOLD_KEY, autoTriggerThreshold, new BiConsumer[0]);
        }

        public static int retentionFileNum(RaftProperties raftProperties) {
            return ConfUtils.getInt(raftProperties::getInt, RETENTION_FILE_NUM_KEY, -1, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setRetentionFileNum(RaftProperties properties, int numSnapshotFilesRetained) {
            ConfUtils.setInt(properties::setInt, RETENTION_FILE_NUM_KEY, numSnapshotFilesRetained, new BiConsumer[0]);
        }
    }

    public static interface Log {
        public static final String PREFIX = "raft.server.log";
        public static final String USE_MEMORY_KEY = "raft.server.log.use.memory";
        public static final boolean USE_MEMORY_DEFAULT = false;
        public static final String QUEUE_ELEMENT_LIMIT_KEY = "raft.server.log.queue.element-limit";
        public static final int QUEUE_ELEMENT_LIMIT_DEFAULT = 4096;
        public static final String QUEUE_BYTE_LIMIT_KEY = "raft.server.log.queue.byte-limit";
        public static final SizeInBytes QUEUE_BYTE_LIMIT_DEFAULT = SizeInBytes.valueOf("64MB");
        public static final String PURGE_GAP_KEY = "raft.server.log.purge.gap";
        public static final int PURGE_GAP_DEFAULT = 1024;
        public static final String PURGE_UPTO_SNAPSHOT_INDEX_KEY = "raft.server.log.purge.upto.snapshot.index";
        public static final boolean PURGE_UPTO_SNAPSHOT_INDEX_DEFAULT = false;
        public static final String PURGE_PRESERVATION_LOG_NUM_KEY = "raft.server.log.purge.preservation.log.num";
        public static final long PURGE_PRESERVATION_LOG_NUM_DEFAULT = 0L;
        public static final String SEGMENT_SIZE_MAX_KEY = "raft.server.log.segment.size.max";
        public static final SizeInBytes SEGMENT_SIZE_MAX_DEFAULT = SizeInBytes.valueOf("32MB");
        public static final String SEGMENT_CACHE_NUM_MAX_KEY = "raft.server.log.segment.cache.num.max";
        public static final int SEGMENT_CACHE_NUM_MAX_DEFAULT = 6;
        public static final String SEGMENT_CACHE_SIZE_MAX_KEY = "raft.server.log.segment.cache.size.max";
        public static final SizeInBytes SEGMENT_CACHE_SIZE_MAX_DEFAULT = SizeInBytes.valueOf("200MB");
        public static final String PREALLOCATED_SIZE_KEY = "raft.server.log.preallocated.size";
        public static final SizeInBytes PREALLOCATED_SIZE_DEFAULT = SizeInBytes.valueOf("4MB");
        public static final String WRITE_BUFFER_SIZE_KEY = "raft.server.log.write.buffer.size";
        public static final SizeInBytes WRITE_BUFFER_SIZE_DEFAULT = SizeInBytes.valueOf("8MB");
        public static final String FORCE_SYNC_NUM_KEY = "raft.server.log.force.sync.num";
        public static final int FORCE_SYNC_NUM_DEFAULT = 128;
        public static final String UNSAFE_FLUSH_ENABLED_KEY = "raft.server.log.unsafe-flush.enabled";
        public static final boolean UNSAFE_FLUSH_ENABLED_DEFAULT = false;
        public static final String ASYNC_FLUSH_ENABLED_KEY = "raft.server.log.async-flush.enabled";
        public static final boolean ASYNC_FLUSH_ENABLED_DEFAULT = false;
        public static final String CORRUPTION_POLICY_KEY = "raft.server.log.corruption.policy";
        public static final CorruptionPolicy CORRUPTION_POLICY_DEFAULT = CorruptionPolicy.getDefault();

        public static boolean useMemory(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, USE_MEMORY_KEY, false, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setUseMemory(RaftProperties properties, boolean useMemory) {
            ConfUtils.setBoolean(properties::setBoolean, USE_MEMORY_KEY, useMemory, new BiConsumer[0]);
        }

        public static int queueElementLimit(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, QUEUE_ELEMENT_LIMIT_KEY, 4096, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(1));
        }

        public static void setQueueElementLimit(RaftProperties properties, int queueSize) {
            ConfUtils.setInt(properties::setInt, QUEUE_ELEMENT_LIMIT_KEY, queueSize, ConfUtils.requireMin(1));
        }

        public static SizeInBytes queueByteLimit(RaftProperties properties) {
            return ConfUtils.getSizeInBytes(properties::getSizeInBytes, QUEUE_BYTE_LIMIT_KEY, QUEUE_BYTE_LIMIT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        @Deprecated
        public static void setQueueByteLimit(RaftProperties properties, int queueSize) {
            ConfUtils.setInt(properties::setInt, QUEUE_BYTE_LIMIT_KEY, queueSize, ConfUtils.requireMin(1));
        }

        public static void setQueueByteLimit(RaftProperties properties, SizeInBytes byteLimit) {
            ConfUtils.setSizeInBytes(properties::set, QUEUE_BYTE_LIMIT_KEY, byteLimit, ConfUtils.requireMin(1L));
        }

        public static int purgeGap(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, PURGE_GAP_KEY, 1024, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(1));
        }

        public static void setPurgeGap(RaftProperties properties, int purgeGap) {
            ConfUtils.setInt(properties::setInt, PURGE_GAP_KEY, purgeGap, ConfUtils.requireMin(1));
        }

        public static boolean purgeUptoSnapshotIndex(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, PURGE_UPTO_SNAPSHOT_INDEX_KEY, false, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setPurgeUptoSnapshotIndex(RaftProperties properties, boolean shouldPurgeUptoSnapshotIndex) {
            ConfUtils.setBoolean(properties::setBoolean, PURGE_UPTO_SNAPSHOT_INDEX_KEY, shouldPurgeUptoSnapshotIndex, new BiConsumer[0]);
        }

        public static long purgePreservationLogNum(RaftProperties properties) {
            return ConfUtils.getLong(properties::getLong, PURGE_PRESERVATION_LOG_NUM_KEY, 0L, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setPurgePreservationLogNum(RaftProperties properties, long purgePreserveLogNum) {
            ConfUtils.setLong(properties::setLong, PURGE_PRESERVATION_LOG_NUM_KEY, purgePreserveLogNum, new BiConsumer[0]);
        }

        public static SizeInBytes segmentSizeMax(RaftProperties properties) {
            return ConfUtils.getSizeInBytes(properties::getSizeInBytes, SEGMENT_SIZE_MAX_KEY, SEGMENT_SIZE_MAX_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setSegmentSizeMax(RaftProperties properties, SizeInBytes segmentSizeMax) {
            ConfUtils.setSizeInBytes(properties::set, SEGMENT_SIZE_MAX_KEY, segmentSizeMax, new BiConsumer[0]);
        }

        public static int segmentCacheNumMax(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, SEGMENT_CACHE_NUM_MAX_KEY, 6, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(0));
        }

        public static void setSegmentCacheNumMax(RaftProperties properties, int maxCachedSegmentNum) {
            ConfUtils.setInt(properties::setInt, SEGMENT_CACHE_NUM_MAX_KEY, maxCachedSegmentNum, new BiConsumer[0]);
        }

        public static SizeInBytes segmentCacheSizeMax(RaftProperties properties) {
            return ConfUtils.getSizeInBytes(properties::getSizeInBytes, SEGMENT_CACHE_SIZE_MAX_KEY, SEGMENT_CACHE_SIZE_MAX_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setSegmentCacheSizeMax(RaftProperties properties, SizeInBytes maxCachedSegmentSize) {
            ConfUtils.setSizeInBytes(properties::set, SEGMENT_CACHE_SIZE_MAX_KEY, maxCachedSegmentSize, new BiConsumer[0]);
        }

        public static SizeInBytes preallocatedSize(RaftProperties properties) {
            return ConfUtils.getSizeInBytes(properties::getSizeInBytes, PREALLOCATED_SIZE_KEY, PREALLOCATED_SIZE_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setPreallocatedSize(RaftProperties properties, SizeInBytes preallocatedSize) {
            ConfUtils.setSizeInBytes(properties::set, PREALLOCATED_SIZE_KEY, preallocatedSize, new BiConsumer[0]);
        }

        public static SizeInBytes writeBufferSize(RaftProperties properties) {
            return ConfUtils.getSizeInBytes(properties::getSizeInBytes, WRITE_BUFFER_SIZE_KEY, WRITE_BUFFER_SIZE_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setWriteBufferSize(RaftProperties properties, SizeInBytes writeBufferSize) {
            ConfUtils.setSizeInBytes(properties::set, WRITE_BUFFER_SIZE_KEY, writeBufferSize, new BiConsumer[0]);
        }

        public static int forceSyncNum(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, FORCE_SYNC_NUM_KEY, 128, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(0));
        }

        public static void setForceSyncNum(RaftProperties properties, int forceSyncNum) {
            ConfUtils.setInt(properties::setInt, FORCE_SYNC_NUM_KEY, forceSyncNum, new BiConsumer[0]);
        }

        public static boolean unsafeFlushEnabled(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, UNSAFE_FLUSH_ENABLED_KEY, false, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setUnsafeFlushEnabled(RaftProperties properties, boolean unsafeFlush) {
            ConfUtils.setBoolean(properties::setBoolean, UNSAFE_FLUSH_ENABLED_KEY, unsafeFlush, new BiConsumer[0]);
        }

        public static boolean asyncFlushEnabled(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, ASYNC_FLUSH_ENABLED_KEY, false, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setAsyncFlushEnabled(RaftProperties properties, boolean asyncFlush) {
            ConfUtils.setBoolean(properties::setBoolean, ASYNC_FLUSH_ENABLED_KEY, asyncFlush, new BiConsumer[0]);
        }

        public static CorruptionPolicy corruptionPolicy(RaftProperties properties) {
            return ConfUtils.get(properties::getEnum, CORRUPTION_POLICY_KEY, CORRUPTION_POLICY_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setCorruptionPolicy(RaftProperties properties, CorruptionPolicy corruptionPolicy) {
            ConfUtils.set(properties::setEnum, CORRUPTION_POLICY_KEY, corruptionPolicy, new BiConsumer[0]);
        }

        public static interface Appender {
            public static final String PREFIX = "raft.server.log.appender";
            public static final String BUFFER_ELEMENT_LIMIT_KEY = "raft.server.log.appender.buffer.element-limit";
            public static final int BUFFER_ELEMENT_LIMIT_DEFAULT = 0;
            public static final String BUFFER_BYTE_LIMIT_KEY = "raft.server.log.appender.buffer.byte-limit";
            public static final SizeInBytes BUFFER_BYTE_LIMIT_DEFAULT = SizeInBytes.valueOf("4MB");
            public static final String SNAPSHOT_CHUNK_SIZE_MAX_KEY = "raft.server.log.appender.snapshot.chunk.size.max";
            public static final SizeInBytes SNAPSHOT_CHUNK_SIZE_MAX_DEFAULT = SizeInBytes.valueOf("16MB");
            public static final String INSTALL_SNAPSHOT_ENABLED_KEY = "raft.server.log.appender.install.snapshot.enabled";
            public static final boolean INSTALL_SNAPSHOT_ENABLED_DEFAULT = true;
            public static final String WAIT_TIME_MIN_KEY = "raft.server.log.appender.wait-time.min";
            public static final TimeDuration WAIT_TIME_MIN_DEFAULT = TimeDuration.ONE_MILLISECOND;
            public static final String RETRY_POLICY_KEY = "raft.server.log.appender.retry.policy";
            public static final String RETRY_POLICY_DEFAULT = "1ms,10, 1s,20, 5s,1000";

            public static int bufferElementLimit(RaftProperties properties) {
                return ConfUtils.getInt(properties::getInt, BUFFER_ELEMENT_LIMIT_KEY, 0, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(0));
            }

            public static void setBufferElementLimit(RaftProperties properties, int bufferElementLimit) {
                ConfUtils.setInt(properties::setInt, BUFFER_ELEMENT_LIMIT_KEY, bufferElementLimit, new BiConsumer[0]);
            }

            public static SizeInBytes bufferByteLimit(RaftProperties properties) {
                return ConfUtils.getSizeInBytes(properties::getSizeInBytes, BUFFER_BYTE_LIMIT_KEY, BUFFER_BYTE_LIMIT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setBufferByteLimit(RaftProperties properties, SizeInBytes bufferByteLimit) {
                ConfUtils.setSizeInBytes(properties::set, BUFFER_BYTE_LIMIT_KEY, bufferByteLimit, new BiConsumer[0]);
            }

            public static SizeInBytes snapshotChunkSizeMax(RaftProperties properties) {
                return ConfUtils.getSizeInBytes(properties::getSizeInBytes, SNAPSHOT_CHUNK_SIZE_MAX_KEY, SNAPSHOT_CHUNK_SIZE_MAX_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setSnapshotChunkSizeMax(RaftProperties properties, SizeInBytes maxChunkSize) {
                ConfUtils.setSizeInBytes(properties::set, SNAPSHOT_CHUNK_SIZE_MAX_KEY, maxChunkSize, new BiConsumer[0]);
            }

            public static boolean installSnapshotEnabled(RaftProperties properties) {
                return ConfUtils.getBoolean(properties::getBoolean, INSTALL_SNAPSHOT_ENABLED_KEY, true, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setInstallSnapshotEnabled(RaftProperties properties, boolean shouldInstallSnapshot) {
                ConfUtils.setBoolean(properties::setBoolean, INSTALL_SNAPSHOT_ENABLED_KEY, shouldInstallSnapshot, new BiConsumer[0]);
            }

            public static TimeDuration waitTimeMin(RaftProperties properties) {
                return ConfUtils.getTimeDuration(properties.getTimeDuration(WAIT_TIME_MIN_DEFAULT.getUnit()), WAIT_TIME_MIN_KEY, WAIT_TIME_MIN_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setWaitTimeMin(RaftProperties properties, TimeDuration minDuration) {
                ConfUtils.setTimeDuration(properties::setTimeDuration, WAIT_TIME_MIN_KEY, minDuration, new BiConsumer[0]);
            }

            public static String retryPolicy(RaftProperties properties) {
                return properties.get(RETRY_POLICY_KEY, RETRY_POLICY_DEFAULT);
            }

            public static void setRetryPolicy(RaftProperties properties, String retryPolicy) {
                properties.set(RETRY_POLICY_KEY, retryPolicy);
            }
        }

        public static interface StateMachineData {
            public static final String PREFIX = "raft.server.log.statemachine.data";
            public static final String SYNC_KEY = "raft.server.log.statemachine.data.sync";
            public static final boolean SYNC_DEFAULT = true;
            public static final String CACHING_ENABLED_KEY = "raft.server.log.statemachine.data.caching.enabled";
            public static final boolean CACHING_ENABLED_DEFAULT = false;
            public static final String SYNC_TIMEOUT_KEY = "raft.server.log.statemachine.data.sync.timeout";
            public static final TimeDuration SYNC_TIMEOUT_DEFAULT = TimeDuration.valueOf(10L, TimeUnit.SECONDS);
            public static final String SYNC_TIMEOUT_RETRY_KEY = "raft.server.log.statemachine.data.sync.timeout.retry";
            public static final int SYNC_TIMEOUT_RETRY_DEFAULT = -1;
            public static final String READ_TIMEOUT_KEY = "raft.server.log.statemachine.data.read.timeout";
            public static final TimeDuration READ_TIMEOUT_DEFAULT = TimeDuration.valueOf(1000L, TimeUnit.MILLISECONDS);

            public static boolean sync(RaftProperties properties) {
                return ConfUtils.getBoolean(properties::getBoolean, SYNC_KEY, true, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setSync(RaftProperties properties, boolean sync) {
                ConfUtils.setBoolean(properties::setBoolean, SYNC_KEY, sync, new BiConsumer[0]);
            }

            public static boolean cachingEnabled(RaftProperties properties) {
                return ConfUtils.getBoolean(properties::getBoolean, CACHING_ENABLED_KEY, false, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setCachingEnabled(RaftProperties properties, boolean enable) {
                ConfUtils.setBoolean(properties::setBoolean, CACHING_ENABLED_KEY, enable, new BiConsumer[0]);
            }

            public static TimeDuration syncTimeout(RaftProperties properties) {
                return ConfUtils.getTimeDuration(properties.getTimeDuration(SYNC_TIMEOUT_DEFAULT.getUnit()), SYNC_TIMEOUT_KEY, SYNC_TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setSyncTimeout(RaftProperties properties, TimeDuration syncTimeout) {
                ConfUtils.setTimeDuration(properties::setTimeDuration, SYNC_TIMEOUT_KEY, syncTimeout, new BiConsumer[0]);
            }

            public static int syncTimeoutRetry(RaftProperties properties) {
                return ConfUtils.getInt(properties::getInt, SYNC_TIMEOUT_RETRY_KEY, -1, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(-1));
            }

            public static void setSyncTimeoutRetry(RaftProperties properties, int syncTimeoutRetry) {
                ConfUtils.setInt(properties::setInt, SYNC_TIMEOUT_RETRY_KEY, syncTimeoutRetry, ConfUtils.requireMin(-1));
            }

            public static TimeDuration readTimeout(RaftProperties properties) {
                return ConfUtils.getTimeDuration(properties.getTimeDuration(READ_TIMEOUT_DEFAULT.getUnit()), READ_TIMEOUT_KEY, READ_TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setReadTimeout(RaftProperties properties, TimeDuration readTimeout) {
                ConfUtils.setTimeDuration(properties::setTimeDuration, READ_TIMEOUT_KEY, readTimeout, new BiConsumer[0]);
            }
        }

        public static enum CorruptionPolicy {
            EXCEPTION,
            WARN_AND_RETURN;


            public static CorruptionPolicy getDefault() {
                return EXCEPTION;
            }

            public static <T> CorruptionPolicy get(T supplier, Function<T, CorruptionPolicy> getMethod) {
                return Optional.ofNullable(supplier).map(getMethod).orElse(CorruptionPolicy.getDefault());
            }
        }
    }

    public static interface Watch {
        public static final String PREFIX = "raft.server.watch";
        public static final String ELEMENT_LIMIT_KEY = "raft.server.watch.element-limit";
        public static final int ELEMENT_LIMIT_DEFAULT = 65536;
        public static final String TIMEOUT_DENOMINATION_KEY = "raft.server.watch.timeout.denomination";
        public static final TimeDuration TIMEOUT_DENOMINATION_DEFAULT = TimeDuration.valueOf(1L, TimeUnit.SECONDS);
        public static final String TIMEOUT_KEY = "raft.server.watch.timeout";
        public static final TimeDuration TIMEOUT_DEFAULT = TimeDuration.valueOf(10L, TimeUnit.SECONDS);

        public static int elementLimit(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, ELEMENT_LIMIT_KEY, 65536, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(1));
        }

        public static void setElementLimit(RaftProperties properties, int limit) {
            ConfUtils.setInt(properties::setInt, ELEMENT_LIMIT_KEY, limit, ConfUtils.requireMin(1));
        }

        public static TimeDuration timeoutDenomination(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(TIMEOUT_DENOMINATION_DEFAULT.getUnit()), TIMEOUT_DENOMINATION_KEY, TIMEOUT_DENOMINATION_DEFAULT, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requirePositive());
        }

        public static void setTimeoutDenomination(RaftProperties properties, TimeDuration watchTimeout) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, TIMEOUT_DENOMINATION_KEY, watchTimeout, new BiConsumer[0]);
        }

        public static TimeDuration timeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(TIMEOUT_DEFAULT.getUnit()), TIMEOUT_KEY, TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requirePositive());
        }

        public static void setTimeout(RaftProperties properties, TimeDuration watchTimeout) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, TIMEOUT_KEY, watchTimeout, new BiConsumer[0]);
        }
    }

    public static interface Write {
        public static final String PREFIX = "raft.server.write";
        public static final String ELEMENT_LIMIT_KEY = "raft.server.write.element-limit";
        public static final int ELEMENT_LIMIT_DEFAULT = 4096;
        public static final String BYTE_LIMIT_KEY = "raft.server.write.byte-limit";
        public static final SizeInBytes BYTE_LIMIT_DEFAULT = SizeInBytes.valueOf("64MB");
        public static final String FOLLOWER_GAP_RATIO_MAX_KEY = "raft.server.write.follower.gap.ratio.max";
        public static final double FOLLOWER_GAP_RATIO_MAX_DEFAULT = -1.0;

        public static int elementLimit(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, ELEMENT_LIMIT_KEY, 4096, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(1));
        }

        public static void setElementLimit(RaftProperties properties, int limit) {
            ConfUtils.setInt(properties::setInt, ELEMENT_LIMIT_KEY, limit, ConfUtils.requireMin(1));
        }

        public static SizeInBytes byteLimit(RaftProperties properties) {
            return ConfUtils.getSizeInBytes(properties::getSizeInBytes, BYTE_LIMIT_KEY, BYTE_LIMIT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMinSizeInByte(SizeInBytes.ONE_MB));
        }

        public static void setByteLimit(RaftProperties properties, SizeInBytes byteLimit) {
            ConfUtils.setSizeInBytes(properties::set, BYTE_LIMIT_KEY, byteLimit, ConfUtils.requireMin(1L));
        }

        public static double followerGapRatioMax(RaftProperties properties) {
            return ConfUtils.getDouble(properties::getDouble, FOLLOWER_GAP_RATIO_MAX_KEY, -1.0, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMax(1.0));
        }

        public static void setFollowerGapRatioMax(RaftProperties properties, float ratio) {
            ConfUtils.setDouble(properties::setDouble, FOLLOWER_GAP_RATIO_MAX_KEY, ratio, ConfUtils.requireMax(1.0));
        }
    }

    public static interface Read {
        public static final String PREFIX = "raft.server." + JavaUtils.getClassSimpleName(Read.class).toLowerCase();
        public static final String TIMEOUT_KEY = PREFIX + ".timeout";
        public static final TimeDuration TIMEOUT_DEFAULT = TimeDuration.valueOf(10L, TimeUnit.SECONDS);
        public static final String OPTION_KEY = PREFIX + ".option";
        public static final Option OPTION_DEFAULT = Option.DEFAULT;
        public static final String LEADER_LEASE_ENABLED_KEY = PREFIX + ".leader.lease.enabled";
        public static final boolean LEADER_LEASE_ENABLED_DEFAULT = false;
        public static final String LEADER_LEASE_TIMEOUT_RATIO_KEY = PREFIX + ".leader.lease.timeout.ratio";
        public static final double LEADER_LEASE_TIMEOUT_RATIO_DEFAULT = 0.9;

        public static TimeDuration timeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(TIMEOUT_DEFAULT.getUnit()), TIMEOUT_KEY, TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requirePositive());
        }

        public static void setTimeout(RaftProperties properties, TimeDuration readOnlyTimeout) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, TIMEOUT_KEY, readOnlyTimeout, new BiConsumer[0]);
        }

        public static Option option(RaftProperties properties) {
            Option option = ConfUtils.get(properties::getEnum, OPTION_KEY, OPTION_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
            if (option != Option.DEFAULT && option != Option.LINEARIZABLE) {
                throw new IllegalArgumentException("Unexpected read option: " + (Object)((Object)option));
            }
            return option;
        }

        public static void setOption(RaftProperties properties, Option option) {
            ConfUtils.set(properties::setEnum, OPTION_KEY, option, new BiConsumer[0]);
        }

        public static boolean leaderLeaseEnabled(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, LEADER_LEASE_ENABLED_KEY, false, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setLeaderLeaseEnabled(RaftProperties properties, boolean enabled) {
            ConfUtils.setBoolean(properties::setBoolean, LEADER_LEASE_ENABLED_KEY, enabled, new BiConsumer[0]);
        }

        public static double leaderLeaseTimeoutRatio(RaftProperties properties) {
            return ConfUtils.getDouble(properties::getDouble, LEADER_LEASE_TIMEOUT_RATIO_KEY, 0.9, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(0.0), ConfUtils.requireMax(1.0));
        }

        public static void setLeaderLeaseTimeoutRatio(RaftProperties properties, double ratio) {
            ConfUtils.setDouble(properties::setDouble, LEADER_LEASE_TIMEOUT_RATIO_KEY, ratio, new BiConsumer[0]);
        }

        public static interface ReadAfterWriteConsistent {
            public static final String PREFIX = PREFIX + ".read-after-write-consistent";
            public static final String WRITE_INDEX_CACHE_EXPIRY_TIME_KEY = PREFIX + ".write-index-cache.expiry-time";
            public static final TimeDuration WRITE_INDEX_CACHE_EXPIRY_TIME_DEFAULT = TimeDuration.valueOf(60L, TimeUnit.SECONDS);

            public static TimeDuration writeIndexCacheExpiryTime(RaftProperties properties) {
                return ConfUtils.getTimeDuration(properties.getTimeDuration(WRITE_INDEX_CACHE_EXPIRY_TIME_DEFAULT.getUnit()), WRITE_INDEX_CACHE_EXPIRY_TIME_KEY, WRITE_INDEX_CACHE_EXPIRY_TIME_DEFAULT, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setWriteIndexCacheExpiryTime(RaftProperties properties, TimeDuration expiryTime) {
                ConfUtils.setTimeDuration(properties::setTimeDuration, WRITE_INDEX_CACHE_EXPIRY_TIME_KEY, expiryTime, new BiConsumer[0]);
            }
        }

        public static enum Option {
            DEFAULT,
            LINEARIZABLE;

        }
    }

    public static interface ThreadPool {
        public static final String PREFIX = "raft.server.threadpool";
        public static final String PROXY_CACHED_KEY = "raft.server.threadpool.proxy.cached";
        public static final boolean PROXY_CACHED_DEFAULT = true;
        public static final String PROXY_SIZE_KEY = "raft.server.threadpool.proxy.size";
        public static final int PROXY_SIZE_DEFAULT = 0;
        public static final String SERVER_CACHED_KEY = "raft.server.threadpool.server.cached";
        public static final boolean SERVER_CACHED_DEFAULT = true;
        public static final String SERVER_SIZE_KEY = "raft.server.threadpool.server.size";
        public static final int SERVER_SIZE_DEFAULT = 0;
        public static final String CLIENT_CACHED_KEY = "raft.server.threadpool.client.cached";
        public static final boolean CLIENT_CACHED_DEFAULT = true;
        public static final String CLIENT_SIZE_KEY = "raft.server.threadpool.client.size";
        public static final int CLIENT_SIZE_DEFAULT = 0;

        public static boolean proxyCached(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, PROXY_CACHED_KEY, true, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setProxyCached(RaftProperties properties, boolean useCached) {
            ConfUtils.setBoolean(properties::setBoolean, PROXY_CACHED_KEY, useCached, new BiConsumer[0]);
        }

        public static int proxySize(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, PROXY_SIZE_KEY, 0, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(0), ConfUtils.requireMax(65536));
        }

        public static void setProxySize(RaftProperties properties, int size) {
            ConfUtils.setInt(properties::setInt, PROXY_SIZE_KEY, size, new BiConsumer[0]);
        }

        public static boolean serverCached(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, SERVER_CACHED_KEY, true, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setServerCached(RaftProperties properties, boolean useCached) {
            ConfUtils.setBoolean(properties::setBoolean, SERVER_CACHED_KEY, useCached, new BiConsumer[0]);
        }

        public static int serverSize(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, SERVER_SIZE_KEY, 0, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(0), ConfUtils.requireMax(65536));
        }

        public static void setServerSize(RaftProperties properties, int size) {
            ConfUtils.setInt(properties::setInt, SERVER_SIZE_KEY, size, new BiConsumer[0]);
        }

        public static boolean clientCached(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, CLIENT_CACHED_KEY, true, RaftServerConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setClientCached(RaftProperties properties, boolean useCached) {
            ConfUtils.setBoolean(properties::setBoolean, CLIENT_CACHED_KEY, useCached, new BiConsumer[0]);
        }

        public static int clientSize(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, CLIENT_SIZE_KEY, 0, RaftServerConfigKeys.getDefaultLog(), ConfUtils.requireMin(0), ConfUtils.requireMax(65536));
        }

        public static void setClientSize(RaftProperties properties, int size) {
            ConfUtils.setInt(properties::setInt, CLIENT_SIZE_KEY, size, new BiConsumer[0]);
        }
    }
}

