/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.server;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.datastream.impl.DataStreamPacketImpl;
import org.apache.ratis.io.WriteOption;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.DataStreamRequest;
import org.apache.ratis.protocol.DataStreamRequestHeader;
import org.apache.ratis.thirdparty.com.google.common.collect.Lists;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;

public class DataStreamRequestByteBuf
extends DataStreamPacketImpl
implements DataStreamRequest {
    private final AtomicReference<ByteBuf> buf;
    private final List<WriteOption> options;

    public DataStreamRequestByteBuf(ClientId clientId, RaftProtos.DataStreamPacketHeaderProto.Type type, long streamId, long streamOffset, Iterable<WriteOption> options, ByteBuf buf) {
        super(clientId, type, streamId, streamOffset);
        this.buf = new AtomicReference<ByteBuf>(buf != null ? buf.asReadOnly() : Unpooled.EMPTY_BUFFER);
        this.options = Collections.unmodifiableList(Lists.newArrayList(options));
    }

    public DataStreamRequestByteBuf(DataStreamRequestHeader header, ByteBuf buf) {
        this(header.getClientId(), header.getType(), header.getStreamId(), header.getStreamOffset(), header.getWriteOptionList(), buf);
    }

    ByteBuf getBuf() {
        return Optional.ofNullable(this.buf.get()).orElseThrow(() -> new IllegalStateException("buf is already released in " + this));
    }

    @Override
    public long getDataLength() {
        return this.getBuf().readableBytes();
    }

    public ByteBuf slice() {
        return this.getBuf().slice();
    }

    public void release() {
        ByteBuf got = this.buf.getAndSet(null);
        if (got != null) {
            got.release();
        }
    }

    @Override
    public List<WriteOption> getWriteOptionList() {
        return this.options;
    }
}

