/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.cdn.CdnEndpoint;
import com.microsoft.azure.management.cdn.CdnProfile;
import com.microsoft.azure.management.cdn.CheckNameAvailabilityResult;
import com.microsoft.azure.management.cdn.DeepCreatedOrigin;
import com.microsoft.azure.management.cdn.implementation.CdnEndpointImpl;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.CdnManager;
import com.microsoft.azure.management.cdn.implementation.CdnProfileImpl;
import com.microsoft.azure.management.cdn.implementation.CustomDomainInner;
import com.microsoft.azure.management.cdn.implementation.EndpointInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesCachedImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@LangDefinition
class CdnEndpointsImpl
extends ExternalChildResourcesCachedImpl<CdnEndpointImpl, CdnEndpoint, EndpointInner, CdnProfileImpl, CdnProfile> {
    CdnEndpointsImpl(CdnProfileImpl parent) {
        super((Object)parent, parent.taskGroup(), "Endpoint");
        if (parent.id() != null) {
            this.cacheCollection();
        }
    }

    Map<String, CdnEndpoint> endpointsAsMap() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.collection().entrySet()) {
            CdnEndpointImpl endpoint = (CdnEndpointImpl)entry.getValue();
            result.put(entry.getKey(), endpoint);
        }
        return Collections.unmodifiableMap(result);
    }

    public void remove(String name) {
        this.prepareInlineRemove(name);
    }

    public void addEndpoint(CdnEndpointImpl endpoint) {
        this.addChildResource(endpoint);
    }

    protected List<CdnEndpointImpl> listChildResources() {
        ArrayList<CdnEndpointImpl> childResources = new ArrayList<CdnEndpointImpl>();
        for (EndpointInner innerEndpoint : ((CdnManagementClientImpl)((Object)((CdnManager)((CdnProfileImpl)this.parent()).manager()).inner())).endpoints().listByProfile(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name())) {
            CdnEndpointImpl endpointResource = new CdnEndpointImpl(innerEndpoint.name(), (CdnProfileImpl)this.parent(), innerEndpoint);
            for (CustomDomainInner customDomain : ((CdnManagementClientImpl)((Object)((CdnManager)((CdnProfileImpl)this.parent()).manager()).inner())).customDomains().listByEndpoint(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), innerEndpoint.name())) {
                endpointResource.withCustomDomain(customDomain.hostName());
            }
            childResources.add(endpointResource);
        }
        return Collections.unmodifiableList(childResources);
    }

    protected CdnEndpointImpl newChildResource(String name) {
        CdnEndpointImpl endpoint = new CdnEndpointImpl(name, (CdnProfileImpl)this.parent(), new EndpointInner());
        return endpoint;
    }

    public CdnEndpointImpl defineNewEndpoint(String endpointName, String originName, String endpointOriginHostname) {
        CdnEndpointImpl endpoint = this.defineNewEndpoint(endpointName);
        ((EndpointInner)((Object)endpoint.inner())).origins().add(new DeepCreatedOrigin().withName(originName).withHostName(endpointOriginHostname));
        return endpoint;
    }

    public CdnEndpointImpl defineNewEndpoint(String endpointName, String endpointOriginHostname) {
        return this.defineNewEndpoint(endpointName, "origin", endpointOriginHostname);
    }

    public CdnEndpointImpl defineNewEndpoint(String name) {
        CdnEndpointImpl endpoint = (CdnEndpointImpl)this.prepareInlineDefine(name);
        ((EndpointInner)((Object)endpoint.inner())).withLocation(((CdnProfileImpl)endpoint.parent()).region().toString());
        ((EndpointInner)((Object)endpoint.inner())).withOrigins(new ArrayList<DeepCreatedOrigin>());
        return endpoint;
    }

    public CdnEndpointImpl defineNewEndpoint() {
        String endpointName = this.generateUniqueEndpointName("Endpoint");
        return this.defineNewEndpoint(endpointName);
    }

    public CdnEndpointImpl defineNewEndpointWithOriginHostname(String endpointOriginHostname) {
        String endpointName = this.generateUniqueEndpointName("Endpoint");
        CdnEndpointImpl endpoint = this.defineNewEndpoint(endpointName, "origin", endpointOriginHostname);
        return endpoint;
    }

    public CdnEndpointImpl updateEndpoint(String name) {
        CdnEndpointImpl endpoint = (CdnEndpointImpl)this.prepareInlineUpdate(name);
        return endpoint;
    }

    private String generateUniqueEndpointName(String endpointNamePrefix) {
        String endpointName;
        CheckNameAvailabilityResult result;
        do {
            endpointName = SdkContext.randomResourceName((String)endpointNamePrefix, (int)50);
        } while (!(result = ((CdnProfileImpl)this.parent()).checkEndpointNameAvailability(endpointName)).nameAvailable());
        return endpointName;
    }
}

