/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryGroup;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryObject;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryUser;
import com.microsoft.azure.management.graphrbac.ServicePrincipal;
import com.microsoft.azure.management.graphrbac.implementation.AADObjectInner;
import com.microsoft.azure.management.graphrbac.implementation.ADGroupInner;
import com.microsoft.azure.management.graphrbac.implementation.ActiveDirectoryApplicationImpl;
import com.microsoft.azure.management.graphrbac.implementation.ActiveDirectoryUserImpl;
import com.microsoft.azure.management.graphrbac.implementation.ApplicationInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.GroupAddMemberParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.GroupCreateParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalImpl;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalInner;
import com.microsoft.azure.management.graphrbac.implementation.UserInner;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class ActiveDirectoryGroupImpl
extends CreatableUpdatableImpl<ActiveDirectoryGroup, ADGroupInner, ActiveDirectoryGroupImpl>
implements ActiveDirectoryGroup,
ActiveDirectoryGroup.Definition,
ActiveDirectoryGroup.Update {
    private final GraphRbacManager manager;
    private GroupCreateParametersInner createParameters;
    private String domainName;
    private Set<String> membersToAdd;
    private Set<String> membersToRemove;

    ActiveDirectoryGroupImpl(ADGroupInner innerModel, GraphRbacManager manager) {
        super(innerModel.displayName(), (Object)innerModel);
        this.manager = manager;
        this.createParameters = new GroupCreateParametersInner().withDisplayName(innerModel.displayName()).withMailEnabled(false).withSecurityEnabled(true);
        this.membersToAdd = new HashSet<String>();
        this.membersToRemove = new HashSet<String>();
    }

    public String id() {
        return ((ADGroupInner)this.inner()).objectId();
    }

    public String name() {
        return ((ADGroupInner)this.inner()).displayName();
    }

    @Override
    public boolean securityEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((ADGroupInner)this.inner()).securityEnabled());
    }

    @Override
    public String mail() {
        return ((ADGroupInner)this.inner()).mail();
    }

    @Override
    public Set<ActiveDirectoryObject> listMembers() {
        return Collections.unmodifiableSet(new HashSet((Collection)this.listMembersAsync().toList().toBlocking().single()));
    }

    @Override
    public Observable<ActiveDirectoryObject> listMembersAsync() {
        return this.manager().inner().groups().getGroupMembersAsync(this.id()).flatMap((Func1)new Func1<Page<AADObjectInner>, Observable<AADObjectInner>>(){

            public Observable<AADObjectInner> call(Page<AADObjectInner> aadObjectInnerPage) {
                return Observable.from((Iterable)aadObjectInnerPage.items());
            }
        }).map((Func1)new Func1<AADObjectInner, ActiveDirectoryObject>(){

            public ActiveDirectoryObject call(AADObjectInner aadObjectInner) {
                SerializerAdapter adapter = ActiveDirectoryGroupImpl.this.manager().inner().restClient().serializerAdapter();
                try {
                    String serialized = adapter.serialize((Object)aadObjectInner);
                    switch (aadObjectInner.objectType()) {
                        case "User": {
                            return new ActiveDirectoryUserImpl((UserInner)adapter.deserialize(serialized, UserInner.class), ActiveDirectoryGroupImpl.this.manager());
                        }
                        case "Group": {
                            return new ActiveDirectoryGroupImpl((ADGroupInner)adapter.deserialize(serialized, ADGroupInner.class), ActiveDirectoryGroupImpl.this.manager());
                        }
                        case "ServicePrincipal": {
                            return new ServicePrincipalImpl((ServicePrincipalInner)adapter.deserialize(serialized, ServicePrincipalInner.class), ActiveDirectoryGroupImpl.this.manager());
                        }
                        case "Application": {
                            return new ActiveDirectoryApplicationImpl((ApplicationInner)adapter.deserialize(serialized, ApplicationInner.class), ActiveDirectoryGroupImpl.this.manager());
                        }
                    }
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public GraphRbacManager manager() {
        return this.manager;
    }

    protected Observable<ADGroupInner> getInnerAsync() {
        return this.manager().inner().groups().getAsync(this.id());
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    public Observable<ActiveDirectoryGroup> createResourceAsync() {
        Observable group = Observable.just((Object)this);
        if (this.isInCreateMode()) {
            group = this.manager().inner().groups().createAsync(this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
        }
        if (!this.membersToRemove.isEmpty()) {
            group = group.flatMap(new Func1<Object, Observable<?>>(){

                public Observable<?> call(Object o) {
                    return Observable.from((Iterable)ActiveDirectoryGroupImpl.this.membersToRemove).flatMap(new Func1<String, Observable<?>>(){

                        public Observable<?> call(String s) {
                            return ActiveDirectoryGroupImpl.this.manager().inner().groups().removeMemberAsync(ActiveDirectoryGroupImpl.this.id(), s);
                        }
                    }).last().doOnCompleted(new Action0(){

                        public void call() {
                            ActiveDirectoryGroupImpl.this.membersToRemove.clear();
                        }
                    });
                }
            });
        }
        if (!this.membersToAdd.isEmpty()) {
            group = group.flatMap(new Func1<Object, Observable<?>>(){

                public Observable<?> call(Object o) {
                    return Observable.from((Iterable)ActiveDirectoryGroupImpl.this.membersToAdd).flatMap(new Func1<String, Observable<?>>(){

                        public Observable<?> call(String s) {
                            return ActiveDirectoryGroupImpl.this.manager().inner().groups().addMemberAsync(ActiveDirectoryGroupImpl.this.id(), new GroupAddMemberParametersInner().withUrl(s));
                        }
                    }).last().doOnCompleted(new Action0(){

                        public void call() {
                            ActiveDirectoryGroupImpl.this.membersToAdd.clear();
                        }
                    });
                }
            });
        }
        return group.map((Func1)new Func1<Object, ActiveDirectoryGroup>(){

            public ActiveDirectoryGroup call(Object o) {
                return ActiveDirectoryGroupImpl.this;
            }
        });
    }

    @Override
    public ActiveDirectoryGroupImpl withEmailAlias(String mailNickname) {
        if (mailNickname.contains("@")) {
            String[] parts = mailNickname.split("@");
            this.domainName = parts[1];
            mailNickname = parts[0];
        }
        this.createParameters.withMailNickname(mailNickname);
        return this;
    }

    @Override
    public ActiveDirectoryGroupImpl withMember(String objectId) {
        this.membersToAdd.add(String.format("https://%s/%s/directoryObjects/%s", this.manager().inner().retrofit().baseUrl().host(), this.manager().tenantId(), objectId));
        return this;
    }

    @Override
    public ActiveDirectoryGroupImpl withMember(ActiveDirectoryUser user) {
        return this.withMember(user.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withMember(ActiveDirectoryGroup group) {
        return this.withMember(group.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withMember(ServicePrincipal servicePrincipal) {
        return this.withMember(servicePrincipal.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withoutMember(String objectId) {
        this.membersToRemove.add(objectId);
        return this;
    }

    @Override
    public ActiveDirectoryGroupImpl withoutMember(ActiveDirectoryUser user) {
        return this.withoutMember(user.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withoutMember(ActiveDirectoryGroup group) {
        return this.withoutMember(group.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withoutMember(ServicePrincipal servicePrincipal) {
        return this.withoutMember(servicePrincipal.id());
    }
}

