/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cosmosdb.CassandraKeyspaceCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.CassandraTableCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.ContainerCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountPatchParameters;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountRegenerateKeyParameters;
import com.microsoft.azure.management.cosmosdb.ErrorResponseException;
import com.microsoft.azure.management.cosmosdb.FailoverPolicies;
import com.microsoft.azure.management.cosmosdb.GremlinDatabaseCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.KeyKind;
import com.microsoft.azure.management.cosmosdb.MongoCollectionCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.MongoDatabaseCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.RegionForOnlineOffline;
import com.microsoft.azure.management.cosmosdb.SqlDatabaseCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.TableCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.implementation.CassandraKeyspaceInner;
import com.microsoft.azure.management.cosmosdb.implementation.CassandraTableInner;
import com.microsoft.azure.management.cosmosdb.implementation.ContainerInner;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountCreateUpdateParametersInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListConnectionStringsResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListKeysResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListReadOnlyKeysResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.FailoverPolicyInner;
import com.microsoft.azure.management.cosmosdb.implementation.GremlinDatabaseInner;
import com.microsoft.azure.management.cosmosdb.implementation.MetricDefinitionInner;
import com.microsoft.azure.management.cosmosdb.implementation.MetricInner;
import com.microsoft.azure.management.cosmosdb.implementation.MongoCollectionInner;
import com.microsoft.azure.management.cosmosdb.implementation.MongoDatabaseInner;
import com.microsoft.azure.management.cosmosdb.implementation.PageImpl;
import com.microsoft.azure.management.cosmosdb.implementation.SqlDatabaseInner;
import com.microsoft.azure.management.cosmosdb.implementation.TableInner;
import com.microsoft.azure.management.cosmosdb.implementation.UsageInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class DatabaseAccountsInner
implements InnerSupportsGet<DatabaseAccountInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<DatabaseAccountInner> {
    private DatabaseAccountsService service;
    private CosmosDBImpl client;

    public DatabaseAccountsInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = (DatabaseAccountsService)retrofit.create(DatabaseAccountsService.class);
        this.client = client;
    }

    public DatabaseAccountInner getByResourceGroup(String resourceGroupName, String accountName) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountInner patch(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.patchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<DatabaseAccountInner> patchAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.patchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountInner> patchAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        return this.patchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> patchWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (updateParameters == null) {
            throw new IllegalArgumentException("Parameter updateParameters is required and cannot be null.");
        }
        Validator.validate((Object)updateParameters);
        Observable<Response<ResponseBody>> observable = this.service.patch(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), updateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DatabaseAccountInner>(){}.getType());
    }

    public DatabaseAccountInner beginPatch(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.beginPatchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAccountInner> beginPatchAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginPatchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountInner> beginPatchAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        return this.beginPatchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> beginPatchWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (updateParameters == null) {
            throw new IllegalArgumentException("Parameter updateParameters is required and cannot be null.");
        }
        Validator.validate((Object)updateParameters);
        return this.service.beginPatch(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), updateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginPatchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountInner> beginPatchDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountInner createOrUpdate(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<DatabaseAccountInner> createOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountInner> createOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateParameters));
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), createUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DatabaseAccountInner>(){}.getType());
    }

    public DatabaseAccountInner beginCreateOrUpdate(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAccountInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParametersInner createUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateParameters));
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), createUpdateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String accountName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void failoverPriorityChange(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies) {
        ((ServiceResponse)this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).toBlocking().last()).body();
    }

    public ServiceFuture<Void> failoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies), serviceCallback);
    }

    public Observable<Void> failoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies) {
        return this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> failoverPriorityChangeWithServiceResponseAsync(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (failoverPolicies == null) {
            throw new IllegalArgumentException("Parameter failoverPolicies is required and cannot be null.");
        }
        Validator.validate(failoverPolicies);
        FailoverPolicies failoverParameters = new FailoverPolicies();
        failoverParameters.withFailoverPolicies(failoverPolicies);
        Observable<Response<ResponseBody>> observable = this.service.failoverPriorityChange(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), failoverParameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginFailoverPriorityChange(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies) {
        ((ServiceResponse)this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginFailoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies), serviceCallback);
    }

    public Observable<Void> beginFailoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies) {
        return this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginFailoverPriorityChangeWithServiceResponseAsync(String resourceGroupName, String accountName, List<FailoverPolicyInner> failoverPolicies) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (failoverPolicies == null) {
            throw new IllegalArgumentException("Parameter failoverPolicies is required and cannot be null.");
        }
        Validator.validate(failoverPolicies);
        FailoverPolicies failoverParameters = new FailoverPolicies();
        failoverParameters.withFailoverPolicies(failoverPolicies);
        return this.service.beginFailoverPriorityChange(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), failoverParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginFailoverPriorityChangeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginFailoverPriorityChangeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DatabaseAccountInner> list() {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<DatabaseAccountInner>(page){

            public Page<DatabaseAccountInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<DatabaseAccountInner>> listAsync(ServiceCallback<List<DatabaseAccountInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<DatabaseAccountInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<DatabaseAccountInner>>, Page<DatabaseAccountInner>>(){

            public Page<DatabaseAccountInner> call(ServiceResponse<List<DatabaseAccountInner>> response) {
                PageImpl<DatabaseAccountInner> page = new PageImpl<DatabaseAccountInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<DatabaseAccountInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseAccountInner>>>>(){

            public Observable<ServiceResponse<List<DatabaseAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DatabaseAccountInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DatabaseAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DatabaseAccountInner> listByResourceGroup(String resourceGroupName) {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<DatabaseAccountInner>(page){

            public Page<DatabaseAccountInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<DatabaseAccountInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<DatabaseAccountInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Page<DatabaseAccountInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<DatabaseAccountInner>>, Page<DatabaseAccountInner>>(){

            public Page<DatabaseAccountInner> call(ServiceResponse<List<DatabaseAccountInner>> response) {
                PageImpl<DatabaseAccountInner> page = new PageImpl<DatabaseAccountInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<DatabaseAccountInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseAccountInner>>>>(){

            public Observable<ServiceResponse<List<DatabaseAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DatabaseAccountInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DatabaseAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountListKeysResultInner listKeys(String resourceGroupName, String accountName) {
        return (DatabaseAccountListKeysResultInner)((ServiceResponse)this.listKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName) {
        return this.listKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListKeysResultInner>, DatabaseAccountListKeysResultInner>(){

            public DatabaseAccountListKeysResultInner call(ServiceResponse<DatabaseAccountListKeysResultInner> response) {
                return (DatabaseAccountListKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListKeysResultInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listKeys(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListKeysResultInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountListKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.listKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListKeysResultInner> listKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountListConnectionStringsResultInner listConnectionStrings(String resourceGroupName, String accountName) {
        return (DatabaseAccountListConnectionStringsResultInner)((ServiceResponse)this.listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListConnectionStringsResultInner> listConnectionStringsAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListConnectionStringsResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListConnectionStringsResultInner> listConnectionStringsAsync(String resourceGroupName, String accountName) {
        return this.listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>, DatabaseAccountListConnectionStringsResultInner>(){

            public DatabaseAccountListConnectionStringsResultInner call(ServiceResponse<DatabaseAccountListConnectionStringsResultInner> response) {
                return (DatabaseAccountListConnectionStringsResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>> listConnectionStringsWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listConnectionStrings(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.listConnectionStringsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListConnectionStringsResultInner> listConnectionStringsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListConnectionStringsResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void offlineRegion(String resourceGroupName, String accountName, String region) {
        ((ServiceResponse)this.offlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().last()).body();
    }

    public ServiceFuture<Void> offlineRegionAsync(String resourceGroupName, String accountName, String region, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.offlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    public Observable<Void> offlineRegionAsync(String resourceGroupName, String accountName, String region) {
        return this.offlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> offlineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        RegionForOnlineOffline regionParameterForOffline = new RegionForOnlineOffline();
        regionParameterForOffline.withRegion(region);
        Observable<Response<ResponseBody>> observable = this.service.offlineRegion(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), regionParameterForOffline, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginOfflineRegion(String resourceGroupName, String accountName, String region) {
        ((ServiceResponse)this.beginOfflineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginOfflineRegionAsync(String resourceGroupName, String accountName, String region, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginOfflineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    public Observable<Void> beginOfflineRegionAsync(String resourceGroupName, String accountName, String region) {
        return this.beginOfflineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginOfflineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        RegionForOnlineOffline regionParameterForOffline = new RegionForOnlineOffline();
        regionParameterForOffline.withRegion(region);
        return this.service.beginOfflineRegion(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), regionParameterForOffline, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginOfflineRegionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginOfflineRegionDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void onlineRegion(String resourceGroupName, String accountName, String region) {
        ((ServiceResponse)this.onlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().last()).body();
    }

    public ServiceFuture<Void> onlineRegionAsync(String resourceGroupName, String accountName, String region, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.onlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    public Observable<Void> onlineRegionAsync(String resourceGroupName, String accountName, String region) {
        return this.onlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> onlineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        RegionForOnlineOffline regionParameterForOnline = new RegionForOnlineOffline();
        regionParameterForOnline.withRegion(region);
        Observable<Response<ResponseBody>> observable = this.service.onlineRegion(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), regionParameterForOnline, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginOnlineRegion(String resourceGroupName, String accountName, String region) {
        ((ServiceResponse)this.beginOnlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginOnlineRegionAsync(String resourceGroupName, String accountName, String region, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginOnlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    public Observable<Void> beginOnlineRegionAsync(String resourceGroupName, String accountName, String region) {
        return this.beginOnlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginOnlineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        RegionForOnlineOffline regionParameterForOnline = new RegionForOnlineOffline();
        regionParameterForOnline.withRegion(region);
        return this.service.beginOnlineRegion(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), regionParameterForOnline, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginOnlineRegionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginOnlineRegionDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public DatabaseAccountListReadOnlyKeysResultInner getReadOnlyKeys(String resourceGroupName, String accountName) {
        return (DatabaseAccountListReadOnlyKeysResultInner)((ServiceResponse)this.getReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListReadOnlyKeysResultInner> getReadOnlyKeysAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListReadOnlyKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListReadOnlyKeysResultInner> getReadOnlyKeysAsync(String resourceGroupName, String accountName) {
        return this.getReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>, DatabaseAccountListReadOnlyKeysResultInner>(){

            public DatabaseAccountListReadOnlyKeysResultInner call(ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> response) {
                return (DatabaseAccountListReadOnlyKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> getReadOnlyKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getReadOnlyKeys(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getReadOnlyKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> getReadOnlyKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListReadOnlyKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountListReadOnlyKeysResultInner listReadOnlyKeys(String resourceGroupName, String accountName) {
        return (DatabaseAccountListReadOnlyKeysResultInner)((ServiceResponse)this.listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListReadOnlyKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysAsync(String resourceGroupName, String accountName) {
        return this.listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>, DatabaseAccountListReadOnlyKeysResultInner>(){

            public DatabaseAccountListReadOnlyKeysResultInner call(ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> response) {
                return (DatabaseAccountListReadOnlyKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> listReadOnlyKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listReadOnlyKeys(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.listReadOnlyKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListReadOnlyKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void regenerateKey(String resourceGroupName, String accountName, KeyKind keyKind) {
        ((ServiceResponse)this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).toBlocking().last()).body();
    }

    public ServiceFuture<Void> regenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind), serviceCallback);
    }

    public Observable<Void> regenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        return this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> regenerateKeyWithServiceResponseAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (keyKind == null) {
            throw new IllegalArgumentException("Parameter keyKind is required and cannot be null.");
        }
        DatabaseAccountRegenerateKeyParameters keyToRegenerate = new DatabaseAccountRegenerateKeyParameters();
        keyToRegenerate.withKeyKind(keyKind);
        Observable<Response<ResponseBody>> observable = this.service.regenerateKey(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), keyToRegenerate, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginRegenerateKey(String resourceGroupName, String accountName, KeyKind keyKind) {
        ((ServiceResponse)this.beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginRegenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind), serviceCallback);
    }

    public Observable<Void> beginRegenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        return this.beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginRegenerateKeyWithServiceResponseAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (keyKind == null) {
            throw new IllegalArgumentException("Parameter keyKind is required and cannot be null.");
        }
        DatabaseAccountRegenerateKeyParameters keyToRegenerate = new DatabaseAccountRegenerateKeyParameters();
        keyToRegenerate.withKeyKind(keyKind);
        return this.service.beginRegenerateKey(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), keyToRegenerate, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginRegenerateKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginRegenerateKeyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public boolean checkNameExists(String accountName) {
        return (Boolean)((ServiceResponse)this.checkNameExistsWithServiceResponseAsync(accountName).toBlocking().single()).body();
    }

    public ServiceFuture<Boolean> checkNameExistsAsync(String accountName, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameExistsWithServiceResponseAsync(accountName), serviceCallback);
    }

    public Observable<Boolean> checkNameExistsAsync(String accountName) {
        return this.checkNameExistsWithServiceResponseAsync(accountName).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> checkNameExistsWithServiceResponseAsync(String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.checkNameExists(accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.checkNameExistsDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> checkNameExistsDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildEmpty(response);
    }

    public List<MetricInner> listMetrics(String resourceGroupName, String accountName, String filter) {
        return (List)((ServiceResponse)this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String filter, ServiceCallback<List<MetricInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, filter), serviceCallback);
    }

    public Observable<List<MetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String filter) {
        return this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, filter).map((Func1)new Func1<ServiceResponse<List<MetricInner>>, List<MetricInner>>(){

            public List<MetricInner> call(ServiceResponse<List<MetricInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricInner>>> listMetricsWithServiceResponseAsync(String resourceGroupName, String accountName, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Parameter filter is required and cannot be null.");
        }
        return this.service.listMetrics(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricInner>>>>(){

            public Observable<ServiceResponse<List<MetricInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listMetricsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MetricInner>> listMetricsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MetricInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<UsageInner> listUsages(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, ServiceCallback<List<UsageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName) {
        return this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<UsageInner>>, List<UsageInner>>(){

            public List<UsageInner> call(ServiceResponse<List<UsageInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<UsageInner>>> listUsagesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.listUsages(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageInner>>>>(){

            public Observable<ServiceResponse<List<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listUsagesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<UsageInner> listUsages(String resourceGroupName, String accountName, String filter) {
        return (List)((ServiceResponse)this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, String filter, ServiceCallback<List<UsageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, filter), serviceCallback);
    }

    public Observable<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, String filter) {
        return this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, filter).map((Func1)new Func1<ServiceResponse<List<UsageInner>>, List<UsageInner>>(){

            public List<UsageInner> call(ServiceResponse<List<UsageInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<UsageInner>>> listUsagesWithServiceResponseAsync(String resourceGroupName, String accountName, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listUsages(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageInner>>>>(){

            public Observable<ServiceResponse<List<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listUsagesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<UsageInner>> listUsagesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<UsageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<MetricDefinitionInner> listMetricDefinitions(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricDefinitionInner>> listMetricDefinitionsAsync(String resourceGroupName, String accountName, ServiceCallback<List<MetricDefinitionInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<MetricDefinitionInner>> listMetricDefinitionsAsync(String resourceGroupName, String accountName) {
        return this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<MetricDefinitionInner>>, List<MetricDefinitionInner>>(){

            public List<MetricDefinitionInner> call(ServiceResponse<List<MetricDefinitionInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricDefinitionInner>>> listMetricDefinitionsWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listMetricDefinitions(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricDefinitionInner>>>>(){

            public Observable<ServiceResponse<List<MetricDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listMetricDefinitionsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MetricDefinitionInner>> listMetricDefinitionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MetricDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<SqlDatabaseInner> listSqlDatabases(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<SqlDatabaseInner>> listSqlDatabasesAsync(String resourceGroupName, String accountName, ServiceCallback<List<SqlDatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<SqlDatabaseInner>> listSqlDatabasesAsync(String resourceGroupName, String accountName) {
        return this.listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<SqlDatabaseInner>>, List<SqlDatabaseInner>>(){

            public List<SqlDatabaseInner> call(ServiceResponse<List<SqlDatabaseInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<SqlDatabaseInner>>> listSqlDatabasesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listSqlDatabases(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlDatabaseInner>>>>(){

            public Observable<ServiceResponse<List<SqlDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listSqlDatabasesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SqlDatabaseInner>> listSqlDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SqlDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlDatabaseInner getSqlDatabase(String resourceGroupName, String accountName, String databaseRid) {
        return (SqlDatabaseInner)((Object)((ServiceResponse)this.getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).toBlocking().single()).body());
    }

    public ServiceFuture<SqlDatabaseInner> getSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, ServiceCallback<SqlDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid), serviceCallback);
    }

    public Observable<SqlDatabaseInner> getSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseRid) {
        return this.getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).map((Func1)new Func1<ServiceResponse<SqlDatabaseInner>, SqlDatabaseInner>(){

            public SqlDatabaseInner call(ServiceResponse<SqlDatabaseInner> response) {
                return (SqlDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlDatabaseInner>> getSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlDatabaseInner>>>(){

            public Observable<ServiceResponse<SqlDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getSqlDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlDatabaseInner> getSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlDatabaseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlDatabaseInner createUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseRid, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return (SqlDatabaseInner)((Object)((ServiceResponse)this.createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateSqlDatabaseParameters).toBlocking().last()).body());
    }

    public ServiceFuture<SqlDatabaseInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, ServiceCallback<SqlDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateSqlDatabaseParameters), serviceCallback);
    }

    public Observable<SqlDatabaseInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return this.createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateSqlDatabaseParameters).map((Func1)new Func1<ServiceResponse<SqlDatabaseInner>, SqlDatabaseInner>(){

            public SqlDatabaseInner call(ServiceResponse<SqlDatabaseInner> response) {
                return (SqlDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlDatabaseInner>> createUpdateSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateSqlDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateSqlDatabaseParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), createUpdateSqlDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlDatabaseInner>(){}.getType());
    }

    public SqlDatabaseInner beginCreateUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseRid, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return (SqlDatabaseInner)((Object)((ServiceResponse)this.beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateSqlDatabaseParameters).toBlocking().single()).body());
    }

    public ServiceFuture<SqlDatabaseInner> beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, ServiceCallback<SqlDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateSqlDatabaseParameters), serviceCallback);
    }

    public Observable<SqlDatabaseInner> beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return this.beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateSqlDatabaseParameters).map((Func1)new Func1<ServiceResponse<SqlDatabaseInner>, SqlDatabaseInner>(){

            public SqlDatabaseInner call(ServiceResponse<SqlDatabaseInner> response) {
                return (SqlDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlDatabaseInner>> beginCreateUpdateSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateSqlDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateSqlDatabaseParameters);
        return this.service.beginCreateUpdateSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), createUpdateSqlDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlDatabaseInner>>>(){

            public Observable<ServiceResponse<SqlDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateSqlDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlDatabaseInner> beginCreateUpdateSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlDatabaseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteSqlDatabase(String resourceGroupName, String accountName, String databaseRid) {
        ((ServiceResponse)this.deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid), serviceCallback);
    }

    public Observable<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseRid) {
        return this.deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteSqlDatabase(String resourceGroupName, String accountName, String databaseRid) {
        ((ServiceResponse)this.beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid), serviceCallback);
    }

    public Observable<Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseRid) {
        return this.beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteSqlDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<ContainerInner> listSqlContainers(String resourceGroupName, String accountName, String databaseRid) {
        return (List)((ServiceResponse)this.listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).toBlocking().single()).body();
    }

    public ServiceFuture<List<ContainerInner>> listSqlContainersAsync(String resourceGroupName, String accountName, String databaseRid, ServiceCallback<List<ContainerInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseRid), serviceCallback);
    }

    public Observable<List<ContainerInner>> listSqlContainersAsync(String resourceGroupName, String accountName, String databaseRid) {
        return this.listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).map((Func1)new Func1<ServiceResponse<List<ContainerInner>>, List<ContainerInner>>(){

            public List<ContainerInner> call(ServiceResponse<List<ContainerInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ContainerInner>>> listSqlContainersWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listSqlContainers(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ContainerInner>>>>(){

            public Observable<ServiceResponse<List<ContainerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listSqlContainersDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ContainerInner>> listSqlContainersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ContainerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ContainerInner getSqlContainer(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        return (ContainerInner)((Object)((ServiceResponse)this.getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid).toBlocking().single()).body());
    }

    public ServiceFuture<ContainerInner> getSqlContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ServiceCallback<ContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid), serviceCallback);
    }

    public Observable<ContainerInner> getSqlContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        return this.getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid).map((Func1)new Func1<ServiceResponse<ContainerInner>, ContainerInner>(){

            public ContainerInner call(ServiceResponse<ContainerInner> response) {
                return (ContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerInner>> getSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (containerRid == null) {
            throw new IllegalArgumentException("Parameter containerRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, containerRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContainerInner>>>(){

            public Observable<ServiceResponse<ContainerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getSqlContainerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ContainerInner> getSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ContainerInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ContainerInner createUpdateSqlContainer(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return (ContainerInner)((Object)((ServiceResponse)this.createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid, createUpdateSqlContainerParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ContainerInner> createUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateSqlContainerParameters, ServiceCallback<ContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid, createUpdateSqlContainerParameters), serviceCallback);
    }

    public Observable<ContainerInner> createUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return this.createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid, createUpdateSqlContainerParameters).map((Func1)new Func1<ServiceResponse<ContainerInner>, ContainerInner>(){

            public ContainerInner call(ServiceResponse<ContainerInner> response) {
                return (ContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerInner>> createUpdateSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (containerRid == null) {
            throw new IllegalArgumentException("Parameter containerRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateSqlContainerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlContainerParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateSqlContainerParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, containerRid, this.client.apiVersion(), createUpdateSqlContainerParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ContainerInner>(){}.getType());
    }

    public ContainerInner beginCreateUpdateSqlContainer(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return (ContainerInner)((Object)((ServiceResponse)this.beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid, createUpdateSqlContainerParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ContainerInner> beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateSqlContainerParameters, ServiceCallback<ContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid, createUpdateSqlContainerParameters), serviceCallback);
    }

    public Observable<ContainerInner> beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return this.beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid, createUpdateSqlContainerParameters).map((Func1)new Func1<ServiceResponse<ContainerInner>, ContainerInner>(){

            public ContainerInner call(ServiceResponse<ContainerInner> response) {
                return (ContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerInner>> beginCreateUpdateSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (containerRid == null) {
            throw new IllegalArgumentException("Parameter containerRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateSqlContainerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlContainerParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateSqlContainerParameters);
        return this.service.beginCreateUpdateSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, containerRid, this.client.apiVersion(), createUpdateSqlContainerParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContainerInner>>>(){

            public Observable<ServiceResponse<ContainerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateSqlContainerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ContainerInner> beginCreateUpdateSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ContainerInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteSqlContainer(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        ((ServiceResponse)this.deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid), serviceCallback);
    }

    public Observable<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        return this.deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (containerRid == null) {
            throw new IllegalArgumentException("Parameter containerRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, containerRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteSqlContainer(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        ((ServiceResponse)this.beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid), serviceCallback);
    }

    public Observable<Void> beginDeleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        return this.beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (containerRid == null) {
            throw new IllegalArgumentException("Parameter containerRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, containerRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteSqlContainerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<MongoDatabaseInner> listMongoDatabases(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listMongoDatabasesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<MongoDatabaseInner>> listMongoDatabasesAsync(String resourceGroupName, String accountName, ServiceCallback<List<MongoDatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMongoDatabasesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<MongoDatabaseInner>> listMongoDatabasesAsync(String resourceGroupName, String accountName) {
        return this.listMongoDatabasesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<MongoDatabaseInner>>, List<MongoDatabaseInner>>(){

            public List<MongoDatabaseInner> call(ServiceResponse<List<MongoDatabaseInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MongoDatabaseInner>>> listMongoDatabasesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listMongoDatabases(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MongoDatabaseInner>>>>(){

            public Observable<ServiceResponse<List<MongoDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listMongoDatabasesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MongoDatabaseInner>> listMongoDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MongoDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public MongoDatabaseInner getMongoDatabase(String resourceGroupName, String accountName, String databaseRid) {
        return (MongoDatabaseInner)((Object)((ServiceResponse)this.getMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).toBlocking().single()).body());
    }

    public ServiceFuture<MongoDatabaseInner> getMongoDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, ServiceCallback<MongoDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid), serviceCallback);
    }

    public Observable<MongoDatabaseInner> getMongoDatabaseAsync(String resourceGroupName, String accountName, String databaseRid) {
        return this.getMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).map((Func1)new Func1<ServiceResponse<MongoDatabaseInner>, MongoDatabaseInner>(){

            public MongoDatabaseInner call(ServiceResponse<MongoDatabaseInner> response) {
                return (MongoDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDatabaseInner>> getMongoDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getMongoDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDatabaseInner>>>(){

            public Observable<ServiceResponse<MongoDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getMongoDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MongoDatabaseInner> getMongoDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MongoDatabaseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public MongoDatabaseInner createUpdateMongoDatabase(String resourceGroupName, String accountName, String databaseRid, MongoDatabaseCreateUpdateParameters createUpdateMongoDatabaseParameters) {
        return (MongoDatabaseInner)((Object)((ServiceResponse)this.createUpdateMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateMongoDatabaseParameters).toBlocking().last()).body());
    }

    public ServiceFuture<MongoDatabaseInner> createUpdateMongoDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, MongoDatabaseCreateUpdateParameters createUpdateMongoDatabaseParameters, ServiceCallback<MongoDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateMongoDatabaseParameters), serviceCallback);
    }

    public Observable<MongoDatabaseInner> createUpdateMongoDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, MongoDatabaseCreateUpdateParameters createUpdateMongoDatabaseParameters) {
        return this.createUpdateMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateMongoDatabaseParameters).map((Func1)new Func1<ServiceResponse<MongoDatabaseInner>, MongoDatabaseInner>(){

            public MongoDatabaseInner call(ServiceResponse<MongoDatabaseInner> response) {
                return (MongoDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDatabaseInner>> createUpdateMongoDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, MongoDatabaseCreateUpdateParameters createUpdateMongoDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateMongoDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateMongoDatabaseParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateMongoDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), createUpdateMongoDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<MongoDatabaseInner>(){}.getType());
    }

    public MongoDatabaseInner beginCreateUpdateMongoDatabase(String resourceGroupName, String accountName, String databaseRid, MongoDatabaseCreateUpdateParameters createUpdateMongoDatabaseParameters) {
        return (MongoDatabaseInner)((Object)((ServiceResponse)this.beginCreateUpdateMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateMongoDatabaseParameters).toBlocking().single()).body());
    }

    public ServiceFuture<MongoDatabaseInner> beginCreateUpdateMongoDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, MongoDatabaseCreateUpdateParameters createUpdateMongoDatabaseParameters, ServiceCallback<MongoDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateMongoDatabaseParameters), serviceCallback);
    }

    public Observable<MongoDatabaseInner> beginCreateUpdateMongoDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, MongoDatabaseCreateUpdateParameters createUpdateMongoDatabaseParameters) {
        return this.beginCreateUpdateMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateMongoDatabaseParameters).map((Func1)new Func1<ServiceResponse<MongoDatabaseInner>, MongoDatabaseInner>(){

            public MongoDatabaseInner call(ServiceResponse<MongoDatabaseInner> response) {
                return (MongoDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDatabaseInner>> beginCreateUpdateMongoDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, MongoDatabaseCreateUpdateParameters createUpdateMongoDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateMongoDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateMongoDatabaseParameters);
        return this.service.beginCreateUpdateMongoDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), createUpdateMongoDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDatabaseInner>>>(){

            public Observable<ServiceResponse<MongoDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateMongoDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MongoDatabaseInner> beginCreateUpdateMongoDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MongoDatabaseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteMongoDatabase(String resourceGroupName, String accountName, String databaseRid) {
        ((ServiceResponse)this.deleteMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteMongoDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid), serviceCallback);
    }

    public Observable<Void> deleteMongoDatabaseAsync(String resourceGroupName, String accountName, String databaseRid) {
        return this.deleteMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteMongoDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteMongoDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteMongoDatabase(String resourceGroupName, String accountName, String databaseRid) {
        ((ServiceResponse)this.beginDeleteMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteMongoDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid), serviceCallback);
    }

    public Observable<Void> beginDeleteMongoDatabaseAsync(String resourceGroupName, String accountName, String databaseRid) {
        return this.beginDeleteMongoDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteMongoDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteMongoDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteMongoDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteMongoDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<MongoCollectionInner> listMongoCollections(String resourceGroupName, String accountName, String databaseRid) {
        return (List)((ServiceResponse)this.listMongoCollectionsWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).toBlocking().single()).body();
    }

    public ServiceFuture<List<MongoCollectionInner>> listMongoCollectionsAsync(String resourceGroupName, String accountName, String databaseRid, ServiceCallback<List<MongoCollectionInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMongoCollectionsWithServiceResponseAsync(resourceGroupName, accountName, databaseRid), serviceCallback);
    }

    public Observable<List<MongoCollectionInner>> listMongoCollectionsAsync(String resourceGroupName, String accountName, String databaseRid) {
        return this.listMongoCollectionsWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).map((Func1)new Func1<ServiceResponse<List<MongoCollectionInner>>, List<MongoCollectionInner>>(){

            public List<MongoCollectionInner> call(ServiceResponse<List<MongoCollectionInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MongoCollectionInner>>> listMongoCollectionsWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listMongoCollections(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MongoCollectionInner>>>>(){

            public Observable<ServiceResponse<List<MongoCollectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listMongoCollectionsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MongoCollectionInner>> listMongoCollectionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MongoCollectionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public MongoCollectionInner getMongoCollection(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        return (MongoCollectionInner)((Object)((ServiceResponse)this.getMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid).toBlocking().single()).body());
    }

    public ServiceFuture<MongoCollectionInner> getMongoCollectionAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, ServiceCallback<MongoCollectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid), serviceCallback);
    }

    public Observable<MongoCollectionInner> getMongoCollectionAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        return this.getMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid).map((Func1)new Func1<ServiceResponse<MongoCollectionInner>, MongoCollectionInner>(){

            public MongoCollectionInner call(ServiceResponse<MongoCollectionInner> response) {
                return (MongoCollectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoCollectionInner>> getMongoCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (collectionRid == null) {
            throw new IllegalArgumentException("Parameter collectionRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getMongoCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoCollectionInner>>>(){

            public Observable<ServiceResponse<MongoCollectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getMongoCollectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MongoCollectionInner> getMongoCollectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MongoCollectionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public MongoCollectionInner createUpdateMongoCollection(String resourceGroupName, String accountName, String databaseRid, String collectionRid, MongoCollectionCreateUpdateParameters createUpdateMongoCollectionParameters) {
        return (MongoCollectionInner)((Object)((ServiceResponse)this.createUpdateMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, createUpdateMongoCollectionParameters).toBlocking().last()).body());
    }

    public ServiceFuture<MongoCollectionInner> createUpdateMongoCollectionAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, MongoCollectionCreateUpdateParameters createUpdateMongoCollectionParameters, ServiceCallback<MongoCollectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, createUpdateMongoCollectionParameters), serviceCallback);
    }

    public Observable<MongoCollectionInner> createUpdateMongoCollectionAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, MongoCollectionCreateUpdateParameters createUpdateMongoCollectionParameters) {
        return this.createUpdateMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, createUpdateMongoCollectionParameters).map((Func1)new Func1<ServiceResponse<MongoCollectionInner>, MongoCollectionInner>(){

            public MongoCollectionInner call(ServiceResponse<MongoCollectionInner> response) {
                return (MongoCollectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoCollectionInner>> createUpdateMongoCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, MongoCollectionCreateUpdateParameters createUpdateMongoCollectionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (collectionRid == null) {
            throw new IllegalArgumentException("Parameter collectionRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateMongoCollectionParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoCollectionParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateMongoCollectionParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateMongoCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.apiVersion(), createUpdateMongoCollectionParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<MongoCollectionInner>(){}.getType());
    }

    public MongoCollectionInner beginCreateUpdateMongoCollection(String resourceGroupName, String accountName, String databaseRid, String collectionRid, MongoCollectionCreateUpdateParameters createUpdateMongoCollectionParameters) {
        return (MongoCollectionInner)((Object)((ServiceResponse)this.beginCreateUpdateMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, createUpdateMongoCollectionParameters).toBlocking().single()).body());
    }

    public ServiceFuture<MongoCollectionInner> beginCreateUpdateMongoCollectionAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, MongoCollectionCreateUpdateParameters createUpdateMongoCollectionParameters, ServiceCallback<MongoCollectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, createUpdateMongoCollectionParameters), serviceCallback);
    }

    public Observable<MongoCollectionInner> beginCreateUpdateMongoCollectionAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, MongoCollectionCreateUpdateParameters createUpdateMongoCollectionParameters) {
        return this.beginCreateUpdateMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, createUpdateMongoCollectionParameters).map((Func1)new Func1<ServiceResponse<MongoCollectionInner>, MongoCollectionInner>(){

            public MongoCollectionInner call(ServiceResponse<MongoCollectionInner> response) {
                return (MongoCollectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoCollectionInner>> beginCreateUpdateMongoCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, MongoCollectionCreateUpdateParameters createUpdateMongoCollectionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (collectionRid == null) {
            throw new IllegalArgumentException("Parameter collectionRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateMongoCollectionParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoCollectionParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateMongoCollectionParameters);
        return this.service.beginCreateUpdateMongoCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.apiVersion(), createUpdateMongoCollectionParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoCollectionInner>>>(){

            public Observable<ServiceResponse<MongoCollectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateMongoCollectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MongoCollectionInner> beginCreateUpdateMongoCollectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MongoCollectionInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteMongoCollection(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        ((ServiceResponse)this.deleteMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteMongoCollectionAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid), serviceCallback);
    }

    public Observable<Void> deleteMongoCollectionAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        return this.deleteMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteMongoCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (collectionRid == null) {
            throw new IllegalArgumentException("Parameter collectionRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteMongoCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteMongoCollection(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        ((ServiceResponse)this.beginDeleteMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteMongoCollectionAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid), serviceCallback);
    }

    public Observable<Void> beginDeleteMongoCollectionAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        return this.beginDeleteMongoCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteMongoCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (collectionRid == null) {
            throw new IllegalArgumentException("Parameter collectionRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteMongoCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteMongoCollectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteMongoCollectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<TableInner> listTables(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listTablesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<TableInner>> listTablesAsync(String resourceGroupName, String accountName, ServiceCallback<List<TableInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listTablesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<TableInner>> listTablesAsync(String resourceGroupName, String accountName) {
        return this.listTablesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<TableInner>>, List<TableInner>>(){

            public List<TableInner> call(ServiceResponse<List<TableInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<TableInner>>> listTablesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listTables(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<TableInner>>>>(){

            public Observable<ServiceResponse<List<TableInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listTablesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TableInner>> listTablesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TableInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TableInner getTable(String resourceGroupName, String accountName, String tableRid) {
        return (TableInner)((Object)((ServiceResponse)this.getTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid).toBlocking().single()).body());
    }

    public ServiceFuture<TableInner> getTableAsync(String resourceGroupName, String accountName, String tableRid, ServiceCallback<TableInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid), serviceCallback);
    }

    public Observable<TableInner> getTableAsync(String resourceGroupName, String accountName, String tableRid) {
        return this.getTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid).map((Func1)new Func1<ServiceResponse<TableInner>, TableInner>(){

            public TableInner call(ServiceResponse<TableInner> response) {
                return (TableInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TableInner>> getTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableRid == null) {
            throw new IllegalArgumentException("Parameter tableRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getTable(this.client.subscriptionId(), resourceGroupName, accountName, tableRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TableInner>>>(){

            public Observable<ServiceResponse<TableInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TableInner> getTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TableInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TableInner createUpdateTable(String resourceGroupName, String accountName, String tableRid, TableCreateUpdateParameters createUpdateTableParameters) {
        return (TableInner)((Object)((ServiceResponse)this.createUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid, createUpdateTableParameters).toBlocking().last()).body());
    }

    public ServiceFuture<TableInner> createUpdateTableAsync(String resourceGroupName, String accountName, String tableRid, TableCreateUpdateParameters createUpdateTableParameters, ServiceCallback<TableInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid, createUpdateTableParameters), serviceCallback);
    }

    public Observable<TableInner> createUpdateTableAsync(String resourceGroupName, String accountName, String tableRid, TableCreateUpdateParameters createUpdateTableParameters) {
        return this.createUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid, createUpdateTableParameters).map((Func1)new Func1<ServiceResponse<TableInner>, TableInner>(){

            public TableInner call(ServiceResponse<TableInner> response) {
                return (TableInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TableInner>> createUpdateTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableRid, TableCreateUpdateParameters createUpdateTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableRid == null) {
            throw new IllegalArgumentException("Parameter tableRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateTableParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateTableParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateTable(this.client.subscriptionId(), resourceGroupName, accountName, tableRid, this.client.apiVersion(), createUpdateTableParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<TableInner>(){}.getType());
    }

    public TableInner beginCreateUpdateTable(String resourceGroupName, String accountName, String tableRid, TableCreateUpdateParameters createUpdateTableParameters) {
        return (TableInner)((Object)((ServiceResponse)this.beginCreateUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid, createUpdateTableParameters).toBlocking().single()).body());
    }

    public ServiceFuture<TableInner> beginCreateUpdateTableAsync(String resourceGroupName, String accountName, String tableRid, TableCreateUpdateParameters createUpdateTableParameters, ServiceCallback<TableInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid, createUpdateTableParameters), serviceCallback);
    }

    public Observable<TableInner> beginCreateUpdateTableAsync(String resourceGroupName, String accountName, String tableRid, TableCreateUpdateParameters createUpdateTableParameters) {
        return this.beginCreateUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid, createUpdateTableParameters).map((Func1)new Func1<ServiceResponse<TableInner>, TableInner>(){

            public TableInner call(ServiceResponse<TableInner> response) {
                return (TableInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TableInner>> beginCreateUpdateTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableRid, TableCreateUpdateParameters createUpdateTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableRid == null) {
            throw new IllegalArgumentException("Parameter tableRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateTableParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateTableParameters);
        return this.service.beginCreateUpdateTable(this.client.subscriptionId(), resourceGroupName, accountName, tableRid, this.client.apiVersion(), createUpdateTableParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TableInner>>>(){

            public Observable<ServiceResponse<TableInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TableInner> beginCreateUpdateTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TableInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteTable(String resourceGroupName, String accountName, String tableRid) {
        ((ServiceResponse)this.deleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteTableAsync(String resourceGroupName, String accountName, String tableRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid), serviceCallback);
    }

    public Observable<Void> deleteTableAsync(String resourceGroupName, String accountName, String tableRid) {
        return this.deleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableRid == null) {
            throw new IllegalArgumentException("Parameter tableRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteTable(this.client.subscriptionId(), resourceGroupName, accountName, tableRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteTable(String resourceGroupName, String accountName, String tableRid) {
        ((ServiceResponse)this.beginDeleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteTableAsync(String resourceGroupName, String accountName, String tableRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid), serviceCallback);
    }

    public Observable<Void> beginDeleteTableAsync(String resourceGroupName, String accountName, String tableRid) {
        return this.beginDeleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableRid == null) {
            throw new IllegalArgumentException("Parameter tableRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteTable(this.client.subscriptionId(), resourceGroupName, accountName, tableRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<CassandraKeyspaceInner> listCassandraKeyspaces(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listCassandraKeyspacesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<CassandraKeyspaceInner>> listCassandraKeyspacesAsync(String resourceGroupName, String accountName, ServiceCallback<List<CassandraKeyspaceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listCassandraKeyspacesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<CassandraKeyspaceInner>> listCassandraKeyspacesAsync(String resourceGroupName, String accountName) {
        return this.listCassandraKeyspacesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<CassandraKeyspaceInner>>, List<CassandraKeyspaceInner>>(){

            public List<CassandraKeyspaceInner> call(ServiceResponse<List<CassandraKeyspaceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<CassandraKeyspaceInner>>> listCassandraKeyspacesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listCassandraKeyspaces(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<CassandraKeyspaceInner>>>>(){

            public Observable<ServiceResponse<List<CassandraKeyspaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listCassandraKeyspacesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CassandraKeyspaceInner>> listCassandraKeyspacesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CassandraKeyspaceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CassandraKeyspaceInner getCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceRid) {
        return (CassandraKeyspaceInner)((Object)((ServiceResponse)this.getCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid).toBlocking().single()).body());
    }

    public ServiceFuture<CassandraKeyspaceInner> getCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceRid, ServiceCallback<CassandraKeyspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid), serviceCallback);
    }

    public Observable<CassandraKeyspaceInner> getCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceRid) {
        return this.getCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid).map((Func1)new Func1<ServiceResponse<CassandraKeyspaceInner>, CassandraKeyspaceInner>(){

            public CassandraKeyspaceInner call(ServiceResponse<CassandraKeyspaceInner> response) {
                return (CassandraKeyspaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraKeyspaceInner>> getCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceRid == null) {
            throw new IllegalArgumentException("Parameter keyspaceRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraKeyspaceInner>>>(){

            public Observable<ServiceResponse<CassandraKeyspaceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getCassandraKeyspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CassandraKeyspaceInner> getCassandraKeyspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CassandraKeyspaceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CassandraKeyspaceInner createUpdateCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceRid, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return (CassandraKeyspaceInner)((Object)((ServiceResponse)this.createUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, createUpdateCassandraKeyspaceParameters).toBlocking().last()).body());
    }

    public ServiceFuture<CassandraKeyspaceInner> createUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceRid, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters, ServiceCallback<CassandraKeyspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, createUpdateCassandraKeyspaceParameters), serviceCallback);
    }

    public Observable<CassandraKeyspaceInner> createUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceRid, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return this.createUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, createUpdateCassandraKeyspaceParameters).map((Func1)new Func1<ServiceResponse<CassandraKeyspaceInner>, CassandraKeyspaceInner>(){

            public CassandraKeyspaceInner call(ServiceResponse<CassandraKeyspaceInner> response) {
                return (CassandraKeyspaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraKeyspaceInner>> createUpdateCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceRid, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceRid == null) {
            throw new IllegalArgumentException("Parameter keyspaceRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateCassandraKeyspaceParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraKeyspaceParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateCassandraKeyspaceParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceRid, this.client.apiVersion(), createUpdateCassandraKeyspaceParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CassandraKeyspaceInner>(){}.getType());
    }

    public CassandraKeyspaceInner beginCreateUpdateCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceRid, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return (CassandraKeyspaceInner)((Object)((ServiceResponse)this.beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, createUpdateCassandraKeyspaceParameters).toBlocking().single()).body());
    }

    public ServiceFuture<CassandraKeyspaceInner> beginCreateUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceRid, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters, ServiceCallback<CassandraKeyspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, createUpdateCassandraKeyspaceParameters), serviceCallback);
    }

    public Observable<CassandraKeyspaceInner> beginCreateUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceRid, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return this.beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, createUpdateCassandraKeyspaceParameters).map((Func1)new Func1<ServiceResponse<CassandraKeyspaceInner>, CassandraKeyspaceInner>(){

            public CassandraKeyspaceInner call(ServiceResponse<CassandraKeyspaceInner> response) {
                return (CassandraKeyspaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraKeyspaceInner>> beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceRid, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceRid == null) {
            throw new IllegalArgumentException("Parameter keyspaceRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateCassandraKeyspaceParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraKeyspaceParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateCassandraKeyspaceParameters);
        return this.service.beginCreateUpdateCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceRid, this.client.apiVersion(), createUpdateCassandraKeyspaceParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraKeyspaceInner>>>(){

            public Observable<ServiceResponse<CassandraKeyspaceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateCassandraKeyspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CassandraKeyspaceInner> beginCreateUpdateCassandraKeyspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CassandraKeyspaceInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceRid) {
        ((ServiceResponse)this.deleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid), serviceCallback);
    }

    public Observable<Void> deleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceRid) {
        return this.deleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceRid == null) {
            throw new IllegalArgumentException("Parameter keyspaceRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceRid) {
        ((ServiceResponse)this.beginDeleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid), serviceCallback);
    }

    public Observable<Void> beginDeleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceRid) {
        return this.beginDeleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceRid == null) {
            throw new IllegalArgumentException("Parameter keyspaceRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteCassandraKeyspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteCassandraKeyspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<CassandraTableInner> listCassandraTables(String resourceGroupName, String accountName, String keyspaceRid) {
        return (List)((ServiceResponse)this.listCassandraTablesWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid).toBlocking().single()).body();
    }

    public ServiceFuture<List<CassandraTableInner>> listCassandraTablesAsync(String resourceGroupName, String accountName, String keyspaceRid, ServiceCallback<List<CassandraTableInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listCassandraTablesWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid), serviceCallback);
    }

    public Observable<List<CassandraTableInner>> listCassandraTablesAsync(String resourceGroupName, String accountName, String keyspaceRid) {
        return this.listCassandraTablesWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid).map((Func1)new Func1<ServiceResponse<List<CassandraTableInner>>, List<CassandraTableInner>>(){

            public List<CassandraTableInner> call(ServiceResponse<List<CassandraTableInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<CassandraTableInner>>> listCassandraTablesWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceRid == null) {
            throw new IllegalArgumentException("Parameter keyspaceRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listCassandraTables(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<CassandraTableInner>>>>(){

            public Observable<ServiceResponse<List<CassandraTableInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listCassandraTablesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CassandraTableInner>> listCassandraTablesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CassandraTableInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CassandraTableInner getCassandraTable(String resourceGroupName, String accountName, String keyspaceRid, String tableRid) {
        return (CassandraTableInner)((Object)((ServiceResponse)this.getCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid).toBlocking().single()).body());
    }

    public ServiceFuture<CassandraTableInner> getCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid, ServiceCallback<CassandraTableInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid), serviceCallback);
    }

    public Observable<CassandraTableInner> getCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid) {
        return this.getCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid).map((Func1)new Func1<ServiceResponse<CassandraTableInner>, CassandraTableInner>(){

            public CassandraTableInner call(ServiceResponse<CassandraTableInner> response) {
                return (CassandraTableInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraTableInner>> getCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceRid == null) {
            throw new IllegalArgumentException("Parameter keyspaceRid is required and cannot be null.");
        }
        if (tableRid == null) {
            throw new IllegalArgumentException("Parameter tableRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceRid, tableRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraTableInner>>>(){

            public Observable<ServiceResponse<CassandraTableInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getCassandraTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CassandraTableInner> getCassandraTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CassandraTableInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CassandraTableInner createUpdateCassandraTable(String resourceGroupName, String accountName, String keyspaceRid, String tableRid, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return (CassandraTableInner)((Object)((ServiceResponse)this.createUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid, createUpdateCassandraTableParameters).toBlocking().last()).body());
    }

    public ServiceFuture<CassandraTableInner> createUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters, ServiceCallback<CassandraTableInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid, createUpdateCassandraTableParameters), serviceCallback);
    }

    public Observable<CassandraTableInner> createUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return this.createUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid, createUpdateCassandraTableParameters).map((Func1)new Func1<ServiceResponse<CassandraTableInner>, CassandraTableInner>(){

            public CassandraTableInner call(ServiceResponse<CassandraTableInner> response) {
                return (CassandraTableInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraTableInner>> createUpdateCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceRid == null) {
            throw new IllegalArgumentException("Parameter keyspaceRid is required and cannot be null.");
        }
        if (tableRid == null) {
            throw new IllegalArgumentException("Parameter tableRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateCassandraTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraTableParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateCassandraTableParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceRid, tableRid, this.client.apiVersion(), createUpdateCassandraTableParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CassandraTableInner>(){}.getType());
    }

    public CassandraTableInner beginCreateUpdateCassandraTable(String resourceGroupName, String accountName, String keyspaceRid, String tableRid, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return (CassandraTableInner)((Object)((ServiceResponse)this.beginCreateUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid, createUpdateCassandraTableParameters).toBlocking().single()).body());
    }

    public ServiceFuture<CassandraTableInner> beginCreateUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters, ServiceCallback<CassandraTableInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid, createUpdateCassandraTableParameters), serviceCallback);
    }

    public Observable<CassandraTableInner> beginCreateUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return this.beginCreateUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid, createUpdateCassandraTableParameters).map((Func1)new Func1<ServiceResponse<CassandraTableInner>, CassandraTableInner>(){

            public CassandraTableInner call(ServiceResponse<CassandraTableInner> response) {
                return (CassandraTableInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraTableInner>> beginCreateUpdateCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceRid == null) {
            throw new IllegalArgumentException("Parameter keyspaceRid is required and cannot be null.");
        }
        if (tableRid == null) {
            throw new IllegalArgumentException("Parameter tableRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateCassandraTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraTableParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateCassandraTableParameters);
        return this.service.beginCreateUpdateCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceRid, tableRid, this.client.apiVersion(), createUpdateCassandraTableParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraTableInner>>>(){

            public Observable<ServiceResponse<CassandraTableInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateCassandraTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CassandraTableInner> beginCreateUpdateCassandraTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CassandraTableInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteCassandraTable(String resourceGroupName, String accountName, String keyspaceRid, String tableRid) {
        ((ServiceResponse)this.deleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid), serviceCallback);
    }

    public Observable<Void> deleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid) {
        return this.deleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceRid == null) {
            throw new IllegalArgumentException("Parameter keyspaceRid is required and cannot be null.");
        }
        if (tableRid == null) {
            throw new IllegalArgumentException("Parameter tableRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceRid, tableRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteCassandraTable(String resourceGroupName, String accountName, String keyspaceRid, String tableRid) {
        ((ServiceResponse)this.beginDeleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid), serviceCallback);
    }

    public Observable<Void> beginDeleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid) {
        return this.beginDeleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceRid, tableRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceRid, String tableRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceRid == null) {
            throw new IllegalArgumentException("Parameter keyspaceRid is required and cannot be null.");
        }
        if (tableRid == null) {
            throw new IllegalArgumentException("Parameter tableRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceRid, tableRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteCassandraTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteCassandraTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<GremlinDatabaseInner> listGremlinDatabases(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listGremlinDatabasesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<GremlinDatabaseInner>> listGremlinDatabasesAsync(String resourceGroupName, String accountName, ServiceCallback<List<GremlinDatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listGremlinDatabasesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<GremlinDatabaseInner>> listGremlinDatabasesAsync(String resourceGroupName, String accountName) {
        return this.listGremlinDatabasesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<GremlinDatabaseInner>>, List<GremlinDatabaseInner>>(){

            public List<GremlinDatabaseInner> call(ServiceResponse<List<GremlinDatabaseInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<GremlinDatabaseInner>>> listGremlinDatabasesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listGremlinDatabases(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<GremlinDatabaseInner>>>>(){

            public Observable<ServiceResponse<List<GremlinDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listGremlinDatabasesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GremlinDatabaseInner>> listGremlinDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<GremlinDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GremlinDatabaseInner getGremlinDatabase(String resourceGroupName, String accountName, String databaseRid) {
        return (GremlinDatabaseInner)((Object)((ServiceResponse)this.getGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).toBlocking().single()).body());
    }

    public ServiceFuture<GremlinDatabaseInner> getGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, ServiceCallback<GremlinDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid), serviceCallback);
    }

    public Observable<GremlinDatabaseInner> getGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseRid) {
        return this.getGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).map((Func1)new Func1<ServiceResponse<GremlinDatabaseInner>, GremlinDatabaseInner>(){

            public GremlinDatabaseInner call(ServiceResponse<GremlinDatabaseInner> response) {
                return (GremlinDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinDatabaseInner>> getGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinDatabaseInner>>>(){

            public Observable<ServiceResponse<GremlinDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getGremlinDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GremlinDatabaseInner> getGremlinDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GremlinDatabaseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GremlinDatabaseInner createUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseRid, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return (GremlinDatabaseInner)((Object)((ServiceResponse)this.createUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateGremlinDatabaseParameters).toBlocking().last()).body());
    }

    public ServiceFuture<GremlinDatabaseInner> createUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, ServiceCallback<GremlinDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateGremlinDatabaseParameters), serviceCallback);
    }

    public Observable<GremlinDatabaseInner> createUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return this.createUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateGremlinDatabaseParameters).map((Func1)new Func1<ServiceResponse<GremlinDatabaseInner>, GremlinDatabaseInner>(){

            public GremlinDatabaseInner call(ServiceResponse<GremlinDatabaseInner> response) {
                return (GremlinDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinDatabaseInner>> createUpdateGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateGremlinDatabaseParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), createUpdateGremlinDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GremlinDatabaseInner>(){}.getType());
    }

    public GremlinDatabaseInner beginCreateUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseRid, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return (GremlinDatabaseInner)((Object)((ServiceResponse)this.beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateGremlinDatabaseParameters).toBlocking().single()).body());
    }

    public ServiceFuture<GremlinDatabaseInner> beginCreateUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, ServiceCallback<GremlinDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateGremlinDatabaseParameters), serviceCallback);
    }

    public Observable<GremlinDatabaseInner> beginCreateUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return this.beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, createUpdateGremlinDatabaseParameters).map((Func1)new Func1<ServiceResponse<GremlinDatabaseInner>, GremlinDatabaseInner>(){

            public GremlinDatabaseInner call(ServiceResponse<GremlinDatabaseInner> response) {
                return (GremlinDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinDatabaseInner>> beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateGremlinDatabaseParameters);
        return this.service.beginCreateUpdateGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), createUpdateGremlinDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinDatabaseInner>>>(){

            public Observable<ServiceResponse<GremlinDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateGremlinDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GremlinDatabaseInner> beginCreateUpdateGremlinDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GremlinDatabaseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteGremlinDatabase(String resourceGroupName, String accountName, String databaseRid) {
        ((ServiceResponse)this.deleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid), serviceCallback);
    }

    public Observable<Void> deleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseRid) {
        return this.deleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteGremlinDatabase(String resourceGroupName, String accountName, String databaseRid) {
        ((ServiceResponse)this.beginDeleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid), serviceCallback);
    }

    public Observable<Void> beginDeleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseRid) {
        return this.beginDeleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteGremlinDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteGremlinDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<ContainerInner> listGremlinContainers(String resourceGroupName, String accountName, String databaseRid) {
        return (List)((ServiceResponse)this.listGremlinContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).toBlocking().single()).body();
    }

    public ServiceFuture<List<ContainerInner>> listGremlinContainersAsync(String resourceGroupName, String accountName, String databaseRid, ServiceCallback<List<ContainerInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listGremlinContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseRid), serviceCallback);
    }

    public Observable<List<ContainerInner>> listGremlinContainersAsync(String resourceGroupName, String accountName, String databaseRid) {
        return this.listGremlinContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseRid).map((Func1)new Func1<ServiceResponse<List<ContainerInner>>, List<ContainerInner>>(){

            public List<ContainerInner> call(ServiceResponse<List<ContainerInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ContainerInner>>> listGremlinContainersWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listGremlinContainers(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ContainerInner>>>>(){

            public Observable<ServiceResponse<List<ContainerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listGremlinContainersDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ContainerInner>> listGremlinContainersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ContainerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ContainerInner getGremlinContainer(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        return (ContainerInner)((Object)((ServiceResponse)this.getGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid).toBlocking().single()).body());
    }

    public ServiceFuture<ContainerInner> getGremlinContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ServiceCallback<ContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid), serviceCallback);
    }

    public Observable<ContainerInner> getGremlinContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        return this.getGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid).map((Func1)new Func1<ServiceResponse<ContainerInner>, ContainerInner>(){

            public ContainerInner call(ServiceResponse<ContainerInner> response) {
                return (ContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerInner>> getGremlinContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (containerRid == null) {
            throw new IllegalArgumentException("Parameter containerRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getGremlinContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, containerRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContainerInner>>>(){

            public Observable<ServiceResponse<ContainerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getGremlinContainerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ContainerInner> getGremlinContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ContainerInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ContainerInner createUpdateGremlinContainer(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateGremlinContainerParameters) {
        return (ContainerInner)((Object)((ServiceResponse)this.createUpdateGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid, createUpdateGremlinContainerParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ContainerInner> createUpdateGremlinContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateGremlinContainerParameters, ServiceCallback<ContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid, createUpdateGremlinContainerParameters), serviceCallback);
    }

    public Observable<ContainerInner> createUpdateGremlinContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateGremlinContainerParameters) {
        return this.createUpdateGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid, createUpdateGremlinContainerParameters).map((Func1)new Func1<ServiceResponse<ContainerInner>, ContainerInner>(){

            public ContainerInner call(ServiceResponse<ContainerInner> response) {
                return (ContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerInner>> createUpdateGremlinContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateGremlinContainerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (containerRid == null) {
            throw new IllegalArgumentException("Parameter containerRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateGremlinContainerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinContainerParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateGremlinContainerParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateGremlinContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, containerRid, this.client.apiVersion(), createUpdateGremlinContainerParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ContainerInner>(){}.getType());
    }

    public ContainerInner beginCreateUpdateGremlinContainer(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateGremlinContainerParameters) {
        return (ContainerInner)((Object)((ServiceResponse)this.beginCreateUpdateGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid, createUpdateGremlinContainerParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ContainerInner> beginCreateUpdateGremlinContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateGremlinContainerParameters, ServiceCallback<ContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid, createUpdateGremlinContainerParameters), serviceCallback);
    }

    public Observable<ContainerInner> beginCreateUpdateGremlinContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateGremlinContainerParameters) {
        return this.beginCreateUpdateGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid, createUpdateGremlinContainerParameters).map((Func1)new Func1<ServiceResponse<ContainerInner>, ContainerInner>(){

            public ContainerInner call(ServiceResponse<ContainerInner> response) {
                return (ContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerInner>> beginCreateUpdateGremlinContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ContainerCreateUpdateParameters createUpdateGremlinContainerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (containerRid == null) {
            throw new IllegalArgumentException("Parameter containerRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateGremlinContainerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinContainerParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateGremlinContainerParameters);
        return this.service.beginCreateUpdateGremlinContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, containerRid, this.client.apiVersion(), createUpdateGremlinContainerParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContainerInner>>>(){

            public Observable<ServiceResponse<ContainerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateGremlinContainerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ContainerInner> beginCreateUpdateGremlinContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ContainerInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteGremlinContainer(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        ((ServiceResponse)this.deleteGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteGremlinContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid), serviceCallback);
    }

    public Observable<Void> deleteGremlinContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        return this.deleteGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteGremlinContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (containerRid == null) {
            throw new IllegalArgumentException("Parameter containerRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteGremlinContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, containerRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteGremlinContainer(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        ((ServiceResponse)this.beginDeleteGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteGremlinContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid), serviceCallback);
    }

    public Observable<Void> beginDeleteGremlinContainerAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        return this.beginDeleteGremlinContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, containerRid).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteGremlinContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String containerRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (containerRid == null) {
            throw new IllegalArgumentException("Parameter containerRid is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteGremlinContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, containerRid, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteGremlinContainerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteGremlinContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DatabaseAccountsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts patch"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> patch(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountPatchParameters var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginPatch"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> beginPatch(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountPatchParameters var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountCreateUpdateParametersInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountCreateUpdateParametersInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts failoverPriorityChange"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/failoverPriorityChange")
        public Observable<Response<ResponseBody>> failoverPriorityChange(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body FailoverPolicies var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginFailoverPriorityChange"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/failoverPriorityChange")
        public Observable<Response<ResponseBody>> beginFailoverPriorityChange(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body FailoverPolicies var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/databaseAccounts")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/listKeys")
        public Observable<Response<ResponseBody>> listKeys(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listConnectionStrings"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/listConnectionStrings")
        public Observable<Response<ResponseBody>> listConnectionStrings(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts offlineRegion"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/offlineRegion")
        public Observable<Response<ResponseBody>> offlineRegion(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegionForOnlineOffline var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginOfflineRegion"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/offlineRegion")
        public Observable<Response<ResponseBody>> beginOfflineRegion(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegionForOnlineOffline var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts onlineRegion"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/onlineRegion")
        public Observable<Response<ResponseBody>> onlineRegion(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegionForOnlineOffline var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginOnlineRegion"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/onlineRegion")
        public Observable<Response<ResponseBody>> beginOnlineRegion(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegionForOnlineOffline var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getReadOnlyKeys"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/readonlykeys")
        public Observable<Response<ResponseBody>> getReadOnlyKeys(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listReadOnlyKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/readonlykeys")
        public Observable<Response<ResponseBody>> listReadOnlyKeys(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts regenerateKey"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/regenerateKey")
        public Observable<Response<ResponseBody>> regenerateKey(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body DatabaseAccountRegenerateKeyParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginRegenerateKey"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/regenerateKey")
        public Observable<Response<ResponseBody>> beginRegenerateKey(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body DatabaseAccountRegenerateKeyParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts checkNameExists"})
        @HEAD(value="providers/Microsoft.DocumentDB/databaseAccountNames/{accountName}")
        public Observable<Response<Void>> checkNameExists(@Path(value="accountName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMetrics"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/metrics")
        public Observable<Response<ResponseBody>> listMetrics(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Query(value="$filter") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listUsages"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/usages")
        public Observable<Response<ResponseBody>> listUsages(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Query(value="$filter") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMetricDefinitions"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/metricDefinitions")
        public Observable<Response<ResponseBody>> listMetricDefinitions(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listSqlDatabases"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases")
        public Observable<Response<ResponseBody>> listSqlDatabases(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getSqlDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseRid}")
        public Observable<Response<ResponseBody>> getSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateSqlDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseRid}")
        public Observable<Response<ResponseBody>> createUpdateSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Body SqlDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateSqlDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseRid}")
        public Observable<Response<ResponseBody>> beginCreateUpdateSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Body SqlDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteSqlDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteSqlDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listSqlContainers"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseRid}/containers")
        public Observable<Response<ResponseBody>> listSqlContainers(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getSqlContainer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseRid}/containers/{containerRid}")
        public Observable<Response<ResponseBody>> getSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="containerRid") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateSqlContainer"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseRid}/containers/{containerRid}")
        public Observable<Response<ResponseBody>> createUpdateSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="containerRid") String var5, @Query(value="api-version") String var6, @Body ContainerCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateSqlContainer"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseRid}/containers/{containerRid}")
        public Observable<Response<ResponseBody>> beginCreateUpdateSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="containerRid") String var5, @Query(value="api-version") String var6, @Body ContainerCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteSqlContainer"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseRid}/containers/{containerRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="containerRid") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteSqlContainer"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseRid}/containers/{containerRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="containerRid") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMongoDatabases"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongo/databases")
        public Observable<Response<ResponseBody>> listMongoDatabases(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getMongoDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongo/databases/{databaseRid}")
        public Observable<Response<ResponseBody>> getMongoDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateMongoDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongo/databases/{databaseRid}")
        public Observable<Response<ResponseBody>> createUpdateMongoDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Body MongoDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateMongoDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongo/databases/{databaseRid}")
        public Observable<Response<ResponseBody>> beginCreateUpdateMongoDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Body MongoDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteMongoDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongo/databases/{databaseRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteMongoDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteMongoDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongo/databases/{databaseRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteMongoDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMongoCollections"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongo/databases/{databaseRid}/collections")
        public Observable<Response<ResponseBody>> listMongoCollections(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getMongoCollection"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongo/databases/{databaseRid}/collections/{collectionRid}")
        public Observable<Response<ResponseBody>> getMongoCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="collectionRid") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateMongoCollection"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongo/databases/{databaseRid}/collections/{collectionRid}")
        public Observable<Response<ResponseBody>> createUpdateMongoCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="collectionRid") String var5, @Query(value="api-version") String var6, @Body MongoCollectionCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateMongoCollection"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongo/databases/{databaseRid}/collections/{collectionRid}")
        public Observable<Response<ResponseBody>> beginCreateUpdateMongoCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="collectionRid") String var5, @Query(value="api-version") String var6, @Body MongoCollectionCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteMongoCollection"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongo/databases/{databaseRid}/collections/{collectionRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteMongoCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="collectionRid") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteMongoCollection"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongo/databases/{databaseRid}/collections/{collectionRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteMongoCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="collectionRid") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listTables"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables")
        public Observable<Response<ResponseBody>> listTables(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getTable"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableRid}")
        public Observable<Response<ResponseBody>> getTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateTable"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableRid}")
        public Observable<Response<ResponseBody>> createUpdateTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableRid") String var4, @Query(value="api-version") String var5, @Body TableCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateTable"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableRid}")
        public Observable<Response<ResponseBody>> beginCreateUpdateTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableRid") String var4, @Query(value="api-version") String var5, @Body TableCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteTable"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteTable"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listCassandraKeyspaces"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces")
        public Observable<Response<ResponseBody>> listCassandraKeyspaces(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getCassandraKeyspace"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceRid}")
        public Observable<Response<ResponseBody>> getCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateCassandraKeyspace"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceRid}")
        public Observable<Response<ResponseBody>> createUpdateCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceRid") String var4, @Query(value="api-version") String var5, @Body CassandraKeyspaceCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateCassandraKeyspace"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceRid}")
        public Observable<Response<ResponseBody>> beginCreateUpdateCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceRid") String var4, @Query(value="api-version") String var5, @Body CassandraKeyspaceCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteCassandraKeyspace"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteCassandraKeyspace"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listCassandraTables"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceRid}/tables")
        public Observable<Response<ResponseBody>> listCassandraTables(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getCassandraTable"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceRid}/tables/{tableRid}")
        public Observable<Response<ResponseBody>> getCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceRid") String var4, @Path(value="tableRid") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateCassandraTable"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceRid}/tables/{tableRid}")
        public Observable<Response<ResponseBody>> createUpdateCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceRid") String var4, @Path(value="tableRid") String var5, @Query(value="api-version") String var6, @Body CassandraTableCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateCassandraTable"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceRid}/tables/{tableRid}")
        public Observable<Response<ResponseBody>> beginCreateUpdateCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceRid") String var4, @Path(value="tableRid") String var5, @Query(value="api-version") String var6, @Body CassandraTableCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteCassandraTable"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceRid}/tables/{tableRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceRid") String var4, @Path(value="tableRid") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteCassandraTable"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceRid}/tables/{tableRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceRid") String var4, @Path(value="tableRid") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listGremlinDatabases"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases")
        public Observable<Response<ResponseBody>> listGremlinDatabases(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getGremlinDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseRid}")
        public Observable<Response<ResponseBody>> getGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateGremlinDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseRid}")
        public Observable<Response<ResponseBody>> createUpdateGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Body GremlinDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateGremlinDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseRid}")
        public Observable<Response<ResponseBody>> beginCreateUpdateGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Body GremlinDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteGremlinDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteGremlinDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listGremlinContainers"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseRid}/containers")
        public Observable<Response<ResponseBody>> listGremlinContainers(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getGremlinContainer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseRid}/containers/{containerRid}")
        public Observable<Response<ResponseBody>> getGremlinContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="containerRid") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateGremlinContainer"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseRid}/containers/{containerRid}")
        public Observable<Response<ResponseBody>> createUpdateGremlinContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="containerRid") String var5, @Query(value="api-version") String var6, @Body ContainerCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateGremlinContainer"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseRid}/containers/{containerRid}")
        public Observable<Response<ResponseBody>> beginCreateUpdateGremlinContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="containerRid") String var5, @Query(value="api-version") String var6, @Body ContainerCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteGremlinContainer"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseRid}/containers/{containerRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteGremlinContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="containerRid") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteGremlinContainer"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseRid}/containers/{containerRid}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteGremlinContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="containerRid") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

