/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.AvailableProviders;
import com.microsoft.azure.management.network.AvailableProvidersListCountry;
import com.microsoft.azure.management.network.AvailableProvidersListParameters;
import com.microsoft.azure.management.network.NetworkWatcher;
import com.microsoft.azure.management.network.implementation.AvailableProvidersListInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkWatcherImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.ExecutableImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class AvailableProvidersImpl
extends ExecutableImpl<AvailableProviders>
implements AvailableProviders,
AvailableProviders.Definition {
    private Map<String, AvailableProvidersListCountry> providersByCountry;
    private final NetworkWatcherImpl parent;
    private AvailableProvidersListParameters parameters = new AvailableProvidersListParameters();
    private AvailableProvidersListInner inner;

    AvailableProvidersImpl(NetworkWatcherImpl parent) {
        this.parent = parent;
    }

    @Override
    public AvailableProvidersListParameters availableProvidersParameters() {
        return this.parameters;
    }

    @Override
    public Map<String, AvailableProvidersListCountry> providersByCountry() {
        return Collections.unmodifiableMap(this.providersByCountry);
    }

    private void initializeResourcesFromInner() {
        this.providersByCountry = new TreeMap<String, AvailableProvidersListCountry>();
        List<AvailableProvidersListCountry> availableProvidersList = this.inner().countries();
        if (availableProvidersList != null) {
            for (AvailableProvidersListCountry resource : availableProvidersList) {
                this.providersByCountry.put(resource.countryName(), resource);
            }
        }
    }

    public NetworkWatcher parent() {
        return this.parent;
    }

    public AvailableProvidersListInner inner() {
        return this.inner;
    }

    public Observable<AvailableProviders> executeWorkAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)((Object)this.parent().manager())).inner())).networkWatchers().listAvailableProvidersAsync(this.parent().resourceGroupName(), this.parent().name(), this.parameters).map((Func1)new Func1<AvailableProvidersListInner, AvailableProviders>(){

            public AvailableProviders call(AvailableProvidersListInner availableProvidersListInner) {
                AvailableProvidersImpl.this.inner = availableProvidersListInner;
                AvailableProvidersImpl.this.initializeResourcesFromInner();
                return AvailableProvidersImpl.this;
            }
        });
    }

    @Override
    public AvailableProvidersImpl withAzureLocations(String ... azureLocations) {
        this.parameters.withAzureLocations(Arrays.asList(azureLocations));
        return this;
    }

    @Override
    public AvailableProvidersImpl withAzureLocation(String azureLocation) {
        if (this.parameters.azureLocations() == null) {
            this.parameters.withAzureLocations(new ArrayList<String>());
        }
        this.parameters.azureLocations().add(azureLocation);
        return this;
    }

    @Override
    public AvailableProvidersImpl withCountry(String country) {
        this.parameters.withCountry(country);
        return this;
    }

    @Override
    public AvailableProvidersImpl withState(String state) {
        this.parameters.withState(state);
        return this;
    }

    @Override
    public AvailableProvidersImpl withCity(String city) {
        this.parameters.withCity(city);
        return this;
    }
}

