/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppServiceCertificate;
import com.microsoft.azure.management.appservice.AppServiceCertificateKeyVaultBinding;
import com.microsoft.azure.management.appservice.AppServiceCertificateOrder;
import com.microsoft.azure.management.appservice.HostingEnvironmentProfile;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.CertificateInner;
import com.microsoft.azure.management.appservice.implementation.CertificatesInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import retrofit2.Retrofit;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class AppServiceCertificateImpl
extends GroupableResourceImpl<AppServiceCertificate, CertificateInner, AppServiceCertificateImpl, AppServiceManager>
implements AppServiceCertificate,
AppServiceCertificate.Definition {
    private String pfxFileUrl;
    private AppServiceCertificateOrder certificateOrder;

    AppServiceCertificateImpl(String name, CertificateInner innerObject, AppServiceManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
    }

    @Override
    public String friendlyName() {
        return ((CertificateInner)((Object)this.inner())).friendlyName();
    }

    @Override
    public String subjectName() {
        return ((CertificateInner)((Object)this.inner())).subjectName();
    }

    @Override
    public List<String> hostNames() {
        return Collections.unmodifiableList(((CertificateInner)((Object)this.inner())).hostNames());
    }

    @Override
    public byte[] pfxBlob() {
        return ((CertificateInner)((Object)this.inner())).pfxBlob();
    }

    @Override
    public String siteName() {
        return ((CertificateInner)((Object)this.inner())).siteName();
    }

    @Override
    public String selfLink() {
        return ((CertificateInner)((Object)this.inner())).selfLink();
    }

    @Override
    public String issuer() {
        return ((CertificateInner)((Object)this.inner())).issuer();
    }

    @Override
    public DateTime issueDate() {
        return ((CertificateInner)((Object)this.inner())).issueDate();
    }

    @Override
    public DateTime expirationDate() {
        return ((CertificateInner)((Object)this.inner())).expirationDate();
    }

    @Override
    public String password() {
        return ((CertificateInner)((Object)this.inner())).password();
    }

    @Override
    public String thumbprint() {
        return ((CertificateInner)((Object)this.inner())).thumbprint();
    }

    @Override
    public Boolean valid() {
        return ((CertificateInner)((Object)this.inner())).valid();
    }

    @Override
    public byte[] certificateBlob() {
        return ((CertificateInner)((Object)this.inner())).cerBlob();
    }

    @Override
    public String publicKeyHash() {
        return ((CertificateInner)((Object)this.inner())).publicKeyHash();
    }

    @Override
    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return ((CertificateInner)((Object)this.inner())).hostingEnvironmentProfile();
    }

    protected Observable<CertificateInner> getInnerAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).certificates().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<AppServiceCertificate> createResourceAsync() {
        Observable pfxBytes = Observable.just(null);
        if (this.pfxFileUrl != null) {
            pfxBytes = Utils.downloadFileAsync((String)this.pfxFileUrl, (Retrofit)((AppServiceManager)this.manager()).restClient().retrofit()).map((Func1)new Func1<byte[], Void>(){

                public Void call(byte[] bytes) {
                    ((CertificateInner)((Object)AppServiceCertificateImpl.this.inner())).withPfxBlob(bytes);
                    return null;
                }
            });
        }
        Observable keyVaultBinding = Observable.just(null);
        if (this.certificateOrder != null) {
            keyVaultBinding = this.certificateOrder.getKeyVaultBindingAsync().map((Func1)new Func1<AppServiceCertificateKeyVaultBinding, Void>(){

                public Void call(AppServiceCertificateKeyVaultBinding keyVaultBinding) {
                    ((CertificateInner)((Object)AppServiceCertificateImpl.this.inner())).withKeyVaultId(keyVaultBinding.keyVaultId()).withKeyVaultSecretName(keyVaultBinding.keyVaultSecretName());
                    return null;
                }
            });
        }
        final CertificatesInner client = ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).certificates();
        return pfxBytes.concatWith(keyVaultBinding).last().flatMap((Func1)new Func1<Void, Observable<CertificateInner>>(){

            public Observable<CertificateInner> call(Void aVoid) {
                return client.createOrUpdateAsync(AppServiceCertificateImpl.this.resourceGroupName(), AppServiceCertificateImpl.this.name(), (CertificateInner)((Object)AppServiceCertificateImpl.this.inner()));
            }
        }).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    @Override
    public AppServiceCertificateImpl withPfxFile(File file) {
        try {
            byte[] fileContent = Files.readAllBytes(file.toPath());
            return this.withPfxByteArray(fileContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AppServiceCertificateImpl withPfxByteArray(byte[] pfxByteArray) {
        ((CertificateInner)((Object)this.inner())).withPfxBlob(pfxByteArray);
        return this;
    }

    @Override
    public AppServiceCertificateImpl withPfxFileFromUrl(String url) {
        this.pfxFileUrl = url;
        return this;
    }

    @Override
    public AppServiceCertificateImpl withExistingCertificateOrder(AppServiceCertificateOrder certificateOrder) {
        this.certificateOrder = certificateOrder;
        return this;
    }

    @Override
    public AppServiceCertificateImpl withPfxPassword(String password) {
        ((CertificateInner)((Object)this.inner())).withPassword(password);
        return this;
    }
}

