/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.security.RefreshPolicy;

public final class DeleteUserRequest
implements Validatable {
    private final String name;
    private final RefreshPolicy refreshPolicy;

    public DeleteUserRequest(String name) {
        this(name, RefreshPolicy.IMMEDIATE);
    }

    public DeleteUserRequest(String name, RefreshPolicy refreshPolicy) {
        this.name = Objects.requireNonNull(name, "user name is required");
        this.refreshPolicy = Objects.requireNonNull(refreshPolicy, "refresh policy is required");
    }

    public String getName() {
        return this.name;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.refreshPolicy});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteUserRequest other = (DeleteUserRequest)obj;
        return this.refreshPolicy == other.refreshPolicy && Objects.equals(this.name, other.name);
    }
}

