/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.resync;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;

public final class ResyncReplicationRequest
extends ReplicatedWriteRequest<ResyncReplicationRequest> {
    private final long trimAboveSeqNo;
    private final Translog.Operation[] operations;
    private final long maxSeenAutoIdTimestampOnPrimary;

    ResyncReplicationRequest(StreamInput in) throws IOException {
        super(in);
        assert (Version.CURRENT.major <= 7);
        if (in.getVersion().equals(Version.V_6_0_0)) {
            throw new IllegalStateException("resync replication request serialization is broken in 6.0.0");
        }
        this.trimAboveSeqNo = in.getVersion().onOrAfter(Version.V_6_4_0) ? in.readZLong() : -2L;
        this.maxSeenAutoIdTimestampOnPrimary = in.getVersion().onOrAfter(Version.V_6_5_0) ? in.readZLong() : -1L;
        this.operations = in.readArray(Translog.Operation::readOperation, Translog.Operation[]::new);
    }

    public ResyncReplicationRequest(ShardId shardId, long trimAboveSeqNo, long maxSeenAutoIdTimestampOnPrimary, Translog.Operation[] operations) {
        super(shardId);
        this.trimAboveSeqNo = trimAboveSeqNo;
        this.maxSeenAutoIdTimestampOnPrimary = maxSeenAutoIdTimestampOnPrimary;
        this.operations = operations;
    }

    public long getTrimAboveSeqNo() {
        return this.trimAboveSeqNo;
    }

    public long getMaxSeenAutoIdTimestampOnPrimary() {
        return this.maxSeenAutoIdTimestampOnPrimary;
    }

    public Translog.Operation[] getOperations() {
        return this.operations;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeZLong(this.trimAboveSeqNo);
        }
        if (out.getVersion().onOrAfter(Version.V_6_5_0)) {
            out.writeZLong(this.maxSeenAutoIdTimestampOnPrimary);
        }
        out.writeArray(Translog.Operation::writeOperation, this.operations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResyncReplicationRequest that = (ResyncReplicationRequest)o;
        return this.trimAboveSeqNo == that.trimAboveSeqNo && this.maxSeenAutoIdTimestampOnPrimary == that.maxSeenAutoIdTimestampOnPrimary && Arrays.equals(this.operations, that.operations);
    }

    public int hashCode() {
        return Objects.hash(this.trimAboveSeqNo, this.maxSeenAutoIdTimestampOnPrimary, this.operations);
    }

    @Override
    public String toString() {
        return "TransportResyncReplicationAction.Request{shardId=" + this.shardId + ", timeout=" + this.timeout + ", index='" + this.index + '\'' + ", trimAboveSeqNo=" + this.trimAboveSeqNo + ", maxSeenAutoIdTimestampOnPrimary=" + this.maxSeenAutoIdTimestampOnPrimary + ", ops=" + this.operations.length + "}";
    }
}

