/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.yarn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.yarn.client.YarnResourceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceYarn
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceYarn.class);
    public static final String ACCESS_TYPE_SUBMIT_APP = "submit-app";

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceYarn.validateConfig Service: (" + serviceName + " )");
        }
        if (this.configs != null) {
            try {
                ret = YarnResourceMgr.validateConfig(serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error("<== RangerServiceYarn.validateConfig Error:" + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceYarn.validateConfig Response : (" + ret + " )");
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        Map configs = this.getConfigs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceYarn.lookupResource Context: (" + context + ")");
        }
        if (context != null) {
            try {
                ret = YarnResourceMgr.getYarnResources(serviceName, configs, context);
            }
            catch (Exception e) {
                LOG.error("<==RangerServiceYarn.lookupResource Error : " + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceYarn.lookupResource Response: (" + ret + ")");
        }
        return ret;
    }

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceYarn.getDefaultRangerPolicies() ");
        }
        List ret = super.getDefaultRangerPolicies();
        String queueResourceName = "queue";
        for (RangerPolicy defaultPolicy : ret) {
            if (!defaultPolicy.getName().contains("all")) continue;
            RangerPolicy.RangerPolicyResource queuePolicyResource = (RangerPolicy.RangerPolicyResource)defaultPolicy.getResources().get(queueResourceName);
            if (StringUtils.isNotBlank((String)this.lookUpUser)) {
                RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
                policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
                policyItemForLookupUser.setAccesses(Collections.singletonList(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_SUBMIT_APP)));
                policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
                defaultPolicy.addPolicyItem(policyItemForLookupUser);
            }
            if (queuePolicyResource != null) {
                List resourceDefs = this.serviceDef.getResources();
                RangerServiceDef.RangerResourceDef queueResourceDef = null;
                for (RangerServiceDef.RangerResourceDef resourceDef : resourceDefs) {
                    if (!resourceDef.getName().equals(queueResourceName)) continue;
                    queueResourceDef = resourceDef;
                    break;
                }
                if (queueResourceDef != null) {
                    queuePolicyResource.setValue("*");
                    continue;
                }
                LOG.warn("No resourceDef found in YARN service-definition for '" + queueResourceName + "'");
                continue;
            }
            LOG.warn("No '" + queueResourceName + "' found in default policy");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceYarn.getDefaultRangerPolicies() : " + ret);
        }
        return ret;
    }
}

