/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

 package org.apache.ranger.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.ranger.common.AppConstants;
import org.apache.ranger.common.StringUtil;
import org.apache.ranger.common.view.VTrxLogAttr;
import org.apache.ranger.entity.XXAsset;
import org.apache.ranger.entity.XXPortalUser;
import org.apache.ranger.entity.XXTrxLog;
import org.apache.ranger.util.RangerEnumUtil;
import org.apache.ranger.view.VXPortalUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope("singleton")
public class XPortalUserService extends
		XPortalUserServiceBase<XXPortalUser, VXPortalUser> {

	@Autowired
	RangerEnumUtil xaEnumUtil;

	@Autowired
	StringUtil stringUtil;

	static HashMap<String, VTrxLogAttr> trxLogAttrs = new HashMap<String, VTrxLogAttr>();
	static {
		trxLogAttrs.put("loginId",
				new VTrxLogAttr("loginId", "Login ID", false));
		trxLogAttrs.put("status", new VTrxLogAttr("status",
				"Activation Status", false));
		trxLogAttrs.put("firstName", new VTrxLogAttr("firstName", "First Name",
				false));
		trxLogAttrs.put("lastName", new VTrxLogAttr("lastName", "Last Name",
				false));
		trxLogAttrs.put("emailAddress", new VTrxLogAttr("emailAddress",
				"Email Address", false));
		trxLogAttrs.put("publicScreenName", new VTrxLogAttr("publicScreenName",
				"Public Screen Name", false));
	}

	@Override
	protected void validateForCreate(VXPortalUser vObj) {
		// TODO Auto-generated method stub

	}

	@Override
	protected void validateForUpdate(VXPortalUser vObj, XXPortalUser mObj) {
		// TODO Auto-generated method stub

	}

	public List<XXTrxLog> getTransactionLog(VXPortalUser vUser, String action) {
		return getTransactionLog(vUser, null, action);
	}

	public List<XXTrxLog> getTransactionLog(VXPortalUser vObj,
			XXPortalUser xObj, String action) {
		if (vObj == null || action == null || (action.equalsIgnoreCase("update") && xObj == null)) {
			return null;
		}

		List<XXTrxLog> trxLogList = new ArrayList<XXTrxLog>();
		Field[] fields = vObj.getClass().getDeclaredFields();

		try {
			Field nameField = vObj.getClass().getDeclaredField("loginId");
			nameField.setAccessible(true);
			String objectName = "" + nameField.get(vObj);

			for (Field field : fields) {
				field.setAccessible(true);
				String fieldName = field.getName();
				if (!trxLogAttrs.containsKey(fieldName)) {
					continue;
				}

				VTrxLogAttr vTrxLogAttr = trxLogAttrs.get(fieldName);

				XXTrxLog xTrxLog = new XXTrxLog();
				xTrxLog.setAttributeName(vTrxLogAttr
						.getAttribUserFriendlyName());

				String value = null;
				boolean isEnum = vTrxLogAttr.isEnum();
				if (isEnum) {
					String enumName = XXAsset.getEnumName(fieldName);
					int enumValue = field.get(vObj) == null ? 0 : Integer
							.parseInt("" + field.get(vObj));
					value = xaEnumUtil.getLabel(enumName, enumValue);
				} else {
					value = "" + field.get(vObj);
				}

				if (action.equalsIgnoreCase("create")) {
					if (stringUtil.isEmpty(value)) {
						continue;
					}
					xTrxLog.setNewValue(value);
				} else if (action.equalsIgnoreCase("delete")) {
					xTrxLog.setPreviousValue(value);
				} else if (action.equalsIgnoreCase("update")) {
					String oldValue = null;
					Field[] xFields = xObj.getClass().getDeclaredFields();

					for (Field xField : xFields) {
						xField.setAccessible(true);
						String xFieldName = xField.getName();

						if (fieldName.equalsIgnoreCase(xFieldName)) {
							if (isEnum) {
								String enumName = XXAsset
										.getEnumName(xFieldName);
								int enumValue = xField.get(xObj) == null ? 0
										: Integer.parseInt(""
												+ xField.get(xObj));
								oldValue = xaEnumUtil.getLabel(enumName,
										enumValue);
							} else {
								oldValue = xField.get(xObj) + "";
							}
							break;
						}
					}
					if (fieldName.equalsIgnoreCase("emailAddress")) {
						if (!stringUtil.validateEmail(oldValue)) {
							oldValue = "";
						}
						if (!stringUtil.validateEmail(value)) {
							value = "";
						}
					}
					if (value.equalsIgnoreCase(oldValue)) {
						continue;
					}
					xTrxLog.setPreviousValue(oldValue);
					xTrxLog.setNewValue(value);
				}

				xTrxLog.setAction(action);
				xTrxLog.setObjectClassType(AppConstants.CLASS_TYPE_USER_PROFILE);
				xTrxLog.setObjectId(vObj.getId());
				xTrxLog.setObjectName(objectName);
				trxLogList.add(xTrxLog);
			}
		} catch (IllegalArgumentException e) {
			logger.info(
					"Caught IllegalArgumentException while"
							+ " getting Transaction log for user : "
							+ vObj.getLoginId(), e);
		} catch (NoSuchFieldException e) {
			logger.info(
					"Caught NoSuchFieldException while"
							+ " getting Transaction log for user : "
							+ vObj.getLoginId(), e);
		} catch (SecurityException e) {
			logger.info(
					"Caught SecurityException while"
							+ " getting Transaction log for user : "
							+ vObj.getLoginId(), e);
		} catch (IllegalAccessException e) {
			logger.info(
					"Caught IllegalAccessException while"
							+ " getting Transaction log for user : "
							+ vObj.getLoginId(), e);
		}
		return trxLogList;
	}

	public void updateXXPortalUserReferences(long xXPortalUserId){
		daoManager.getXXAsset().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXAsset().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXAuditMap().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXAuditMap().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXAuthSession().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXAuthSession().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXCredentialStore().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXCredentialStore().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXGroup().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXGroup().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXGroupGroup().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXGroupGroup().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXGroupUser().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXGroupUser().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXPermMap().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXPermMap().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXPolicyExportAudit().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXPolicyExportAudit().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXPortalUser().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXPortalUser().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXPortalUserRole().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXPortalUserRole().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXResource().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXResource().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXTrxLog().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXTrxLog().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXUser().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXUser().updateUserIDReference("upd_by_id", xXPortalUserId);
		//0.5
		daoManager.getXXServiceDef().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXServiceDef().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXService().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXService().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXPolicy().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXPolicy().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXServiceConfigDef().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXServiceConfigDef().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXResourceDef().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXResourceDef().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXAccessTypeDef().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXAccessTypeDef().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXAccessTypeDefGrants().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXAccessTypeDefGrants().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXPolicyConditionDef().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXPolicyConditionDef().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXContextEnricherDef().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXContextEnricherDef().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXEnumDef().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXEnumDef().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXEnumElementDef().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXEnumElementDef().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXServiceConfigMap().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXServiceConfigMap().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXPolicyResource().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXPolicyResource().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXPolicyResourceMap().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXPolicyResourceMap().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXPolicyItem().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXPolicyItem().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXPolicyItemAccess().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXPolicyItemAccess().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXPolicyItemCondition().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXPolicyItemCondition().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXPolicyItemUserPerm().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXPolicyItemUserPerm().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXPolicyItemGroupPerm().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXPolicyItemGroupPerm().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXModuleDef().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXModuleDef().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXUserPermission().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXUserPermission().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXGroupPermission().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXGroupPermission().updateUserIDReference("upd_by_id", xXPortalUserId);
		//0.6
		daoManager.getXXTagDef().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXTagDef().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXTagAttributeDef().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXTagAttributeDef().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXServiceResource().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXServiceResource().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXServiceResourceElement().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXServiceResourceElement().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXServiceResourceElementValue().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXServiceResourceElementValue().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXTag().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXTag().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXTagAttribute().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXTagAttribute().updateUserIDReference("upd_by_id", xXPortalUserId);
		daoManager.getXXTagResourceMap().updateUserIDReference("added_by_id", xXPortalUserId);
		daoManager.getXXTagResourceMap().updateUserIDReference("upd_by_id", xXPortalUserId);
	}
}
