/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.QpidException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ClientChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.util.ByteBufferUtils;

public class QueueDeclareOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 11;
    private final AMQShortString _queue;
    private final long _messageCount;
    private final long _consumerCount;

    public QueueDeclareOkBody(AMQShortString queue, long messageCount, long consumerCount) {
        this._queue = queue;
        this._messageCount = messageCount;
        this._consumerCount = consumerCount;
    }

    @Override
    public int getClazz() {
        return 50;
    }

    @Override
    public int getMethod() {
        return 11;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final long getMessageCount() {
        return this._messageCount;
    }

    public final long getConsumerCount() {
        return this._consumerCount;
    }

    @Override
    protected int getBodySize() {
        int size = 8;
        return size += this.getSizeOf(this._queue);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._queue);
        this.writeUnsignedInteger(buffer, this._messageCount);
        this.writeUnsignedInteger(buffer, this._consumerCount);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchQueueDeclareOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[QueueDeclareOkBodyImpl: ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("messageCount=");
        buf.append(this.getMessageCount());
        buf.append(", ");
        buf.append("consumerCount=");
        buf.append(this.getConsumerCount());
        buf.append("]");
        return buf.toString();
    }

    public static void process(ByteBuffer buffer, ClientChannelMethodProcessor dispatcher) {
        AMQShortString queue = AMQShortString.readAMQShortString(buffer);
        long messageCount = ByteBufferUtils.getUnsignedInt(buffer);
        long consumerCount = ByteBufferUtils.getUnsignedInt(buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveQueueDeclareOk(queue, messageCount, consumerCount);
        }
    }
}

