/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.filter;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.qpid.filter.BinaryExpression;
import org.apache.qpid.filter.BooleanExpression;
import org.apache.qpid.filter.ConstantExpression;
import org.apache.qpid.filter.Expression;
import org.apache.qpid.filter.LogicExpression;
import org.apache.qpid.filter.PropertyExpression;
import org.apache.qpid.filter.SelectorParsingException;
import org.apache.qpid.filter.UnaryExpression;

public abstract class ComparisonExpression<T>
extends BinaryExpression<T>
implements BooleanExpression<T> {
    private static final HashSet<Character> REGEXP_CONTROL_CHARS = new HashSet();

    public static <E> BooleanExpression<E> createBetween(Expression<E> value, Expression<E> left, Expression<E> right) {
        return LogicExpression.createAND(ComparisonExpression.createGreaterThanEqual(value, left), ComparisonExpression.createLessThanEqual(value, right));
    }

    public static <E> BooleanExpression<E> createNotBetween(Expression<E> value, Expression<E> left, Expression<E> right) {
        return LogicExpression.createOR(ComparisonExpression.createLessThan(value, left), ComparisonExpression.createGreaterThan(value, right));
    }

    public static <E> BooleanExpression<E> createLike(Expression<E> left, String right, String escape) {
        if (escape != null && escape.length() != 1) {
            throw new SelectorParsingException("The ESCAPE string literal is invalid.  It can only be one character.  Litteral used: " + escape);
        }
        int c = -1;
        if (escape != null) {
            c = 0xFFFF & escape.charAt(0);
        }
        return new LikeExpression<E>(left, right, c);
    }

    public static <E> BooleanExpression<E> createNotLike(Expression<E> left, String right, String escape) {
        return UnaryExpression.createNOT(ComparisonExpression.createLike(left, right, escape));
    }

    public static <E> BooleanExpression<E> createInFilter(Expression<E> left, List<?> elements, boolean allowNonJms) {
        if (!allowNonJms && !(left instanceof PropertyExpression)) {
            throw new SelectorParsingException("Expected a property for In expression, got: " + left);
        }
        return UnaryExpression.createInExpression(left, elements, false, allowNonJms);
    }

    public static <E> BooleanExpression<E> createNotInFilter(Expression<E> left, List<?> elements, boolean allowNonJms) {
        if (!allowNonJms && !(left instanceof PropertyExpression)) {
            throw new SelectorParsingException("Expected a property for In expression, got: " + left);
        }
        return UnaryExpression.createInExpression(left, elements, true, allowNonJms);
    }

    public static <E> BooleanExpression<E> createIsNull(Expression<E> left) {
        return ComparisonExpression.doCreateEqual(left, ConstantExpression.NULL());
    }

    public static <E> BooleanExpression<E> createIsNotNull(Expression<E> left) {
        return UnaryExpression.createNOT(ComparisonExpression.doCreateEqual(left, ConstantExpression.NULL()));
    }

    public static <E> BooleanExpression<E> createNotEqual(Expression<E> left, Expression<E> right) {
        return UnaryExpression.createNOT(ComparisonExpression.createEqual(left, right));
    }

    public static <E> BooleanExpression<E> createEqual(Expression<E> left, Expression<E> right) {
        ComparisonExpression.checkEqualOperand(left);
        ComparisonExpression.checkEqualOperand(right);
        ComparisonExpression.checkEqualOperandCompatability(left, right);
        return ComparisonExpression.doCreateEqual(left, right);
    }

    private static <E> BooleanExpression<E> doCreateEqual(Expression<E> left, Expression<E> right) {
        return new EqualExpression<E>(left, right);
    }

    public static <E> BooleanExpression<E> createGreaterThan(Expression<E> left, Expression<E> right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression<E>((Expression)left, (Expression)right){

            @Override
            protected boolean asBoolean(int answer) {
                return answer > 0;
            }

            @Override
            public String getExpressionSymbol() {
                return ">";
            }
        };
    }

    public static <E> BooleanExpression<E> createGreaterThanEqual(Expression<E> left, Expression<E> right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression<E>((Expression)left, (Expression)right){

            @Override
            protected boolean asBoolean(int answer) {
                return answer >= 0;
            }

            @Override
            public String getExpressionSymbol() {
                return ">=";
            }
        };
    }

    public static <E> BooleanExpression<E> createLessThan(Expression<E> left, Expression<E> right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression<E>((Expression)left, (Expression)right){

            @Override
            protected boolean asBoolean(int answer) {
                return answer < 0;
            }

            @Override
            public String getExpressionSymbol() {
                return "<";
            }
        };
    }

    public static <E> BooleanExpression<E> createLessThanEqual(Expression<E> left, Expression<E> right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression<E>((Expression)left, (Expression)right){

            @Override
            protected boolean asBoolean(int answer) {
                return answer <= 0;
            }

            @Override
            public String getExpressionSymbol() {
                return "<=";
            }
        };
    }

    public static <E> void checkLessThanOperand(Expression<E> expr) {
        if (expr instanceof ConstantExpression) {
            Object value = ((ConstantExpression)expr).getValue();
            if (value instanceof Number) {
                return;
            }
            throw new SelectorParsingException("Value '" + expr + "' cannot be compared.");
        }
        if (expr instanceof BooleanExpression) {
            throw new SelectorParsingException("Value '" + expr + "' cannot be compared.");
        }
    }

    public static <E> void checkEqualOperand(Expression<E> expr) {
        Object value;
        if (expr instanceof ConstantExpression && (value = ((ConstantExpression)expr).getValue()) == null) {
            throw new SelectorParsingException("'" + expr + "' cannot be compared.");
        }
    }

    private static <E> void checkEqualOperandCompatability(Expression<E> left, Expression<E> right) {
        if (left instanceof ConstantExpression && right instanceof ConstantExpression && left instanceof BooleanExpression && !(right instanceof BooleanExpression)) {
            throw new SelectorParsingException("'" + left + "' cannot be compared with '" + right + "'");
        }
    }

    public ComparisonExpression(Expression<T> left, Expression<T> right) {
        super(left, right);
    }

    @Override
    public Object evaluate(T message) {
        Comparable lv = (Comparable)this.getLeft().evaluate(message);
        if (lv == null) {
            return null;
        }
        Comparable rv = (Comparable)this.getRight().evaluate(message);
        if (rv == null) {
            return null;
        }
        return this.compare(lv, rv);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Boolean compare(Comparable lv15222, Comparable rv6222) {
        void rv6222;
        void rv6222;
        void lv15222;
        Comparable<Object> lv15222;
        Class<?> rc;
        Class<?> lc = lv15222.getClass();
        if (lc == (rc = rv6222.getClass())) return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
        if (lc == Byte.class) {
            if (rc == Short.class) {
                Short lv15222 = ((Number)((Object)lv15222)).shortValue();
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Integer.class) {
                Integer lv15222 = ((Number)((Object)lv15222)).intValue();
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Long.class) {
                Long lv15222 = ((Number)((Object)lv15222)).longValue();
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Float.class) {
                Float lv15222 = Float.valueOf(((Number)((Object)lv15222)).floatValue());
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rc != Double.class) return Boolean.FALSE;
                Double lv15222 = ((Number)((Object)lv15222)).doubleValue();
            }
            return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (lc == Short.class) {
            if (rc == Integer.class) {
                Integer lv15222 = ((Number)((Object)lv15222)).intValue();
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Long.class) {
                Long lv15222 = ((Number)((Object)lv15222)).longValue();
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Float.class) {
                Float lv15222 = Float.valueOf(((Number)((Object)lv15222)).floatValue());
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rc != Double.class) return Boolean.FALSE;
                Double lv15222 = ((Number)((Object)lv15222)).doubleValue();
            }
            return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (lc == Integer.class) {
            if (rc == Long.class) {
                Long lv15222 = ((Number)((Object)lv15222)).longValue();
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Float.class) {
                Float lv15222 = Float.valueOf(((Number)((Object)lv15222)).floatValue());
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rc != Double.class) return Boolean.FALSE;
                Double lv15222 = ((Number)((Object)lv15222)).doubleValue();
            }
            return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (lc == Long.class) {
            if (rc == Integer.class) {
                Long rv6222 = ((Number)rv6222).longValue();
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Float.class) {
                Float lv15222 = Float.valueOf(((Number)((Object)lv15222)).floatValue());
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rc != Double.class) return Boolean.FALSE;
                Double lv15222 = ((Number)((Object)lv15222)).doubleValue();
            }
            return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (lc == Float.class) {
            if (rc == Integer.class) {
                Float rv6222 = Float.valueOf(((Number)rv6222).floatValue());
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Long.class) {
                Float rv6222 = Float.valueOf(((Number)rv6222).floatValue());
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rc != Double.class) return Boolean.FALSE;
                Double lv15222 = ((Number)((Object)lv15222)).doubleValue();
            }
            return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (lc == Double.class) {
            if (rc == Integer.class) {
                Double rv6222 = ((Number)rv6222).doubleValue();
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Long.class) {
                Double rv6222 = ((Number)rv6222).doubleValue();
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rc != Float.class) return Boolean.FALSE;
                Double rv6222 = ((Number)rv6222).doubleValue();
            }
            return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (lv15222 instanceof Enum) {
            if (!(rv6222 instanceof String)) return Boolean.FALSE;
            try {
                Object rv6222 = Enum.valueOf(lc, (String)rv6222);
                return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (IllegalArgumentException e) {
                return Boolean.FALSE;
            }
        } else {
            if (!(lv15222 instanceof String)) return Boolean.FALSE;
            if (!(rv6222 instanceof Enum)) return Boolean.FALSE;
            Object lv15222 = Enum.valueOf(rc, (String)((Object)lv15222));
        }
        return this.asBoolean(lv15222.compareTo(rv6222)) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected abstract boolean asBoolean(int var1);

    @Override
    public boolean matches(T message) {
        Object object = this.evaluate(message);
        return object != null && object == Boolean.TRUE;
    }

    static {
        REGEXP_CONTROL_CHARS.add(Character.valueOf('.'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('\\'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('['));
        REGEXP_CONTROL_CHARS.add(Character.valueOf(']'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('^'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('$'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('?'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('*'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('+'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('{'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('}'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('|'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('('));
        REGEXP_CONTROL_CHARS.add(Character.valueOf(')'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf(':'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('&'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('<'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('>'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('='));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('!'));
    }

    private static class EqualExpression<E>
    extends ComparisonExpression<E> {
        public EqualExpression(Expression<E> left, Expression<E> right) {
            super(left, right);
        }

        @Override
        public Object evaluate(E message) {
            Object rv;
            Object lv = this.getLeft().evaluate(message);
            if (lv == null ^ (rv = this.getRight().evaluate(message)) == null) {
                return Boolean.FALSE;
            }
            if (lv == rv || lv.equals(rv)) {
                return Boolean.TRUE;
            }
            if (lv instanceof Comparable && rv instanceof Comparable) {
                return this.compare((Comparable)lv, (Comparable)rv);
            }
            return Boolean.FALSE;
        }

        @Override
        protected boolean asBoolean(int answer) {
            return answer == 0;
        }

        @Override
        public String getExpressionSymbol() {
            return "=";
        }
    }

    static class LikeExpression<E>
    extends UnaryExpression<E>
    implements BooleanExpression<E> {
        private Pattern likePattern;

        public LikeExpression(Expression<E> right, String like, int escape) {
            super(right);
            StringBuilder regexp = new StringBuilder(like.length() * 2);
            regexp.append("\\A");
            for (int i = 0; i < like.length(); ++i) {
                char c = like.charAt(i);
                if (escape == (0xFFFF & c)) {
                    if (++i >= like.length()) break;
                    char t = like.charAt(i);
                    regexp.append("\\x");
                    regexp.append(Integer.toHexString(0xFFFF & t));
                    continue;
                }
                if (c == '%') {
                    regexp.append(".*?");
                    continue;
                }
                if (c == '_') {
                    regexp.append(".");
                    continue;
                }
                if (REGEXP_CONTROL_CHARS.contains(Character.valueOf(c))) {
                    regexp.append("\\x");
                    regexp.append(Integer.toHexString(0xFFFF & c));
                    continue;
                }
                regexp.append(c);
            }
            regexp.append("\\z");
            this.likePattern = Pattern.compile(regexp.toString(), 32);
        }

        @Override
        public String getExpressionSymbol() {
            return "LIKE";
        }

        @Override
        public Object evaluate(E message) {
            Object rv = this.getRight().evaluate(message);
            if (rv == null) {
                return null;
            }
            if (!(rv instanceof String)) {
                return Boolean.FALSE;
            }
            return this.likePattern.matcher((String)rv).matches() ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public boolean matches(E message) {
            Object object = this.evaluate(message);
            return object != null && object == Boolean.TRUE;
        }
    }
}

