/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObjectCustomSerialization;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.Version;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.cfg.EnumFeature;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.module.SimpleModule;

public class ConfiguredObjectJacksonModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private static final ConfiguredObjectJacksonModule INSTANCE = new ConfiguredObjectJacksonModule(false);
    private static final ConfiguredObjectJacksonModule PERSISTENCE_INSTANCE = new ConfiguredObjectJacksonModule(true);
    private static final Set<String> OBJECT_METHOD_NAMES = Collections.synchronizedSet(new HashSet());

    private ConfiguredObjectJacksonModule(boolean forPersistence) {
        super("ConfiguredObjectSerializer", new Version(1, 0, 0, null, "org.apache.qpid", "broker-core"));
        for (final ConfiguredObjectCustomSerialization.Converter<?> converter : ConfiguredObjectCustomSerialization.getConverters(forPersistence)) {
            this.addSerializer(converter.getConversionClass(), (ValueSerializer)new ValueSerializer<Object>(){

                public void serialize(Object value, JsonGenerator gen, SerializationContext serializers) throws JacksonException {
                    gen.writePOJO(converter.convert(value));
                }
            });
        }
    }

    public static ObjectMapper newObjectMapper(boolean forPersistence) {
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((JacksonModule)(forPersistence ? PERSISTENCE_INSTANCE : INSTANCE))).enable(new DatatypeFeature[]{DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS})).enable(new MapperFeature[]{MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS})).disable(new DatatypeFeature[]{EnumFeature.READ_ENUMS_USING_TO_STRING})).disable(new DatatypeFeature[]{EnumFeature.WRITE_ENUMS_USING_TO_STRING})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build();
    }

    public static ObjectMapper newObjectMapper(boolean forPersistence, SerializationFeature serializationFeature) {
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((JacksonModule)(forPersistence ? PERSISTENCE_INSTANCE : INSTANCE))).enable(new DatatypeFeature[]{DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS})).enable(new MapperFeature[]{MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS})).disable(new DatatypeFeature[]{EnumFeature.READ_ENUMS_USING_TO_STRING})).disable(new DatatypeFeature[]{EnumFeature.WRITE_ENUMS_USING_TO_STRING})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).enable(new SerializationFeature[]{serializationFeature})).build();
    }

    static {
        for (Method method : Object.class.getMethods()) {
            OBJECT_METHOD_NAMES.add(method.getName());
        }
    }
}

