/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationStatus;
import java.util.Set;

public class StoredKeySet<K>
extends StoredCollection<K>
implements Set<K> {
    public StoredKeySet(Database database, EntryBinding<K> keyBinding, boolean writeAllowed) {
        super(new DataView(database, keyBinding, null, null, writeAllowed, null));
    }

    StoredKeySet(DataView keySetView) {
        super(keySetView);
    }

    @Override
    public boolean add(K key) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.putNoOverwrite(key, null, false);
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean remove(Object key) {
        return this.removeKey(key, null);
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    boolean hasValues() {
        return false;
    }

    @Override
    K makeIteratorData(BaseIterator iterator, DatabaseEntry keyEntry, DatabaseEntry priKeyEntry, DatabaseEntry valueEntry) {
        return (K)this.view.makeKey(keyEntry, priKeyEntry);
    }

    @Override
    boolean iterateDuplicates() {
        return false;
    }
}

