/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.ConfiguredObjectFinder;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.ConfiguredObjectStatistic;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.ConfiguredSettableAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.OperationParameter;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationFeature;

public class MetaDataServlet
extends AbstractServlet {
    private static final long serialVersionUID = 1L;

    @Override
    public void init() throws ServletException {
        super.init();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws ServletException, IOException {
        response.setContentType("application/json");
        this.sendCachingHeadersOnResponse(response);
        response.setStatus(200);
        ConfiguredObjectFinder finder = this.getConfiguredObjectFinder(managedObject);
        TreeMap<String, Map<String, Map>> classToDataMap = new TreeMap<String, Map<String, Map>>();
        for (Class clazz : finder.getManagedCategories()) {
            classToDataMap.put(clazz.getSimpleName(), this.processCategory(clazz, managedObject.getModel()));
        }
        OutputStream stream = this.getOutputStream(request, response);
        ObjectMapper mapper = ConfiguredObjectJacksonModule.newObjectMapper((boolean)false, (SerializationFeature)SerializationFeature.INDENT_OUTPUT);
        mapper.writeValue(stream, classToDataMap);
        response.setContentType("application/json");
        response.setStatus(200);
    }

    private Map<String, Map> processCategory(Class<? extends ConfiguredObject> clazz, Model model) {
        TreeMap<String, Map> typeToDataMap = new TreeMap<String, Map>();
        ConfiguredObjectTypeRegistry typeRegistry = model.getTypeRegistry();
        for (Class type : typeRegistry.getTypeSpecialisations(clazz)) {
            typeToDataMap.put(ConfiguredObjectTypeRegistry.getType((Class)type), this.processType(type, model));
        }
        return typeToDataMap;
    }

    private Map<String, Object> processType(Class<? extends ConfiguredObject> type, Model model) {
        LinkedHashMap<String, Object> typeDetails = new LinkedHashMap<String, Object>();
        typeDetails.put("attributes", this.processAttributes(type, model));
        typeDetails.put("statistics", this.processStatistics(type, model));
        typeDetails.put("operations", this.processOperations(type, model));
        typeDetails.put("managedInterfaces", this.getManagedInterfaces(type, model));
        typeDetails.put("validChildTypes", this.getValidChildTypes(type, model));
        typeDetails.put("contextDependencies", this.getContextDependencies(type, model));
        ManagedObject annotation = type.getAnnotation(ManagedObject.class);
        if (annotation != null) {
            if (annotation.deprecated()) {
                typeDetails.put("deprecated", true);
            }
            if (!"".equals(annotation.description())) {
                typeDetails.put("description", annotation.description());
            }
        }
        return typeDetails;
    }

    private Map<String, String> getContextDependencies(Class<? extends ConfiguredObject> type, Model model) {
        Collection contextDependencies = model.getTypeRegistry().getContextDependencies(type);
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (contextDependencies != null) {
            for (ManagedContextDefault contextDefault : contextDependencies) {
                result.put(contextDefault.name(), contextDefault.description());
            }
        }
        return result;
    }

    private Map<String, Collection<String>> getValidChildTypes(Class<? extends ConfiguredObject> type, Model model) {
        HashMap<String, Collection<String>> validChildTypes = new HashMap<String, Collection<String>>();
        for (Class childType : model.getChildTypes(ConfiguredObjectTypeRegistry.getCategory(type))) {
            Collection validValues = model.getTypeRegistry().getValidChildTypes(type, childType);
            if (validValues == null) continue;
            validChildTypes.put(childType.getSimpleName(), validValues);
        }
        return validChildTypes;
    }

    private Set<String> getManagedInterfaces(Class<? extends ConfiguredObject> type, Model model) {
        HashSet<String> interfaces = new HashSet<String>();
        for (Class classObject : model.getTypeRegistry().getManagedInterfaces(type)) {
            interfaces.add(classObject.getSimpleName());
        }
        return interfaces;
    }

    private Map<String, Map> processAttributes(Class<? extends ConfiguredObject> type, Model model) {
        Collection attributes = model.getTypeRegistry().getAttributeTypes(type).values();
        LinkedHashMap<String, Map> attributeDetails = new LinkedHashMap<String, Map>();
        for (ConfiguredObjectAttribute attribute : attributes) {
            LinkedHashMap<String, Object> attrDetails = new LinkedHashMap<String, Object>();
            attrDetails.put("type", attribute.getType().getSimpleName());
            if (!"".equals(attribute.getDescription())) {
                attrDetails.put("description", attribute.getDescription());
            }
            if (attribute.isDerived()) {
                attrDetails.put("derived", attribute.isDerived());
            }
            if (!attribute.isDerived()) {
                ConfiguredSettableAttribute automatedAttribute = (ConfiguredSettableAttribute)attribute;
                if (!"".equals(automatedAttribute.defaultValue())) {
                    attrDetails.put("defaultValue", automatedAttribute.defaultValue());
                }
                if (automatedAttribute.isMandatory()) {
                    attrDetails.put("mandatory", automatedAttribute.isMandatory());
                }
                if (automatedAttribute.isImmutable()) {
                    attrDetails.put("immutable", automatedAttribute.isImmutable());
                }
                if (!automatedAttribute.validValues().isEmpty()) {
                    Collection validValues = ((ConfiguredSettableAttribute)attribute).validValues();
                    ArrayList<Object> convertedValues = new ArrayList<Object>(validValues.size());
                    for (String value : validValues) {
                        convertedValues.add(((ConfiguredSettableAttribute)attribute).convert((Object)value, null));
                    }
                    attrDetails.put("validValues", convertedValues);
                } else if (!"".equals(automatedAttribute.validValuePattern())) {
                    attrDetails.put("validValuesPattern", automatedAttribute.validValuePattern());
                }
            }
            if (attribute.isSecure()) {
                attrDetails.put("secure", attribute.isSecure());
            }
            if (attribute.isOversized()) {
                attrDetails.put("oversize", attribute.isOversized());
            }
            attributeDetails.put(attribute.getName(), attrDetails);
        }
        return attributeDetails;
    }

    private Map<String, Map> processOperations(Class<? extends ConfiguredObject> type, Model model) {
        Collection operations = model.getTypeRegistry().getOperations(type).values();
        LinkedHashMap<String, Map> attributeDetails = new LinkedHashMap<String, Map>();
        for (ConfiguredObjectOperation operation : operations) {
            List parameters;
            LinkedHashMap<String, Object> attrDetails = new LinkedHashMap<String, Object>();
            attrDetails.put("name", operation.getName());
            attrDetails.put("returnType", operation.getReturnType().getSimpleName());
            if (!"".equals(operation.getDescription())) {
                attrDetails.put("description", operation.getDescription());
            }
            if (!(parameters = operation.getParameters()).isEmpty()) {
                LinkedHashMap paramDetails = new LinkedHashMap();
                for (OperationParameter param : parameters) {
                    LinkedHashMap<String, Object> paramAttrs = new LinkedHashMap<String, Object>();
                    paramAttrs.put("type", param.getType().getSimpleName());
                    paramAttrs.put("mandatory", param.isMandatory());
                    if (!"".equals(param.getDefaultValue())) {
                        paramAttrs.put("defaultValue", param.getDefaultValue());
                    }
                    paramDetails.put(param.getName(), paramAttrs);
                }
                attrDetails.put("parameters", paramDetails);
            }
            attributeDetails.put(operation.getName(), attrDetails);
        }
        return attributeDetails;
    }

    private Map<String, Map> processStatistics(Class<? extends ConfiguredObject> type, Model model) {
        Collection statistics = model.getTypeRegistry().getStatistics(type);
        LinkedHashMap<String, Map> allStatisticsDetails = new LinkedHashMap<String, Map>();
        for (ConfiguredObjectStatistic statistic : statistics) {
            LinkedHashMap<String, String> stat = new LinkedHashMap<String, String>();
            stat.put("name", statistic.getName());
            stat.put("type", statistic.getType().getSimpleName());
            if (!"".equals(statistic.getDescription())) {
                stat.put("description", statistic.getDescription());
            }
            if (!"".equals(statistic.getLabel())) {
                stat.put("label", statistic.getLabel());
            }
            stat.put("units", (String)statistic.getUnits());
            stat.put("statisticType", statistic.getStatisticType().toString());
            allStatisticsDetails.put(statistic.getName(), stat);
        }
        return allStatisticsDetails;
    }
}

