/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser;

import java.util.Set;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.BeanSerializer;
import tools.jackson.databind.ser.BeanSerializerBuilder;
import tools.jackson.databind.ser.bean.BeanAsArraySerializer;
import tools.jackson.databind.ser.bean.BeanSerializerBase;
import tools.jackson.databind.ser.bean.UnwrappingBeanSerializer;
import tools.jackson.databind.ser.impl.ObjectIdWriter;
import tools.jackson.databind.util.NameTransformer;

@JacksonStdImpl
public class UnrolledBeanSerializer
extends BeanSerializerBase {
    private static final int MAX_PROPS = 6;
    protected final int _propCount;
    protected BeanPropertyWriter _prop1;
    protected BeanPropertyWriter _prop2;
    protected BeanPropertyWriter _prop3;
    protected BeanPropertyWriter _prop4;
    protected BeanPropertyWriter _prop5;
    protected BeanPropertyWriter _prop6;

    public UnrolledBeanSerializer(JavaType type, BeanSerializerBuilder builder, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super(type, builder, properties, filteredProperties);
        this._propCount = this._props.length;
        this._calcUnrolled();
    }

    protected UnrolledBeanSerializer(UnrolledBeanSerializer src, Set<String> toIgnore, Set<String> toInclude) {
        super((BeanSerializerBase)src, toIgnore, toInclude);
        this._propCount = this._props.length;
        this._calcUnrolled();
    }

    protected UnrolledBeanSerializer(UnrolledBeanSerializer src, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super((BeanSerializerBase)src, properties, filteredProperties);
        this._propCount = this._props.length;
        this._calcUnrolled();
    }

    private void _calcUnrolled() {
        BeanPropertyWriter[] oProps = new BeanPropertyWriter[6];
        int offset = 6 - this._propCount;
        System.arraycopy(this._props, 0, oProps, offset, this._propCount);
        this._prop1 = oProps[0];
        this._prop2 = oProps[1];
        this._prop3 = oProps[2];
        this._prop4 = oProps[3];
        this._prop5 = oProps[4];
        this._prop6 = oProps[5];
    }

    public static UnrolledBeanSerializer tryConstruct(JavaType type, BeanSerializerBuilder builder, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        if (properties.length > 6 || builder.getFilterId() != null) {
            return null;
        }
        return new UnrolledBeanSerializer(type, builder, properties, filteredProperties);
    }

    @Override
    public ValueSerializer<Object> unwrappingSerializer(NameTransformer unwrapper) {
        return new UnwrappingBeanSerializer((BeanSerializerBase)this, unwrapper);
    }

    @Override
    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new BeanSerializer((BeanSerializerBase)this, objectIdWriter, this._propertyFilterId);
    }

    @Override
    public BeanSerializerBase withFilterId(Object filterId) {
        return new BeanSerializer((BeanSerializerBase)this, this._objectIdWriter, filterId);
    }

    @Override
    public ValueSerializer<?> withIgnoredProperties(Set<String> toIgnore) {
        return new BeanSerializer((BeanSerializerBase)this, toIgnore, null);
    }

    @Override
    protected BeanSerializerBase withByNameInclusion(Set<String> toIgnore, Set<String> toInclude) {
        return new UnrolledBeanSerializer(this, toIgnore, toInclude);
    }

    @Override
    protected BeanSerializerBase withProperties(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        return new UnrolledBeanSerializer(this, properties, filteredProperties);
    }

    @Override
    protected BeanSerializerBase asArraySerializer() {
        if (this.canCreateArraySerializer()) {
            return BeanAsArraySerializer.construct(this);
        }
        return this;
    }

    @Override
    public void resolve(SerializationContext provider) {
        super.resolve(provider);
        this._calcUnrolled();
    }

    @Override
    public void serialize(Object bean, JsonGenerator gen, SerializationContext provider) throws JacksonException {
        BeanPropertyWriter[] fProps = this._filteredProps;
        if (fProps != null && provider.getActiveView() != null) {
            gen.writeStartObject(bean);
            this._serializePropertiesMaybeView(bean, gen, provider, fProps);
            gen.writeEndObject();
            return;
        }
        this.serializeNonFiltered(bean, gen, provider);
    }

    protected void serializeNonFiltered(Object bean, JsonGenerator gen, SerializationContext provider) throws JacksonException {
        gen.writeStartObject(bean);
        BeanPropertyWriter prop = null;
        try {
            switch (this._propCount) {
                default: {
                    prop = this._prop1;
                    prop.serializeAsProperty(bean, gen, provider);
                }
                case 5: {
                    prop = this._prop2;
                    prop.serializeAsProperty(bean, gen, provider);
                }
                case 4: {
                    prop = this._prop3;
                    prop.serializeAsProperty(bean, gen, provider);
                }
                case 3: {
                    prop = this._prop4;
                    prop.serializeAsProperty(bean, gen, provider);
                }
                case 2: {
                    prop = this._prop5;
                    prop.serializeAsProperty(bean, gen, provider);
                }
                case 1: {
                    prop = this._prop6;
                    prop.serializeAsProperty(bean, gen, provider);
                }
                case 0: 
            }
            prop = null;
        }
        catch (Exception e) {
            String name = prop == null ? "[anySetter]" : prop.getName();
            this.wrapAndThrow(provider, (Throwable)e, bean, name);
        }
        catch (StackOverflowError e) {
            String name = prop == null ? "[anySetter]" : prop.getName();
            throw DatabindException.from(gen, "Infinite recursion (StackOverflowError)", (Throwable)e).prependPath(bean, name);
        }
        gen.writeEndObject();
    }
}

