/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.rep.elections.Acceptor;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.impl.node.RepNode;

public class MasterSuggestionGenerator
implements Acceptor.SuggestionGenerator {
    private final RepNode repNode;
    private boolean forceAsMaster = false;
    private static final Acceptor.SuggestionGenerator.Ranking PREMPTIVE_RANKING = new Acceptor.SuggestionGenerator.Ranking(Long.MAX_VALUE, 0L);
    private static final Acceptor.SuggestionGenerator.Ranking MASTER_RANKING = new Acceptor.SuggestionGenerator.Ranking(0x7FFFFFFFFFFFFFFEL, 0L);

    public MasterSuggestionGenerator(RepNode repNode) {
        this.repNode = repNode;
    }

    @Override
    public Protocol.Value get(Proposer.Proposal proposal) {
        return new MasterValue(this.repNode.getHostName(), this.repNode.getPort(), this.repNode.getNameIdPair());
    }

    @Override
    public Acceptor.SuggestionGenerator.Ranking getRanking(Proposer.Proposal proposal) {
        if (this.forceAsMaster) {
            return PREMPTIVE_RANKING;
        }
        this.repNode.getVLSNFreezeLatch().freeze(proposal);
        if (this.repNode.isAuthoritativeMaster()) {
            return MASTER_RANKING;
        }
        long dtvlsn = this.repNode.getDTVLSN();
        long vlsn = this.repNode.getVLSNIndex().getRange().getLast().getSequence();
        if (dtvlsn == 0L) {
            return new Acceptor.SuggestionGenerator.Ranking(vlsn, 0L);
        }
        return new Acceptor.SuggestionGenerator.Ranking(dtvlsn, vlsn);
    }

    public void forceMaster(boolean force) {
        this.forceAsMaster = force;
    }
}

