/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.apache.qpid.server.util.BaseAction;

public class FileHelper {
    public void writeFileSafely(Path targetFile, BaseAction<File, IOException> operation) throws IOException {
        String name = targetFile.toFile().getName();
        this.writeFileSafely(targetFile, targetFile.resolveSibling(name + ".bak"), targetFile.resolveSibling(name + ".tmp"), operation);
    }

    public void writeFileSafely(Path targetFile, Path backupFile, Path tmpFile, BaseAction<File, IOException> write) throws IOException {
        Set<PosixFilePermission> backupPermissions;
        Files.deleteIfExists(tmpFile);
        Files.deleteIfExists(backupFile);
        Set<PosixFilePermission> permissions = null;
        if (Files.exists(targetFile, new LinkOption[0]) && this.isPosixFileSystem(targetFile)) {
            permissions = Files.getPosixFilePermissions(targetFile, new LinkOption[0]);
        }
        tmpFile = this.createNewFile(tmpFile, permissions);
        write.performAction(tmpFile.toFile());
        this.atomicFileMoveOrReplace(targetFile, backupFile);
        if (permissions != null && !(backupPermissions = Files.getPosixFilePermissions(backupFile, new LinkOption[0])).equals(permissions)) {
            Files.setPosixFilePermissions(backupFile, permissions);
        }
        this.atomicFileMoveOrReplace(tmpFile, targetFile);
        Files.deleteIfExists(tmpFile);
        Files.deleteIfExists(backupFile);
    }

    public Path createNewFile(File newFile, String posixFileAttributes) throws IOException {
        return this.createNewFile(newFile.toPath(), posixFileAttributes);
    }

    public Path createNewFile(Path newFile, String posixFileAttributes) throws IOException {
        Set<PosixFilePermission> permissions = posixFileAttributes == null ? null : PosixFilePermissions.fromString(posixFileAttributes);
        return this.createNewFile(newFile, permissions);
    }

    public Path createNewFile(Path newFile, Set<PosixFilePermission> permissions) throws IOException {
        if (!Files.exists(newFile, new LinkOption[0])) {
            newFile = Files.createFile(newFile, new FileAttribute[0]);
        }
        if (permissions != null && this.isPosixFileSystem(newFile)) {
            Files.setPosixFilePermissions(newFile, permissions);
        }
        return newFile;
    }

    public boolean isPosixFileSystem(Path path) throws IOException {
        while (!Files.exists(path, new LinkOption[0])) {
            if ((path = path.getParent()) != null) continue;
            return false;
        }
        return Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]) != null;
    }

    public Path atomicFileMoveOrReplace(Path sourceFile, Path targetFile) throws IOException {
        try {
            return Files.move(sourceFile, targetFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException e) {
            if (sourceFile.toFile().renameTo(targetFile.toFile())) {
                return targetFile;
            }
            throw new RuntimeException("Atomic move is unsupported and rename from : '" + String.valueOf(sourceFile) + "' to: '" + String.valueOf(targetFile) + "' failed.");
        }
    }

    public boolean isWritableDirectory(String path) {
        File storePath = new File(path).getAbsoluteFile();
        if (storePath.exists()) {
            if (!storePath.isDirectory()) {
                return false;
            }
        } else {
            do {
                if ((storePath = storePath.getParentFile()) != null) continue;
                return false;
            } while (!storePath.exists());
        }
        return storePath.canWrite();
    }
}

