/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.instrumentation.metadata;

import java.util.Objects;
import org.apache.qpid.server.instrumentation.metadata.MemberDescription;
import org.apache.qpid.server.instrumentation.metadata.MethodDescription;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class AutomatedFieldDescription
implements MemberDescription {
    private final String _declaringClass;
    private final String _name;
    private final MethodDescription _beforeSet;
    private final MethodDescription _afterSet;

    public AutomatedFieldDescription(String declaringClass, String name, MethodDescription beforeSet, MethodDescription afterSet) {
        this._declaringClass = declaringClass;
        this._name = name;
        this._beforeSet = beforeSet;
        this._afterSet = afterSet;
    }

    public static AutomatedFieldDescription of(ClassNode classNode, FieldNode fieldNode, AnnotationNode annotationNode) {
        String declaringClass = classNode.name;
        String fieldName = fieldNode.name;
        MethodDescription beforeSet = null;
        MethodDescription afterSet = null;
        if (annotationNode.values != null) {
            for (int i = 0; i < annotationNode.values.size(); ++i) {
                Object name = annotationNode.values.get(i);
                if ("beforeSet".equals(name)) {
                    beforeSet = AutomatedFieldDescription.createMethodDescription(classNode, annotationNode, i);
                }
                if (!"afterSet".equals(name)) continue;
                afterSet = AutomatedFieldDescription.createMethodDescription(classNode, annotationNode, i);
            }
        }
        return new AutomatedFieldDescription(declaringClass, fieldName, beforeSet, afterSet);
    }

    private static MethodDescription createMethodDescription(ClassNode classNode, AnnotationNode annotationNode, int i) {
        String beforeSetName = (String)annotationNode.values.get(i + 1);
        return classNode.methods.stream().filter(methodNode -> Objects.equals(beforeSetName, methodNode.name)).findFirst().map(node -> MethodDescription.of(classNode, node)).orElse(null);
    }

    @Override
    public String getDeclaringClass() {
        return this._declaringClass;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getSignature() {
        return this._declaringClass.replace('/', '.') + "#" + this._name;
    }

    public MethodDescription getBeforeSet() {
        return this._beforeSet;
    }

    public MethodDescription getAfterSet() {
        return this._afterSet;
    }

    public String toString() {
        return "AutomatedFieldDescription{_declaringClass='" + this._declaringClass + "', _name='" + this._name + "', _beforeSet=" + String.valueOf(this._beforeSet) + ", _afterSet=" + String.valueOf(this._afterSet) + "}";
    }
}

