/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth;

import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.security.QpidPrincipal;

public class UsernamePrincipal
implements QpidPrincipal {
    private static final long serialVersionUID = 1L;
    private final String _name;
    private final AuthenticationProvider<?> _authenticationProvider;

    public UsernamePrincipal(String name, AuthenticationProvider<?> authenticationProvider) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this._name = name;
        this._authenticationProvider = authenticationProvider;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String toString() {
        return this._name;
    }

    public AuthenticationProvider<?> getOrigin() {
        return this._authenticationProvider;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsernamePrincipal that = (UsernamePrincipal)o;
        if (!this._name.equals(that._name)) {
            return false;
        }
        if (this._authenticationProvider == null || that._authenticationProvider == null) {
            return this._authenticationProvider == null && that._authenticationProvider == null;
        }
        return this._authenticationProvider.getType().equals(that._authenticationProvider.getType()) && this._authenticationProvider.getName().equals(that._authenticationProvider.getName());
    }

    @Override
    public int hashCode() {
        int result = this._name.hashCode();
        result = 31 * result + (this._authenticationProvider != null ? this._authenticationProvider.hashCode() : 0);
        return result;
    }
}

