/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

public final class PrimitivesUtils {
    public static final int BYTES = 2;
    private static final String ARRAY_TOO_SMALL = "array too small: %s < %s";

    private PrimitivesUtils() {
    }

    private static void checkArgument(boolean expression, int p1) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(ARRAY_TOO_SMALL, p1, 2));
        }
    }

    public static byte[] toByteArray(short value) {
        return new byte[]{(byte)(value >> 8), (byte)value};
    }

    public static byte[] toByteArray(char value) {
        return new byte[]{(byte)(value >> 8), (byte)value};
    }

    public static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static byte[] toByteArray(long value) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    public static short shortFromByteArray(byte[] bytes) {
        PrimitivesUtils.checkArgument(bytes.length >= 2, bytes.length);
        return (short)(bytes[0] << 8 | bytes[1] & 0xFF);
    }

    public static char charFromByteArray(byte[] bytes) {
        PrimitivesUtils.checkArgument(bytes.length >= 2, bytes.length);
        return (char)(bytes[0] << 8 | bytes[1] & 0xFF);
    }

    public static int intFromByteArray(byte[] bytes) {
        PrimitivesUtils.checkArgument(bytes.length >= 2, bytes.length);
        return bytes[0] << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static long longFromByteArray(byte[] bytes) {
        PrimitivesUtils.checkArgument(bytes.length >= 2, bytes.length);
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }
}

